-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Aug 22, 2025 at 05:01 AM
-- Server version: 8.4.3
-- PHP Version: 8.3.16

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `toko_kuliner`
--

-- --------------------------------------------------------

--
-- Table structure for table `audit_log`
--

CREATE TABLE `audit_log` (
  `id_log` int NOT NULL,
  `id_pengguna` int DEFAULT NULL,
  `aksi` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `tabel` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_record` int DEFAULT NULL,
  `data_lama` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `data_baru` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `ip_address` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `backup_history`
--

CREATE TABLE `backup_history` (
  `id_backup` int NOT NULL,
  `nama_file` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `ukuran` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_pengguna` int NOT NULL,
  `jenis_backup` enum('manual','otomatis') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `lokasi_penyimpanan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `catatan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `barang`
--

CREATE TABLE `barang` (
  `id_barang` int NOT NULL,
  `kode_barang` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `barcode` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `nama_barang` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_kategori` int NOT NULL,
  `id_satuan` int NOT NULL,
  `harga_beli` decimal(12,2) NOT NULL,
  `harga_jual` decimal(12,2) NOT NULL,
  `stok_minimal` int DEFAULT '0',
  `foto_barang` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deskripsi` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `barang`
--

INSERT INTO `barang` (`id_barang`, `kode_barang`, `barcode`, `nama_barang`, `id_kategori`, `id_satuan`, `harga_beli`, `harga_jual`, `stok_minimal`, `foto_barang`, `deskripsi`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'BRG001', 'uploads/barang/barcode_689317f19849f.jpeg', 'Indomie Goreng', 5, 1, 2500.00, 3500.00, 50, 'uploads/barang/barang_1_689317f19afd6.jpeg', '', 1, '2025-07-31 04:15:29', '2025-08-06 08:53:05'),
(2, 'BRG002', 'uploads/barang/barcode_68931836bd827.jpeg', 'Indomie Soto', 5, 1, 2500.00, 3500.00, 50, 'uploads/barang/barang_2_68931836bfe7d.jpeg', '', 1, '2025-07-31 04:15:29', '2025-08-06 08:54:14'),
(3, 'BRG003', 'uploads/barang/barcode_68931816a3e5e.jpeg', 'Indomie Kari Ayam', 5, 1, 2500.00, 3500.00, 50, 'uploads/barang/barang_3_68931816a673f.jpeg', '', 1, '2025-07-31 04:15:29', '2025-08-06 08:53:42'),
(4, 'BRG004', 'uploads/barang/barcode_6893179209896.jpg', 'Aqua Gelas 240ml', 2, 1, 1500.00, 2500.00, 100, 'uploads/barang/barang_4_689317920c7ff.jpg', '', 1, '2025-07-31 04:15:29', '2025-08-06 08:51:30'),
(5, 'BRG005', 'uploads/barang/barcode_689317ab48593.jpg', 'Aqua Botol 600ml', 2, 3, 3000.00, 5000.00, 80, 'uploads/barang/barang_5_689317ab4a710.jpg', '', 1, '2025-07-31 04:15:29', '2025-08-07 01:15:47'),
(6, 'BRG006', '8999999600067', 'Teh Botol Sosro 350ml', 2, 3, 3500.00, 6000.00, 60, NULL, NULL, 1, '2025-07-31 04:15:29', '2025-08-04 08:17:02'),
(7, 'BRG007', '8999999700074', 'Ultra Milk Full Cream 1L', 6, 6, 12000.00, 15000.00, 30, NULL, NULL, 1, '2025-07-31 04:15:29', '2025-08-04 08:17:02'),
(8, 'BRG008', 'uploads/barang/barcode_6893170fbd47d.jpg', 'Chitato Rasa Ayam', 1, 1, 8000.00, 12000.00, 40, 'uploads/barang/barang_8_6893166cb29d5.jpg', '', 1, '2025-07-31 04:15:29', '2025-08-06 08:49:19'),
(9, 'BRG009', '8999999900098', 'Lays Rasa Keju', 1, 1, 9000.00, 13000.00, 40, NULL, NULL, 1, '2025-07-31 04:15:29', '2025-08-04 08:17:02'),
(10, 'BRG010', '8998888800010', 'Roti Tawar Gandum', 4, 8, 15000.00, 20000.00, 20, NULL, NULL, 1, '2025-07-31 04:15:29', '2025-08-04 08:17:02'),
(11, 'BRG011', 'uploads/barang/barcode_6893177a42a1e.jpg', 'Beras Ramos 5kg', 3, 5, 60000.00, 75000.00, 15, 'uploads/barang/barang_11_6893177a45091.jpg', '', 1, '2025-07-31 04:15:29', '2025-08-06 08:51:06'),
(12, 'BRG012', '8998888800034', 'Minyak Goreng Bimoli 2L', 3, 6, 25000.00, 32000.00, 25, NULL, NULL, 1, '2025-07-31 04:15:29', '2025-08-04 08:17:02'),
(13, 'BRG013', 'uploads/barang/barcode_689317d57314c.jpg', 'Gulaku 1kg', 3, 7, 12000.00, 15000.00, 30, 'uploads/barang/barang_13_689317d5750c0.jpg', '', 1, '2025-07-31 04:15:29', '2025-08-06 08:52:37'),
(14, 'BRG014', 'uploads/barang/barcode_68931890312c1.jpg', 'Kecap Bango 275ml', 7, 3, 10000.00, 13000.00, 40, 'uploads/barang/barang_14_6893189033ae6.jpg', '', 1, '2025-07-31 04:15:29', '2025-08-06 08:55:44'),
(15, 'BRG015', '8998888800065', 'Sambal ABC 135ml', 7, 3, 8000.00, 10000.00, 50, NULL, NULL, 1, '2025-07-31 04:15:29', '2025-08-04 08:17:02'),
(16, 'BRG016', '8998888800072', 'Nugget So Good 500g', 8, 7, 25000.00, 32000.00, 20, NULL, NULL, 1, '2025-07-31 04:15:29', '2025-08-04 08:17:02'),
(17, 'BRG017', '8998888800089', 'Sosis Farmhouse 250g', 8, 7, 18000.00, 24000.00, 25, NULL, NULL, 1, '2025-07-31 04:15:29', '2025-08-04 08:17:02'),
(18, 'BRG018', '8998888800096', 'Pasta Gigi Pepsodent 190g', 9, 1, 10000.00, 13000.00, 30, NULL, NULL, 1, '2025-07-31 04:15:29', '2025-08-04 08:17:02'),
(19, 'BRG019', '8998888800102', 'Sabun Lifebuoy 90g', 9, 1, 5000.00, 7000.00, 50, NULL, NULL, 1, '2025-07-31 04:15:29', '2025-08-06 07:14:22'),
(20, 'BRG020', 'uploads/barang/barcode_6893175fc09d5.jpg', 'Blender Miyako', 10, 1, 200000.00, 250000.00, 5, 'uploads/barang/barang_20_6893175fc20b2.jpg', '', 1, '2025-07-31 04:15:29', '2025-08-06 08:50:39'),
(21, 'BRG021', '8998888800191', 'Soffell Kulit Jeruk Botol 80 Gram', 3, 3, 20000.00, 25000.00, 10, NULL, 'Barang datang 05 Agustus 2025', 0, '2025-08-05 01:15:16', '2025-08-06 08:40:16');

-- --------------------------------------------------------

--
-- Table structure for table `biaya_operasional`
--

CREATE TABLE `biaya_operasional` (
  `id_biaya` int NOT NULL,
  `id_toko` int NOT NULL,
  `tanggal` date NOT NULL,
  `jenis_biaya` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `jumlah` decimal(12,2) NOT NULL,
  `keterangan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `id_pengguna` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `biaya_operasional`
--

INSERT INTO `biaya_operasional` (`id_biaya`, `id_toko`, `tanggal`, `jenis_biaya`, `jumlah`, `keterangan`, `id_pengguna`, `created_at`, `updated_at`) VALUES
(1, 1, '2025-07-01', 'Listrik', 1500000.00, 'Pembayaran listrik PLN', 1, '2025-08-01 03:10:56', '2025-08-01 03:10:56'),
(2, 1, '2025-07-01', 'Gaji Karyawan', 7500000.00, 'Gaji bulan Juli', 1, '2025-08-01 03:10:56', '2025-08-01 03:10:56'),
(3, 1, '2025-07-01', 'Sewa Ruko', 5000000.00, 'Sewa ruko bulanan', 1, '2025-08-01 03:10:56', '2025-08-01 03:10:56'),
(4, 2, '2025-07-01', 'Listrik', 1200000.00, 'Listrik bulan Juli', 1, '2025-08-01 03:10:56', '2025-08-01 03:10:56'),
(5, 2, '2025-07-01', 'Gaji Karyawan', 6800000.00, 'Gaji pegawai', 1, '2025-08-01 03:10:56', '2025-08-01 03:10:56'),
(6, 3, '2025-07-01', 'Listrik', 1400000.00, 'Pembayaran listrik', 1, '2025-08-01 03:10:56', '2025-08-01 03:10:56'),
(7, 3, '2025-07-01', 'Internet', 500000.00, 'IndiHome + Router', 1, '2025-08-01 03:10:56', '2025-08-01 03:10:56'),
(8, 4, '2025-08-01', 'Gaji Karyawan', 8000000.00, 'Gaji awal Agustus', 1, '2025-08-01 03:10:56', '2025-08-01 03:10:56'),
(9, 4, '2025-08-01', 'Listrik', 1300000.00, 'Listrik PLN', 1, '2025-08-01 03:10:56', '2025-08-01 03:10:56');

-- --------------------------------------------------------

--
-- Table structure for table `detail_mutasi`
--

CREATE TABLE `detail_mutasi` (
  `id_detail_mutasi` int NOT NULL,
  `id_mutasi` int NOT NULL,
  `id_barang` int NOT NULL,
  `jumlah` int NOT NULL,
  `catatan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `detail_mutasi`
--

INSERT INTO `detail_mutasi` (`id_detail_mutasi`, `id_mutasi`, `id_barang`, `jumlah`, `catatan`) VALUES
(1, 1, 1, 20, NULL),
(2, 1, 2, 15, NULL),
(3, 1, 3, 10, NULL),
(4, 2, 4, 30, NULL),
(5, 2, 5, 20, NULL),
(6, 3, 15, 10, NULL),
(7, 3, 16, 5, NULL),
(8, 3, 17, 8, NULL),
(9, 3, 18, 5, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `detail_pembelian`
--

CREATE TABLE `detail_pembelian` (
  `id_detail_pembelian` int NOT NULL,
  `id_pembelian` int NOT NULL,
  `id_barang` int NOT NULL,
  `jumlah` int NOT NULL,
  `harga_beli` decimal(12,2) NOT NULL,
  `subtotal` decimal(12,2) NOT NULL,
  `expired_date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `detail_pembelian`
--

INSERT INTO `detail_pembelian` (`id_detail_pembelian`, `id_pembelian`, `id_barang`, `jumlah`, `harga_beli`, `subtotal`, `expired_date`, `created_at`) VALUES
(1, 1, 1, 100, 2500.00, 250000.00, '2026-08-01', '2025-07-31 04:15:29'),
(2, 1, 2, 80, 2500.00, 200000.00, '2026-08-01', '2025-07-31 04:15:29'),
(3, 1, 3, 90, 2500.00, 225000.00, '2026-08-01', '2025-07-31 04:15:29'),
(4, 1, 4, 200, 1500.00, 300000.00, '2026-10-31', '2025-07-31 04:15:29'),
(5, 1, 5, 150, 3000.00, 450000.00, '2026-11-30', '2025-07-31 04:15:29'),
(6, 2, 6, 120, 3500.00, 420000.00, '2026-09-30', '2025-07-31 04:15:29'),
(7, 2, 7, 50, 12000.00, 600000.00, '2026-08-31', '2025-07-31 04:15:29'),
(8, 2, 8, 80, 8000.00, 640000.00, '2026-07-31', '2025-07-31 04:15:29'),
(9, 2, 9, 70, 9000.00, 630000.00, '2026-07-31', '2025-07-31 04:15:29'),
(10, 3, 10, 40, 15000.00, 600000.00, '2026-06-30', '2025-07-31 04:15:29'),
(11, 3, 11, 30, 60000.00, 1800000.00, '2026-01-31', '2025-07-31 04:15:29'),
(12, 3, 12, 40, 25000.00, 1000000.00, '2026-02-28', '2025-07-31 04:15:29');

--
-- Triggers `detail_pembelian`
--
DELIMITER $$
CREATE TRIGGER `after_detail_pembelian_insert` AFTER INSERT ON `detail_pembelian` FOR EACH ROW BEGIN
    DECLARE stok_ada INT;
    
    -- Cek apakah stok untuk barang dan toko ini sudah ada
    SELECT COUNT(*) INTO stok_ada FROM stok_toko 
    WHERE id_barang = NEW.id_barang 
    AND id_toko = (SELECT id_toko FROM pembelian WHERE id_pembelian = NEW.id_pembelian);
    
    IF stok_ada = 0 THEN
        -- Jika belum ada, buat record baru
        INSERT INTO stok_toko (id_barang, id_toko, stok_awal, stok_masuk, stok_keluar, stok_akhir, expired_date)
        VALUES (
            NEW.id_barang, 
            (SELECT id_toko FROM pembelian WHERE id_pembelian = NEW.id_pembelian),
            0,
            NEW.jumlah,
            0,
            NEW.jumlah,
            NEW.expired_date
        );
    ELSE
        -- Jika sudah ada, update record
        UPDATE stok_toko 
        SET 
            stok_masuk = stok_masuk + NEW.jumlah,
            stok_akhir = stok_akhir + NEW.jumlah,
            expired_date = CASE WHEN expired_date IS NULL OR NEW.expired_date < expired_date 
                               THEN NEW.expired_date ELSE expired_date END,
            last_updated = NOW()
        WHERE id_barang = NEW.id_barang 
        AND id_toko = (SELECT id_toko FROM pembelian WHERE id_pembelian = NEW.id_pembelian);
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `detail_penjualan`
--

CREATE TABLE `detail_penjualan` (
  `id_detail_penjualan` int NOT NULL,
  `id_penjualan` int NOT NULL,
  `id_barang` int NOT NULL,
  `jumlah` int NOT NULL,
  `harga_jual` decimal(12,2) NOT NULL,
  `diskon_item` decimal(12,2) DEFAULT '0.00',
  `subtotal` decimal(12,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `diskon_jenis` enum('nominal','persen') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'nominal'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `detail_penyesuaian`
--

CREATE TABLE `detail_penyesuaian` (
  `id_detail_penyesuaian` int NOT NULL,
  `id_penyesuaian` int NOT NULL,
  `id_barang` int NOT NULL,
  `stok_sistem` int NOT NULL,
  `stok_fisik` int NOT NULL,
  `selisih` int NOT NULL,
  `keterangan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `detail_retur_pembelian`
--

CREATE TABLE `detail_retur_pembelian` (
  `id_detail_retur_pembelian` int NOT NULL,
  `id_retur_pembelian` int NOT NULL,
  `id_barang` int NOT NULL,
  `jumlah` int NOT NULL,
  `harga_retur` decimal(12,2) NOT NULL,
  `subtotal` decimal(12,2) NOT NULL,
  `alasan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `detail_retur_penjualan`
--

CREATE TABLE `detail_retur_penjualan` (
  `id_detail_retur_penjualan` int NOT NULL,
  `id_retur_penjualan` int NOT NULL,
  `id_barang` int NOT NULL,
  `jumlah` int NOT NULL,
  `harga_retur` decimal(12,2) NOT NULL,
  `subtotal` decimal(12,2) NOT NULL,
  `alasan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hak_akses`
--

CREATE TABLE `hak_akses` (
  `id_hak_akses` int NOT NULL,
  `id_role` int NOT NULL,
  `modul` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `bisa_lihat` tinyint(1) DEFAULT '0',
  `bisa_tambah` tinyint(1) DEFAULT '0',
  `bisa_edit` tinyint(1) DEFAULT '0',
  `bisa_hapus` tinyint(1) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hutang_pelanggan`
--

CREATE TABLE `hutang_pelanggan` (
  `id_hutang` int NOT NULL,
  `id_penjualan` int NOT NULL,
  `id_pelanggan` int NOT NULL,
  `tanggal_hutang` date NOT NULL,
  `tanggal_jatuh_tempo` date DEFAULT NULL,
  `jumlah_hutang` decimal(12,2) NOT NULL,
  `jumlah_bayar` decimal(12,2) DEFAULT '0.00',
  `sisa_hutang` decimal(12,2) NOT NULL,
  `status` enum('lunas','belum_lunas') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'belum_lunas',
  `keterangan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `hutang_pelanggan`
--

INSERT INTO `hutang_pelanggan` (`id_hutang`, `id_penjualan`, `id_pelanggan`, `tanggal_hutang`, `tanggal_jatuh_tempo`, `jumlah_hutang`, `jumlah_bayar`, `sisa_hutang`, `status`, `keterangan`, `created_at`, `updated_at`) VALUES
(1, 4, 4, '2025-07-31', '2025-08-05', 495000.00, 100000.00, 0.00, 'lunas', NULL, '2025-07-31 04:15:29', '2025-08-04 08:43:33'),
(2, 5, 5, '2025-08-01', '2025-09-05', 657000.00, 200000.00, 0.00, 'lunas', NULL, '2025-07-31 04:15:29', '2025-08-04 08:43:46');

-- --------------------------------------------------------

--
-- Table structure for table `hutang_supplier`
--

CREATE TABLE `hutang_supplier` (
  `id_hutang_supplier` int NOT NULL,
  `id_pembelian` int NOT NULL,
  `id_supplier` int NOT NULL,
  `tanggal_hutang` date NOT NULL,
  `tanggal_jatuh_tempo` date DEFAULT NULL,
  `jumlah_hutang` decimal(12,2) NOT NULL,
  `jumlah_bayar` decimal(12,2) DEFAULT '0.00',
  `sisa_hutang` decimal(12,2) NOT NULL,
  `status` enum('lunas','hutang','sebagian','belum_lunas') COLLATE utf8mb4_general_ci DEFAULT 'belum_lunas',
  `keterangan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `hutang_supplier`
--

INSERT INTO `hutang_supplier` (`id_hutang_supplier`, `id_pembelian`, `id_supplier`, `tanggal_hutang`, `tanggal_jatuh_tempo`, `jumlah_hutang`, `jumlah_bayar`, `sisa_hutang`, `status`, `keterangan`, `created_at`, `updated_at`) VALUES
(1, 2, 2, '2025-07-31', '2025-08-05', 2090000.00, 500000.00, 1090000.00, 'sebagian', NULL, '2025-07-31 04:15:29', '2025-08-04 08:43:19'),
(2, 3, 3, '2025-08-01', '2025-09-05', 1925000.00, 500000.00, 925000.00, 'sebagian', NULL, '2025-07-31 04:15:29', '2025-08-04 08:43:06');

-- --------------------------------------------------------

--
-- Table structure for table `jadwal_karyawan`
--

CREATE TABLE `jadwal_karyawan` (
  `id_jadwal` int NOT NULL,
  `id_pengguna` int NOT NULL,
  `id_shift` int NOT NULL,
  `tanggal` date NOT NULL,
  `id_toko` int NOT NULL,
  `catatan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `jadwal_karyawan`
--

INSERT INTO `jadwal_karyawan` (`id_jadwal`, `id_pengguna`, `id_shift`, `tanggal`, `id_toko`, `catatan`, `created_at`) VALUES
(1, 2, 1, '2025-08-01', 1, NULL, '2025-07-31 04:15:29'),
(2, 2, 1, '2025-08-02', 1, NULL, '2025-07-31 04:15:29'),
(3, 2, 2, '2025-08-03', 1, NULL, '2025-07-31 04:15:29'),
(4, 3, 1, '2025-08-04', 2, NULL, '2025-07-31 04:15:29'),
(5, 3, 1, '2025-08-05', 2, NULL, '2025-07-31 04:15:29'),
(6, 3, 2, '2025-08-06', 2, NULL, '2025-07-31 04:15:29'),
(7, 5, 4, '2025-08-07', 1, NULL, '2025-07-31 04:15:29'),
(8, 5, 4, '2025-08-08', 1, NULL, '2025-07-31 04:15:29'),
(9, 5, 4, '2025-08-09', 1, NULL, '2025-07-31 04:15:29');

-- --------------------------------------------------------

--
-- Table structure for table `kategori`
--

CREATE TABLE `kategori` (
  `id_kategori` int NOT NULL,
  `nama_kategori` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `deskripsi` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `kategori`
--

INSERT INTO `kategori` (`id_kategori`, `nama_kategori`, `deskripsi`, `created_at`, `updated_at`) VALUES
(1, 'Makanan Ringan', 'Snack dan makanan ringan lainnya', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(2, 'Minuman', 'Aneka minuman kemasan', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(3, 'Bahan Pokok', 'Bahan makanan pokok', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(4, 'Kue & Roti', 'Aneka kue dan roti', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(5, 'Makanan Instan', 'Makanan siap saji instan', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(6, 'Produk Susu', 'Produk olahan susu', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(7, 'Bumbu Dapur', 'Aneka bumbu masakan', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(8, 'Frozen Food', 'Makanan beku siap olah', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(9, 'Kesehatan', 'Produk kesehatan dan kebersihan', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(10, 'Elektronik', 'Perangkat elektronik dapur', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(12, 'Lainnya', 'Kategori untuk barang-barang yang tidak termasuk dalam kategori utama', '2025-08-06 08:58:44', '2025-08-06 08:58:44');

-- --------------------------------------------------------

--
-- Table structure for table `metode_pembayaran`
--

CREATE TABLE `metode_pembayaran` (
  `id_metode` int NOT NULL,
  `nama_metode` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `kode_metode` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `deskripsi` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `metode_pembayaran`
--

INSERT INTO `metode_pembayaran` (`id_metode`, `nama_metode`, `kode_metode`, `deskripsi`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Tunai', 'CASH', 'Pembayaran dengan uang tunai', 1, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(2, 'Transfer Bank', 'TRF', 'Pembayaran via transfer bank', 1, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(3, 'QRIS', 'QRIS', 'Pembayaran via QRIS', 1, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(4, 'E-Wallet', 'EWALLET', 'Pembayaran via aplikasi e-wallet', 1, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(5, 'Kartu Debit', 'DEBIT', 'Pembayaran dengan kartu debit', 1, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(6, 'Hutang / Potong Gaji', 'HUTANG', 'Pembayaran dengan metode potong gaji atau sistem hutang internal', 1, '2025-08-04 07:44:12', '2025-08-04 07:44:12');

-- --------------------------------------------------------

--
-- Table structure for table `mutasi`
--

CREATE TABLE `mutasi` (
  `id_mutasi` int NOT NULL,
  `no_mutasi` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_toko_asal` int NOT NULL,
  `id_toko_tujuan` int NOT NULL,
  `id_pengguna` int NOT NULL,
  `tanggal_mutasi` date NOT NULL,
  `total_barang` int NOT NULL,
  `catatan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `status` enum('draft','dikirim','diterima','ditolak') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'draft',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `mutasi`
--

INSERT INTO `mutasi` (`id_mutasi`, `no_mutasi`, `id_toko_asal`, `id_toko_tujuan`, `id_pengguna`, `tanggal_mutasi`, `total_barang`, `catatan`, `status`, `created_at`, `updated_at`) VALUES
(1, 'MTS-20231001-001', 1, 2, 6, '2025-08-01', 3, NULL, 'diterima', '2025-07-31 04:15:29', '2025-08-04 08:41:19'),
(2, 'MTS-20231002-001', 2, 3, 6, '2025-08-02', 2, NULL, 'dikirim', '2025-07-31 04:15:29', '2025-08-04 08:41:23'),
(3, 'MTS-20231003-001', 3, 1, 6, '2025-08-03', 4, NULL, 'draft', '2025-07-31 04:15:29', '2025-08-04 08:41:27');

-- --------------------------------------------------------

--
-- Table structure for table `nota_pembelian`
--

CREATE TABLE `nota_pembelian` (
  `id_nota` int NOT NULL,
  `id_pembelian` int NOT NULL,
  `nama_file` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `path_file` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `notifikasi`
--

CREATE TABLE `notifikasi` (
  `id_notifikasi` int NOT NULL,
  `id_pengguna` int NOT NULL,
  `judul` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `pesan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `tipe` enum('info','warning','danger','success') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `is_read` tinyint(1) DEFAULT '0',
  `link` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `notifikasi`
--

INSERT INTO `notifikasi` (`id_notifikasi`, `id_pengguna`, `judul`, `pesan`, `tipe`, `is_read`, `link`, `created_at`) VALUES
(1, 1, 'Stok Menipis', 'Stok Indomie Goreng hampir mencapai batas minimal', 'warning', 0, NULL, '2025-07-31 04:15:29'),
(2, 2, 'Pembayaran Hutang', 'Pelanggan Andi Wijaya telah melunasi hutangnya', 'info', 0, NULL, '2025-07-31 04:15:29'),
(3, 3, 'Barang Expired', 'Beberapa barang akan kadaluarsa dalam 30 hari', 'danger', 0, NULL, '2025-07-31 04:15:29'),
(4, 4, 'Laporan Bulanan', 'Laporan penjualan bulan September telah tersedia', 'info', 0, NULL, '2025-07-31 04:15:29'),
(5, 5, 'Mutasi Barang', 'Mutasi barang dari Toko Utama telah diterima', 'success', 0, NULL, '2025-07-31 04:15:29');

-- --------------------------------------------------------

--
-- Table structure for table `pelanggan`
--

CREATE TABLE `pelanggan` (
  `id_pelanggan` int NOT NULL,
  `kode_pelanggan` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `nama_pelanggan` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `alamat` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `telepon` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `jenis_pelanggan` enum('reguler','member','reseller') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'reguler',
  `poin` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `pelanggan`
--

INSERT INTO `pelanggan` (`id_pelanggan`, `kode_pelanggan`, `nama_pelanggan`, `alamat`, `telepon`, `email`, `jenis_pelanggan`, `poin`, `created_at`, `updated_at`) VALUES
(1, 'PLG001', 'Andi Wijaya', 'Jl. Mangga No. 5, Jakarta', '0817777777', 'andi@gmail.com', 'member', 0, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(2, 'PLG002', 'Budi Santoso', 'Jl. Melati No. 10, Jakarta', '0818888888', 'budi@yahoo.com', 'member', 0, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(3, 'PLG003', 'Citra Dewi', 'Jl. Anggrek No. 15, Bandung', '0819999999', 'citra@gmail.com', 'reseller', 0, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(4, 'PLG004', 'Dodi Pranoto', 'Jl. Mawar No. 20, Bandung', '0821111111', 'dodi@yahoo.com', 'reguler', 0, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(5, 'PLG005', 'Eka Putri', 'Jl. Kenanga No. 25, Surabaya', '0822222222', 'eka@gmail.com', 'reseller', 0, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(6, 'PLG006', 'Nyai', 'Jl. Benteng Makmur', '0992234', 'bejo@gmail.com', 'reseller', 0, '2025-08-02 02:35:22', '2025-08-02 02:35:22');

-- --------------------------------------------------------

--
-- Table structure for table `pembayaran_hutang`
--

CREATE TABLE `pembayaran_hutang` (
  `id_pembayaran_hutang` int NOT NULL,
  `id_hutang` int NOT NULL,
  `id_pengguna` int NOT NULL,
  `tanggal_bayar` date NOT NULL,
  `jumlah_bayar` decimal(12,2) NOT NULL,
  `metode_bayar` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `keterangan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `pembayaran_hutang`
--

INSERT INTO `pembayaran_hutang` (`id_pembayaran_hutang`, `id_hutang`, `id_pengguna`, `tanggal_bayar`, `jumlah_bayar`, `metode_bayar`, `keterangan`, `created_at`) VALUES
(1, 1, 2, '2025-08-05', 100000.00, 'Transfer Bank', NULL, '2025-07-31 04:15:29'),
(2, 2, 3, '2025-08-05', 200000.00, 'Tunai', NULL, '2025-07-31 04:15:29');

-- --------------------------------------------------------

--
-- Table structure for table `pembayaran_hutang_supplier`
--

CREATE TABLE `pembayaran_hutang_supplier` (
  `id_pembayaran_hutang_supplier` int NOT NULL,
  `id_hutang_supplier` int NOT NULL,
  `id_pengguna` int NOT NULL,
  `tanggal_bayar` date NOT NULL,
  `jumlah_bayar` decimal(12,2) NOT NULL,
  `metode_bayar` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `keterangan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `pembayaran_hutang_supplier`
--

INSERT INTO `pembayaran_hutang_supplier` (`id_pembayaran_hutang_supplier`, `id_hutang_supplier`, `id_pengguna`, `tanggal_bayar`, `jumlah_bayar`, `metode_bayar`, `keterangan`, `created_at`) VALUES
(1, 1, 6, '2025-08-01', 500000.00, 'Transfer Bank', NULL, '2025-07-31 04:15:29'),
(2, 2, 6, '2025-08-02', 500000.00, 'Transfer Bank', NULL, '2025-07-31 04:15:29');

-- --------------------------------------------------------

--
-- Table structure for table `pembelian`
--

CREATE TABLE `pembelian` (
  `id_pembelian` int NOT NULL,
  `no_faktur` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_supplier` int NOT NULL,
  `id_toko` int NOT NULL,
  `id_pengguna` int NOT NULL,
  `tanggal_pembelian` date NOT NULL,
  `tanggal_jatuh_tempo` date DEFAULT NULL,
  `total_pembelian` decimal(12,2) NOT NULL,
  `diskon` decimal(12,2) DEFAULT '0.00',
  `ppn` decimal(12,2) DEFAULT '0.00',
  `grand_total` decimal(12,2) NOT NULL,
  `status_pembayaran` enum('lunas','hutang','sebagian') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'hutang',
  `jumlah_bayar` decimal(12,2) DEFAULT '0.00',
  `sisa_hutang` decimal(12,2) DEFAULT '0.00',
  `catatan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id_metode` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `pembelian`
--

INSERT INTO `pembelian` (`id_pembelian`, `no_faktur`, `id_supplier`, `id_toko`, `id_pengguna`, `tanggal_pembelian`, `tanggal_jatuh_tempo`, `total_pembelian`, `diskon`, `ppn`, `grand_total`, `status_pembayaran`, `jumlah_bayar`, `sisa_hutang`, `catatan`, `created_at`, `updated_at`, `id_metode`) VALUES
(1, 'PBL-20250801-001', 1, 1, 6, '2025-08-01', NULL, 1500000.00, 0.00, 150000.00, 1650000.00, 'lunas', 1650000.00, 0.00, NULL, '2025-07-31 04:15:29', '2025-08-07 01:52:15', 1),
(2, 'PBL-20250802-001', 2, 2, 3, '2025-08-02', NULL, 2000000.00, 100000.00, 190000.00, 2090000.00, 'sebagian', 1000000.00, 1090000.00, NULL, '2025-07-31 04:15:29', '2025-08-07 01:52:21', 2),
(3, 'PBL-20250803-001', 3, 3, 3, '2025-08-03', NULL, 1750000.00, 0.00, 175000.00, 1925000.00, 'sebagian', 1000000.00, 925000.00, NULL, '2025-07-31 04:15:29', '2025-08-07 01:52:25', 2);

-- --------------------------------------------------------

--
-- Table structure for table `pengguna`
--

CREATE TABLE `pengguna` (
  `id_pengguna` int NOT NULL,
  `username` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `nama_lengkap` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `telepon` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `id_role` int NOT NULL,
  `id_toko` int DEFAULT NULL,
  `foto_profil` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `reset_token` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reset_token_expires` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `pengguna`
--

INSERT INTO `pengguna` (`id_pengguna`, `username`, `password`, `nama_lengkap`, `email`, `telepon`, `id_role`, `id_toko`, `foto_profil`, `last_login`, `is_active`, `reset_token`, `reset_token_expires`, `created_at`, `updated_at`) VALUES
(1, 'Kasir 1', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Indah Putri', 'indah@tokokuliner.com', '0811111111', 2, 3, NULL, NULL, 1, NULL, NULL, '2025-07-31 04:15:29', '2025-08-01 07:14:18'),
(2, 'Kasir 2', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Budi Santoso', 'budi@tokokuliner.com', '0812222222', 2, 3, NULL, NULL, 1, NULL, NULL, '2025-07-31 04:15:29', '2025-08-01 07:13:45'),
(3, 'Kasir 3', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Ani Wijaya', 'ani@tokokuliner.com', '0813333333', 2, 2, NULL, NULL, 1, NULL, NULL, '2025-07-31 04:15:29', '2025-08-01 07:13:51'),
(4, 'Owner', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Joko Prasetyo', 'joko@tokokuliner.com', '0814444444', 3, 2, NULL, NULL, 1, NULL, NULL, '2025-07-31 04:15:29', '2025-08-01 07:11:36'),
(5, 'Manager', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Rina Melati', 'rina@tokokuliner.com', '0815555555', 4, 4, NULL, NULL, 1, NULL, NULL, '2025-07-31 04:15:29', '2025-08-01 07:14:02'),
(6, 'Gudang', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Dewi Kusuma', 'dewi@tokokuliner.com', '0816666666', 5, 4, NULL, NULL, 1, NULL, NULL, '2025-07-31 04:15:29', '2025-08-01 07:14:06'),
(7, 'Syafran Arguna', '$2y$10$FMqnC..ubyv4cYgcuJldeu7piIssHX6TIDcTJrslXPFTeAgMiO3c2', 'Syafran Arguna', 'argunasyafran12@gmail.com', '085157741684', 0, 1, 'profile_7_1753956471.jpg', '2025-08-13 10:28:59', 1, 'eb59fb6581ebf4c117d2e8d1c1c07f9c7ac3bbe60ea303db433c946c576ebcc1', '2025-08-02 08:32:57', '2025-07-31 04:36:04', '2025-08-13 03:28:59'),
(8, 'HRD', '$2y$10$vkE2qzjFqftllc9CnVOM7OzxYUY1CvcNSC1IYQdAaRX9zylaNMvTW', 'Human Resources Development', 'recruitment@spog.co.id', '(0711) 310953', 6, 1, 'profile_8_1754028857.png', '2025-08-04 10:18:22', 1, NULL, NULL, '2025-08-01 06:12:46', '2025-08-04 03:18:22'),
(10, 'alirodiansyah', '$2y$10$uhuPFp1OfIaDaKdlZmR96uxILyonaXuNiqouVYAlPdPgpi/1PkiNa', 'Ali', 'ok@ali.com', 'ok', 7, NULL, NULL, '2025-08-02 10:26:29', 1, NULL, NULL, '2025-08-02 03:26:17', '2025-08-04 08:59:57'),
(11, 'BoyIT', '$2y$10$pcsyD9GGoCoXzh54bLsqvOgXVcrcUnixSvkJdGhsBUoXf24NMKUWa', 'Pardi Boy', 'boyaja@gmail.com', '089567890012', 10, NULL, NULL, '2025-08-04 10:37:42', 1, NULL, NULL, '2025-08-04 03:31:43', '2025-08-04 07:51:46'),
(12, 'Meitedy Anggara', '$2y$10$TjW/QCKaChFc0tV.j6XayO387yCJ0Ct6jjr1XYp.wx63LNQ9xsHsG', 'AnggaGIS', 'angganewenewepartIIajadehkatenye@gmail.com', '09966228811', 7, NULL, NULL, '2025-08-08 04:24:42', 1, NULL, NULL, '2025-08-04 07:51:04', '2025-08-07 21:24:42');

-- --------------------------------------------------------

--
-- Table structure for table `penjualan`
--

CREATE TABLE `penjualan` (
  `id_penjualan` int NOT NULL,
  `no_transaksi` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_toko` int NOT NULL,
  `id_pelanggan` int DEFAULT NULL,
  `id_pengguna` int NOT NULL,
  `id_metode` int NOT NULL,
  `tanggal_penjualan` datetime NOT NULL,
  `total_penjualan` decimal(12,2) NOT NULL,
  `diskon` decimal(12,2) DEFAULT '0.00',
  `ppn` decimal(12,2) DEFAULT '0.00',
  `grand_total` decimal(12,2) NOT NULL,
  `jumlah_bayar` decimal(12,2) NOT NULL,
  `kembalian` decimal(12,2) DEFAULT '0.00',
  `status_pembayaran` enum('lunas','hutang','sebagian') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'lunas',
  `sisa_hutang` decimal(12,2) DEFAULT '0.00',
  `catatan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `penjualan`
--

INSERT INTO `penjualan` (`id_penjualan`, `no_transaksi`, `id_toko`, `id_pelanggan`, `id_pengguna`, `id_metode`, `tanggal_penjualan`, `total_penjualan`, `diskon`, `ppn`, `grand_total`, `jumlah_bayar`, `kembalian`, `status_pembayaran`, `sisa_hutang`, `catatan`, `created_at`, `updated_at`) VALUES
(1, 'PJL-20231001-001', 1, 1, 2, 1, '2025-08-01 10:15:30', 150000.00, 0.00, 15000.00, 165000.00, 200000.00, 35000.00, 'lunas', 0.00, NULL, '2025-07-31 04:15:29', '2025-08-04 08:36:57'),
(2, 'PJL-20231001-002', 1, 2, 2, 1, '2025-08-01 11:15:30', 75000.00, 5000.00, 7000.00, 77000.00, 100000.00, 23000.00, 'lunas', 0.00, NULL, '2025-07-31 04:15:29', '2025-08-04 08:37:07'),
(3, 'PJL-20231002-001', 2, 3, 3, 3, '2025-08-01 12:15:30', 300000.00, 20000.00, 28000.00, 308000.00, 308000.00, 0.00, 'lunas', 0.00, NULL, '2025-07-31 04:15:29', '2025-08-04 08:37:14'),
(4, 'PJL-20231002-002', 2, 4, 3, 2, '2025-08-01 13:15:30', 450000.00, 0.00, 45000.00, 495000.00, 500000.00, 5000.00, 'lunas', 0.00, NULL, '2025-07-31 04:15:29', '2025-08-04 08:37:49'),
(5, 'PJL-20231003-001', 3, 5, 3, 4, '2025-08-01 14:15:30', 600000.00, 30000.00, 57000.00, 657000.00, 700000.00, 43000.00, 'lunas', 0.00, NULL, '2025-07-31 04:15:29', '2025-08-04 08:37:53'),
(6, 'PJL-20231003-002', 3, 2, 3, 1, '2025-08-01 15:15:30', 120000.00, 0.00, 12000.00, 132000.00, 150000.00, 18000.00, 'lunas', 0.00, NULL, '2025-07-31 04:15:29', '2025-08-04 08:37:44');

-- --------------------------------------------------------

--
-- Table structure for table `penyesuaian_stok`
--

CREATE TABLE `penyesuaian_stok` (
  `id_penyesuaian` int NOT NULL,
  `no_penyesuaian` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_toko` int NOT NULL,
  `id_pengguna` int NOT NULL,
  `tanggal_penyesuaian` date NOT NULL,
  `total_barang` int NOT NULL,
  `catatan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `promo`
--

CREATE TABLE `promo` (
  `id_promo` int NOT NULL,
  `kode_promo` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `nama_promo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `jenis_promo` enum('diskon','gratis','bundling') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `nilai_promo` decimal(12,2) NOT NULL,
  `tipe_nilai` enum('persen','nominal') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'nominal',
  `tanggal_mulai` date NOT NULL,
  `tanggal_selesai` date NOT NULL,
  `id_toko` int DEFAULT NULL,
  `min_pembelian` decimal(12,2) DEFAULT '0.00',
  `max_diskon` decimal(12,2) DEFAULT NULL,
  `kuota` int DEFAULT NULL,
  `deskripsi` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `promo`
--

INSERT INTO `promo` (`id_promo`, `kode_promo`, `nama_promo`, `jenis_promo`, `nilai_promo`, `tipe_nilai`, `tanggal_mulai`, `tanggal_selesai`, `id_toko`, `min_pembelian`, `max_diskon`, `kuota`, `deskripsi`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'DISC10', 'Diskon 10%', 'diskon', 10.00, 'persen', '2025-08-01', '2025-08-31', 1, 100000.00, 50000.00, 100, 'Jumat Berkah', 1, '2025-07-31 04:15:29', '2025-08-01 04:24:37'),
(2, 'CASHBACK5', 'Cashback 5%', 'diskon', 5.00, 'persen', '2025-08-01', '2025-08-31', 2, 200000.00, NULL, 50, 'Jumat Berkah', 1, '2025-07-31 04:15:29', '2025-08-01 04:14:46'),
(3, 'GRATIS1', 'Beli 2 Gratis 1', 'gratis', 1.00, 'nominal', '2025-08-01', '2025-08-31', 3, 0.00, NULL, 25, 'Jumat Berkah', 1, '2025-07-31 04:15:29', '2025-08-01 04:14:51'),
(4, 'DISC15', 'Diskon 15%', 'diskon', 15.00, 'persen', '2025-08-08', '2025-08-31', 1, 2000000.00, 100000.00, 10, 'Promo 08.08', 1, '2025-08-01 04:28:12', '2025-08-01 04:32:31');

-- --------------------------------------------------------

--
-- Table structure for table `promo_barang`
--

CREATE TABLE `promo_barang` (
  `id_promo_barang` int NOT NULL,
  `id_promo` int NOT NULL,
  `id_barang` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `jumlah` int DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `promo_barang`
--

INSERT INTO `promo_barang` (`id_promo_barang`, `id_promo`, `id_barang`, `created_at`, `jumlah`) VALUES
(4, 2, 4, '2025-07-31 04:15:29', 1),
(5, 2, 5, '2025-07-31 04:15:29', 1),
(6, 2, 6, '2025-07-31 04:15:29', 1),
(7, 3, 8, '2025-07-31 04:15:29', 1),
(8, 3, 9, '2025-07-31 04:15:29', 1),
(19, 1, 1, '2025-08-01 04:24:37', 1),
(20, 1, 3, '2025-08-01 04:24:37', 1),
(21, 1, 2, '2025-08-01 04:24:37', 1),
(22, 1, 16, '2025-08-01 04:24:37', 1),
(23, 1, 7, '2025-08-01 04:24:37', 1),
(29, 4, 11, '2025-08-01 04:32:31', 1),
(30, 4, 20, '2025-08-01 04:32:31', 1),
(31, 4, 3, '2025-08-01 04:32:31', 1),
(32, 4, 9, '2025-08-01 04:32:31', 1),
(33, 4, 19, '2025-08-01 04:32:31', 1);

-- --------------------------------------------------------

--
-- Table structure for table `retur_pembelian`
--

CREATE TABLE `retur_pembelian` (
  `id_retur_pembelian` int NOT NULL,
  `no_retur` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_pembelian` int NOT NULL,
  `id_pengguna` int NOT NULL,
  `tanggal_retur` date NOT NULL,
  `alasan_retur` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `total_retur` decimal(12,2) NOT NULL,
  `status` enum('draft','diproses','selesai','ditolak') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'draft',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `retur_penjualan`
--

CREATE TABLE `retur_penjualan` (
  `id_retur_penjualan` int NOT NULL,
  `no_retur` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_penjualan` int NOT NULL,
  `id_pengguna` int NOT NULL,
  `tanggal_retur` date NOT NULL,
  `alasan_retur` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `total_retur` decimal(12,2) NOT NULL,
  `status` enum('draft','diproses','selesai','ditolak') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'draft',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `role`
--

CREATE TABLE `role` (
  `id_role` int NOT NULL,
  `nama_role` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `deskripsi` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `role`
--

INSERT INTO `role` (`id_role`, `nama_role`, `deskripsi`, `created_at`, `updated_at`) VALUES
(0, 'Super Admin', 'Akses penuh ke seluruh sistem, termasuk semua toko, data, dan pengguna', '2025-08-01 09:14:53', '2025-08-01 09:15:15'),
(1, 'Admin', 'Akses penuh ke semua fitur sistem', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(2, 'Kasir', 'Hanya bisa melakukan transaksi penjualan', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(3, 'Owner', 'Bisa melihat semua laporan tapi tidak bisa edit', '2025-07-31 04:15:29', '2025-08-01 07:10:08'),
(4, 'Manajer Toko', 'Bisa mengelola stok dan transaksi di tokonya saja', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(5, 'Gudang', 'Bisa mengelola stok dan pembelian', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(6, 'HRD', 'Mengelola data karyawan dan jadwal kerja', '2025-08-01 08:45:45', '2025-08-01 08:45:45'),
(7, 'Audit', 'Hanya melihat laporan dan aktivitas sistem', '2025-08-01 08:45:45', '2025-08-01 08:45:45'),
(8, 'Finance', 'Melihat laporan keuangan dan transaksi pembayaran', '2025-08-01 08:45:45', '2025-08-01 08:45:45'),
(9, 'Supervisor', 'Memantau aktivitas toko dan approval operasional', '2025-08-01 08:45:45', '2025-08-01 08:45:45'),
(10, 'Teknisi IT', 'Akses teknis untuk debugging & maintenance', '2025-08-01 08:45:45', '2025-08-01 08:45:45');

-- --------------------------------------------------------

--
-- Table structure for table `satuan`
--

CREATE TABLE `satuan` (
  `id_satuan` int NOT NULL,
  `nama_satuan` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `simbol` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `satuan`
--

INSERT INTO `satuan` (`id_satuan`, `nama_satuan`, `simbol`, `created_at`, `updated_at`) VALUES
(1, 'Pieces', 'pcs', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(2, 'Dus', 'dus', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(3, 'Botol', 'btl', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(4, 'Pack', 'pack', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(5, 'Kilogram', 'kg', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(6, 'Liter', 'L', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(7, 'Gram', 'g', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(8, 'Bungkus', 'bks', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(9, 'Kaleng', 'kalen', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(10, 'Sachet', 'sch', '2025-07-31 04:15:29', '2025-07-31 04:15:29');

-- --------------------------------------------------------

--
-- Table structure for table `shift`
--

CREATE TABLE `shift` (
  `id_shift` int NOT NULL,
  `nama_shift` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `jam_mulai` time NOT NULL,
  `jam_selesai` time NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `shift`
--

INSERT INTO `shift` (`id_shift`, `nama_shift`, `jam_mulai`, `jam_selesai`, `created_at`, `updated_at`) VALUES
(1, 'Pagi', '08:00:00', '16:00:00', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(2, 'Sore', '16:00:00', '00:00:00', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(3, 'Malam', '00:00:00', '08:00:00', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(4, 'Full Day', '08:00:00', '20:00:00', '2025-07-31 04:15:29', '2025-07-31 04:15:29');

-- --------------------------------------------------------

--
-- Table structure for table `stok_toko`
--

CREATE TABLE `stok_toko` (
  `id_stok_toko` int NOT NULL,
  `id_barang` int NOT NULL,
  `id_toko` int NOT NULL,
  `stok_awal` int DEFAULT '0',
  `stok_masuk` int DEFAULT '0',
  `stok_keluar` int DEFAULT '0',
  `stok_akhir` int DEFAULT '0',
  `expired_date` date DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `stok_toko`
--

INSERT INTO `stok_toko` (`id_stok_toko`, `id_barang`, `id_toko`, `stok_awal`, `stok_masuk`, `stok_keluar`, `stok_akhir`, `expired_date`, `last_updated`) VALUES
(1, 1, 1, 100, 50, 35, 115, '2024-12-31', '2025-08-04 07:58:56'),
(2, 2, 1, 80, 45, 25, 100, '2024-12-31', '2025-08-04 07:58:56'),
(3, 3, 1, 90, 45, 20, 115, '2024-12-31', '2025-08-04 08:09:53'),
(4, 4, 1, 200, 100, 80, 220, '2024-10-31', '2025-08-04 08:09:53'),
(5, 5, 1, 150, 70, 60, 160, '2024-11-30', '2025-08-04 08:09:53'),
(6, 6, 1, 120, 60, 40, 140, '2024-09-30', '2025-08-04 08:09:53'),
(7, 7, 1, 50, 25, 15, 60, '2024-08-31', '2025-08-04 08:09:53'),
(8, 8, 1, 80, 40, 30, 90, '2024-07-31', '2025-08-04 08:09:53'),
(9, 9, 1, 70, 35, 25, 80, '2024-07-31', '2025-08-04 08:09:53'),
(10, 10, 1, 40, 20, 10, 50, '2024-06-30', '2025-08-04 08:09:53'),
(11, 1, 2, 80, 40, 20, 100, '2024-12-31', '2025-08-04 08:09:53'),
(12, 2, 2, 70, 35, 15, 90, '2024-12-31', '2025-08-04 08:09:53'),
(13, 4, 2, 150, 75, 50, 175, '2024-10-31', '2025-08-04 08:09:53'),
(14, 5, 2, 120, 60, 40, 140, '2024-11-30', '2025-08-04 08:09:53'),
(15, 6, 2, 100, 50, 40, 110, '2024-09-30', '2025-08-04 07:58:56'),
(16, 7, 2, 40, 25, 10, 55, '2024-08-31', '2025-08-04 07:58:56'),
(17, 11, 2, 30, 15, 5, 40, '2025-01-31', '2025-08-04 08:09:53'),
(18, 12, 2, 40, 20, 10, 50, '2025-02-28', '2025-08-04 08:09:53'),
(19, 13, 2, 50, 25, 15, 60, '2025-03-31', '2025-08-04 08:09:53'),
(20, 14, 2, 60, 30, 20, 70, '2024-12-31', '2025-08-04 08:09:53'),
(21, 3, 3, 70, 35, 15, 90, '2024-12-31', '2025-08-04 08:09:53'),
(22, 4, 3, 120, 60, 40, 140, '2024-10-31', '2025-08-04 08:09:53'),
(23, 5, 3, 100, 50, 30, 120, '2024-11-30', '2025-08-04 08:09:53'),
(24, 6, 3, 80, 40, 20, 100, '2024-09-30', '2025-08-04 08:09:53'),
(25, 7, 3, 30, 15, 5, 40, '2024-08-31', '2025-08-04 08:09:53'),
(26, 15, 3, 80, 40, 25, 95, '2024-12-31', '2025-08-04 07:58:56'),
(27, 16, 3, 40, 20, 10, 50, '2024-10-31', '2025-08-04 08:09:53'),
(28, 17, 3, 50, 25, 15, 60, '2024-11-30', '2025-08-04 08:09:53'),
(29, 18, 3, 60, 30, 20, 70, '2025-06-30', '2025-08-04 08:09:53'),
(30, 19, 3, 70, 35, 25, 80, '2025-07-31', '2025-08-04 08:09:53'),
(31, 8, 2, 80, 80, 5, 75, '2024-07-31', '2025-08-04 08:16:43'),
(32, 9, 2, 70, 70, 0, 70, '2024-07-31', '2025-08-04 08:16:43'),
(33, 10, 3, 40, 40, 0, 40, '2024-06-30', '2025-08-04 08:16:43'),
(34, 11, 3, 30, 30, 0, 30, '2025-01-31', '2025-08-04 08:16:43'),
(35, 12, 3, 40, 40, 0, 40, '2025-02-28', '2025-08-04 08:16:43'),
(36, 21, 1, 0, 0, 0, 0, NULL, '2025-08-05 01:15:16');

-- --------------------------------------------------------

--
-- Table structure for table `supplier`
--

CREATE TABLE `supplier` (
  `id_supplier` int NOT NULL,
  `kode_supplier` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `nama_supplier` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `alamat` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `telepon` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `kontak_person` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `rekening_bank` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status_aktif` tinyint(1) DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `supplier`
--

INSERT INTO `supplier` (`id_supplier`, `kode_supplier`, `nama_supplier`, `alamat`, `telepon`, `email`, `kontak_person`, `rekening_bank`, `status_aktif`, `created_at`, `updated_at`) VALUES
(1, 'SUP001', 'PT Sumber Makmur', 'Jl. Industri No. 10, Jakarta', '0211112222', 'info@sumbermakmur.com', 'Budi Santoso', NULL, 1, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(2, 'SUP002', 'CV Sejahtera Bersama', 'Jl. Raya Bogor Km. 5', '0213334444', 'sales@sejahterabersama.com', 'Ani Wijaya', NULL, 1, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(3, 'SUP003', 'UD Jaya Abadi', 'Jl. Mangga Dua No. 8, Jakarta', '0215556666', 'udjayaabadi@gmail.com', 'Joko Prasetyo', NULL, 1, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(4, 'SUP004', 'PT Indofood', 'Jl. Sudirman Kav. 1, Jakarta', '0217778888', 'supplier@indofood.com', 'Rina Melati', NULL, 1, '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(5, 'SUP005', 'CV Segar Alami', 'Jl. Kesehatan No. 3, Bandung', '0229990000', 'segaralami@yahoo.com', 'Dewi Kusuma', NULL, 1, '2025-07-31 04:15:29', '2025-07-31 04:15:29');

-- --------------------------------------------------------

--
-- Table structure for table `toko`
--

CREATE TABLE `toko` (
  `id_toko` int NOT NULL,
  `kode_toko` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `nama_toko` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `alamat` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `telepon` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status_aktif` tinyint(1) DEFAULT '1',
  `tanggal_buka` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `toko`
--

INSERT INTO `toko` (`id_toko`, `kode_toko`, `nama_toko`, `alamat`, `telepon`, `email`, `status_aktif`, `tanggal_buka`, `created_at`, `updated_at`) VALUES
(1, 'TK001', 'PMI STORE', 'Jl. Merdeka No. 123, Jakarta', '0211234567', 'utama@tokokuliner.com', 1, '2020-01-15', '2025-07-31 04:15:29', '2025-07-31 10:02:25'),
(2, 'TK002', 'Toko Kuliner Cabang Bandung', 'Jl. Asia Afrika No. 45, Bandung', '0227654321', 'bandung@tokokuliner.com', 1, '2021-03-20', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(3, 'TK003', 'Toko Kuliner Cabang Surabaya', 'Jl. Tunjungan No. 78, Surabaya', '0319876543', 'surabaya@tokokuliner.com', 1, '2022-05-10', '2025-07-31 04:15:29', '2025-07-31 04:15:29'),
(4, 'TK004', 'PSM STORE', 'Secondong Estate', '02298001', 'banyuasin@tokokuliner.com', 1, '2025-08-01', '2025-08-01 01:41:56', '2025-08-01 01:41:56');

-- --------------------------------------------------------

--
-- Stand-in structure for view `view_laporan_stok`
-- (See below for the actual view)
--
CREATE TABLE `view_laporan_stok` (
`kode_barang` varchar(20)
,`nama_barang` varchar(100)
,`nama_kategori` varchar(50)
,`nama_satuan` varchar(20)
,`kode_toko` varchar(10)
,`nama_toko` varchar(100)
,`stok_awal` int
,`stok_masuk` int
,`stok_keluar` int
,`stok_akhir` int
,`expired_date` date
);

--
-- Indexes for dumped tables
--

--
-- Indexes for table `audit_log`
--
ALTER TABLE `audit_log`
  ADD PRIMARY KEY (`id_log`),
  ADD KEY `id_pengguna` (`id_pengguna`);

--
-- Indexes for table `backup_history`
--
ALTER TABLE `backup_history`
  ADD PRIMARY KEY (`id_backup`),
  ADD KEY `id_pengguna` (`id_pengguna`);

--
-- Indexes for table `barang`
--
ALTER TABLE `barang`
  ADD PRIMARY KEY (`id_barang`),
  ADD UNIQUE KEY `kode_barang` (`kode_barang`),
  ADD KEY `id_kategori` (`id_kategori`),
  ADD KEY `id_satuan` (`id_satuan`);

--
-- Indexes for table `biaya_operasional`
--
ALTER TABLE `biaya_operasional`
  ADD PRIMARY KEY (`id_biaya`),
  ADD KEY `id_toko` (`id_toko`),
  ADD KEY `id_pengguna` (`id_pengguna`);

--
-- Indexes for table `detail_mutasi`
--
ALTER TABLE `detail_mutasi`
  ADD PRIMARY KEY (`id_detail_mutasi`),
  ADD KEY `id_mutasi` (`id_mutasi`),
  ADD KEY `id_barang` (`id_barang`);

--
-- Indexes for table `detail_pembelian`
--
ALTER TABLE `detail_pembelian`
  ADD PRIMARY KEY (`id_detail_pembelian`),
  ADD KEY `id_pembelian` (`id_pembelian`),
  ADD KEY `id_barang` (`id_barang`);

--
-- Indexes for table `detail_penjualan`
--
ALTER TABLE `detail_penjualan`
  ADD PRIMARY KEY (`id_detail_penjualan`),
  ADD KEY `id_penjualan` (`id_penjualan`),
  ADD KEY `id_barang` (`id_barang`);

--
-- Indexes for table `detail_penyesuaian`
--
ALTER TABLE `detail_penyesuaian`
  ADD PRIMARY KEY (`id_detail_penyesuaian`),
  ADD KEY `id_penyesuaian` (`id_penyesuaian`),
  ADD KEY `id_barang` (`id_barang`);

--
-- Indexes for table `detail_retur_pembelian`
--
ALTER TABLE `detail_retur_pembelian`
  ADD PRIMARY KEY (`id_detail_retur_pembelian`),
  ADD KEY `id_retur_pembelian` (`id_retur_pembelian`),
  ADD KEY `id_barang` (`id_barang`);

--
-- Indexes for table `detail_retur_penjualan`
--
ALTER TABLE `detail_retur_penjualan`
  ADD PRIMARY KEY (`id_detail_retur_penjualan`),
  ADD KEY `id_retur_penjualan` (`id_retur_penjualan`),
  ADD KEY `id_barang` (`id_barang`);

--
-- Indexes for table `hak_akses`
--
ALTER TABLE `hak_akses`
  ADD PRIMARY KEY (`id_hak_akses`),
  ADD KEY `id_role` (`id_role`);

--
-- Indexes for table `hutang_pelanggan`
--
ALTER TABLE `hutang_pelanggan`
  ADD PRIMARY KEY (`id_hutang`),
  ADD KEY `id_penjualan` (`id_penjualan`),
  ADD KEY `id_pelanggan` (`id_pelanggan`);

--
-- Indexes for table `hutang_supplier`
--
ALTER TABLE `hutang_supplier`
  ADD PRIMARY KEY (`id_hutang_supplier`),
  ADD KEY `id_pembelian` (`id_pembelian`),
  ADD KEY `id_supplier` (`id_supplier`);

--
-- Indexes for table `jadwal_karyawan`
--
ALTER TABLE `jadwal_karyawan`
  ADD PRIMARY KEY (`id_jadwal`),
  ADD KEY `id_pengguna` (`id_pengguna`),
  ADD KEY `id_shift` (`id_shift`),
  ADD KEY `id_toko` (`id_toko`);

--
-- Indexes for table `kategori`
--
ALTER TABLE `kategori`
  ADD PRIMARY KEY (`id_kategori`);

--
-- Indexes for table `metode_pembayaran`
--
ALTER TABLE `metode_pembayaran`
  ADD PRIMARY KEY (`id_metode`),
  ADD UNIQUE KEY `kode_metode` (`kode_metode`);

--
-- Indexes for table `mutasi`
--
ALTER TABLE `mutasi`
  ADD PRIMARY KEY (`id_mutasi`),
  ADD UNIQUE KEY `no_mutasi` (`no_mutasi`),
  ADD KEY `id_toko_asal` (`id_toko_asal`),
  ADD KEY `id_toko_tujuan` (`id_toko_tujuan`),
  ADD KEY `id_pengguna` (`id_pengguna`);

--
-- Indexes for table `nota_pembelian`
--
ALTER TABLE `nota_pembelian`
  ADD PRIMARY KEY (`id_nota`),
  ADD KEY `id_pembelian` (`id_pembelian`);

--
-- Indexes for table `notifikasi`
--
ALTER TABLE `notifikasi`
  ADD PRIMARY KEY (`id_notifikasi`),
  ADD KEY `id_pengguna` (`id_pengguna`);

--
-- Indexes for table `pelanggan`
--
ALTER TABLE `pelanggan`
  ADD PRIMARY KEY (`id_pelanggan`),
  ADD UNIQUE KEY `kode_pelanggan` (`kode_pelanggan`);

--
-- Indexes for table `pembayaran_hutang`
--
ALTER TABLE `pembayaran_hutang`
  ADD PRIMARY KEY (`id_pembayaran_hutang`),
  ADD KEY `id_hutang` (`id_hutang`),
  ADD KEY `id_pengguna` (`id_pengguna`);

--
-- Indexes for table `pembayaran_hutang_supplier`
--
ALTER TABLE `pembayaran_hutang_supplier`
  ADD PRIMARY KEY (`id_pembayaran_hutang_supplier`),
  ADD KEY `id_hutang_supplier` (`id_hutang_supplier`),
  ADD KEY `id_pengguna` (`id_pengguna`);

--
-- Indexes for table `pembelian`
--
ALTER TABLE `pembelian`
  ADD PRIMARY KEY (`id_pembelian`),
  ADD UNIQUE KEY `no_faktur` (`no_faktur`),
  ADD KEY `id_supplier` (`id_supplier`),
  ADD KEY `id_toko` (`id_toko`),
  ADD KEY `id_pengguna` (`id_pengguna`),
  ADD KEY `fk_pembelian_metode` (`id_metode`);

--
-- Indexes for table `pengguna`
--
ALTER TABLE `pengguna`
  ADD PRIMARY KEY (`id_pengguna`),
  ADD UNIQUE KEY `username` (`username`),
  ADD KEY `id_role` (`id_role`),
  ADD KEY `id_toko` (`id_toko`);

--
-- Indexes for table `penjualan`
--
ALTER TABLE `penjualan`
  ADD PRIMARY KEY (`id_penjualan`),
  ADD UNIQUE KEY `no_transaksi` (`no_transaksi`),
  ADD KEY `id_toko` (`id_toko`),
  ADD KEY `id_pelanggan` (`id_pelanggan`),
  ADD KEY `id_pengguna` (`id_pengguna`),
  ADD KEY `id_metode` (`id_metode`);

--
-- Indexes for table `penyesuaian_stok`
--
ALTER TABLE `penyesuaian_stok`
  ADD PRIMARY KEY (`id_penyesuaian`),
  ADD UNIQUE KEY `no_penyesuaian` (`no_penyesuaian`),
  ADD KEY `id_toko` (`id_toko`),
  ADD KEY `id_pengguna` (`id_pengguna`);

--
-- Indexes for table `promo`
--
ALTER TABLE `promo`
  ADD PRIMARY KEY (`id_promo`),
  ADD UNIQUE KEY `kode_promo` (`kode_promo`),
  ADD KEY `id_toko` (`id_toko`);

--
-- Indexes for table `promo_barang`
--
ALTER TABLE `promo_barang`
  ADD PRIMARY KEY (`id_promo_barang`),
  ADD KEY `id_promo` (`id_promo`),
  ADD KEY `id_barang` (`id_barang`);

--
-- Indexes for table `retur_pembelian`
--
ALTER TABLE `retur_pembelian`
  ADD PRIMARY KEY (`id_retur_pembelian`),
  ADD UNIQUE KEY `no_retur` (`no_retur`),
  ADD KEY `id_pembelian` (`id_pembelian`),
  ADD KEY `id_pengguna` (`id_pengguna`);

--
-- Indexes for table `retur_penjualan`
--
ALTER TABLE `retur_penjualan`
  ADD PRIMARY KEY (`id_retur_penjualan`),
  ADD UNIQUE KEY `no_retur` (`no_retur`),
  ADD KEY `id_penjualan` (`id_penjualan`),
  ADD KEY `id_pengguna` (`id_pengguna`);

--
-- Indexes for table `role`
--
ALTER TABLE `role`
  ADD PRIMARY KEY (`id_role`);

--
-- Indexes for table `satuan`
--
ALTER TABLE `satuan`
  ADD PRIMARY KEY (`id_satuan`);

--
-- Indexes for table `shift`
--
ALTER TABLE `shift`
  ADD PRIMARY KEY (`id_shift`);

--
-- Indexes for table `stok_toko`
--
ALTER TABLE `stok_toko`
  ADD PRIMARY KEY (`id_stok_toko`),
  ADD UNIQUE KEY `id_barang` (`id_barang`,`id_toko`),
  ADD KEY `id_toko` (`id_toko`);

--
-- Indexes for table `supplier`
--
ALTER TABLE `supplier`
  ADD PRIMARY KEY (`id_supplier`),
  ADD UNIQUE KEY `kode_supplier` (`kode_supplier`);

--
-- Indexes for table `toko`
--
ALTER TABLE `toko`
  ADD PRIMARY KEY (`id_toko`),
  ADD UNIQUE KEY `kode_toko` (`kode_toko`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `audit_log`
--
ALTER TABLE `audit_log`
  MODIFY `id_log` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `backup_history`
--
ALTER TABLE `backup_history`
  MODIFY `id_backup` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `barang`
--
ALTER TABLE `barang`
  MODIFY `id_barang` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=22;

--
-- AUTO_INCREMENT for table `biaya_operasional`
--
ALTER TABLE `biaya_operasional`
  MODIFY `id_biaya` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `detail_mutasi`
--
ALTER TABLE `detail_mutasi`
  MODIFY `id_detail_mutasi` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `detail_pembelian`
--
ALTER TABLE `detail_pembelian`
  MODIFY `id_detail_pembelian` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `detail_penjualan`
--
ALTER TABLE `detail_penjualan`
  MODIFY `id_detail_penjualan` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `detail_penyesuaian`
--
ALTER TABLE `detail_penyesuaian`
  MODIFY `id_detail_penyesuaian` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `detail_retur_pembelian`
--
ALTER TABLE `detail_retur_pembelian`
  MODIFY `id_detail_retur_pembelian` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `detail_retur_penjualan`
--
ALTER TABLE `detail_retur_penjualan`
  MODIFY `id_detail_retur_penjualan` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hak_akses`
--
ALTER TABLE `hak_akses`
  MODIFY `id_hak_akses` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT for table `hutang_pelanggan`
--
ALTER TABLE `hutang_pelanggan`
  MODIFY `id_hutang` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `hutang_supplier`
--
ALTER TABLE `hutang_supplier`
  MODIFY `id_hutang_supplier` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `jadwal_karyawan`
--
ALTER TABLE `jadwal_karyawan`
  MODIFY `id_jadwal` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `kategori`
--
ALTER TABLE `kategori`
  MODIFY `id_kategori` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `metode_pembayaran`
--
ALTER TABLE `metode_pembayaran`
  MODIFY `id_metode` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `mutasi`
--
ALTER TABLE `mutasi`
  MODIFY `id_mutasi` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `nota_pembelian`
--
ALTER TABLE `nota_pembelian`
  MODIFY `id_nota` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `notifikasi`
--
ALTER TABLE `notifikasi`
  MODIFY `id_notifikasi` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `pelanggan`
--
ALTER TABLE `pelanggan`
  MODIFY `id_pelanggan` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `pembayaran_hutang`
--
ALTER TABLE `pembayaran_hutang`
  MODIFY `id_pembayaran_hutang` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `pembayaran_hutang_supplier`
--
ALTER TABLE `pembayaran_hutang_supplier`
  MODIFY `id_pembayaran_hutang_supplier` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `pembelian`
--
ALTER TABLE `pembelian`
  MODIFY `id_pembelian` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `pengguna`
--
ALTER TABLE `pengguna`
  MODIFY `id_pengguna` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `penjualan`
--
ALTER TABLE `penjualan`
  MODIFY `id_penjualan` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `penyesuaian_stok`
--
ALTER TABLE `penyesuaian_stok`
  MODIFY `id_penyesuaian` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `promo`
--
ALTER TABLE `promo`
  MODIFY `id_promo` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `promo_barang`
--
ALTER TABLE `promo_barang`
  MODIFY `id_promo_barang` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=34;

--
-- AUTO_INCREMENT for table `retur_pembelian`
--
ALTER TABLE `retur_pembelian`
  MODIFY `id_retur_pembelian` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `retur_penjualan`
--
ALTER TABLE `retur_penjualan`
  MODIFY `id_retur_penjualan` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `role`
--
ALTER TABLE `role`
  MODIFY `id_role` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `satuan`
--
ALTER TABLE `satuan`
  MODIFY `id_satuan` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `shift`
--
ALTER TABLE `shift`
  MODIFY `id_shift` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `stok_toko`
--
ALTER TABLE `stok_toko`
  MODIFY `id_stok_toko` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=37;

--
-- AUTO_INCREMENT for table `supplier`
--
ALTER TABLE `supplier`
  MODIFY `id_supplier` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `toko`
--
ALTER TABLE `toko`
  MODIFY `id_toko` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

-- --------------------------------------------------------

--
-- Structure for view `view_laporan_stok`
--
DROP TABLE IF EXISTS `view_laporan_stok`;

CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `view_laporan_stok`  AS SELECT `b`.`kode_barang` AS `kode_barang`, `b`.`nama_barang` AS `nama_barang`, `k`.`nama_kategori` AS `nama_kategori`, `s`.`nama_satuan` AS `nama_satuan`, `t`.`kode_toko` AS `kode_toko`, `t`.`nama_toko` AS `nama_toko`, `st`.`stok_awal` AS `stok_awal`, `st`.`stok_masuk` AS `stok_masuk`, `st`.`stok_keluar` AS `stok_keluar`, `st`.`stok_akhir` AS `stok_akhir`, `st`.`expired_date` AS `expired_date` FROM ((((`stok_toko` `st` join `barang` `b` on((`st`.`id_barang` = `b`.`id_barang`))) join `kategori` `k` on((`b`.`id_kategori` = `k`.`id_kategori`))) join `satuan` `s` on((`b`.`id_satuan` = `s`.`id_satuan`))) join `toko` `t` on((`st`.`id_toko` = `t`.`id_toko`))) ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `audit_log`
--
ALTER TABLE `audit_log`
  ADD CONSTRAINT `audit_log_ibfk_1` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`);

--
-- Constraints for table `backup_history`
--
ALTER TABLE `backup_history`
  ADD CONSTRAINT `backup_history_ibfk_1` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`);

--
-- Constraints for table `barang`
--
ALTER TABLE `barang`
  ADD CONSTRAINT `barang_ibfk_1` FOREIGN KEY (`id_kategori`) REFERENCES `kategori` (`id_kategori`),
  ADD CONSTRAINT `barang_ibfk_2` FOREIGN KEY (`id_satuan`) REFERENCES `satuan` (`id_satuan`);

--
-- Constraints for table `biaya_operasional`
--
ALTER TABLE `biaya_operasional`
  ADD CONSTRAINT `biaya_operasional_ibfk_1` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  ADD CONSTRAINT `biaya_operasional_ibfk_2` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`);

--
-- Constraints for table `detail_mutasi`
--
ALTER TABLE `detail_mutasi`
  ADD CONSTRAINT `detail_mutasi_ibfk_1` FOREIGN KEY (`id_mutasi`) REFERENCES `mutasi` (`id_mutasi`),
  ADD CONSTRAINT `detail_mutasi_ibfk_2` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`);

--
-- Constraints for table `detail_pembelian`
--
ALTER TABLE `detail_pembelian`
  ADD CONSTRAINT `detail_pembelian_ibfk_1` FOREIGN KEY (`id_pembelian`) REFERENCES `pembelian` (`id_pembelian`),
  ADD CONSTRAINT `detail_pembelian_ibfk_2` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`);

--
-- Constraints for table `detail_penjualan`
--
ALTER TABLE `detail_penjualan`
  ADD CONSTRAINT `detail_penjualan_ibfk_1` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`),
  ADD CONSTRAINT `detail_penjualan_ibfk_2` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`);

--
-- Constraints for table `detail_penyesuaian`
--
ALTER TABLE `detail_penyesuaian`
  ADD CONSTRAINT `detail_penyesuaian_ibfk_1` FOREIGN KEY (`id_penyesuaian`) REFERENCES `penyesuaian_stok` (`id_penyesuaian`),
  ADD CONSTRAINT `detail_penyesuaian_ibfk_2` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`);

--
-- Constraints for table `detail_retur_pembelian`
--
ALTER TABLE `detail_retur_pembelian`
  ADD CONSTRAINT `detail_retur_pembelian_ibfk_1` FOREIGN KEY (`id_retur_pembelian`) REFERENCES `retur_pembelian` (`id_retur_pembelian`),
  ADD CONSTRAINT `detail_retur_pembelian_ibfk_2` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`);

--
-- Constraints for table `detail_retur_penjualan`
--
ALTER TABLE `detail_retur_penjualan`
  ADD CONSTRAINT `detail_retur_penjualan_ibfk_1` FOREIGN KEY (`id_retur_penjualan`) REFERENCES `retur_penjualan` (`id_retur_penjualan`),
  ADD CONSTRAINT `detail_retur_penjualan_ibfk_2` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`);

--
-- Constraints for table `hak_akses`
--
ALTER TABLE `hak_akses`
  ADD CONSTRAINT `hak_akses_ibfk_1` FOREIGN KEY (`id_role`) REFERENCES `role` (`id_role`);

--
-- Constraints for table `hutang_pelanggan`
--
ALTER TABLE `hutang_pelanggan`
  ADD CONSTRAINT `hutang_pelanggan_ibfk_1` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`),
  ADD CONSTRAINT `hutang_pelanggan_ibfk_2` FOREIGN KEY (`id_pelanggan`) REFERENCES `pelanggan` (`id_pelanggan`);

--
-- Constraints for table `hutang_supplier`
--
ALTER TABLE `hutang_supplier`
  ADD CONSTRAINT `hutang_supplier_ibfk_1` FOREIGN KEY (`id_pembelian`) REFERENCES `pembelian` (`id_pembelian`),
  ADD CONSTRAINT `hutang_supplier_ibfk_2` FOREIGN KEY (`id_supplier`) REFERENCES `supplier` (`id_supplier`);

--
-- Constraints for table `jadwal_karyawan`
--
ALTER TABLE `jadwal_karyawan`
  ADD CONSTRAINT `jadwal_karyawan_ibfk_1` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`),
  ADD CONSTRAINT `jadwal_karyawan_ibfk_2` FOREIGN KEY (`id_shift`) REFERENCES `shift` (`id_shift`),
  ADD CONSTRAINT `jadwal_karyawan_ibfk_3` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`);

--
-- Constraints for table `mutasi`
--
ALTER TABLE `mutasi`
  ADD CONSTRAINT `mutasi_ibfk_1` FOREIGN KEY (`id_toko_asal`) REFERENCES `toko` (`id_toko`),
  ADD CONSTRAINT `mutasi_ibfk_2` FOREIGN KEY (`id_toko_tujuan`) REFERENCES `toko` (`id_toko`),
  ADD CONSTRAINT `mutasi_ibfk_3` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`);

--
-- Constraints for table `nota_pembelian`
--
ALTER TABLE `nota_pembelian`
  ADD CONSTRAINT `nota_pembelian_ibfk_1` FOREIGN KEY (`id_pembelian`) REFERENCES `pembelian` (`id_pembelian`);

--
-- Constraints for table `notifikasi`
--
ALTER TABLE `notifikasi`
  ADD CONSTRAINT `notifikasi_ibfk_1` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`);

--
-- Constraints for table `pembayaran_hutang`
--
ALTER TABLE `pembayaran_hutang`
  ADD CONSTRAINT `pembayaran_hutang_ibfk_1` FOREIGN KEY (`id_hutang`) REFERENCES `hutang_pelanggan` (`id_hutang`),
  ADD CONSTRAINT `pembayaran_hutang_ibfk_2` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`);

--
-- Constraints for table `pembayaran_hutang_supplier`
--
ALTER TABLE `pembayaran_hutang_supplier`
  ADD CONSTRAINT `pembayaran_hutang_supplier_ibfk_1` FOREIGN KEY (`id_hutang_supplier`) REFERENCES `hutang_supplier` (`id_hutang_supplier`),
  ADD CONSTRAINT `pembayaran_hutang_supplier_ibfk_2` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`);

--
-- Constraints for table `pembelian`
--
ALTER TABLE `pembelian`
  ADD CONSTRAINT `fk_pembelian_metode` FOREIGN KEY (`id_metode`) REFERENCES `metode_pembayaran` (`id_metode`),
  ADD CONSTRAINT `pembelian_ibfk_1` FOREIGN KEY (`id_supplier`) REFERENCES `supplier` (`id_supplier`),
  ADD CONSTRAINT `pembelian_ibfk_2` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  ADD CONSTRAINT `pembelian_ibfk_3` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`);

--
-- Constraints for table `pengguna`
--
ALTER TABLE `pengguna`
  ADD CONSTRAINT `pengguna_ibfk_1` FOREIGN KEY (`id_role`) REFERENCES `role` (`id_role`),
  ADD CONSTRAINT `pengguna_ibfk_2` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`);

--
-- Constraints for table `penjualan`
--
ALTER TABLE `penjualan`
  ADD CONSTRAINT `penjualan_ibfk_1` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  ADD CONSTRAINT `penjualan_ibfk_2` FOREIGN KEY (`id_pelanggan`) REFERENCES `pelanggan` (`id_pelanggan`),
  ADD CONSTRAINT `penjualan_ibfk_3` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`),
  ADD CONSTRAINT `penjualan_ibfk_4` FOREIGN KEY (`id_metode`) REFERENCES `metode_pembayaran` (`id_metode`);

--
-- Constraints for table `penyesuaian_stok`
--
ALTER TABLE `penyesuaian_stok`
  ADD CONSTRAINT `penyesuaian_stok_ibfk_1` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  ADD CONSTRAINT `penyesuaian_stok_ibfk_2` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`);

--
-- Constraints for table `promo`
--
ALTER TABLE `promo`
  ADD CONSTRAINT `promo_ibfk_1` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`);

--
-- Constraints for table `promo_barang`
--
ALTER TABLE `promo_barang`
  ADD CONSTRAINT `promo_barang_ibfk_1` FOREIGN KEY (`id_promo`) REFERENCES `promo` (`id_promo`),
  ADD CONSTRAINT `promo_barang_ibfk_2` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`);

--
-- Constraints for table `retur_pembelian`
--
ALTER TABLE `retur_pembelian`
  ADD CONSTRAINT `retur_pembelian_ibfk_1` FOREIGN KEY (`id_pembelian`) REFERENCES `pembelian` (`id_pembelian`),
  ADD CONSTRAINT `retur_pembelian_ibfk_2` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`);

--
-- Constraints for table `retur_penjualan`
--
ALTER TABLE `retur_penjualan`
  ADD CONSTRAINT `retur_penjualan_ibfk_1` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`),
  ADD CONSTRAINT `retur_penjualan_ibfk_2` FOREIGN KEY (`id_pengguna`) REFERENCES `pengguna` (`id_pengguna`);

--
-- Constraints for table `stok_toko`
--
ALTER TABLE `stok_toko`
  ADD CONSTRAINT `stok_toko_ibfk_1` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`),
  ADD CONSTRAINT `stok_toko_ibfk_2` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
