<?php
session_start();
require_once 'config.php';

// Cek koneksi database
if (!$conn) {
    die(json_encode(['error' => 'Database connection failed']));
}

// Ambil keyword pencarian
$keyword = isset($_GET['keyword']) ? trim($_GET['keyword']) : '';

if (empty($keyword)) {
    die(json_encode([]));
}

// Query pencarian barang
$query = "SELECT b.id_barang, b.kode_barang, b.nama_barang, b.harga_jual, 
                 s.stok_akhir as stok, k.nama_kategori
          FROM barang b
          JOIN kategori k ON b.id_kategori = k.id_kategori
          LEFT JOIN stok_toko s ON b.id_barang = s.id_barang AND s.id_toko = 1
          WHERE (b.kode_barang LIKE ? OR b.nama_barang LIKE ?) AND b.is_active = 1
          LIMIT 10";

$stmt = mysqli_prepare($conn, $query);
$search_term = "%$keyword%";
mysqli_stmt_bind_param($stmt, "ss", $search_term, $search_term);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$barang = [];
while ($row = mysqli_fetch_assoc($result)) {
    $barang[] = [
        'id_barang' => $row['id_barang'],
        'kode_barang' => $row['kode_barang'],
        'nama_barang' => $row['nama_barang'],
        'harga_jual' => $row['harga_jual'],
        'stok' => $row['stok'],
        'kategori' => $row['nama_kategori']
    ];
}

header('Content-Type: application/json');
echo json_encode($barang);
?>