<?php
session_start();
require_once 'config.php';

// Cek session
if (!isset($_SESSION['id_pengguna'])) {
    echo json_encode([]);
    exit();
}

// Ambil keyword pencarian
$keyword = isset($_GET['keyword']) ? trim($_GET['keyword']) : '';

if (strlen($keyword) < 2) {
    echo json_encode([]);
    exit();
}

// Query pencarian barang dengan stok dari semua toko
$query = "SELECT b.id_barang, b.kode_barang, b.nama_barang, b.harga_beli, 
                 k.nama_kategori, SUM(COALESCE(s.stok_akhir, 0)) as stok
          FROM barang b
          JOIN kategori k ON b.id_kategori = k.id_kategori
          LEFT JOIN stok_toko s ON b.id_barang = s.id_barang
          WHERE (b.nama_barang LIKE ? OR b.kode_barang LIKE ? OR b.barcode LIKE ?) 
          AND b.is_active = 1
          GROUP BY b.id_barang
          ORDER BY b.nama_barang
          LIMIT 10";

$stmt = mysqli_prepare($conn, $query);
$like_keyword = "%$keyword%";
mysqli_stmt_bind_param($stmt, 'sss', $like_keyword, $like_keyword, $like_keyword);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$barang = [];
while ($row = mysqli_fetch_assoc($result)) {
    $barang[] = $row;
}

header('Content-Type: application/json');
echo json_encode($barang);
?>