<?php
// Start session jika belum dimulai
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
require_once 'config.php';

// Cek koneksi database
if (!$conn) {
    die("Koneksi database gagal: " . mysqli_connect_error());
}

// Fungsi untuk format rupiah
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Fungsi untuk upload gambar
function upload_gambar($file, $prefix = 'barang') {
    $target_dir = "uploads/barang/";
    if (!file_exists($target_dir)) {
        mkdir($target_dir, 0777, true);
    }
    
    $extension = strtolower(pathinfo($file["name"], PATHINFO_EXTENSION));
    $filename = $prefix . '_' . uniqid() . '.' . $extension;
    $target_file = $target_dir . $filename;
    
    // Cek apakah file adalah gambar
    $check = getimagesize($file["tmp_name"]);
    if ($check === false) {
        return ['status' => false, 'message' => 'File bukan gambar'];
    }
    
    // Cek ukuran file
    if ($file["size"] > 2000000) {
        return ['status' => false, 'message' => 'Ukuran gambar terlalu besar (max 2MB)'];
    }
    
    // Izinkan format tertentu
    if (!in_array($extension, ['jpg', 'jpeg', 'png', 'gif'])) {
        return ['status' => false, 'message' => 'Hanya format JPG, JPEG, PNG & GIF yang diizinkan'];
    }
    
    // Coba upload file
    if (move_uploaded_file($file["tmp_name"], $target_file)) {
        return ['status' => true, 'file_name' => $target_file];
    } else {
        return ['status' => false, 'message' => 'Gagal mengupload gambar'];
    }
}

// Proses tambah barang
if (isset($_POST['tambah_barang'])) {
    $kode_barang = mysqli_real_escape_string($conn, $_POST['kode_barang']);
    $nama_barang = mysqli_real_escape_string($conn, $_POST['nama_barang']);
    $id_kategori = mysqli_real_escape_string($conn, $_POST['id_kategori']);
    $id_satuan = mysqli_real_escape_string($conn, $_POST['id_satuan']);
    $harga_beli = mysqli_real_escape_string($conn, str_replace('.', '', $_POST['harga_beli']));
    $harga_jual = mysqli_real_escape_string($conn, str_replace('.', '', $_POST['harga_jual']));
    $stok_minimal = mysqli_real_escape_string($conn, $_POST['stok_minimal']);
    $deskripsi = mysqli_real_escape_string($conn, $_POST['deskripsi']);
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    
    // Handle barcode (teks atau gambar)
    $barcode = '';
    if (!empty($_FILES['barcode_image']['name'])) {
        $upload_barcode = upload_gambar($_FILES['barcode_image'], 'barcode');
        if ($upload_barcode['status']) {
            $barcode = $upload_barcode['file_name'];
        } else {
            $_SESSION['pesan'] = ['tipe' => 'warning', 'isi' => 'Gagal upload barcode: ' . $upload_barcode['message']];
        }
    } else {
        $barcode = mysqli_real_escape_string($conn, $_POST['barcode'] ?? '');
    }
    
    // Query tambah barang
    $query = "INSERT INTO barang (kode_barang, barcode, nama_barang, id_kategori, id_satuan, harga_beli, harga_jual, stok_minimal, deskripsi, is_active) 
              VALUES ('$kode_barang', '$barcode', '$nama_barang', '$id_kategori', '$id_satuan', '$harga_beli', '$harga_jual', '$stok_minimal', '$deskripsi', '$is_active')";
    
    if (mysqli_query($conn, $query)) {
        $id_barang = mysqli_insert_id($conn);
        
        // Upload gambar barang jika ada
        if (!empty($_FILES['foto_barang']['name'])) {
            $upload = upload_gambar($_FILES['foto_barang'], 'barang_' . $id_barang);
            if ($upload['status']) {
                $foto_barang = $upload['file_name'];
                mysqli_query($conn, "UPDATE barang SET foto_barang = '$foto_barang' WHERE id_barang = '$id_barang'");
            } else {
                $_SESSION['pesan'] = ['tipe' => 'warning', 'isi' => 'Barang berhasil ditambahkan tetapi gagal upload gambar: ' . $upload['message']];
            }
        }
        
        // Tambahkan stok awal ke toko utama
        $id_toko = 1; // Ganti dengan ID toko yang sesuai
        $query_stok = "INSERT INTO stok_toko (id_barang, id_toko, stok_awal, stok_akhir) 
                       VALUES ('$id_barang', '$id_toko', 0, 0)";
        mysqli_query($conn, $query_stok);
        
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Barang berhasil ditambahkan'];
        header("Location: barang.php");
        exit();
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menambahkan barang: ' . mysqli_error($conn)];
    }
}

// Proses edit barang
if (isset($_POST['edit_barang'])) {
    $id_barang = mysqli_real_escape_string($conn, $_POST['id_barang']);
    $kode_barang = mysqli_real_escape_string($conn, $_POST['kode_barang']);
    $nama_barang = mysqli_real_escape_string($conn, $_POST['nama_barang']);
    $id_kategori = mysqli_real_escape_string($conn, $_POST['id_kategori']);
    $id_satuan = mysqli_real_escape_string($conn, $_POST['id_satuan']);
    $harga_beli = mysqli_real_escape_string($conn, str_replace('.', '', $_POST['harga_beli']));
    $harga_jual = mysqli_real_escape_string($conn, str_replace('.', '', $_POST['harga_jual']));
    $stok_minimal = mysqli_real_escape_string($conn, $_POST['stok_minimal']);
    $deskripsi = mysqli_real_escape_string($conn, $_POST['deskripsi']);
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    
    // Handle barcode (teks atau gambar)
    $query_barcode = mysqli_query($conn, "SELECT barcode FROM barang WHERE id_barang = '$id_barang'");
    $barcode_data = mysqli_fetch_assoc($query_barcode);
    $barcode = $barcode_data['barcode'];
    
    if (!empty($_FILES['barcode_image']['name'])) {
        $upload_barcode = upload_gambar($_FILES['barcode_image'], 'barcode');
        if ($upload_barcode['status']) {
            // Hapus barcode lama jika ada dan berupa gambar
            if ($barcode && file_exists($barcode)) {
                unlink($barcode);
            }
            $barcode = $upload_barcode['file_name'];
        } else {
            $_SESSION['pesan'] = ['tipe' => 'warning', 'isi' => 'Barang berhasil diupdate tetapi gagal upload barcode: ' . $upload_barcode['message']];
        }
    } elseif (!empty($_POST['barcode'])) {
        // Jika input barcode teks diisi dan barcode sebelumnya adalah gambar, hapus gambar lama
        if ($barcode && file_exists($barcode)) {
            unlink($barcode);
        }
        $barcode = mysqli_real_escape_string($conn, $_POST['barcode']);
    }
    
    // Query update barang
    $query = "UPDATE barang SET 
              kode_barang = '$kode_barang',
              barcode = '$barcode',
              nama_barang = '$nama_barang',
              id_kategori = '$id_kategori',
              id_satuan = '$id_satuan',
              harga_beli = '$harga_beli',
              harga_jual = '$harga_jual',
              stok_minimal = '$stok_minimal',
              deskripsi = '$deskripsi',
              is_active = '$is_active',
              updated_at = NOW()
              WHERE id_barang = '$id_barang'";
    
    if (mysqli_query($conn, $query)) {
        // Upload gambar baru jika ada
        if (!empty($_FILES['foto_barang']['name'])) {
            // Hapus foto lama jika ada
            $query_foto = mysqli_query($conn, "SELECT foto_barang FROM barang WHERE id_barang = '$id_barang'");
            $foto_lama = mysqli_fetch_assoc($query_foto)['foto_barang'];
            if ($foto_lama && file_exists($foto_lama)) {
                unlink($foto_lama);
            }
            
            $upload = upload_gambar($_FILES['foto_barang'], 'barang_' . $id_barang);
            if ($upload['status']) {
                $foto_barang = $upload['file_name'];
                mysqli_query($conn, "UPDATE barang SET foto_barang = '$foto_barang' WHERE id_barang = '$id_barang'");
            } else {
                $_SESSION['pesan'] = ['tipe' => 'warning', 'isi' => 'Barang berhasil diupdate tetapi gagal upload gambar: ' . $upload['message']];
            }
        }
        
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Barang berhasil diupdate'];
        header("Location: barang.php");
        exit();
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal mengupdate barang: ' . mysqli_error($conn)];
    }
}

// Proses hapus barang (soft delete)
if (isset($_GET['hapus'])) {
    $id_barang = mysqli_real_escape_string($conn, $_GET['hapus']);
    $query = "UPDATE barang SET is_active = 0 WHERE id_barang = '$id_barang'";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Barang berhasil dinonaktifkan'];
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menonaktifkan barang: ' . mysqli_error($conn)];
    }
    header("Location: barang.php");
    exit();
}

// Proses aktifkan barang
if (isset($_GET['aktifkan'])) {
    $id_barang = mysqli_real_escape_string($conn, $_GET['aktifkan']);
    $query = "UPDATE barang SET is_active = 1 WHERE id_barang = '$id_barang'";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Barang berhasil diaktifkan'];
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal mengaktifkan barang: ' . mysqli_error($conn)];
    }
    header("Location: barang.php");
    exit();
}

// Filter dan pencarian
$filter_nama = isset($_GET['filter_nama']) ? mysqli_real_escape_string($conn, $_GET['filter_nama']) : '';
$filter_kategori = isset($_GET['filter_kategori']) ? mysqli_real_escape_string($conn, $_GET['filter_kategori']) : '';
$filter_status = isset($_GET['filter_status']) ? mysqli_real_escape_string($conn, $_GET['filter_status']) : '';

// Query untuk mendapatkan data barang dengan join ke kategori dan satuan
$query_barang = "SELECT b.*, k.nama_kategori, s.nama_satuan, 
                (SELECT st.stok_akhir FROM stok_toko st WHERE st.id_barang = b.id_barang AND st.id_toko = 1 LIMIT 1) as stok_toko
                FROM barang b
                LEFT JOIN kategori k ON b.id_kategori = k.id_kategori
                LEFT JOIN satuan s ON b.id_satuan = s.id_satuan
                WHERE 1=1";

// Tambahkan filter jika ada
if (!empty($filter_nama)) {
    $query_barang .= " AND b.nama_barang LIKE '%$filter_nama%'";
}
if (!empty($filter_kategori) && $filter_kategori != 'semua') {
    $query_barang .= " AND b.id_kategori = '$filter_kategori'";
}
if (!empty($filter_status) && $filter_status != 'semua') {
    $query_barang .= " AND b.is_active = " . ($filter_status == 'aktif' ? 1 : 0);
}

$query_barang .= " ORDER BY b.nama_barang ASC";
$result_barang = mysqli_query($conn, $query_barang);

// Query untuk dropdown kategori
$query_kategori = "SELECT * FROM kategori ORDER BY nama_kategori ASC";
$result_kategori = mysqli_query($conn, $query_kategori);

// Query untuk dropdown satuan
$query_satuan = "SELECT * FROM satuan ORDER BY nama_satuan ASC";
$result_satuan = mysqli_query($conn, $query_satuan);

// Cek apakah ada barang dengan stok kurang dari stok minimal
$query_stok_minimal = "SELECT COUNT(*) as total FROM barang b 
                      JOIN stok_toko s ON b.id_barang = s.id_barang 
                      WHERE s.stok_akhir <= b.stok_minimal AND s.id_toko = 1";
$result_stok_minimal = mysqli_query($conn, $query_stok_minimal);
$stok_minimal = mysqli_fetch_assoc($result_stok_minimal)['total'];
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Manajemen Barang</h1>
        <div class="d-none d-sm-inline-block">
            <button class="btn btn-primary-custom" data-bs-toggle="modal" data-bs-target="#tambahBarangModal">
                <i class="fas fa-plus-circle fa-sm"></i> Tambah Barang
            </button>
        </div>
    </div>
    
    <!-- Notifikasi -->
    <?php if (isset($_SESSION['pesan'])) : ?>
        <div class="alert alert-<?= $_SESSION['pesan']['tipe'] ?> alert-dismissible fade show" role="alert">
            <?= $_SESSION['pesan']['isi'] ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php unset($_SESSION['pesan']); ?>
    <?php endif; ?>
    
    <!-- Filter dan Pencarian -->
    <div class="card mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary-custom">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="get" action="">
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label for="filter_nama" class="form-label">Nama Barang</label>
                        <input type="text" class="form-control" id="filter_nama" name="filter_nama" 
                               value="<?= htmlspecialchars($filter_nama) ?>" placeholder="Cari nama barang...">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="filter_kategori" class="form-label">Kategori</label>
                        <select class="form-select" id="filter_kategori" name="filter_kategori">
                            <option value="semua">Semua Kategori</option>
                            <?php while ($kategori = mysqli_fetch_assoc($result_kategori)) : ?>
                                <option value="<?= $kategori['id_kategori'] ?>" <?= ($filter_kategori == $kategori['id_kategori']) ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($kategori['nama_kategori']) ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="filter_status" class="form-label">Status</label>
                        <select class="form-select" id="filter_status" name="filter_status">
                            <option value="semua" <?= ($filter_status == 'semua') ? 'selected' : '' ?>>Semua Status</option>
                            <option value="aktif" <?= ($filter_status == 'aktif') ? 'selected' : '' ?>>Aktif</option>
                            <option value="nonaktif" <?= ($filter_status == 'nonaktif') ? 'selected' : '' ?>>Nonaktif</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary-custom me-2">
                            <i class="fas fa-filter fa-sm"></i> Filter
                        </button>
                        <a href="barang.php" class="btn btn-secondary">
                            <i class="fas fa-sync-alt fa-sm"></i> Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Card untuk Barang Hampir Habis -->
    <?php if ($stok_minimal > 0) : ?>
    <div class="alert alert-warning animate-fade-in" style="animation-delay: 0.2s;">
        <i class="fas fa-exclamation-triangle me-2"></i>
        Ada <strong><?= $stok_minimal ?></strong> barang yang stoknya kurang dari stok minimal. 
        <a href="#" class="alert-link" data-bs-toggle="modal" data-bs-target="#stokMinimalModal">Lihat detail</a>
    </div>
    <?php endif; ?>
    
    <!-- Tabel Data Barang -->
    <div class="card animate-fade-in" style="animation-delay: 0.3s;">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary-custom">Daftar Barang</h6>
            <div>
                <button class="btn btn-sm btn-success me-2" data-bs-toggle="modal" data-bs-target="#exportModal">
                    <i class="fas fa-file-export fa-sm"></i> Export
                </button>
                <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#importModal">
                    <i class="fas fa-file-import fa-sm"></i> Import
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead class="bg-primary-custom text-white">
                        <tr>
                            <th width="5%">No</th>
                            <th width="10%">Kode</th>
                            <th width="10%">Barcode</th>
                            <th>Nama Barang</th>
                            <th width="10%">Kategori</th>
                            <th width="8%">Satuan</th>
                            <th width="10%">Harga Beli</th>
                            <th width="10%">Harga Jual</th>
                            <th width="8%">Stok</th>
                            <th width="8%">Min Stok</th>
                            <th width="5%">Foto</th>
                            <th width="8%">Status</th>
                            <th width="12%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (mysqli_num_rows($result_barang) > 0) : ?>
                            <?php $no = 1; ?>
                            <?php while ($barang = mysqli_fetch_assoc($result_barang)) : ?>
                                <tr class="<?= ($barang['stok_toko'] <= $barang['stok_minimal']) ? 'table-warning' : '' ?>">
                                    <td><?= $no++ ?></td>
                                    <td><?= htmlspecialchars($barang['kode_barang']) ?></td>
                                    <td>
                                        <?php if (!empty($barang['barcode']) && file_exists($barang['barcode'])) : ?>
                                            <img src="<?= $barang['barcode'] ?>" alt="Barcode" class="img-thumbnail" width="50" height="50">
                                        <?php else : ?>
                                            <?= htmlspecialchars($barang['barcode']) ?>
                                        <?php endif; ?>
                                    </td>
                                    <td><?= htmlspecialchars($barang['nama_barang']) ?></td>
                                    <td><?= htmlspecialchars($barang['nama_kategori']) ?></td>
                                    <td><?= htmlspecialchars($barang['nama_satuan']) ?></td>
                                    <td class="text-end"><?= format_rupiah($barang['harga_beli']) ?></td>
                                    <td class="text-end"><?= format_rupiah($barang['harga_jual']) ?></td>
                                    <td class="text-center <?= ($barang['stok_toko'] <= $barang['stok_minimal']) ? 'text-danger fw-bold' : '' ?>">
                                        <?= $barang['stok_toko'] ?>
                                    </td>
                                    <td class="text-center"><?= $barang['stok_minimal'] ?></td>
                                    <td class="text-center">
                                        <?php if (!empty($barang['foto_barang'])) : ?>
                                            <img src="<?= $barang['foto_barang'] ?>" alt="Foto Barang" class="img-thumbnail" width="50" height="50">
                                        <?php else : ?>
                                            <span class="text-muted">No Image</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-<?= ($barang['is_active'] == 1) ? 'success' : 'danger' ?>">
                                            <?= ($barang['is_active'] == 1) ? 'Aktif' : 'Nonaktif' ?>
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <button class="btn btn-sm btn-info btn-detail" data-bs-toggle="modal" data-bs-target="#detailBarangModal" 
                                                data-id="<?= $barang['id_barang'] ?>" title="Detail">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning btn-edit" data-bs-toggle="modal" data-bs-target="#editBarangModal" 
                                                data-id="<?= $barang['id_barang'] ?>" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <?php if ($barang['is_active'] == 1) : ?>
                                            <a href="barang.php?hapus=<?= $barang['id_barang'] ?>" class="btn btn-sm btn-danger" 
                                               onclick="return confirm('Yakin ingin menonaktifkan barang ini?')" title="Nonaktifkan">
                                                <i class="fas fa-trash-alt"></i>
                                            </a>
                                        <?php else : ?>
                                            <a href="barang.php?aktifkan=<?= $barang['id_barang'] ?>" class="btn btn-sm btn-success" 
                                               onclick="return confirm('Yakin ingin mengaktifkan barang ini?')" title="Aktifkan">
                                                <i class="fas fa-check-circle"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="13" class="text-center">Tidak ada data barang</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Tambah Barang -->
<div class="modal fade" id="tambahBarangModal" tabindex="-1" aria-labelledby="tambahBarangModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title" id="tambahBarangModalLabel">Tambah Barang Baru</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="kode_barang" class="form-label">Kode Barang <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="kode_barang" name="kode_barang" required>
                            <small class="text-muted">Kode unik untuk identifikasi barang</small>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="barcode" class="form-label">Barcode</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="barcode" name="barcode">
                                <input type="file" class="form-control d-none" id="barcode_image" name="barcode_image" accept="image/*">
                                <button type="button" class="btn btn-outline-secondary" id="toggle_barcode_input">
                                    <i class="fas fa-camera"></i>
                                </button>
                            </div>
                            <small class="text-muted">Scan atau upload gambar barcode</small>
                            <div id="barcode_preview" class="mt-2"></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="nama_barang" class="form-label">Nama Barang <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="nama_barang" name="nama_barang" required>
                            <small class="text-muted">Nama lengkap barang</small>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="id_kategori" class="form-label">Kategori <span class="text-danger">*</span></label>
                            <select class="form-select" id="id_kategori" name="id_kategori" required>
                                <option value="">Pilih Kategori</option>
                                <?php mysqli_data_seek($result_kategori, 0); ?>
                                <?php while ($kategori = mysqli_fetch_assoc($result_kategori)) : ?>
                                    <option value="<?= $kategori['id_kategori'] ?>"><?= htmlspecialchars($kategori['nama_kategori']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="id_satuan" class="form-label">Satuan <span class="text-danger">*</span></label>
                            <select class="form-select" id="id_satuan" name="id_satuan" required>
                                <option value="">Pilih Satuan</option>
                                <?php mysqli_data_seek($result_satuan, 0); ?>
                                <?php while ($satuan = mysqli_fetch_assoc($result_satuan)) : ?>
                                    <option value="<?= $satuan['id_satuan'] ?>"><?= htmlspecialchars($satuan['nama_satuan']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="harga_beli" class="form-label">Harga Beli <span class="text-danger">*</span></label>
                            <input type="text" class="form-control rupiah" id="harga_beli" name="harga_beli" required>
                            <small class="text-muted">Harga beli dari supplier</small>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="harga_jual" class="form-label">Harga Jual <span class="text-danger">*</span></label>
                            <input type="text" class="form-control rupiah" id="harga_jual" name="harga_jual" required>
                            <small class="text-muted">Harga jual ke pelanggan</small>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="stok_minimal" class="form-label">Stok Minimal</label>
                            <input type="number" class="form-control" id="stok_minimal" name="stok_minimal" min="0" value="0">
                            <small class="text-muted">Stok minimal sebelum restock</small>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="foto_barang" class="form-label">Foto Barang</label>
                            <input type="file" class="form-control" id="foto_barang" name="foto_barang" accept="image/*">
                            <small class="text-muted">Format: JPG, PNG (max 2MB)</small>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="deskripsi" class="form-label">Deskripsi</label>
                        <textarea class="form-control" id="deskripsi" name="deskripsi" rows="3"></textarea>
                        <small class="text-muted">Deskripsi tambahan tentang barang</small>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="is_active" name="is_active" checked>
                        <label class="form-check-label" for="is_active">
                            Aktif
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary-custom" name="tambah_barang">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Edit Barang -->
<div class="modal fade" id="editBarangModal" tabindex="-1" aria-labelledby="editBarangModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title" id="editBarangModalLabel">Edit Barang</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="" enctype="multipart/form-data">
                <input type="hidden" id="edit_id_barang" name="id_barang">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="edit_kode_barang" class="form-label">Kode Barang <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="edit_kode_barang" name="kode_barang" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="edit_barcode" class="form-label">Barcode</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="edit_barcode" name="barcode">
                                <input type="file" class="form-control d-none" id="edit_barcode_image" name="barcode_image" accept="image/*">
                                <button type="button" class="btn btn-outline-secondary" id="toggle_barcode_edit">
                                    <i class="fas fa-camera"></i>
                                </button>
                            </div>
                            <div id="edit_barcode_preview" class="mt-2"></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="edit_nama_barang" class="form-label">Nama Barang <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="edit_nama_barang" name="nama_barang" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="edit_id_kategori" class="form-label">Kategori <span class="text-danger">*</span></label>
                            <select class="form-select" id="edit_id_kategori" name="id_kategori" required>
                                <option value="">Pilih Kategori</option>
                                <?php mysqli_data_seek($result_kategori, 0); ?>
                                <?php while ($kategori = mysqli_fetch_assoc($result_kategori)) : ?>
                                    <option value="<?= $kategori['id_kategori'] ?>"><?= htmlspecialchars($kategori['nama_kategori']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="edit_id_satuan" class="form-label">Satuan <span class="text-danger">*</span></label>
                            <select class="form-select" id="edit_id_satuan" name="id_satuan" required>
                                <option value="">Pilih Satuan</option>
                                <?php mysqli_data_seek($result_satuan, 0); ?>
                                <?php while ($satuan = mysqli_fetch_assoc($result_satuan)) : ?>
                                    <option value="<?= $satuan['id_satuan'] ?>"><?= htmlspecialchars($satuan['nama_satuan']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="edit_harga_beli" class="form-label">Harga Beli <span class="text-danger">*</span></label>
                            <input type="text" class="form-control rupiah" id="edit_harga_beli" name="harga_beli" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="edit_harga_jual" class="form-label">Harga Jual <span class="text-danger">*</span></label>
                            <input type="text" class="form-control rupiah" id="edit_harga_jual" name="harga_jual" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="edit_stok_minimal" class="form-label">Stok Minimal</label>
                            <input type="number" class="form-control" id="edit_stok_minimal" name="stok_minimal" min="0" value="0">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="edit_foto_barang" class="form-label">Foto Barang</label>
                            <input type="file" class="form-control" id="edit_foto_barang" name="foto_barang" accept="image/*">
                            <small class="text-muted">Kosongkan jika tidak ingin mengubah foto</small>
                            <div id="edit_foto_preview" class="mt-2"></div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_deskripsi" class="form-label">Deskripsi</label>
                        <textarea class="form-control" id="edit_deskripsi" name="deskripsi" rows="3"></textarea>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="edit_is_active" name="is_active">
                        <label class="form-check-label" for="edit_is_active">
                            Aktif
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary-custom" name="edit_barang">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Detail Barang -->
<div class="modal fade" id="detailBarangModal" tabindex="-1" aria-labelledby="detailBarangModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title" id="detailBarangModalLabel">Detail Barang</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4 text-center mb-3">
                        <img id="detail_foto_barang" src="" alt="Foto Barang" class="img-thumbnail" style="max-height: 200px;">
                        <div class="mt-2">
                            <img id="detail_barcode_image" src="" alt="Barcode" class="img-fluid" style="max-height: 100px;">
                        </div>
                    </div>
                    <div class="col-md-8">
                        <table class="table table-bordered">
                            <tr>
                                <th width="30%">Kode Barang</th>
                                <td id="detail_kode_barang"></td>
                            </tr>
                            <tr>
                                <th>Barcode</th>
                                <td id="detail_barcode"></td>
                            </tr>
                            <tr>
                                <th>Nama Barang</th>
                                <td id="detail_nama_barang"></td>
                            </tr>
                            <tr>
                                <th>Kategori</th>
                                <td id="detail_kategori"></td>
                            </tr>
                            <tr>
                                <th>Satuan</th>
                                <td id="detail_satuan"></td>
                            </tr>
                            <tr>
                                <th>Harga Beli</th>
                                <td id="detail_harga_beli"></td>
                            </tr>
                            <tr>
                                <th>Harga Jual</th>
                                <td id="detail_harga_jual"></td>
                            </tr>
                            <tr>
                                <th>Stok Minimal</th>
                                <td id="detail_stok_minimal"></td>
                            </tr>
                            <tr>
                                <th>Stok Toko</th>
                                <td id="detail_stok_toko"></td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td id="detail_status"></td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-md-6">
                        <h6>Dibuat Pada:</h6>
                        <p id="detail_created_at" class="text-muted"></p>
                    </div>
                    <div class="col-md-6">
                        <h6>Diupdate Pada:</h6>
                        <p id="detail_updated_at" class="text-muted"></p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <h6>Deskripsi:</h6>
                        <p id="detail_deskripsi" class="text-muted"></p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Stok Minimal -->
<div class="modal fade" id="stokMinimalModal" tabindex="-1" aria-labelledby="stokMinimalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title" id="stokMinimalModalLabel">Barang dengan Stok Minimal</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Kode Barang</th>
                                <th>Nama Barang</th>
                                <th>Stok Toko</th>
                                <th>Stok Minimal</th>
                                <th>Selisih</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $query_stok_minimal_detail = "SELECT b.kode_barang, b.nama_barang, b.stok_minimal, 
                                                         s.stok_akhir, (b.stok_minimal - s.stok_akhir) as selisih
                                                         FROM barang b 
                                                         JOIN stok_toko s ON b.id_barang = s.id_barang 
                                                         WHERE s.stok_akhir <= b.stok_minimal AND s.id_toko = 1
                                                         ORDER BY selisih DESC";
                            $result_stok_minimal_detail = mysqli_query($conn, $query_stok_minimal_detail);
                            ?>
                            <?php if (mysqli_num_rows($result_stok_minimal_detail) > 0) : ?>
                                <?php $no = 1; ?>
                                <?php while ($row = mysqli_fetch_assoc($result_stok_minimal_detail)) : ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= htmlspecialchars($row['kode_barang']) ?></td>
                                        <td><?= htmlspecialchars($row['nama_barang']) ?></td>
                                        <td class="text-danger fw-bold"><?= $row['stok_akhir'] ?></td>
                                        <td><?= $row['stok_minimal'] ?></td>
                                        <td class="text-danger fw-bold"><?= $row['selisih'] ?></td>
                                    </tr>
                                <?php endwhile; ?>
                            <?php else : ?>
                                <tr>
                                    <td colspan="6" class="text-center">Tidak ada barang dengan stok kurang dari stok minimal</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <a href="pembelian.php" class="btn btn-primary-custom">Buat Pembelian</a>
            </div>
        </div>
    </div>
</div>

<!-- Modal Export Data -->
<div class="modal fade" id="exportModal" tabindex="-1" aria-labelledby="exportModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title" id="exportModalLabel">Export Data Barang</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="export_barang.php">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="export_format" class="form-label">Format Export</label>
                        <select class="form-select" id="export_format" name="export_format" required>
                            <option value="excel">Excel (.xlsx)</option>
                            <option value="pdf">PDF (.pdf)</option>
                            <option value="csv">CSV (.csv)</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="export_kolom" class="form-label">Kolom yang Diexport</label>
                        <select class="form-select" id="export_kolom" name="export_kolom[]" multiple required>
                            <option value="kode_barang" selected>Kode Barang</option>
                            <option value="barcode" selected>Barcode</option>
                            <option value="nama_barang" selected>Nama Barang</option>
                            <option value="nama_kategori" selected>Kategori</option>
                            <option value="nama_satuan" selected>Satuan</option>
                            <option value="harga_beli" selected>Harga Beli</option>
                            <option value="harga_jual" selected>Harga Jual</option>
                            <option value="stok_toko" selected>Stok Toko</option>
                            <option value="stok_minimal" selected>Stok Minimal</option>
                            <option value="is_active" selected>Status</option>
                        </select>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="export_filter" name="export_filter" checked>
                        <label class="form-check-label" for="export_filter">
                            Gunakan filter yang aktif
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">Export Data</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Import Data -->
<div class="modal fade" id="importModal" tabindex="-1" aria-labelledby="importModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title" id="importModalLabel">Import Data Barang</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="import_barang.php" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="import_file" class="form-label">File Excel</label>
                        <input type="file" class="form-control" id="import_file" name="import_file" accept=".xlsx, .xls" required>
                        <small class="text-muted">Download template <a href="template_import_barang.xlsx">disini</a></small>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="import_update" name="import_update">
                        <label class="form-check-label" for="import_update">
                            Update data yang sudah ada
                        </label>
                    </div>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Pastikan format file sesuai dengan template untuk menghindari kesalahan import.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-info text-white">Import Data</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Script untuk format rupiah dan fungsi lainnya -->
<script>
    // Format input harga
    document.querySelectorAll('.rupiah').forEach(function(element) {
        element.addEventListener('keyup', function(e) {
            this.value = formatRupiah(this.value);
        });
    });

    function formatRupiah(angka) {
        var number_string = angka.replace(/[^,\d]/g, '').toString(),
            split = number_string.split(','),
            sisa = split[0].length % 3,
            rupiah = split[0].substr(0, sisa),
            ribuan = split[0].substr(sisa).match(/\d{3}/gi);

        if (ribuan) {
            separator = sisa ? '.' : '';
            rupiah += separator + ribuan.join('.');
        }

        rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        return rupiah;
    }

    // Toggle input barcode antara teks dan gambar (tambah barang)
    document.getElementById('toggle_barcode_input').addEventListener('click', function() {
        const textInput = document.getElementById('barcode');
        const fileInput = document.getElementById('barcode_image');
        
        if (textInput.classList.contains('d-none')) {
            textInput.classList.remove('d-none');
            fileInput.classList.add('d-none');
            this.innerHTML = '<i class="fas fa-camera"></i>';
        } else {
            textInput.classList.add('d-none');
            fileInput.classList.remove('d-none');
            this.innerHTML = '<i class="fas fa-keyboard"></i>';
        }
    });

    // Toggle input barcode antara teks dan gambar (edit barang)
    document.getElementById('toggle_barcode_edit').addEventListener('click', function() {
        const textInput = document.getElementById('edit_barcode');
        const fileInput = document.getElementById('edit_barcode_image');
        
        if (textInput.classList.contains('d-none')) {
            textInput.classList.remove('d-none');
            fileInput.classList.add('d-none');
            this.innerHTML = '<i class="fas fa-camera"></i>';
        } else {
            textInput.classList.add('d-none');
            fileInput.classList.remove('d-none');
            this.innerHTML = '<i class="fas fa-keyboard"></i>';
        }
    });

    // Preview gambar barcode saat dipilih (tambah barang)
    document.getElementById('barcode_image').addEventListener('change', function(e) {
        const preview = document.getElementById('barcode_preview');
        preview.innerHTML = '';
        
        if (this.files && this.files[0]) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                const img = document.createElement('img');
                img.src = e.target.result;
                img.alt = 'Preview Barcode';
                img.style.maxHeight = '100px';
                preview.appendChild(img);
            }
            
            reader.readAsDataURL(this.files[0]);
        }
    });

    // Preview gambar barcode saat dipilih (edit barang)
    document.getElementById('edit_barcode_image').addEventListener('change', function(e) {
        const preview = document.getElementById('edit_barcode_preview');
        preview.innerHTML = '';
        
        if (this.files && this.files[0]) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                const img = document.createElement('img');
                img.src = e.target.result;
                img.alt = 'Preview Barcode';
                img.style.maxHeight = '100px';
                preview.appendChild(img);
            }
            
            reader.readAsDataURL(this.files[0]);
        }
    });

    // Script untuk edit modal
    document.querySelectorAll('.btn-edit').forEach(function(button) {
        button.addEventListener('click', function() {
            var id_barang = this.getAttribute('data-id');
            
            fetch('get_barang.php?id=' + id_barang)
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.json();
                })
                .then(data => {
                    // Isi form edit dengan data yang diterima
                    document.getElementById('edit_id_barang').value = data.id_barang;
                    document.getElementById('edit_kode_barang').value = data.kode_barang || '';
                    document.getElementById('edit_nama_barang').value = data.nama_barang || '';
                    document.getElementById('edit_id_kategori').value = data.id_kategori || '';
                    document.getElementById('edit_id_satuan').value = data.id_satuan || '';
                    document.getElementById('edit_harga_beli').value = formatRupiah(data.harga_beli?.toString() || '0');
                    document.getElementById('edit_harga_jual').value = formatRupiah(data.harga_jual?.toString() || '0');
                    document.getElementById('edit_stok_minimal').value = data.stok_minimal || '0';
                    document.getElementById('edit_deskripsi').value = data.deskripsi || '';
                    document.getElementById('edit_is_active').checked = data.is_active == 1;
                    
                    // Handle barcode (teks atau gambar)
                    const barcodePreview = document.getElementById('edit_barcode_preview');
                    barcodePreview.innerHTML = '';
                    
                    if (data.barcode) {
                        if (data.barcode.startsWith('uploads/')) {
                            // Jika barcode adalah gambar
                            document.getElementById('edit_barcode').value = '';
                            document.getElementById('edit_barcode_image').classList.remove('d-none');
                            document.getElementById('edit_barcode').classList.add('d-none');
                            document.getElementById('toggle_barcode_edit').innerHTML = '<i class="fas fa-keyboard"></i>';
                            
                            const img = document.createElement('img');
                            img.src = data.barcode;
                            img.alt = 'Barcode';
                            img.style.maxHeight = '100px';
                            barcodePreview.appendChild(img);
                        } else {
                            // Jika barcode adalah teks
                            document.getElementById('edit_barcode').value = data.barcode;
                            document.getElementById('edit_barcode_image').classList.add('d-none');
                            document.getElementById('edit_barcode').classList.remove('d-none');
                            document.getElementById('toggle_barcode_edit').innerHTML = '<i class="fas fa-camera"></i>';
                        }
                    }
                    
                    // Tampilkan foto barang jika ada
                    const fotoPreview = document.getElementById('edit_foto_preview');
                    fotoPreview.innerHTML = '';
                    if (data.foto_barang) {
                        const img = document.createElement('img');
                        img.src = data.foto_barang;
                        img.alt = 'Foto Barang';
                        img.className = 'img-thumbnail';
                        img.style.maxHeight = '150px';
                        fotoPreview.appendChild(img);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Gagal memuat data barang');
                });
        });
    });

    // Script untuk detail modal
    document.querySelectorAll('.btn-detail').forEach(function(button) {
        button.addEventListener('click', function() {
            var id_barang = this.getAttribute('data-id');
            
            fetch('get_barang.php?id=' + id_barang)
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.json();
                })
                .then(data => {
                    // Isi data detail
                    document.getElementById('detail_kode_barang').textContent = data.kode_barang || '-';
                    
                    // Handle barcode (teks atau gambar)
                    const barcodeImg = document.getElementById('detail_barcode_image');
                    if (data.barcode && data.barcode.startsWith('uploads/')) {
                        document.getElementById('detail_barcode').textContent = '-';
                        barcodeImg.src = data.barcode;
                        barcodeImg.style.display = 'block';
                    } else {
                        document.getElementById('detail_barcode').textContent = data.barcode || '-';
                        barcodeImg.style.display = 'none';
                    }
                    
                    document.getElementById('detail_nama_barang').textContent = data.nama_barang || '-';
                    document.getElementById('detail_kategori').textContent = data.nama_kategori || '-';
                    document.getElementById('detail_satuan').textContent = data.nama_satuan || '-';
                    document.getElementById('detail_harga_beli').textContent = 'Rp ' + parseInt(data.harga_beli || 0).toLocaleString('id-ID');
                    document.getElementById('detail_harga_jual').textContent = 'Rp ' + parseInt(data.harga_jual || 0).toLocaleString('id-ID');
                    document.getElementById('detail_stok_minimal').textContent = data.stok_minimal || '0';
                    document.getElementById('detail_stok_toko').textContent = data.stok_toko || '0';
                    document.getElementById('detail_status').innerHTML = data.is_active == 1 ? 
                        '<span class="badge bg-success">Aktif</span>' : 
                        '<span class="badge bg-danger">Nonaktif</span>';
                    document.getElementById('detail_deskripsi').textContent = data.deskripsi || '-';
                    document.getElementById('detail_created_at').textContent = data.created_at || '-';
                    document.getElementById('detail_updated_at').textContent = data.updated_at || '-';
                    
                    // Foto barang
                    const fotoBarang = document.getElementById('detail_foto_barang');
                    if (data.foto_barang) {
                        fotoBarang.src = data.foto_barang;
                        fotoBarang.style.display = 'block';
                    } else {
                        fotoBarang.src = 'assets/img/no-image.png';
                        fotoBarang.style.display = 'block';
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Gagal memuat detail barang');
                });
        });
    });

    // Inisialisasi select multiple
    document.addEventListener('DOMContentLoaded', function() {
        // Inisialisasi select multiple untuk export kolom
        if (typeof MultiSelectTag !== 'undefined') {
            new MultiSelectTag('export_kolom', {
                rounded: true,
                shadow: true,
                placeholder: 'Pilih kolom',
                onChange: function(values) {
                    console.log(values);
                }
            });
        }
    });
</script>

<?php include 'footer.php'; ?>