<?php
session_start();
include 'header.php';
require_once 'config.php';

// Fungsi untuk format rupiah
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Query data barang hampir habis
$query = "SELECT b.id_barang, b.kode_barang, b.nama_barang, k.nama_kategori, 
          s.stok_akhir, b.stok_minimal, (b.stok_minimal - s.stok_akhir) as selisih,
          b.harga_beli, b.harga_jual
          FROM barang b
          JOIN stok_toko s ON b.id_barang = s.id_barang
          JOIN kategori k ON b.id_kategori = k.id_kategori
          WHERE s.id_toko = 1 AND s.stok_akhir <= b.stok_minimal
          ORDER BY selisih DESC";

$result = mysqli_query($conn, $query);
?>

<main class="animate-fade-in">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Barang Hampir Habis</h1>
        <div>
            <a href="pembelian.php" class="btn btn-primary-custom">
                <i class="fas fa-cart-plus"></i> Buat Pembelian
            </a>
        </div>
    </div>

    <div class="card shadow mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-header py-3 bg-danger text-white">
            <h6 class="m-0 font-weight-bold">Daftar Barang dengan Stok Minimal</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Kode</th>
                            <th>Nama Barang</th>
                            <th>Kategori</th>
                            <th>Stok Akhir</th>
                            <th>Stok Minimal</th>
                            <th>Selisih</th>
                            <th>Harga Beli</th>
                            <th>Harga Jual</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; while($row = mysqli_fetch_assoc($result)): ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= $row['kode_barang'] ?></td>
                            <td><?= $row['nama_barang'] ?></td>
                            <td><?= $row['nama_kategori'] ?></td>
                            <td class="text-center text-danger fw-bold"><?= $row['stok_akhir'] ?></td>
                            <td class="text-center"><?= $row['stok_minimal'] ?></td>
                            <td class="text-center text-danger fw-bold"><?= $row['selisih'] ?></td>
                            <td class="text-end"><?= format_rupiah($row['harga_beli']) ?></td>
                            <td class="text-end"><?= format_rupiah($row['harga_jual']) ?></td>
                            <td class="text-center">
                                <a href="pembelian.php?tambah=<?= $row['id_barang'] ?>" class="btn btn-sm btn-success">
                                    <i class="fas fa-cart-plus"></i> Beli
                                </a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<?php include 'footer.php'; ?>