<?php
session_start();
include 'header.php';
require_once 'config.php';

// Fungsi untuk format rupiah
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Query data barang kedaluwarsa (30 hari ke depan)
$tanggal_sekarang = date('Y-m-d');
$tanggal_30_hari = date('Y-m-d', strtotime('+30 days'));

$query = "SELECT b.id_barang, b.kode_barang, b.nama_barang, k.nama_kategori, 
          s.stok_akhir, s.expired_date,
          DATEDIFF(s.expired_date, '$tanggal_sekarang') as hari_menuju_expired,
          b.harga_beli, b.harga_jual
          FROM barang b
          JOIN stok_toko s ON b.id_barang = s.id_barang
          JOIN kategori k ON b.id_kategori = k.id_kategori
          WHERE s.id_toko = 1 AND s.expired_date IS NOT NULL 
          AND s.expired_date BETWEEN '$tanggal_sekarang' AND '$tanggal_30_hari'
          ORDER BY s.expired_date ASC";

$result = mysqli_query($conn, $query);
?>

<main class="animate-fade-in">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Barang Kedaluwarsa</h1>
        <div>
            <a href="stok.php" class="btn btn-primary-custom">
                <i class="fas fa-boxes"></i> Lihat Semua Stok
            </a>
        </div>
    </div>

    <div class="card shadow mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-header py-3 bg-warning text-dark">
            <h6 class="m-0 font-weight-bold">Daftar Barang Akan Kedaluwarsa (30 Hari ke Depan)</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Kode</th>
                            <th>Nama Barang</th>
                            <th>Kategori</th>
                            <th>Stok</th>
                            <th>Tanggal Expired</th>
                            <th>Sisa Hari</th>
                            <th>Harga Beli</th>
                            <th>Harga Jual</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; while($row = mysqli_fetch_assoc($result)): 
                            $class = '';
                            if($row['hari_menuju_expired'] <= 7) {
                                $class = 'bg-danger text-white';
                            } elseif($row['hari_menuju_expired'] <= 14) {
                                $class = 'bg-warning';
                            }
                        ?>
                        <tr class="<?= $class ?>">
                            <td><?= $no++ ?></td>
                            <td><?= $row['kode_barang'] ?></td>
                            <td><?= $row['nama_barang'] ?></td>
                            <td><?= $row['nama_kategori'] ?></td>
                            <td class="text-center"><?= $row['stok_akhir'] ?></td>
                            <td><?= date('d/m/Y', strtotime($row['expired_date'])) ?></td>
                            <td class="text-center"><?= $row['hari_menuju_expired'] ?> hari</td>
                            <td class="text-end"><?= format_rupiah($row['harga_beli']) ?></td>
                            <td class="text-end"><?= format_rupiah($row['harga_jual']) ?></td>
                            <td class="text-center">
                                <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#promoModal" 
                                        data-id="<?= $row['id_barang'] ?>" data-nama="<?= $row['nama_barang'] ?>">
                                    <i class="fas fa-tag"></i> Buat Promo
                                </button>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Buat Promo -->
<div class="modal fade" id="promoModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title">Buat Promo Barang</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="buat_promo.php">
                <div class="modal-body">
                    <input type="hidden" id="promo_id_barang" name="id_barang">
                    <div class="mb-3">
                        <label class="form-label">Nama Barang</label>
                        <input type="text" class="form-control" id="promo_nama_barang" readonly>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Jenis Promo</label>
                        <select class="form-select" name="jenis_promo" required>
                            <option value="diskon">Diskon</option>
                            <option value="bundling">Bundling</option>
                            <option value="gratis">Gratis</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Nilai Promo</label>
                        <input type="number" class="form-control" name="nilai_promo" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tanggal Mulai</label>
                        <input type="date" class="form-control" name="tanggal_mulai" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tanggal Selesai</label>
                        <input type="date" class="form-control" name="tanggal_selesai" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary-custom">Simpan Promo</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Set data untuk modal promo
document.querySelectorAll('[data-bs-target="#promoModal"]').forEach(button => {
    button.addEventListener('click', function() {
        const id = this.getAttribute('data-id');
        const nama = this.getAttribute('data-nama');
        
        document.getElementById('promo_id_barang').value = id;
        document.getElementById('promo_nama_barang').value = nama;
    });
});
</script>

<?php include 'footer.php'; ?>