<?php
session_start();
require_once 'config.php';

// Cek koneksi database
if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Ambil ID penjualan dari URL
$id_penjualan = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($id_penjualan <= 0) {
    die("ID penjualan tidak valid");
}

// Query untuk mendapatkan data penjualan
$query_penjualan = "SELECT p.*, pl.nama_pelanggan, mp.nama_metode, pg.nama_lengkap as nama_kasir, t.nama_toko, t.alamat as alamat_toko, t.telepon as telepon_toko
                   FROM penjualan p
                   LEFT JOIN pelanggan pl ON p.id_pelanggan = pl.id_pelanggan
                   JOIN metode_pembayaran mp ON p.id_metode = mp.id_metode
                   JOIN pengguna pg ON p.id_pengguna = pg.id_pengguna
                   JOIN toko t ON p.id_toko = t.id_toko
                   WHERE p.id_penjualan = ?";
$stmt_penjualan = mysqli_prepare($conn, $query_penjualan);
mysqli_stmt_bind_param($stmt_penjualan, "i", $id_penjualan);
mysqli_stmt_execute($stmt_penjualan);
$result_penjualan = mysqli_stmt_get_result($stmt_penjualan);

if (mysqli_num_rows($result_penjualan) == 0) {
    die("Transaksi tidak ditemukan");
}

$penjualan = mysqli_fetch_assoc($result_penjualan);

// Query untuk mendapatkan detail penjualan
$query_detail = "SELECT dp.*, b.nama_barang, b.kode_barang
                FROM detail_penjualan dp
                JOIN barang b ON dp.id_barang = b.id_barang
                WHERE dp.id_penjualan = ?
                ORDER BY dp.id_detail_penjualan";
$stmt_detail = mysqli_prepare($conn, $query_detail);
mysqli_stmt_bind_param($stmt_detail, "i", $id_penjualan);
mysqli_stmt_execute($stmt_detail);
$result_detail = mysqli_stmt_get_result($stmt_detail);

// Fungsi untuk format rupiah
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Set header untuk PDF
header("Content-type: application/pdf");
header("Content-Disposition: inline; filename=Struk_" . $penjualan['no_transaksi'] . ".pdf");
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Struk <?php echo $penjualan['no_transaksi']; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            width: 80mm;
            margin: 0 auto;
            padding: 5px;
        }
        .header {
            text-align: center;
            margin-bottom: 10px;
            border-bottom: 1px dashed #000;
            padding-bottom: 10px;
        }
        .title {
            font-weight: bold;
            font-size: 14px;
            margin-bottom: 5px;
        }
        .info-transaksi {
            margin-bottom: 10px;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        .table th, .table td {
            padding: 3px;
            border-bottom: 1px dashed #ddd;
        }
        .table th {
            text-align: left;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .footer {
            margin-top: 10px;
            border-top: 1px dashed #000;
            padding-top: 10px;
            text-align: center;
        }
        .barcode {
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="title"><?php echo $penjualan['nama_toko']; ?></div>
        <div><?php echo $penjualan['alamat_toko']; ?></div>
        <div>Telp: <?php echo $penjualan['telepon_toko']; ?></div>
    </div>
    
    <div class="info-transaksi">
        <table width="100%">
            <tr>
                <td width="40%">No. Transaksi</td>
                <td>: <?php echo $penjualan['no_transaksi']; ?></td>
            </tr>
            <tr>
                <td>Tanggal</td>
                <td>: <?php echo date('d/m/Y H:i', strtotime($penjualan['tanggal_penjualan'])); ?></td>
            </tr>
            <tr>
                <td>Kasir</td>
                <td>: <?php echo $penjualan['nama_kasir']; ?></td>
            </tr>
            <?php if (!empty($penjualan['nama_pelanggan'])): ?>
            <tr>
                <td>Pelanggan</td>
                <td>: <?php echo $penjualan['nama_pelanggan']; ?></td>
            </tr>
            <?php endif; ?>
        </table>
    </div>
    
    <table class="table">
        <thead>
            <tr>
                <th>Barang</th>
                <th>Qty</th>
                <th class="text-right">Harga</th>
                <th class="text-right">Subtotal</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($detail = mysqli_fetch_assoc($result_detail)): ?>
            <tr>
                <td><?php echo $detail['nama_barang']; ?></td>
                <td><?php echo $detail['jumlah']; ?></td>
                <td class="text-right"><?php echo format_rupiah($detail['harga_jual']); ?></td>
                <td class="text-right"><?php echo format_rupiah($detail['subtotal']); ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
    
    <table width="100%">
        <tr>
            <td width="60%">Total</td>
            <td class="text-right"><?php echo format_rupiah($penjualan['total_penjualan']); ?></td>
        </tr>
        <tr>
            <td>Diskon</td>
            <td class="text-right"><?php echo format_rupiah($penjualan['diskon']); ?></td>
        </tr>
        <tr>
            <td>PPN</td>
            <td class="text-right"><?php echo format_rupiah($penjualan['ppn']); ?></td>
        </tr>
        <tr>
            <td><strong>Grand Total</strong></td>
            <td class="text-right"><strong><?php echo format_rupiah($penjualan['grand_total']); ?></strong></td>
        </tr>
        <tr>
            <td>Bayar</td>
            <td class="text-right"><?php echo format_rupiah($penjualan['jumlah_bayar']); ?></td>
        </tr>
        <tr>
            <td>Kembali</td>
            <td class="text-right"><?php echo format_rupiah($penjualan['kembalian']); ?></td>
        </tr>
        <?php if ($penjualan['status_pembayaran'] != 'lunas'): ?>
        <tr>
            <td>Sisa Hutang</td>
            <td class="text-right"><?php echo format_rupiah($penjualan['sisa_hutang']); ?></td>
        </tr>
        <?php endif; ?>
    </table>
    
    <div class="footer">
        <div>Terima kasih telah berbelanja</div>
        <div>Barang yang sudah dibeli tidak dapat ditukar atau dikembalikan</div>
        <div class="barcode">
            <!-- Anda bisa menambahkan barcode generator di sini -->
            *<?php echo $penjualan['no_transaksi']; ?>*
        </div>
    </div>
</body>
</html>