<?php 
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
require_once 'config.php'; // Pastikan file config.php berisi koneksi database

// Check if database connection is established
if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Fungsi untuk format mata uang
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Query untuk mendapatkan statistik dashboard
$today = date('Y-m-d');
$yesterday = date('Y-m-d', strtotime('-1 day'));

// 1. Total Penjualan Hari Ini
$query_penjualan_hari_ini = "SELECT SUM(grand_total) as total FROM penjualan WHERE DATE(tanggal_penjualan) = '$today' AND status_pembayaran != 'dibatalkan'";
$result_penjualan_hari_ini = mysqli_query($conn, $query_penjualan_hari_ini);
$total_penjualan_hari_ini = $result_penjualan_hari_ini ? (mysqli_fetch_assoc($result_penjualan_hari_ini))['total'] ?? 0 : 0;

// 2. Total Penjualan Kemarin (untuk perbandingan)
$query_penjualan_kemarin = "SELECT SUM(grand_total) as total FROM penjualan WHERE DATE(tanggal_penjualan) = '$yesterday' AND status_pembayaran != 'dibatalkan'";
$result_penjualan_kemarin = mysqli_query($conn, $query_penjualan_kemarin);
$total_penjualan_kemarin = $result_penjualan_kemarin ? (mysqli_fetch_assoc($result_penjualan_kemarin))['total'] ?? 1 : 1;

// 3. Persentase perubahan penjualan
$persentase_penjualan = 0;
if ($total_penjualan_kemarin > 0) {
    $persentase_penjualan = (($total_penjualan_hari_ini - $total_penjualan_kemarin) / $total_penjualan_kemarin) * 100;
}

// 4. Jumlah Transaksi Hari Ini
$query_jumlah_transaksi = "SELECT COUNT(*) as total FROM penjualan WHERE DATE(tanggal_penjualan) = '$today' AND status_pembayaran != 'dibatalkan'";
$result_jumlah_transaksi = mysqli_query($conn, $query_jumlah_transaksi);
$jumlah_transaksi = $result_jumlah_transaksi ? (mysqli_fetch_assoc($result_jumlah_transaksi))['total'] ?? 0 : 0;

// 5. Jumlah Transaksi Kemarin
$query_jumlah_transaksi_kemarin = "SELECT COUNT(*) as total FROM penjualan WHERE DATE(tanggal_penjualan) = '$yesterday' AND status_pembayaran != 'dibatalkan'";
$result_jumlah_transaksi_kemarin = mysqli_query($conn, $query_jumlah_transaksi_kemarin);
$jumlah_transaksi_kemarin = $result_jumlah_transaksi_kemarin ? (mysqli_fetch_assoc($result_jumlah_transaksi_kemarin)['total'] ?? 1) : 1;

// 6. Persentase perubahan transaksi
$persentase_transaksi = 0;
if ($jumlah_transaksi_kemarin > 0) {
    $persentase_transaksi = (($jumlah_transaksi - $jumlah_transaksi_kemarin) / $jumlah_transaksi_kemarin) * 100;
}

// 7. Total Pembelian Hari Ini
$query_pembelian_hari_ini = "SELECT SUM(grand_total) as total FROM pembelian WHERE DATE(tanggal_pembelian) = '$today'";
$result_pembelian_hari_ini = mysqli_query($conn, $query_pembelian_hari_ini);
$total_pembelian_hari_ini = $result_pembelian_hari_ini ? (mysqli_fetch_assoc($result_pembelian_hari_ini)['total'] ?? 0) : 0;

// 8. Total Pembelian Kemarin
$query_pembelian_kemarin = "SELECT SUM(grand_total) as total FROM pembelian WHERE DATE(tanggal_pembelian) = '$yesterday'";
$result_pembelian_kemarin = mysqli_query($conn, $query_pembelian_kemarin);
$total_pembelian_kemarin = $result_pembelian_kemarin ? (mysqli_fetch_assoc($result_pembelian_kemarin)['total'] ?? 1) : 1;

// 9. Persentase perubahan pembelian
$persentase_pembelian = 0;
if ($total_pembelian_kemarin > 0) {
    $persentase_pembelian = (($total_pembelian_hari_ini - $total_pembelian_kemarin) / $total_pembelian_kemarin) * 100;
}

// 10. Barang Hampir Habis (stok < stok minimal)
$query_barang_hampir_habis = "SELECT COUNT(*) as total FROM barang b 
                              JOIN stok_toko s ON b.id_barang = s.id_barang 
                              WHERE s.stok_akhir <= b.stok_minimal AND s.id_toko = 1"; // Ganti dengan id_toko yang sesuai
$result_barang_hampir_habis = mysqli_query($conn, $query_barang_hampir_habis);
$barang_hampir_habis = $result_barang_hampir_habis ? (mysqli_fetch_assoc($result_barang_hampir_habis)['total'] ?? 0) : 0;

// 11. Hutang Jatuh Tempo
$query_hutang_jatuh_tempo = "SELECT SUM(sisa_hutang) as total FROM hutang_pelanggan 
                             WHERE status = 'belum_lunas' AND tanggal_jatuh_tempo <= '$today'";
$result_hutang_jatuh_tempo = mysqli_query($conn, $query_hutang_jatuh_tempo);
$hutang_jatuh_tempo = $result_hutang_jatuh_tempo ? (mysqli_fetch_assoc($result_hutang_jatuh_tempo)['total'] ?? 0) : 0;

// 12. Jumlah Invoice Hutang Jatuh Tempo
$query_jumlah_invoice_hutang = "SELECT COUNT(*) as total FROM hutang_pelanggan 
                                WHERE status = 'belum_lunas' AND tanggal_jatuh_tempo <= '$today'";
$result_jumlah_invoice_hutang = mysqli_query($conn, $query_jumlah_invoice_hutang);
$jumlah_invoice_hutang = $result_jumlah_invoice_hutang ? (mysqli_fetch_assoc($result_jumlah_invoice_hutang)['total'] ?? 0) : 0;

// 13. Piutang Jatuh Tempo
$query_piutang_jatuh_tempo = "SELECT SUM(sisa_hutang) as total FROM hutang_supplier 
                              WHERE status = 'belum_lunas' AND tanggal_jatuh_tempo <= '$today'";
$result_piutang_jatuh_tempo = mysqli_query($conn, $query_piutang_jatuh_tempo);
$piutang_jatuh_tempo = $result_piutang_jatuh_tempo ? (mysqli_fetch_assoc($result_piutang_jatuh_tempo)['total'] ?? 0) : 0;

// 14. Jumlah Supplier Piutang Jatuh Tempo
$query_jumlah_supplier_piutang = "SELECT COUNT(*) as total FROM hutang_supplier 
                                  WHERE status = 'belum_lunas' AND tanggal_jatuh_tempo <= '$today'";
$result_jumlah_supplier_piutang = mysqli_query($conn, $query_jumlah_supplier_piutang);
$jumlah_supplier_piutang = $result_jumlah_supplier_piutang ? (mysqli_fetch_assoc($result_jumlah_supplier_piutang)['total'] ?? 0) : 0;

// 15. Laba Kotor Hari Ini
$query_laba_kotor = "SELECT SUM(dp.subtotal - (dp.jumlah * b.harga_beli)) as laba 
                     FROM detail_penjualan dp
                     JOIN barang b ON dp.id_barang = b.id_barang
                     JOIN penjualan p ON dp.id_penjualan = p.id_penjualan
                     WHERE DATE(p.tanggal_penjualan) = '$today' AND p.status_pembayaran != 'dibatalkan'";
$result_laba_kotor = mysqli_query($conn, $query_laba_kotor);
$laba_kotor = $result_laba_kotor ? (mysqli_fetch_assoc($result_laba_kotor)['laba'] ?? 0) : 0;

// 16. Laba Kotor Kemarin
$query_laba_kotor_kemarin = "SELECT SUM(dp.subtotal - (dp.jumlah * b.harga_beli)) as laba 
                            FROM detail_penjualan dp
                            JOIN barang b ON dp.id_barang = b.id_barang
                            JOIN penjualan p ON dp.id_penjualan = p.id_penjualan
                            WHERE DATE(p.tanggal_penjualan) = '$yesterday' AND p.status_pembayaran != 'dibatalkan'";
$result_laba_kotor_kemarin = mysqli_query($conn, $query_laba_kotor_kemarin);
$laba_kotor_kemarin = $result_laba_kotor_kemarin ? (mysqli_fetch_assoc($result_laba_kotor_kemarin)['laba'] ?? 1) : 1;

// 17. Persentase perubahan laba
$persentase_laba = 0;
if ($laba_kotor_kemarin > 0) {
    $persentase_laba = (($laba_kotor - $laba_kotor_kemarin) / $laba_kotor_kemarin) * 100;
}

// 18. Notifikasi Baru
$id_pengguna = isset($_SESSION['id_pengguna']) ? $_SESSION['id_pengguna'] : 0;
$query_notifikasi = "SELECT COUNT(*) as total FROM notifikasi 
                     WHERE id_pengguna = '$id_pengguna' AND is_read = 0";
$result_notifikasi = mysqli_query($conn, $query_notifikasi);
$jumlah_notifikasi = $result_notifikasi ? (mysqli_fetch_assoc($result_notifikasi)['total'] ?? 0) : 0;

// 19. Data untuk grafik penjualan 7 hari terakhir
$labels_7hari = [];
$data_penjualan_7hari = [];

for ($i = 6; $i >= 0; $i--) {
    $date = date('Y-m-d', strtotime("-$i days"));
    $labels_7hari[] = date('d M', strtotime($date));
    
    $query = "SELECT COALESCE(SUM(grand_total), 0) as total FROM penjualan 
              WHERE DATE(tanggal_penjualan) = '$date' AND status_pembayaran != 'dibatalkan'";
    $result = mysqli_query($conn, $query);
    $data = $result ? mysqli_fetch_assoc($result) : ['total' => 0];
    $data_penjualan_7hari[] = $data['total'];
}

// 20. Data untuk grafik pembelian vs penjualan bulan ini
$bulan_ini = date('Y-m');
$query_penjualan_bulan_ini = "SELECT COALESCE(SUM(grand_total), 0) as total FROM penjualan 
                              WHERE DATE_FORMAT(tanggal_penjualan, '%Y-%m') = '$bulan_ini' 
                              AND status_pembayaran != 'dibatalkan'";
$result_penjualan_bulan_ini = mysqli_query($conn, $query_penjualan_bulan_ini);
$total_penjualan_bulan_ini = $result_penjualan_bulan_ini ? (mysqli_fetch_assoc($result_penjualan_bulan_ini)['total'] ?? 0) : 0;

$query_pembelian_bulan_ini = "SELECT COALESCE(SUM(grand_total), 0) as total FROM pembelian 
                              WHERE DATE_FORMAT(tanggal_pembelian, '%Y-%m') = '$bulan_ini'";
$result_pembelian_bulan_ini = mysqli_query($conn, $query_pembelian_bulan_ini);
$total_pembelian_bulan_ini = $result_pembelian_bulan_ini ? (mysqli_fetch_assoc($result_pembelian_bulan_ini)['total'] ?? 0) : 0;

// 21. 5 Transaksi Terakhir
$query_transaksi_terakhir = "SELECT p.no_transaksi, p.tanggal_penjualan, p.grand_total, p.status_pembayaran
                            FROM penjualan p
                            WHERE p.status_pembayaran != 'dibatalkan'
                            ORDER BY p.tanggal_penjualan DESC
                            LIMIT 5";
$result_transaksi_terakhir = mysqli_query($conn, $query_transaksi_terakhir);

// 22. 5 Barang Terlaris
$query_barang_terlaris = "SELECT b.nama_barang, k.nama_kategori, SUM(dp.jumlah) as terjual, SUM(dp.subtotal) as pendapatan
                          FROM detail_penjualan dp
                          JOIN barang b ON dp.id_barang = b.id_barang
                          JOIN kategori k ON b.id_kategori = k.id_kategori
                          JOIN penjualan p ON dp.id_penjualan = p.id_penjualan
                          WHERE p.status_pembayaran != 'dibatalkan'
                          GROUP BY dp.id_barang
                          ORDER BY terjual DESC
                          LIMIT 5";
$result_barang_terlaris = mysqli_query($conn, $query_barang_terlaris);

// 23. Hutang Pelanggan Jatuh Tempo
$query_hutang_pelanggan = "SELECT pl.nama_pelanggan, p.no_transaksi, hp.tanggal_jatuh_tempo, 
                          hp.sisa_hutang, hp.status
                          FROM hutang_pelanggan hp
                          JOIN penjualan p ON hp.id_penjualan = p.id_penjualan
                          JOIN pelanggan pl ON hp.id_pelanggan = pl.id_pelanggan
                          WHERE hp.status = 'belum_lunas' AND hp.tanggal_jatuh_tempo <= '$today'
                          ORDER BY hp.tanggal_jatuh_tempo ASC
                          LIMIT 5";
$result_hutang_pelanggan = mysqli_query($conn, $query_hutang_pelanggan);
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
        <div class="d-none d-sm-inline-block">
            <span class="text-muted">Last updated: <?php echo date('d M Y H:i:s'); ?></span>
        </div>
    </div>
    
    <!-- Statistik Ringkasan -->
    <div class="row">
        <!-- Total Penjualan Hari Ini -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card h-100 py-2 animate-fade-in" style="animation-delay: 0.1s;">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs font-weight-bold text-primary-custom text-uppercase mb-1">
                                Total Penjualan Hari Ini</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo format_rupiah($total_penjualan_hari_ini); ?></div>
                            <small class="<?php echo ($persentase_penjualan >= 0) ? 'text-success' : 'text-danger'; ?>">
                                <i class="fas fa-arrow-<?php echo ($persentase_penjualan >= 0) ? 'up' : 'down'; ?> me-1"></i> 
                                <?php echo abs(round($persentase_penjualan, 1)); ?>% dari kemarin
                            </small>
                        </div>
                        <div class="col-auto">
                            <div class="icon bg-primary-light rounded-circle p-3">
                                <i class="fas fa-shopping-bag text-primary-custom"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Jumlah Transaksi -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card h-100 py-2 animate-fade-in" style="animation-delay: 0.2s;">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs font-weight-bold text-primary-custom text-uppercase mb-1">
                                Jumlah Transaksi</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $jumlah_transaksi; ?></div>
                            <small class="<?php echo ($persentase_transaksi >= 0) ? 'text-success' : 'text-danger'; ?>">
                                <i class="fas fa-arrow-<?php echo ($persentase_transaksi >= 0) ? 'up' : 'down'; ?> me-1"></i> 
                                <?php echo abs(round($persentase_transaksi, 1)); ?>% dari kemarin
                            </small>
                        </div>
                        <div class="col-auto">
                            <div class="icon bg-primary-light rounded-circle p-3">
                                <i class="fas fa-receipt text-primary-custom"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Total Pembelian -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card h-100 py-2 animate-fade-in" style="animation-delay: 0.3s;">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs font-weight-bold text-primary-custom text-uppercase mb-1">
                                Total Pembelian</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo format_rupiah($total_pembelian_hari_ini); ?></div>
                            <small class="<?php echo ($persentase_pembelian >= 0) ? 'text-success' : 'text-danger'; ?>">
                                <i class="fas fa-arrow-<?php echo ($persentase_pembelian >= 0) ? 'up' : 'down'; ?> me-1"></i> 
                                <?php echo abs(round($persentase_pembelian, 1)); ?>% dari kemarin
                            </small>
                        </div>
                        <div class="col-auto">
                            <div class="icon bg-primary-light rounded-circle p-3">
                                <i class="fas fa-truck-loading text-primary-custom"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Barang Hampir Habis -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card h-100 py-2 animate-fade-in" style="animation-delay: 0.4s;">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs font-weight-bold text-primary-custom text-uppercase mb-1">
                                Barang Hampir Habis</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $barang_hampir_habis; ?></div>
                            <small class="text-warning">
                                <i class="fas fa-exclamation-circle me-1"></i> Perlu restock
                            </small>
                        </div>
                        <div class="col-auto">
                            <div class="icon bg-primary-light rounded-circle p-3">
                                <i class="fas fa-box-open text-primary-custom"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Hutang Jatuh Tempo -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card h-100 py-2 animate-fade-in" style="animation-delay: 0.1s;">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs font-weight-bold text-primary-custom text-uppercase mb-1">
                                Hutang Jatuh Tempo</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo format_rupiah($hutang_jatuh_tempo); ?></div>
                            <small class="text-danger">
                                <i class="fas fa-clock me-1"></i> <?php echo $jumlah_invoice_hutang; ?> invoice
                            </small>
                        </div>
                        <div class="col-auto">
                            <div class="icon bg-primary-light rounded-circle p-3">
                                <i class="fas fa-file-invoice-dollar text-primary-custom"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Piutang Jatuh Tempo -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card h-100 py-2 animate-fade-in" style="animation-delay: 0.2s;">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs font-weight-bold text-primary-custom text-uppercase mb-1">
                                Piutang Jatuh Tempo</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo format_rupiah($piutang_jatuh_tempo); ?></div>
                            <small class="text-danger">
                                <i class="fas fa-clock me-1"></i> <?php echo $jumlah_supplier_piutang; ?> supplier
                            </small>
                        </div>
                        <div class="col-auto">
                            <div class="icon bg-primary-light rounded-circle p-3">
                                <i class="fas fa-hand-holding-usd text-primary-custom"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Laba Kotor -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card h-100 py-2 animate-fade-in" style="animation-delay: 0.3s;">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs font-weight-bold text-primary-custom text-uppercase mb-1">
                                Laba Kotor Hari Ini</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo format_rupiah($laba_kotor); ?></div>
                            <small class="<?php echo ($persentase_laba >= 0) ? 'text-success' : 'text-danger'; ?>">
                                <i class="fas fa-arrow-<?php echo ($persentase_laba >= 0) ? 'up' : 'down'; ?> me-1"></i> 
                                <?php echo abs(round($persentase_laba, 1)); ?>% dari kemarin
                            </small>
                        </div>
                        <div class="col-auto">
                            <div class="icon bg-primary-light rounded-circle p-3">
                                <i class="fas fa-chart-line text-primary-custom"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Notifikasi Baru -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card h-100 py-2 animate-fade-in" style="animation-delay: 0.4s;">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs font-weight-bold text-primary-custom text-uppercase mb-1">
                                Notifikasi Baru</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $jumlah_notifikasi; ?></div>
                            <small class="text-primary-custom">
                                <i class="fas fa-bell me-1"></i> Perlu perhatian
                            </small>
                        </div>
                        <div class="col-auto">
                            <div class="icon bg-primary-light rounded-circle p-3">
                                <i class="fas fa-bell text-primary-custom"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Grafik dan Tabel -->
    <div class="row">
        <!-- Grafik Penjualan 7 Hari Terakhir -->
        <div class="col-xl-8 mb-4">
            <div class="card animate-fade-in" style="animation-delay: 0.2s;">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary-custom">Grafik Penjualan 7 Hari Terakhir</h6>
                    <div class="dropdown no-arrow">
                        <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="dropdownMenuLink">
                            <li><a class="dropdown-item" href="#">Lihat Detail</a></li>
                            <li><a class="dropdown-item" href="#">Export Data</a></li>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="salesChart" height="300"></canvas>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Grafik Pembelian vs Penjualan Bulanan -->
        <div class="col-xl-4 mb-4">
            <div class="card animate-fade-in" style="animation-delay: 0.3s;">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary-custom">Pembelian vs Penjualan Bulan Ini</h6>
                    <div class="dropdown no-arrow">
                        <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="dropdownMenuLink">
                            <li><a class="dropdown-item" href="#">Lihat Detail</a></li>
                            <li><a class="dropdown-item" href="#">Export Data</a></li>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart-pie pt-4 pb-2">
                        <canvas id="purchaseVsSalesChart" height="250"></canvas>
                    </div>
                    <div class="mt-4 text-center small">
                        <span class="me-2">
                            <i class="fas fa-circle text-success"></i> Penjualan
                        </span>
                        <span class="me-2">
                            <i class="fas fa-circle text-primary-custom"></i> Pembelian
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Tabel Transaksi Terakhir -->
    <div class="row">
        <!-- 5 Transaksi Terakhir -->
        <div class="col-lg-6 mb-4">
            <div class="card animate-fade-in" style="animation-delay: 0.4s;">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary-custom">5 Transaksi Terakhir</h6>
                    <a href="penjualan.php" class="btn btn-sm btn-primary-custom">Lihat Semua</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>No. Transaksi</th>
                                    <th>Tanggal</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($result_transaksi_terakhir && mysqli_num_rows($result_transaksi_terakhir) > 0): ?>
                                    <?php while ($transaksi = mysqli_fetch_assoc($result_transaksi_terakhir)): ?>
                                    <tr>
                                        <td><?php echo $transaksi['no_transaksi']; ?></td>
                                        <td><?php echo date('d M Y', strtotime($transaksi['tanggal_penjualan'])); ?></td>
                                        <td><?php echo format_rupiah($transaksi['grand_total']); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo ($transaksi['status_pembayaran'] == 'lunas') ? 'success' : 'warning text-dark'; ?>">
                                                <?php echo ($transaksi['status_pembayaran'] == 'lunas') ? 'Lunas' : 'Hutang'; ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="4" class="text-center">Tidak ada data transaksi</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Barang Terlaris -->
        <div class="col-lg-6 mb-4">
            <div class="card animate-fade-in" style="animation-delay: 0.5s;">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary-custom">5 Barang Terlaris</h6>
                    <a href="barang.php" class="btn btn-sm btn-primary-custom">Lihat Semua</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Nama Barang</th>
                                    <th>Kategori</th>
                                    <th>Terjual</th>
                                    <th>Pendapatan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($result_barang_terlaris && mysqli_num_rows($result_barang_terlaris) > 0): ?>
                                    <?php while ($barang = mysqli_fetch_assoc($result_barang_terlaris)): ?>
                                    <tr>
                                        <td><?php echo $barang['nama_barang']; ?></td>
                                        <td><?php echo $barang['nama_kategori']; ?></td>
                                        <td><?php echo $barang['terjual']; ?></td>
                                        <td><?php echo format_rupiah($barang['pendapatan']); ?></td>
                                    </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="4" class="text-center">Tidak ada data barang terlaris</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Tabel Hutang Jatuh Tempo -->
    <div class="row">
        <div class="col-12 mb-4">
            <div class="card animate-fade-in" style="animation-delay: 0.6s;">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary-custom">Hutang Pelanggan Jatuh Tempo</h6>
                    <a href="hutang_pelanggan.php" class="btn btn-sm btn-primary-custom">Lihat Semua</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Pelanggan</th>
                                    <th>No. Transaksi</th>
                                    <th>Tanggal Jatuh Tempo</th>
                                    <th>Total Hutang</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($result_hutang_pelanggan && mysqli_num_rows($result_hutang_pelanggan) > 0): ?>
                                    <?php while ($hutang = mysqli_fetch_assoc($result_hutang_pelanggan)): ?>
                                    <tr>
                                        <td><?php echo $hutang['nama_pelanggan']; ?></td>
                                        <td><?php echo $hutang['no_transaksi']; ?></td>
                                        <td><?php echo date('d M Y', strtotime($hutang['tanggal_jatuh_tempo'])); ?></td>
                                        <td><?php echo format_rupiah($hutang['sisa_hutang']); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo ($hutang['status'] == 'belum_lunas') ? 'danger' : 'success'; ?>">
                                                <?php echo ($hutang['status'] == 'belum_lunas') ? 'Belum Lunas' : 'Lunas'; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-success">Bayar</button>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center">Tidak ada hutang jatuh tempo</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<!-- JavaScript untuk Grafik -->
<script src="vendor/chart.js/Chart.min.js"></script>
<script>
// Grafik Penjualan 7 Hari Terakhir
var ctx = document.getElementById('salesChart').getContext('2d');
var salesChart = new Chart(ctx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode($labels_7hari); ?>,
        datasets: [{
            label: 'Total Penjualan',
            data: <?php echo json_encode($data_penjualan_7hari); ?>,
            backgroundColor: 'rgba(78, 115, 223, 0.05)',
            borderColor: 'rgba(78, 115, 223, 1)',
            pointBackgroundColor: 'rgba(78, 115, 223, 1)',
            pointBorderColor: '#fff',
            pointHoverBackgroundColor: '#fff',
            pointHoverBorderColor: 'rgba(78, 115, 223, 1)',
            borderWidth: 2,
            tension: 0.3,
            fill: true
        }]
    },
    options: {
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        return 'Rp ' + context.raw.toLocaleString();
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return 'Rp ' + value.toLocaleString();
                    }
                },
                grid: {
                    color: 'rgba(0, 0, 0, 0.05)'
                }
            },
            x: {
                grid: {
                    display: false
                }
            }
        }
    }
});

// Grafik Pembelian vs Penjualan Bulanan
var ctx2 = document.getElementById('purchaseVsSalesChart').getContext('2d');
var purchaseVsSalesChart = new Chart(ctx2, {
    type: 'doughnut',
    data: {
        labels: ['Penjualan', 'Pembelian'],
        datasets: [{
            data: [<?php echo $total_penjualan_bulan_ini; ?>, <?php echo $total_pembelian_bulan_ini; ?>],
            backgroundColor: ['#4e73df', '#1cc88a'],
            hoverBackgroundColor: ['#2e59d9', '#17a673'],
            hoverBorderColor: "rgba(234, 236, 244, 1)",
        }],
    },
    options: {
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        return context.label + ': Rp ' + context.raw.toLocaleString();
                    }
                }
            }
        },
        cutout: '70%',
    },
});
</script>

<?php include 'footer.php'; ?>