<?php
session_start();
require_once 'config.php';

// Cek hak akses
if ($_SESSION['id_role'] != 1 && $_SESSION['id_role'] != 4) {
    header("Location: unauthorized.php");
    exit();
}

// Ambil ID pengguna dari parameter POST
$id_pengguna = isset($_POST['id_pengguna']) ? intval($_POST['id_pengguna']) : 0;

if ($id_pengguna > 0) {
    // Cek apakah pengguna mencoba menghapus dirinya sendiri
    if ($id_pengguna == $_SESSION['id_pengguna']) {
        header('Location: pengguna.php?notif=failed&msg=Tidak bisa menghapus akun sendiri');
        exit();
    }
    
    // Hapus data pengguna
    $query = "DELETE FROM pengguna WHERE id_pengguna = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $id_pengguna);
    
    if (mysqli_stmt_execute($stmt)) {
        header('Location: pengguna.php?notif=success_delete');
    } else {
        $error = urlencode("Gagal menghapus data: " . mysqli_error($conn));
        header('Location: pengguna.php?notif=failed&msg=' . $error);
    }
} else {
    header('Location: pengguna.php?notif=failed&msg=ID pengguna tidak valid');
}

exit;
?>