<?php
require_once 'config.php';
session_start();

if (!isset($_GET['id']) || !isset($_SESSION['id_pengguna'])) {
    header("Location: pembelian.php");
    exit();
}

$id_pembelian = $_GET['id'];

// Ambil data pembelian
$query = "SELECT p.*, s.nama_supplier, t.nama_toko, m.nama_metode, pg.nama_lengkap as nama_kasir 
          FROM pembelian p
          JOIN supplier s ON p.id_supplier = s.id_supplier
          JOIN toko t ON p.id_toko = t.id_toko
          JOIN metode_pembayaran m ON p.id_metode = m.id_metode
          JOIN pengguna pg ON p.id_pengguna = pg.id_pengguna
          WHERE p.id_pembelian = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, 'i', $id_pembelian);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$pembelian = mysqli_fetch_assoc($result);

if (!$pembelian) {
    $_SESSION['error'] = "Data pembelian tidak ditemukan";
    header("Location: pembelian.php");
    exit();
}

// Ambil detail pembelian
$query_detail = "SELECT dp.*, b.kode_barang, b.nama_barang, s.nama_satuan 
                 FROM detail_pembelian dp
                 JOIN barang b ON dp.id_barang = b.id_barang
                 JOIN satuan s ON b.id_satuan = s.id_satuan
                 WHERE dp.id_pembelian = ?";
$stmt_detail = mysqli_prepare($conn, $query_detail);
mysqli_stmt_bind_param($stmt_detail, 'i', $id_pembelian);
mysqli_stmt_execute($stmt_detail);
$result_detail = mysqli_stmt_get_result($stmt_detail);
$detail_pembelian = mysqli_fetch_all($result_detail, MYSQLI_ASSOC);

// Ambil nota pembelian jika ada
$query_nota = "SELECT * FROM nota_pembelian WHERE id_pembelian = ?";
$stmt_nota = mysqli_prepare($conn, $query_nota);
mysqli_stmt_bind_param($stmt_nota, 'i', $id_pembelian);
mysqli_stmt_execute($stmt_nota);
$result_nota = mysqli_stmt_get_result($stmt_nota);
$nota = mysqli_fetch_assoc($result_nota);

// Fungsi format rupiah
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}
?>

<div class="modal fade" id="detailPembelianModal" tabindex="-1" aria-labelledby="detailPembelianModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title" id="detailPembelianModalLabel">Detail Pembelian - <?= $pembelian['no_faktur'] ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <th width="30%">No Faktur</th>
                                <td>: <?= $pembelian['no_faktur'] ?></td>
                            </tr>
                            <tr>
                                <th>Tanggal</th>
                                <td>: <?= date('d-m-Y H:i', strtotime($pembelian['tanggal_pembelian'])) ?></td>
                            </tr>
                            <tr>
                                <th>Supplier</th>
                                <td>: <?= $pembelian['nama_supplier'] ?></td>
                            </tr>
                            <tr>
                                <th>Toko</th>
                                <td>: <?= $pembelian['nama_toko'] ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <th width="30%">Metode Bayar</th>
                                <td>: <?= $pembelian['nama_metode'] ?></td>
                            </tr>
                            <tr>
                                <th>Kasir</th>
                                <td>: <?= $pembelian['nama_kasir'] ?></td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>: 
                                    <?php if ($pembelian['status_pembayaran'] == 'lunas'): ?>
                                        <span class="badge bg-success">Lunas</span>
                                    <?php elseif ($pembelian['status_pembayaran'] == 'hutang'): ?>
                                        <span class="badge bg-danger">Hutang</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark">Sebagian</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Nota</th>
                                <td>: 
                                    <?php if ($nota): ?>
                                        <a href="<?= $nota['path_file'] ?>" target="_blank" class="btn btn-sm btn-info">
                                            <i class="fas fa-file-invoice"></i> Lihat Nota
                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted">Tidak ada nota</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead class="thead-light">
                            <tr>
                                <th>No</th>
                                <th>Kode Barang</th>
                                <th>Nama Barang</th>
                                <th>Jumlah</th>
                                <th>Satuan</th>
                                <th>Harga Beli</th>
                                <th>Subtotal</th>
                                <th>Expired Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1; ?>
                            <?php foreach ($detail_pembelian as $detail): ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= $detail['kode_barang'] ?></td>
                                    <td><?= $detail['nama_barang'] ?></td>
                                    <td><?= $detail['jumlah'] ?></td>
                                    <td><?= $detail['nama_satuan'] ?></td>
                                    <td class="text-right"><?= format_rupiah($detail['harga_beli']) ?></td>
                                    <td class="text-right"><?= format_rupiah($detail['subtotal']) ?></td>
                                    <td><?= $detail['expired_date'] ? date('d-m-Y', strtotime($detail['expired_date'])) : '-' ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="6" class="text-right">Total</th>
                                <th class="text-right"><?= format_rupiah($pembelian['total_pembelian']) ?></th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="6" class="text-right">Diskon</th>
                                <th class="text-right"><?= format_rupiah($pembelian['diskon']) ?></th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="6" class="text-right">PPN</th>
                                <th class="text-right"><?= format_rupiah($pembelian['ppn']) ?></th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="6" class="text-right">Grand Total</th>
                                <th class="text-right"><?= format_rupiah($pembelian['grand_total']) ?></th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="6" class="text-right">Dibayar</th>
                                <th class="text-right"><?= format_rupiah($pembelian['jumlah_bayar']) ?></th>
                                <th></th>
                            </tr>
                            <tr>
                                <th colspan="6" class="text-right">Kembalian</th>
                                <th class="text-right"><?= format_rupiah($pembelian['kembalian']) ?></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="row mt-3">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="catatan">Catatan</label>
                            <textarea class="form-control" id="catatan" rows="3" readonly><?= $pembelian['catatan'] ?></textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <a href="cetak_nota_pembelian.php?id=<?= $pembelian['id_pembelian'] ?>" class="btn btn-primary" target="_blank">
                    <i class="fas fa-print"></i> Cetak Nota
                </a>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Tampilkan modal detail ketika halaman selesai dimuat
    $('#detailPembelianModal').modal('show');
    
    // Tutup modal dan redirect ke halaman pembelian ketika modal ditutup
    $('#detailPembelianModal').on('hidden.bs.modal', function () {
        window.location.href = 'pembelian.php';
    });
});
</script>