<?php
// Start session dan validasi login
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Cek apakah user sudah login
if (!isset($_SESSION['id_pengguna'])) {
    header("Location: login.php");
    exit();
}

include 'header.php';
require_once 'config.php';

// Validasi ID promo
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: promo.php");
    exit();
}

$id_promo = (int)$_GET['id'];

// Ambil data promo dari database
$query_promo = "SELECT p.*, t.nama_toko 
                FROM promo p
                LEFT JOIN toko t ON p.id_toko = t.id_toko
                WHERE p.id_promo = ?";
$stmt_promo = mysqli_prepare($conn, $query_promo);
mysqli_stmt_bind_param($stmt_promo, "i", $id_promo);
mysqli_stmt_execute($stmt_promo);
$result_promo = mysqli_stmt_get_result($stmt_promo);

if (mysqli_num_rows($result_promo) == 0) {
    header("Location: promo.php");
    exit();
}

$promo = mysqli_fetch_assoc($result_promo);

// Ambil barang yang termasuk dalam promo ini
$query_barang = "SELECT b.kode_barang, b.nama_barang 
                 FROM promo_barang pb
                 JOIN barang b ON pb.id_barang = b.id_barang
                 WHERE pb.id_promo = ?
                 ORDER BY b.nama_barang";
$stmt_barang = mysqli_prepare($conn, $query_barang);
mysqli_stmt_bind_param($stmt_barang, "i", $id_promo);
mysqli_stmt_execute($stmt_barang);
$result_barang = mysqli_stmt_get_result($stmt_barang);

// Format nilai promo
$nilai_promo = ($promo['tipe_nilai'] == 'persen') ? 
    $promo['nilai_promo'] . '%' : 
    'Rp ' . number_format($promo['nilai_promo'], 0, ',', '.');

// Format tanggal
$tanggal_mulai = date('d M Y', strtotime($promo['tanggal_mulai']));
$tanggal_selesai = date('d M Y', strtotime($promo['tanggal_selesai']));
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card shadow mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-primary-custom">
                        <h6 class="m-0 font-weight-bold text-white">Detail Promo</h6>
                        <div>
                            <a href="promo.php" class="btn btn-sm btn-light">
                                <i class="fas fa-arrow-left"></i> Kembali
                            </a>
                            <?php if ($_SESSION['id_role'] == 1 || $_SESSION['id_role'] == 2): ?>
                                <a href="edit_promo.php?id=<?php echo $id_promo; ?>" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-md-8">
                                <h4 class="text-primary-custom"><?php echo htmlspecialchars($promo['nama_promo']); ?></h4>
                                <p class="text-muted">Kode: <?php echo htmlspecialchars($promo['kode_promo']); ?></p>
                            </div>
                            <div class="col-md-4 text-right">
                                <span class="badge badge-<?php echo $promo['is_active'] ? 'success' : 'danger'; ?> p-2">
                                    <?php echo $promo['is_active'] ? 'AKTIF' : 'NONAKTIF'; ?>
                                </span>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">Jenis Promo</th>
                                            <td>
                                                <?php 
                                                $badge_class = '';
                                                switch ($promo['jenis_promo']) {
                                                    case 'diskon': $badge_class = 'bg-info'; break;
                                                    case 'gratis': $badge_class = 'bg-success'; break;
                                                    case 'bundling': $badge_class = 'bg-warning text-dark'; break;
                                                }
                                                ?>
                                                <span class="badge <?php echo $badge_class; ?>">
                                                    <?php echo ucfirst($promo['jenis_promo']); ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Nilai Promo</th>
                                            <td><?php echo $nilai_promo; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Periode</th>
                                            <td><?php echo "$tanggal_mulai - $tanggal_selesai"; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Toko</th>
                                            <td><?php echo $promo['nama_toko'] ? htmlspecialchars($promo['nama_toko']) : 'Semua Toko'; ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">Minimal Pembelian</th>
                                            <td><?php echo $promo['min_pembelian'] > 0 ? 'Rp ' . number_format($promo['min_pembelian'], 0, ',', '.') : 'Tidak ada'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Maksimal Diskon</th>
                                            <td><?php echo $promo['max_diskon'] ? 'Rp ' . number_format($promo['max_diskon'], 0, ',', '.') : 'Tidak ada'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Kuota</th>
                                            <td><?php echo $promo['kuota'] ? number_format($promo['kuota'], 0, ',', '.') : 'Tidak terbatas'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Dibuat Pada</th>
                                            <td><?php echo date('d M Y H:i', strtotime($promo['created_at'])); ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <h5>Deskripsi</h5>
                                <p><?php echo nl2br(htmlspecialchars($promo['deskripsi'])); ?></p>
                            </div>
                        </div>
                        
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <h5>Barang yang Termasuk dalam Promo</h5>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Kode Barang</th>
                                                <th>Nama Barang</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (mysqli_num_rows($result_barang) > 0): ?>
                                                <?php $no = 1; while ($barang = mysqli_fetch_assoc($result_barang)): ?>
                                                    <tr>
                                                        <td><?php echo $no++; ?></td>
                                                        <td><?php echo htmlspecialchars($barang['kode_barang']); ?></td>
                                                        <td><?php echo htmlspecialchars($barang['nama_barang']); ?></td>
                                                    </tr>
                                                <?php endwhile; ?>
                                            <?php else: ?>
                                                <tr>
                                                    <td colspan="3" class="text-center">Tidak ada barang dalam promo ini</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include 'footer.php'; ?>