<?php
session_start();
require_once 'config.php';

// Cek hak akses
if ($_SESSION['id_role'] != 1 && $_SESSION['id_role'] != 4) {
    header("Location: unauthorized.php");
    exit();
}

$id_pengguna = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Ambil data pengguna
$query = "SELECT * FROM pengguna WHERE id_pengguna = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_pengguna);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$pengguna = mysqli_fetch_assoc($result);

if (!$pengguna) {
    header("Location: pengguna.php");
    exit();
}

include 'header.php';

// Ambil data untuk dropdown
$query_role = "SELECT * FROM role ORDER BY nama_role ASC";
$result_role = mysqli_query($conn, $query_role);

$query_toko = "SELECT * FROM toko WHERE status_aktif = 1 ORDER BY nama_toko ASC";
$result_toko = mysqli_query($conn, $query_toko);

// Proses form submit
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $nama_lengkap = mysqli_real_escape_string($conn, $_POST['nama_lengkap']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $telepon = mysqli_real_escape_string($conn, $_POST['telepon']);
    $id_role = intval($_POST['id_role']);
    $id_toko = !empty($_POST['id_toko']) ? intval($_POST['id_toko']) : NULL;
    $is_active = isset($_POST['is_active']) ? 1 : 0;

    // Jika password diisi, update password
    if (!empty($_POST['password'])) {
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $query = "UPDATE pengguna SET 
                  username = ?, password = ?, nama_lengkap = ?, email = ?, telepon = ?, 
                  id_role = ?, id_toko = ?, is_active = ? 
                  WHERE id_pengguna = ?";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "sssssiisi", $username, $password, $nama_lengkap, $email, $telepon, $id_role, $id_toko, $is_active, $id_pengguna);
    } else {
        $query = "UPDATE pengguna SET 
                  username = ?, nama_lengkap = ?, email = ?, telepon = ?, 
                  id_role = ?, id_toko = ?, is_active = ? 
                  WHERE id_pengguna = ?";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "ssssiisi", $username, $nama_lengkap, $email, $telepon, $id_role, $id_toko, $is_active, $id_pengguna);
    }
    
    if (mysqli_stmt_execute($stmt)) {
        header('Location: pengguna.php?notif=success_edit');
        exit;
    } else {
        $error = "Error: " . mysqli_error($conn);
    }
}
?>

<main class="animate-fade-in">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Edit Pengguna</h1>
        <a href="pengguna.php" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-left fa-sm text-white-50"></i> Kembali
        </a>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3 bg-primary-custom">
            <h6 class="m-0 font-weight-bold text-white">Form Edit Pengguna</h6>
        </div>
        <div class="card-body">
            <?php if (isset($error)): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo $error; ?>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="username" class="form-label">Username*</label>
                        <input type="text" class="form-control" id="username" name="username" 
                               value="<?php echo htmlspecialchars($pengguna['username']); ?>" required>
                    </div>
                    <div class="col-md-6">
                        <label for="password" class="form-label">Password (Kosongkan jika tidak diubah)</label>
                        <input type="password" class="form-control" id="password" name="password">
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="nama_lengkap" class="form-label">Nama Lengkap*</label>
                        <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" 
                               value="<?php echo htmlspecialchars($pengguna['nama_lengkap']); ?>" required>
                    </div>
                    <div class="col-md-6">
                        <label for="id_role" class="form-label">Role*</label>
                        <select class="form-control" id="id_role" name="id_role" required>
                            <option value="">Pilih Role</option>
                            <?php 
                            mysqli_data_seek($result_role, 0);
                            while ($role = mysqli_fetch_assoc($result_role)): 
                                $selected = ($role['id_role'] == $pengguna['id_role']) ? 'selected' : '';
                            ?>
                                <option value="<?php echo $role['id_role']; ?>" <?php echo $selected; ?>>
                                    <?php echo htmlspecialchars($role['nama_role']); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" class="form-control" id="email" name="email" 
                               value="<?php echo htmlspecialchars($pengguna['email']); ?>">
                    </div>
                    <div class="col-md-6">
                        <label for="telepon" class="form-label">Telepon</label>
                        <input type="text" class="form-control" id="telepon" name="telepon" 
                               value="<?php echo htmlspecialchars($pengguna['telepon']); ?>">
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="id_toko" class="form-label">Toko</label>
                        <select class="form-control" id="id_toko" name="id_toko">
                            <option value="">Pilih Toko (Opsional)</option>
                            <?php 
                            mysqli_data_seek($result_toko, 0);
                            while ($toko = mysqli_fetch_assoc($result_toko)): 
                                $selected = ($toko['id_toko'] == $pengguna['id_toko']) ? 'selected' : '';
                            ?>
                                <option value="<?php echo $toko['id_toko']; ?>" <?php echo $selected; ?>>
                                    <?php echo htmlspecialchars($toko['nama_toko']); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <div class="form-check mt-4 pt-2">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" 
                                <?php echo ($pengguna['is_active'] == 1) ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="is_active">Aktif</label>
                        </div>
                    </div>
                </div>
                
                <div class="d-flex justify-content-end">
                    <button type="reset" class="btn btn-secondary mr-2">Reset</button>
                    <button type="submit" class="btn btn-primary-custom">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</main>

<?php include 'footer.php'; ?>