<?php
require_once 'config.php';
session_start();

// Cek session
if (!isset($_SESSION['id_pengguna'])) {
    header("Location: login.php");
    exit();
}

// Set header untuk file Excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="laporan_barang_' . date('Ymd_His') . '.xlsx"');

// Gunakan library PHPExcel
require_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Buat spreadsheet baru
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set judul kolom
$sheet->setCellValue('A1', 'No');
$sheet->setCellValue('B1', 'Kode Barang');
$sheet->setCellValue('C1', 'Barcode');
$sheet->setCellValue('D1', 'Nama Barang');
$sheet->setCellValue('E1', 'Kategori');
$sheet->setCellValue('F1', 'Satuan');
$sheet->setCellValue('G1', 'Harga Beli');
$sheet->setCellValue('H1', 'Harga Jual');
$sheet->setCellValue('I1', 'Stok Minimal');
$sheet->setCellValue('J1', 'Status');

// Query data barang
$query = "SELECT b.*, k.nama_kategori, s.nama_satuan 
          FROM barang b
          JOIN kategori k ON b.id_kategori = k.id_kategori
          JOIN satuan s ON b.id_satuan = s.id_satuan
          ORDER BY b.nama_barang";
$result = mysqli_query($conn, $query);

// Isi data ke Excel
$row = 2;
while ($barang = mysqli_fetch_assoc($result)) {
    $sheet->setCellValue('A' . $row, $row - 1);
    $sheet->setCellValue('B' . $row, $barang['kode_barang']);
    $sheet->setCellValue('C' . $row, $barang['barcode']);
    $sheet->setCellValue('D' . $row, $barang['nama_barang']);
    $sheet->setCellValue('E' . $row, $barang['nama_kategori']);
    $sheet->setCellValue('F' . $row, $barang['nama_satuan']);
    $sheet->setCellValue('G' . $row, $barang['harga_beli']);
    $sheet->setCellValue('H' . $row, $barang['harga_jual']);
    $sheet->setCellValue('I' . $row, $barang['stok_minimal']);
    $sheet->setCellValue('J' . $row, $barang['is_active'] ? 'Aktif' : 'Nonaktif');
    
    // Format angka untuk harga
    $sheet->getStyle('G' . $row . ':H' . $row)->getNumberFormat()
          ->setFormatCode('#,##0');
    
    $row++;
}

// Auto size kolom
foreach (range('A', 'J') as $col) {
    $sheet->getColumnDimension($col)->setAutoSize(true);
}

// Buat judul
$sheet->insertNewRowBefore(1, 2);
$sheet->mergeCells('A1:J1');
$sheet->setCellValue('A1', 'LAPORAN DATA BARANG');
$sheet->getStyle('A1')->getFont()->setBold(true)->setSize(16);
$sheet->getStyle('A1')->getAlignment()->setHorizontal('center');

// Format header tabel
$sheet->getStyle('A3:J3')->getFont()->setBold(true);
$sheet->getStyle('A3:J3')->getAlignment()->setHorizontal('center');

// Buat file Excel dan kirim ke browser
$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit();
?>