<?php
require_once 'config.php';
session_start();

// Cek session
if (!isset($_SESSION['id_pengguna'])) {
    header("Location: login.php");
    exit();
}

// Set header untuk file Excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="laporan_pembelian_' . date('Ymd_His') . '.xlsx"');

// Gunakan library PHPExcel
require_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Buat spreadsheet baru
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set judul kolom
$sheet->setCellValue('A1', 'No');
$sheet->setCellValue('B1', 'No Faktur');
$sheet->setCellValue('C1', 'Tanggal');
$sheet->setCellValue('D1', 'Supplier');
$sheet->setCellValue('E1', 'Toko');
$sheet->setCellValue('F1', 'Metode');
$sheet->setCellValue('G1', 'Total');
$sheet->setCellValue('H1', 'Diskon');
$sheet->setCellValue('I1', 'PPN');
$sheet->setCellValue('J1', 'Grand Total');
$sheet->setCellValue('K1', 'Dibayar');
$sheet->setCellValue('L1', 'Status');

// Ambil data pembelian dengan filter yang sama
$where = "1=1";
$params = [];

if (!empty($_GET['dari_tanggal'])) {
    $where .= " AND p.tanggal_pembelian >= ?";
    $params[] = $_GET['dari_tanggal'];
}

if (!empty($_GET['sampai_tanggal'])) {
    $where .= " AND p.tanggal_pembelian <= ?";
    $params[] = $_GET['sampai_tanggal'] . ' 23:59:59';
}

if (!empty($_GET['id_supplier'])) {
    $where .= " AND p.id_supplier = ?";
    $params[] = $_GET['id_supplier'];
}

if (!empty($_GET['status_pembayaran'])) {
    $where .= " AND p.status_pembayaran = ?";
    $params[] = $_GET['status_pembayaran'];
}

if (!empty($_GET['id_toko'])) {
    $where .= " AND p.id_toko = ?";
    $params[] = $_GET['id_toko'];
}

$query = "SELECT p.*, s.nama_supplier, t.nama_toko, m.nama_metode, pg.nama_lengkap as nama_kasir 
          FROM pembelian p
          JOIN supplier s ON p.id_supplier = s.id_supplier
          JOIN toko t ON p.id_toko = t.id_toko
          JOIN metode_pembayaran m ON p.id_metode = m.id_metode
          JOIN pengguna pg ON p.id_pengguna = pg.id_pengguna
          WHERE $where
          ORDER BY p.tanggal_pembelian DESC";
$stmt = mysqli_prepare($conn, $query);

if (!empty($params)) {
    $types = str_repeat('s', count($params));
    mysqli_stmt_bind_param($stmt, $types, ...$params);
}

mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$pembelian = mysqli_fetch_all($result, MYSQLI_ASSOC);

// Isi data ke Excel
$row = 2;
foreach ($pembelian as $trx) {
    $sheet->setCellValue('A' . $row, $row - 1);
    $sheet->setCellValue('B' . $row, $trx['no_faktur']);
    $sheet->setCellValue('C' . $row, date('d-m-Y H:i', strtotime($trx['tanggal_pembelian'])));
    $sheet->setCellValue('D' . $row, $trx['nama_supplier']);
    $sheet->setCellValue('E' . $row, $trx['nama_toko']);
    $sheet->setCellValue('F' . $row, $trx['nama_metode']);
    $sheet->setCellValue('G' . $row, $trx['total_pembelian']);
    $sheet->setCellValue('H' . $row, $trx['diskon']);
    $sheet->setCellValue('I' . $row, $trx['ppn']);
    $sheet->setCellValue('J' . $row, $trx['grand_total']);
    $sheet->setCellValue('K' . $row, $trx['jumlah_bayar']);
    $sheet->setCellValue('L' . $row, ucfirst($trx['status_pembayaran']));
    
    // Format angka
    $sheet->getStyle('G' . $row . ':K' . $row)->getNumberFormat()
          ->setFormatCode('#,##0');
    
    $row++;
}

// Auto size kolom
foreach (range('A', 'L') as $col) {
    $sheet->getColumnDimension($col)->setAutoSize(true);
}

// Buat file Excel dan kirim ke browser
$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit();
?>