<?php
require_once 'config.php';
session_start();

// Cek session
if (!isset($_SESSION['id_pengguna'])) {
    header("Location: login.php");
    exit();
}

// Gunakan library TCPDF
require_once('tcpdf/tcpdf.php');

// Ambil filter dari parameter GET
$dari_tanggal = isset($_GET['dari_tanggal']) ? $_GET['dari_tanggal'] : '';
$sampai_tanggal = isset($_GET['sampai_tanggal']) ? $_GET['sampai_tanggal'] : '';
$id_supplier = isset($_GET['id_supplier']) ? $_GET['id_supplier'] : '';
$status_pembayaran = isset($_GET['status_pembayaran']) ? $_GET['status_pembayaran'] : '';
$id_toko = isset($_GET['id_toko']) ? $_GET['id_toko'] : '';

// Buat query dengan filter
$where = "1=1";
$params = [];

if (!empty($dari_tanggal)) {
    $where .= " AND p.tanggal_pembelian >= ?";
    $params[] = $dari_tanggal;
}

if (!empty($sampai_tanggal)) {
    $where .= " AND p.tanggal_pembelian <= ?";
    $params[] = $sampai_tanggal . ' 23:59:59';
}

if (!empty($id_supplier)) {
    $where .= " AND p.id_supplier = ?";
    $params[] = $id_supplier;
}

if (!empty($status_pembayaran)) {
    $where .= " AND p.status_pembayaran = ?";
    $params[] = $status_pembayaran;
}

if (!empty($id_toko)) {
    $where .= " AND p.id_toko = ?";
    $params[] = $id_toko;
}

// Query data pembelian
$query = "SELECT p.*, s.nama_supplier, t.nama_toko, m.nama_metode, pg.nama_lengkap as nama_kasir 
          FROM pembelian p
          JOIN supplier s ON p.id_supplier = s.id_supplier
          JOIN toko t ON p.id_toko = t.id_toko
          JOIN metode_pembayaran m ON p.id_metode = m.id_metode
          JOIN pengguna pg ON p.id_pengguna = pg.id_pengguna
          WHERE $where
          ORDER BY p.tanggal_pembelian DESC";
$stmt = mysqli_prepare($conn, $query);

if (!empty($params)) {
    $types = str_repeat('s', count($params));
    mysqli_stmt_bind_param($stmt, $types, ...$params);
}

mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$pembelian = mysqli_fetch_all($result, MYSQLI_ASSOC);

// Fungsi format rupiah
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Buat dokumen PDF
$pdf = new TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Set informasi dokumen
$pdf->SetCreator('Toko Kuliner');
$pdf->SetAuthor('Toko Kuliner');
$pdf->SetTitle('Laporan Pembelian');
$pdf->SetSubject('Laporan Pembelian');

// Set margin
$pdf->SetMargins(15, 15, 15);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);

// Add a page
$pdf->AddPage();

// Set font
$pdf->SetFont('helvetica', 'B', 16);
$pdf->Cell(0, 15, 'LAPORAN PEMBELIAN', 0, 1, 'C');

// Tambahkan informasi filter
$pdf->SetFont('helvetica', '', 10);
$pdf->Cell(0, 10, 'Periode: ' . (!empty($dari_tanggal) ? date('d-m-Y', strtotime($dari_tanggal)) : '-') . 
            ' s/d ' . (!empty($sampai_tanggal) ? date('d-m-Y', strtotime($sampai_tanggal)) : '-'), 0, 1);
$pdf->Cell(0, 10, 'Dicetak pada: ' . date('d-m-Y H:i:s'), 0, 1);

// Buat tabel
$pdf->SetFont('helvetica', 'B', 10);
$html = '<table border="1" cellpadding="4">
    <thead>
        <tr>
            <th width="5%">No</th>
            <th width="12%">No Faktur</th>
            <th width="10%">Tanggal</th>
            <th width="15%">Supplier</th>
            <th width="10%">Toko</th>
            <th width="10%">Metode</th>
            <th width="12%">Total</th>
            <th width="12%">Grand Total</th>
            <th width="12%">Dibayar</th>
            <th width="12%">Status</th>
        </tr>
    </thead>
    <tbody>';

$no = 1;
foreach ($pembelian as $trx) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . $trx['no_faktur'] . '</td>
        <td>' . date('d-m-Y H:i', strtotime($trx['tanggal_pembelian'])) . '</td>
        <td>' . $trx['nama_supplier'] . '</td>
        <td>' . $trx['nama_toko'] . '</td>
        <td>' . $trx['nama_metode'] . '</td>
        <td align="right">' . format_rupiah($trx['total_pembelian']) . '</td>
        <td align="right">' . format_rupiah($trx['grand_total']) . '</td>
        <td align="right">' . format_rupiah($trx['jumlah_bayar']) . '</td>
        <td>' . ucfirst($trx['status_pembayaran']) . '</td>
    </tr>';
}

$html .= '</tbody></table>';

// Output HTML ke PDF
$pdf->writeHTML($html, true, false, true, false, '');

// Close and output PDF document
$pdf->Output('laporan_pembelian_' . date('Ymd_His') . '.pdf', 'D');
exit();
?>