<!-- Footer -->
<footer class="sticky-footer bg-white border-top">
    <div class="container-fluid py-3">
        <div class="row align-items-center">
            <!-- Kolom 1: Copyright & Info Dasar -->
            <div class="col-md-4 text-center text-md-start mb-3 mb-md-0">
                <div class="d-flex flex-column">
                    <span class="text-muted small mb-1">
                        &copy; <?php echo date('Y'); ?> PT SPOG. All rights reserved.
                    </span>
                    <span class="text-dark small fw-bold">
                        SawitMart Retail Management System v1.2.0
                    </span>
                </div>
            </div>
            
            <!-- Kolom 2: Info Sistem & Status -->
            <div class="col-md-4 text-center mb-3 mb-md-0">
                <div class="d-flex flex-wrap justify-content-center gap-2">
                    <span class="badge bg-light text-dark border small">
                        <i class="fas fa-server me-1"></i> 
                        Server: <?php echo date('d M Y, H:i:s'); ?> WIB
                    </span>
                    
                    <?php
                    // Cek koneksi database
                    $db_status = mysqli_ping($conn) ? 'success' : 'danger';
                    $db_status_text = mysqli_ping($conn) ? 'Online' : 'Offline';
                    ?>
                    <span class="badge bg-<?php echo $db_status; ?> small">
                        <i class="fas fa-database me-1"></i> 
                        Database: <?php echo $db_status_text; ?>
                    </span>
                    
                    <span class="badge bg-light text-dark border small">
                        <i class="fas fa-code-branch me-1"></i> 
                        Build: 28 Juli 2025
                    </span>
                </div>
            </div>
            
            <!-- Kolom 3: Kontak & Bantuan -->
            <div class="col-md-4 text-center text-md-end">
                <div class="d-flex flex-column flex-md-row justify-content-md-end align-items-center gap-2">
                    <a href="bantuan.php" class="text-decoration-none small text-primary-custom">
                        <i class="fas fa-book me-1"></i> Pusat Bantuan
                    </a>
                    <span class="text-muted small d-none d-md-inline">|</span>
                    <a href="mailto:it.spo@domain.com" class="text-decoration-none small text-primary-custom">
                        <i class="fas fa-envelope me-1"></i> it.spo@domain.com
                    </a>
                </div>
                <div class="mt-1 small text-muted">
                    Developed by IT/GIS Dept - HO SPOG
                </div>
            </div>
        </div>
        
        <!-- Baris 2: Catatan Internal -->
        <div class="row mt-2">
            <div class="col-12 text-center">
                <p class="small text-danger mb-0">
                    <i class="fas fa-lock me-1"></i> 
                    Untuk penggunaan internal PT SPOG saja. Dilarang menyebarkan sistem ini.
                </p>
            </div>
        </div>
    </div>
</footer>
<!-- End of Footer -->

<!-- Bootstrap core JavaScript-->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

<!-- Custom scripts for all pages-->
<script>
    // Toggle sidebar on mobile
    document.getElementById('sidebarToggle').addEventListener('click', function() {
        document.querySelector('.sidebar').classList.toggle('collapse');
    });
    
    // Animasi saat scroll
    document.addEventListener('DOMContentLoaded', function() {
        const animatedElements = document.querySelectorAll('.animate-fade-in');
        
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = 1;
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, { threshold: 0.1 });
        
        animatedElements.forEach(element => {
            element.style.opacity = 0;
            element.style.transform = 'translateY(20px)';
            element.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
            observer.observe(element);
        });
    });
</script>
</body>
</html>