<?php
require_once 'config.php';

if (isset($_GET['id'])) {
    $id_barang = mysqli_real_escape_string($conn, $_GET['id']);
    
    $query = "SELECT b.*, k.nama_kategori, s.nama_satuan, 
              (SELECT st.stok_akhir FROM stok_toko st WHERE st.id_barang = b.id_barang AND st.id_toko = 1 LIMIT 1) as stok_toko,
              DATE_FORMAT(b.created_at, '%d %b %Y %H:%i') as created_at,
              DATE_FORMAT(b.updated_at, '%d %b %Y %H:%i') as updated_at
              FROM barang b
              LEFT JOIN kategori k ON b.id_kategori = k.id_kategori
              LEFT JOIN satuan s ON b.id_satuan = s.id_satuan
              WHERE b.id_barang = '$id_barang'";
    
    $result = mysqli_query($conn, $query);
    
    if ($result && mysqli_num_rows($result) > 0) {
        $data = mysqli_fetch_assoc($result);
        header('Content-Type: application/json');
        echo json_encode($data);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Data barang tidak ditemukan']);
    }
} else {
    http_response_code(400);
    echo json_encode(['error' => 'ID barang tidak valid']);
}
?>