<?php
// Start session dan validasi login
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'config.php';

// Validasi request AJAX
if (!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) != 'xmlhttprequest') {
    die("Invalid request");
}

// Validasi parameter
if (!isset($_GET['id_promo']) || !is_numeric($_GET['id_promo'])) {
    die(json_encode([]));
}

$id_promo = (int)$_GET['id_promo'];

// Query untuk mendapatkan daftar barang promo
$query = "SELECT b.kode_barang, b.nama_barang 
          FROM promo_barang pb
          JOIN barang b ON pb.id_barang = b.id_barang
          WHERE pb.id_promo = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_promo);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$barang = [];
while ($row = mysqli_fetch_assoc($result)) {
    $barang[] = $row;
}

header('Content-Type: application/json');
echo json_encode($barang);
?>