<?php
// Start session dan validasi login
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Cek apakah user sudah login dan memiliki akses
if (!isset($_SESSION['id_pengguna'])) {
    header("Location: login.php");
    exit();
}

// Validasi hak akses (hanya admin)
if (!isset($_SESSION['role']) || $_SESSION['role'] != 'admin') {
    header("Location: unauthorized.php");
    exit();
}

require_once 'config.php';

// Validasi input
if ($_SERVER['REQUEST_METHOD'] != 'POST' || !isset($_POST['id_promo'])) {
    $_SESSION['error'] = "Invalid request";
    header("Location: promo.php");
    exit();
}

$id_promo = (int)$_POST['id_promo'];

// Mulai transaksi
mysqli_begin_transaction($conn);

try {
    // Hapus dari tabel promo_barang terlebih dahulu
    $query1 = "DELETE FROM promo_barang WHERE id_promo = ?";
    $stmt1 = mysqli_prepare($conn, $query1);
    mysqli_stmt_bind_param($stmt1, "i", $id_promo);
    mysqli_stmt_execute($stmt1);
    
    // Hapus dari tabel promo
    $query2 = "DELETE FROM promo WHERE id_promo = ?";
    $stmt2 = mysqli_prepare($conn, $query2);
    mysqli_stmt_bind_param($stmt2, "i", $id_promo);
    mysqli_stmt_execute($stmt2);
    
    // Commit transaksi
    mysqli_commit($conn);
    
    $_SESSION['success'] = "Promo berhasil dihapus";
} catch (Exception $e) {
    // Rollback transaksi jika ada error
    mysqli_rollback($conn);
    $_SESSION['error'] = "Gagal menghapus promo: " . $e->getMessage();
}

header("Location: promo.php");
exit();
?>