<?php
// Debugging info
error_log("Current page: ".basename($_SERVER['PHP_SELF']));
error_log("Session content: ".print_r($_SESSION, true));

// Jika belum login DAN tidak sedang di halaman login
if (!isset($_SESSION['id_pengguna']) && basename($_SERVER['PHP_SELF']) != 'login.php') {
    error_log("Redirecting to login.php");
    header("Location: login.php");
    exit();
}

// Jika sudah login DAN sedang di halaman login, redirect ke dashboard
if (isset($_SESSION['id_pengguna']) && basename($_SERVER['PHP_SELF']) == 'login.php') {
    error_log("Redirecting to dashboard.php from login");
    header("Location: dashboard.php");
    exit();
}

// Koneksi database (sesuaikan dengan konfigurasi Anda)
require_once 'config.php';

// Ambil data pengguna yang login
$user_id = $_SESSION['id_pengguna'];
$query = "SELECT p.*, r.nama_role, t.nama_toko 
          FROM pengguna p 
          JOIN role r ON p.id_role = r.id_role 
          LEFT JOIN toko t ON p.id_toko = t.id_toko 
          WHERE p.id_pengguna = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

// Ambil notifikasi
$query_notif = "SELECT * FROM notifikasi WHERE id_pengguna = ? AND is_read = FALSE ORDER BY created_at DESC LIMIT 5";
$stmt_notif = $conn->prepare($query_notif);
$stmt_notif->bind_param("i", $user_id);
$stmt_notif->execute();
$notifications = $stmt_notif->get_result()->fetch_all(MYSQLI_ASSOC);

// Fungsi untuk menampilkan waktu dalam format "x waktu yang lalu"
function time_elapsed_string($datetime, $full = false) {
    $now = new DateTime;
    $ago = new DateTime($datetime);
    $diff = $now->diff($ago);

    $diff->w = floor($diff->d / 7);
    $diff->d -= $diff->w * 7;
    
    $string = array(
        'y' => 'tahun',
        'm' => 'bulan',
        'w' => 'minggu',
        'd' => 'hari',
        'h' => 'jam',
        'i' => 'menit',
        's' => 'detik',
    );
    
    foreach ($string as $k => &$v) {
        if ($diff->$k) {
            $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? '' : '');
        } else {
            unset($string[$k]);
        }
    }

    if (!$full) $string = array_slice($string, 0, 1);
    return $string ? implode(', ', $string) . ' yang lalu' : 'baru saja';
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Sistem Manajemen Toko Retail</title>
    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="96x96" href="favicon/favicon-96x96.png">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: #2E7D32;
            --primary-light: #81C784;
            --primary-dark: #1B5E20;
            --secondary-color: #689F38;
            --accent-color: #8BC34A;
            --text-color: #333;
            --light-bg: #F5F5F5;
            --card-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
            color: var(--text-color);
        }
        
        .sidebar {
            background-color: var(--primary-dark);
            color: white;
            min-height: 100vh;
            transition: all 0.3s;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
        }
        
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            border-radius: 5px;
            margin-bottom: 5px;
            transition: all 0.2s;
        }
        
        .sidebar .nav-link:hover {
            background-color: var(--primary-color);
            color: white;
        }
        
        .sidebar .nav-link.active {
            background-color: var(--accent-color);
            color: var(--primary-dark);
            font-weight: 600;
        }
        
        .sidebar .nav-link i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        
        .topbar {
            background-color: white;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            z-index: 100;
        }
        
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: var(--card-shadow);
            transition: transform 0.3s, box-shadow 0.3s;
            margin-bottom: 20px;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        }
        
        .stat-card {
            border-left: 4px solid var(--primary-color);
        }
        
        .stat-card .icon {
            font-size: 2rem;
            color: var(--primary-color);
        }
        
        .bg-primary-custom {
            background-color: var(--primary-color) !important;
        }
        
        .text-primary-custom {
            color: var(--primary-color) !important;
        }
        
        .btn-primary-custom {
            background-color: var(--primary-color);
            border-color: var(--primary-dark);
        }
        
        .btn-primary-custom:hover {
            background-color: var(--primary-dark);
            border-color: var(--primary-dark);
        }
        
        .badge-primary-custom {
            background-color: var(--primary-light);
            color: var(--primary-dark);
        }
        
        .table-responsive {
            border-radius: 10px;
            overflow: hidden;
        }
        
        .table th {
            background-color: var(--primary-color);
            color: white;
        }
        
        .notification-item {
            border-left: 3px solid var(--primary-color);
            transition: all 0.2s;
        }
        
        .notification-item:hover {
            background-color: #f8f9fa;
        }
        
        .notification-item.unread {
            background-color: rgba(46, 125, 50, 0.05);
        }
        
        .dropdown-menu {
            border: none;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .logo {
            font-weight: 700;
            letter-spacing: 1px;
        }
        
        .logo span {
            color: var(--accent-color);
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .animate-bounce {
            animation: bounce 2s infinite;
        }
        
        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% {transform: translateY(0);}
            40% {transform: translateY(-10px);}
            60% {transform: translateY(-5px);}
        }
        
        /* Tambahan untuk foto profil */
        .profile-img-container {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #f0f0f0;
        }
        
        .profile-img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'sidebar.php'; ?>
            
            <!-- Main Content -->
            <div class="col-lg-10 col-md-9 ms-sm-auto px-md-4">
                <!-- Topbar -->
                <nav class="navbar topbar navbar-expand-lg navbar-light bg-white sticky-top mb-4">
                    <div class="container-fluid">
                        <button class="btn btn-sm d-lg-none" id="sidebarToggle">
                            <i class="fas fa-bars"></i>
                        </button>
                        
                        <div class="d-flex align-items-center">
                            <span class="me-2 d-none d-sm-inline">
                                <i class="fas fa-store-alt text-primary-custom"></i>
                                <strong><?php echo htmlspecialchars($user['nama_toko'] ?? 'Toko Belum Dipilih'); ?></strong>
                            </span>
                        </div>
                        
                        <div class="d-flex align-items-center ms-auto">
                            <!-- Notifikasi Dropdown -->
                            <div class="dropdown me-3">
                                <button class="btn btn-sm position-relative" type="button" id="notificationDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fas fa-bell text-muted"></i>
                                    <?php if(count($notifications) > 0): ?>
                                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                            <?php echo count($notifications); ?>
                                        </span>
                                    <?php endif; ?>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-end p-0" aria-labelledby="notificationDropdown" style="width: 350px;">
                                    <li>
                                        <div class="p-3 border-bottom">
                                            <h6 class="mb-0">Notifikasi</h6>
                                        </div>
                                    </li>
                                    <?php if(count($notifications) > 0): ?>
                                        <?php foreach($notifications as $notif): ?>
                                            <li>
                                                <a href="<?php echo htmlspecialchars($notif['link'] ?? '#'); ?>" class="dropdown-item notification-item unread p-3">
                                                    <div class="d-flex align-items-center">
                                                        <div class="flex-grow-1">
                                                            <h6 class="mb-1"><?php echo htmlspecialchars($notif['judul']); ?></h6>
                                                            <p class="mb-0 text-muted small"><?php echo htmlspecialchars($notif['pesan']); ?></p>
                                                            <small class="text-muted"><?php echo time_elapsed_string($notif['created_at']); ?></small>
                                                        </div>
                                                    </div>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <li>
                                            <div class="dropdown-item text-center py-3">
                                                <p class="text-muted mb-0">Tidak ada notifikasi baru</p>
                                            </div>
                                        </li>
                                    <?php endif; ?>
                                    <li>
                                        <div class="p-2 border-top text-center">
                                            <a href="notifikasi.php" class="btn btn-sm btn-primary-custom">Lihat Semua</a>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            
                            <!-- User Dropdown - Bagian yang Diperbaiki -->
                            <div class="dropdown">
                                <button class="btn btn-sm dropdown-toggle d-flex align-items-center" type="button" id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                    <div class="me-2 d-none d-sm-inline">
                                        <small class="d-block text-end"><?php echo htmlspecialchars($user['nama_lengkap']); ?></small>
                                        <small class="text-muted d-block text-end"><?php echo htmlspecialchars($user['nama_role']); ?></small>
                                    </div>
                                    <div class="profile-img-container">
                                        <?php if(!empty($user['foto_profil'])): ?>
                                            <img src="uploads/profil/<?php echo htmlspecialchars($user['foto_profil']); ?>" 
                                                 alt="Foto Profil" 
                                                 class="profile-img"
                                                 onerror="this.src='assets/img/default-profile.png';this.onerror=null;">
                                        <?php else: ?>
                                            <i class="fas fa-user text-muted"></i>
                                        <?php endif; ?>
                                    </div>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                                    <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user me-2"></i> Profil</a></li>
                                    <li><a class="dropdown-item" href="pengaturan.php"><i class="fas fa-cog me-2"></i> Pengaturan</a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item text-danger" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i> Keluar</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </nav>
                
                <!-- Main Content Will Be Inserted Here -->