<?php
// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
require_once 'config.php';

// Fungsi untuk format mata uang
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Query untuk mendapatkan data piutang pelanggan
$query = "SELECT hp.*, p.nama_pelanggan, pj.no_transaksi 
          FROM hutang_pelanggan hp
          JOIN pelanggan p ON hp.id_pelanggan = p.id_pelanggan
          JOIN penjualan pj ON hp.id_penjualan = pj.id_penjualan
          ORDER BY hp.tanggal_hutang DESC";
$result = mysqli_query($conn, $query);
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Daftar Piutang Pelanggan</h1>
        <div class="d-none d-sm-inline-block">
            <span class="text-muted">Terakhir diperbarui: <?php echo date('d M Y H:i:s'); ?></span>
        </div>
    </div>

    <!-- Card untuk tabel -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-primary-custom">
            <h6 class="m-0 font-weight-bold text-white">Daftar Piutang</h6>
            <div>
                <a href="laporan_keuangan.php" class="btn btn-sm btn-success">
                    <i class="fas fa-file-alt"></i> Laporan Keuangan
                </a>
            </div>
        </div>
        <div class="card-body">
            <?php if (mysqli_num_rows($result) > 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-hover" id="dataTable" width="100%" cellspacing="0">
                        <thead class="bg-light">
                            <tr>
                                <th>No</th>
                                <th>Nama Pelanggan</th>
                                <th>No Transaksi</th>
                                <th>Tanggal Hutang</th>
                                <th>Jatuh Tempo</th>
                                <th>Total Hutang</th>
                                <th>Jumlah Bayar</th>
                                <th>Sisa Hutang</th>
                                <th>Status</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $no = 1;
                            while ($row = mysqli_fetch_assoc($result)): 
                                $sisa_hutang = $row['jumlah_hutang'] - $row['jumlah_bayar'];
                            ?>
                                <tr>
                                    <td><?php echo $no++; ?></td>
                                    <td><?php echo htmlspecialchars($row['nama_pelanggan']); ?></td>
                                    <td><?php echo htmlspecialchars($row['no_transaksi']); ?></td>
                                    <td><?php echo date('d M Y', strtotime($row['tanggal_hutang'])); ?></td>
                                    <td><?php echo date('d M Y', strtotime($row['tanggal_jatuh_tempo'])); ?></td>
                                    <td class="text-right"><?php echo format_rupiah($row['jumlah_hutang']); ?></td>
                                    <td class="text-right"><?php echo format_rupiah($row['jumlah_bayar']); ?></td>
                                    <td class="text-right"><?php echo format_rupiah($sisa_hutang); ?></td>
                                    <td>
                                        <span class="badge badge-<?php echo ($sisa_hutang == 0) ? 'success' : 'danger'; ?>">
                                            <?php echo ($sisa_hutang == 0) ? 'Lunas' : 'Belum Lunas'; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <a href="detail_piutang.php?id_hutang=<?php echo $row['id_hutang']; ?>" class="btn btn-sm btn-info" title="Detail">
                                            <i class="fas fa-search"></i>
                                        </a>
                                        <?php if ($sisa_hutang > 0): ?>
                                            <a href="pembayaran_hutang.php?id_hutang=<?php echo $row['id_hutang']; ?>" class="btn btn-sm btn-success" title="Bayar">
                                                <i class="fas fa-money-bill-wave"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i> Tidak ada data piutang pelanggan yang ditemukan.
                </div>
            <?php endif; ?>
        </div>
    </div>
</main>

<!-- Include DataTables CSS & JS -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap4.min.css">
<script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap4.min.js"></script>

<script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.11.5/i18n/Indonesian.json"
            },
            "columnDefs": [
                { "orderable": false, "targets": [9] },
                { "searchable": false, "targets": [9] }
            ],
            "order": [[3, "desc"]]
        });
    });
</script>

<?php include 'footer.php'; ?>