<?php
// Start session jika belum dimulai
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
require_once 'config.php';

// Cek koneksi database
if (!$conn) {
    die("Koneksi database gagal: " . mysqli_connect_error());
}

// Fungsi untuk memotong teks
function potong_teks($teks, $panjang = 100) {
    if (strlen($teks) > $panjang) {
        return substr($teks, 0, $panjang) . '...';
    }
    return $teks;
}

// Proses tambah kategori
if (isset($_POST['tambah_kategori'])) {
    $nama_kategori = mysqli_real_escape_string($conn, $_POST['nama_kategori']);
    $deskripsi = mysqli_real_escape_string($conn, $_POST['deskripsi']);
    
    // Query tambah kategori
    $query = "INSERT INTO kategori (nama_kategori, deskripsi) VALUES ('$nama_kategori', '$deskripsi')";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Kategori berhasil ditambahkan'];
        header("Location: kategori.php");
        exit();
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menambahkan kategori: ' . mysqli_error($conn)];
    }
}

// Proses edit kategori
if (isset($_POST['edit_kategori'])) {
    $id_kategori = mysqli_real_escape_string($conn, $_POST['id_kategori']);
    $nama_kategori = mysqli_real_escape_string($conn, $_POST['nama_kategori']);
    $deskripsi = mysqli_real_escape_string($conn, $_POST['deskripsi']);
    
    // Query update kategori
    $query = "UPDATE kategori SET 
              nama_kategori = '$nama_kategori',
              deskripsi = '$deskripsi'
              WHERE id_kategori = '$id_kategori'";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Kategori berhasil diupdate'];
        header("Location: kategori.php");
        exit();
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal mengupdate kategori: ' . mysqli_error($conn)];
    }
}

// Proses hapus kategori
if (isset($_GET['hapus'])) {
    $id_kategori = mysqli_real_escape_string($conn, $_GET['hapus']);
    
    // Cek apakah kategori digunakan oleh barang
    $cek_barang = mysqli_query($conn, "SELECT COUNT(*) as total FROM barang WHERE id_kategori = '$id_kategori'");
    $jumlah_barang = mysqli_fetch_assoc($cek_barang)['total'];
    
    if ($jumlah_barang > 0) {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menghapus kategori karena masih digunakan oleh ' . $jumlah_barang . ' barang'];
    } else {
        $query = "DELETE FROM kategori WHERE id_kategori = '$id_kategori'";
        
        if (mysqli_query($conn, $query)) {
            $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Kategori berhasil dihapus'];
        } else {
            $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menghapus kategori: ' . mysqli_error($conn)];
        }
    }
    header("Location: kategori.php");
    exit();
}

// Filter dan pencarian
$filter_nama = isset($_GET['filter_nama']) ? mysqli_real_escape_string($conn, $_GET['filter_nama']) : '';

// Query untuk mendapatkan data kategori
$query_kategori = "SELECT k.*, 
                  (SELECT COUNT(*) FROM barang WHERE id_kategori = k.id_kategori) as jumlah_barang
                  FROM kategori k
                  WHERE 1=1";

// Tambahkan filter jika ada
if (!empty($filter_nama)) {
    $query_kategori .= " AND k.nama_kategori LIKE '%$filter_nama%'";
}

$query_kategori .= " ORDER BY k.nama_kategori ASC";
$result_kategori = mysqli_query($conn, $query_kategori);
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Manajemen Kategori</h1>
        <div class="d-none d-sm-inline-block">
            <button class="btn btn-primary-custom" data-bs-toggle="modal" data-bs-target="#tambahKategoriModal">
                <i class="fas fa-plus-circle fa-sm"></i> Tambah Kategori
            </button>
        </div>
    </div>
    
    <!-- Notifikasi -->
    <?php if (isset($_SESSION['pesan'])) : ?>
        <div class="alert alert-<?= $_SESSION['pesan']['tipe'] ?> alert-dismissible fade show" role="alert">
            <?= $_SESSION['pesan']['isi'] ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php unset($_SESSION['pesan']); ?>
    <?php endif; ?>
    
    <!-- Filter dan Pencarian -->
    <div class="card mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary-custom">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="get" action="">
                <div class="row">
                    <div class="col-md-8 mb-3">
                        <label for="filter_nama" class="form-label">Nama Kategori</label>
                        <input type="text" class="form-control" id="filter_nama" name="filter_nama" 
                               value="<?= htmlspecialchars($filter_nama) ?>" placeholder="Cari nama kategori...">
                    </div>
                    <div class="col-md-4 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary-custom me-2">
                            <i class="fas fa-filter fa-sm"></i> Filter
                        </button>
                        <a href="kategori.php" class="btn btn-secondary">
                            <i class="fas fa-sync-alt fa-sm"></i> Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Tabel Data Kategori -->
    <div class="card animate-fade-in" style="animation-delay: 0.2s;">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary-custom">Daftar Kategori</h6>
            <div>
                <button class="btn btn-sm btn-success me-2" data-bs-toggle="modal" data-bs-target="#exportModal">
                    <i class="fas fa-file-export fa-sm"></i> Export
                </button>
                <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#importModal">
                    <i class="fas fa-file-import fa-sm"></i> Import
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead class="bg-primary-custom text-white">
                        <tr>
                            <th width="5%">No</th>
                            <th>Nama Kategori</th>
                            <th width="15%">Jumlah Barang</th>
                            <th width="30%">Deskripsi</th>
                            <th width="15%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (mysqli_num_rows($result_kategori) > 0) : ?>
                            <?php $no = 1; ?>
                            <?php while ($kategori = mysqli_fetch_assoc($result_kategori)) : ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= htmlspecialchars($kategori['nama_kategori']) ?></td>
                                    <td class="text-center"><?= $kategori['jumlah_barang'] ?></td>
                                    <td><?= potong_teks(htmlspecialchars($kategori['deskripsi'])) ?></td>
                                    <td class="text-center">
                                        <button class="btn btn-sm btn-warning btn-edit" data-bs-toggle="modal" data-bs-target="#editKategoriModal" 
                                                data-id="<?= $kategori['id_kategori'] ?>" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <a href="kategori.php?hapus=<?= $kategori['id_kategori'] ?>" class="btn btn-sm btn-danger" 
                                           onclick="return confirm('Yakin ingin menghapus kategori ini?')" title="Hapus">
                                            <i class="fas fa-trash-alt"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="5" class="text-center">Tidak ada data kategori</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Tambah Kategori -->
<div class="modal fade" id="tambahKategoriModal" tabindex="-1" aria-labelledby="tambahKategoriModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title" id="tambahKategoriModalLabel">Tambah Kategori Baru</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="nama_kategori" class="form-label">Nama Kategori</label>
                        <input type="text" class="form-control" id="nama_kategori" name="nama_kategori" required>
                    </div>
                    <div class="mb-3">
                        <label for="deskripsi" class="form-label">Deskripsi</label>
                        <textarea class="form-control" id="deskripsi" name="deskripsi" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary-custom" name="tambah_kategori">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Edit Kategori -->
<div class="modal fade" id="editKategoriModal" tabindex="-1" aria-labelledby="editKategoriModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title" id="editKategoriModalLabel">Edit Kategori</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="">
                <input type="hidden" id="edit_id_kategori" name="id_kategori">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_nama_kategori" class="form-label">Nama Kategori</label>
                        <input type="text" class="form-control" id="edit_nama_kategori" name="nama_kategori" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_deskripsi" class="form-label">Deskripsi</label>
                        <textarea class="form-control" id="edit_deskripsi" name="deskripsi" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary-custom" name="edit_kategori">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Export Data -->
<div class="modal fade" id="exportModal" tabindex="-1" aria-labelledby="exportModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title" id="exportModalLabel">Export Data Kategori</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="export_kategori.php">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="export_format" class="form-label">Format Export</label>
                        <select class="form-select" id="export_format" name="export_format" required>
                            <option value="excel">Excel (.xlsx)</option>
                            <option value="pdf">PDF (.pdf)</option>
                            <option value="csv">CSV (.csv)</option>
                        </select>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="export_filter" name="export_filter" checked>
                        <label class="form-check-label" for="export_filter">
                            Gunakan filter yang aktif
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">Export Data</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Import Data -->
<div class="modal fade" id="importModal" tabindex="-1" aria-labelledby="importModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title" id="importModalLabel">Import Data Kategori</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="import_kategori.php" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="import_file" class="form-label">File Excel</label>
                        <input type="file" class="form-control" id="import_file" name="import_file" accept=".xlsx, .xls" required>
                        <small class="text-muted">Download template <a href="template_import_kategori.xlsx">disini</a></small>
                    </div>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Pastikan format file sesuai dengan template untuk menghindari kesalahan import.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-info text-white">Import Data</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    // Script untuk edit modal
    document.querySelectorAll('.btn-edit').forEach(function(button) {
        button.addEventListener('click', function() {
            var id_kategori = this.getAttribute('data-id');
            
            // AJAX untuk mendapatkan data kategori
            var xhr = new XMLHttpRequest();
            xhr.open('GET', 'get_kategori.php?id=' + id_kategori, true);
            xhr.onload = function() {
                if (this.status == 200) {
                    var data = JSON.parse(this.responseText);
                    
                    document.getElementById('edit_id_kategori').value = data.id_kategori;
                    document.getElementById('edit_nama_kategori').value = data.nama_kategori;
                    document.getElementById('edit_deskripsi').value = data.deskripsi;
                }
            };
            xhr.send();
        });
    });
</script>

<?php include 'footer.php'; ?>