<?php
// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
require_once 'config.php';

// Fungsi untuk format mata uang
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Tanggal default untuk filter
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : date('Y-m-01');
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : date('Y-m-d');
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Laporan Keuangan</h1>
        <div class="d-none d-sm-inline-block">
            <span class="text-muted">Periode: <?php echo date('d M Y', strtotime($start_date)); ?> - <?php echo date('d M Y', strtotime($end_date)); ?></span>
        </div>
    </div>

    <!-- Filter Laporan -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 bg-primary-custom">
            <h6 class="m-0 font-weight-bold text-white">Filter Laporan</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="">
                <div class="row">
                    <div class="col-md-5">
                        <div class="form-group">
                            <label for="start_date">Tanggal Mulai</label>
                            <input type="date" class="form-control" id="start_date" name="start_date" 
                                   value="<?php echo $start_date; ?>" required>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <label for="end_date">Tanggal Akhir</label>
                            <input type="date" class="form-control" id="end_date" name="end_date" 
                                   value="<?php echo $end_date; ?>" required>
                        </div>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary-custom btn-block">
                            <i class="fas fa-filter"></i> Filter
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Ringkasan Keuangan -->
    <div class="row">
        <!-- Total Penjualan -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Total Penjualan</div>
                            <?php
                            $query_penjualan = "SELECT COALESCE(SUM(grand_total), 0) as total 
                                               FROM penjualan 
                                               WHERE DATE(tanggal_penjualan) BETWEEN '$start_date' AND '$end_date'
                                               AND status_pembayaran != 'dibatalkan'";
                            $result_penjualan = mysqli_query($conn, $query_penjualan);
                            $total_penjualan = mysqli_fetch_assoc($result_penjualan)['total'];
                            ?>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo format_rupiah($total_penjualan); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-shopping-cart fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Pembelian -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Pembelian</div>
                            <?php
                            $query_pembelian = "SELECT COALESCE(SUM(grand_total), 0) as total 
                                              FROM pembelian 
                                              WHERE DATE(tanggal_pembelian) BETWEEN '$start_date' AND '$end_date'";
                            $result_pembelian = mysqli_query($conn, $query_pembelian);
                            $total_pembelian = mysqli_fetch_assoc($result_pembelian)['total'];
                            ?>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo format_rupiah($total_pembelian); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-truck fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Piutang -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Piutang</div>
                            <?php
                            $query_piutang = "SELECT COALESCE(SUM(jumlah_hutang - jumlah_bayar), 0) as total 
                                            FROM hutang_pelanggan 
                                            WHERE status = 'belum_lunas'";
                            $result_piutang = mysqli_query($conn, $query_piutang);
                            $total_piutang = mysqli_fetch_assoc($result_piutang)['total'];
                            ?>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo format_rupiah($total_piutang); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-hand-holding-usd fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Hutang -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Total Hutang</div>
                            <?php
                            $query_hutang = "SELECT COALESCE(SUM(jumlah_hutang - jumlah_bayar), 0) as total 
                                           FROM hutang_supplier 
                                           WHERE status = 'belum_lunas'";
                            $result_hutang = mysqli_query($conn, $query_hutang);
                            $total_hutang = mysqli_fetch_assoc($result_hutang)['total'];
                            ?>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo format_rupiah($total_hutang); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-invoice-dollar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Grafik dan Tabel -->
    <div class="row">
        <!-- Grafik Penjualan vs Pembelian -->
        <div class="col-xl-8 mb-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-primary-custom">
                    <h6 class="m-0 font-weight-bold text-white">Grafik Penjualan vs Pembelian</h6>
                </div>
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="myAreaChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Ringkasan Laba Rugi -->
        <div class="col-xl-4 mb-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-primary-custom">
                    <h6 class="m-0 font-weight-bold text-white">Laba Rugi</h6>
                </div>
                <div class="card-body">
                    <?php
                    // Hitung laba kotor
                    $query_laba = "SELECT COALESCE(SUM(dp.subtotal - (dp.jumlah * b.harga_beli)), 0) as laba 
                                 FROM detail_penjualan dp
                                 JOIN barang b ON dp.id_barang = b.id_barang
                                 JOIN penjualan p ON dp.id_penjualan = p.id_penjualan
                                 WHERE DATE(p.tanggal_penjualan) BETWEEN '$start_date' AND '$end_date'
                                 AND p.status_pembayaran != 'dibatalkan'";
                    $result_laba = mysqli_query($conn, $query_laba);
                    $laba_kotor = mysqli_fetch_assoc($result_laba)['laba'];
                    
                    // Hitung biaya operasional (contoh sederhana)
                    $query_biaya = "SELECT COALESCE(SUM(jumlah), 0) as total 
                                   FROM biaya_operasional 
                                   WHERE DATE(tanggal) BETWEEN '$start_date' AND '$end_date'";
                    $result_biaya = mysqli_query($conn, $query_biaya);
                    $biaya_operasional = mysqli_fetch_assoc($result_biaya)['total'];
                    
                    $laba_bersih = $laba_kotor - $biaya_operasional;
                    ?>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <td>Pendapatan Penjualan</td>
                                    <td class="text-right"><?php echo format_rupiah($total_penjualan); ?></td>
                                </tr>
                                <tr>
                                    <td>Harga Pokok Penjualan</td>
                                    <td class="text-right"><?php echo format_rupiah($total_pembelian); ?></td>
                                </tr>
                                <tr class="font-weight-bold">
                                    <td>Laba Kotor</td>
                                    <td class="text-right"><?php echo format_rupiah($laba_kotor); ?></td>
                                </tr>
                                <tr>
                                    <td>Biaya Operasional</td>
                                    <td class="text-right"><?php echo format_rupiah($biaya_operasional); ?></td>
                                </tr>
                                <tr class="font-weight-bold <?php echo ($laba_bersih >= 0) ? 'text-success' : 'text-danger'; ?>">
                                    <td>Laba Bersih</td>
                                    <td class="text-right"><?php echo format_rupiah($laba_bersih); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabel Transaksi Penjualan -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-primary-custom">
            <h6 class="m-0 font-weight-bold text-white">Transaksi Penjualan</h6>
        </div>
        <div class="card-body">
            <?php
            $query_transaksi = "SELECT p.no_transaksi, p.tanggal_penjualan, pl.nama_pelanggan, 
                              p.grand_total, p.status_pembayaran
                              FROM penjualan p
                              LEFT JOIN pelanggan pl ON p.id_pelanggan = pl.id_pelanggan
                              WHERE DATE(p.tanggal_penjualan) BETWEEN '$start_date' AND '$end_date'
                              AND p.status_pembayaran != 'dibatalkan'
                              ORDER BY p.tanggal_penjualan DESC";
            $result_transaksi = mysqli_query($conn, $query_transaksi);
            ?>
            
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTablePenjualan" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>No. Transaksi</th>
                            <th>Tanggal</th>
                            <th>Pelanggan</th>
                            <th>Total</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1;
                        while ($row = mysqli_fetch_assoc($result_transaksi)): 
                        ?>
                            <tr>
                                <td><?php echo $no++; ?></td>
                                <td><?php echo htmlspecialchars($row['no_transaksi']); ?></td>
                                <td><?php echo date('d M Y', strtotime($row['tanggal_penjualan'])); ?></td>
                                <td><?php echo htmlspecialchars($row['nama_pelanggan'] ?: '-'); ?></td>
                                <td class="text-right"><?php echo format_rupiah($row['grand_total']); ?></td>
                                <td>
                                    <span class="badge badge-<?php echo ($row['status_pembayaran'] == 'lunas') ? 'success' : 'warning'; ?>">
                                        <?php echo ucfirst($row['status_pembayaran']); ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Tabel Transaksi Pembelian -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-primary-custom">
            <h6 class="m-0 font-weight-bold text-white">Transaksi Pembelian</h6>
        </div>
        <div class="card-body">
            <?php
            $query_pembelian = "SELECT pb.no_faktur, pb.tanggal_pembelian, s.nama_supplier, 
                              pb.grand_total, pb.status_pembayaran
                              FROM pembelian pb
                              JOIN supplier s ON pb.id_supplier = s.id_supplier
                              WHERE DATE(pb.tanggal_pembelian) BETWEEN '$start_date' AND '$end_date'
                              ORDER BY pb.tanggal_pembelian DESC";
            $result_pembelian = mysqli_query($conn, $query_pembelian);
            ?>
            
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTablePembelian" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>No. Faktur</th>
                            <th>Tanggal</th>
                            <th>Supplier</th>
                            <th>Total</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1;
                        while ($row = mysqli_fetch_assoc($result_pembelian)): 
                        ?>
                            <tr>
                                <td><?php echo $no++; ?></td>
                                <td><?php echo htmlspecialchars($row['no_faktur']); ?></td>
                                <td><?php echo date('d M Y', strtotime($row['tanggal_pembelian'])); ?></td>
                                <td><?php echo htmlspecialchars($row['nama_supplier']); ?></td>
                                <td class="text-right"><?php echo format_rupiah($row['grand_total']); ?></td>
                                <td>
                                    <span class="badge badge-<?php echo ($row['status_pembayaran'] == 'lunas') ? 'success' : 'warning'; ?>">
                                        <?php echo ucfirst($row['status_pembayaran']); ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Include Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    // Area Chart Example
    var ctx = document.getElementById("myAreaChart");
    
    // Ambil data untuk chart (contoh sederhana)
    var labels = [];
    var penjualanData = [];
    var pembelianData = [];
    
    <?php
    // Query untuk data chart
    $query_chart = "SELECT DATE(tanggal) as tanggal, 
                   COALESCE(SUM(CASE WHEN jenis = 'penjualan' THEN jumlah ELSE 0 END), 0) as penjualan,
                   COALESCE(SUM(CASE WHEN jenis = 'pembelian' THEN jumlah ELSE 0 END), 0) as pembelian
                   FROM (
                       SELECT tanggal_penjualan as tanggal, grand_total as jumlah, 'penjualan' as jenis
                       FROM penjualan
                       WHERE DATE(tanggal_penjualan) BETWEEN '$start_date' AND '$end_date'
                       AND status_pembayaran != 'dibatalkan'
                       
                       UNION ALL
                       
                       SELECT tanggal_pembelian as tanggal, grand_total as jumlah, 'pembelian' as jenis
                       FROM pembelian
                       WHERE DATE(tanggal_pembelian) BETWEEN '$start_date' AND '$end_date'
                   ) as combined
                   GROUP BY DATE(tanggal)
                   ORDER BY tanggal";
    
    $result_chart = mysqli_query($conn, $query_chart);
    while ($row = mysqli_fetch_assoc($result_chart)) {
        echo "labels.push('" . date('d M', strtotime($row['tanggal'])) . "');";
        echo "penjualanData.push(" . $row['penjualan'] . ");";
        echo "pembelianData.push(" . $row['pembelian'] . ");";
    }
    ?>
    
    var myLineChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: labels,
            datasets: [{
                label: "Penjualan",
                lineTension: 0.3,
                backgroundColor: "rgba(78, 115, 223, 0.05)",
                borderColor: "rgba(78, 115, 223, 1)",
                pointRadius: 3,
                pointBackgroundColor: "rgba(78, 115, 223, 1)",
                pointBorderColor: "rgba(78, 115, 223, 1)",
                pointHoverRadius: 3,
                pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                pointHitRadius: 10,
                pointBorderWidth: 2,
                data: penjualanData,
            }, {
                label: "Pembelian",
                lineTension: 0.3,
                backgroundColor: "rgba(28, 200, 138, 0.05)",
                borderColor: "rgba(28, 200, 138, 1)",
                pointRadius: 3,
                pointBackgroundColor: "rgba(28, 200, 138, 1)",
                pointBorderColor: "rgba(28, 200, 138, 1)",
                pointHoverRadius: 3,
                pointHoverBackgroundColor: "rgba(28, 200, 138, 1)",
                pointHoverBorderColor: "rgba(28, 200, 138, 1)",
                pointHitRadius: 10,
                pointBorderWidth: 2,
                data: pembelianData,
            }],
        },
        options: {
            maintainAspectRatio: false,
            layout: {
                padding: {
                    left: 10,
                    right: 25,
                    top: 25,
                    bottom: 0
                }
            },
            scales: {
                x: {
                    grid: {
                        display: false,
                        drawBorder: false
                    },
                    ticks: {
                        maxTicksLimit: 7
                    }
                },
                y: {
                    ticks: {
                        maxTicksLimit: 5,
                        padding: 10,
                        callback: function(value, index, values) {
                            return 'Rp ' + value.toLocaleString();
                        }
                    },
                    grid: {
                        color: "rgb(234, 236, 244)",
                        zeroLineColor: "rgb(234, 236, 244)",
                        drawBorder: false,
                        borderDash: [2],
                        zeroLineBorderDash: [2]
                    }
                },
            },
            plugins: {
                legend: {
                    display: true,
                    position: 'top',
                },
                tooltip: {
                    backgroundColor: "rgb(255,255,255)",
                    bodyColor: "#858796",
                    titleMarginBottom: 10,
                    titleColor: '#6e707e',
                    titleFontSize: 14,
                    borderColor: '#dddfeb',
                    borderWidth: 1,
                    xPadding: 15,
                    yPadding: 15,
                    displayColors: false,
                    intersect: false,
                    mode: 'index',
                    caretPadding: 10,
                    callbacks: {
                        label: function(context) {
                            var label = context.dataset.label || '';
                            if (label) {
                                label += ': ';
                            }
                            label += 'Rp ' + context.raw.toLocaleString();
                            return label;
                        }
                    }
                }
            }
        }
    });

    // Inisialisasi DataTables
    $(document).ready(function() {
        $('#dataTablePenjualan').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.11.5/i18n/Indonesian.json"
            },
            "order": [[2, "desc"]]
        });
        
        $('#dataTablePembelian').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.11.5/i18n/Indonesian.json"
            },
            "order": [[2, "desc"]]
        });
    });
</script>

<?php include 'footer.php'; ?>