<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
require_once 'config.php'; // Pastikan file config.php berisi koneksi database

// Check if database connection is established
if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Fungsi untuk format mata uang
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka ?? 0, 0, ',', '.');
}

// Inisialisasi variabel filter
$filter_tanggal_mulai = isset($_GET['tanggal_mulai']) ? $_GET['tanggal_mulai'] : date('Y-m-01');
$filter_tanggal_selesai = isset($_GET['tanggal_selesai']) ? $_GET['tanggal_selesai'] : date('Y-m-d');
$filter_id_toko = isset($_GET['id_toko']) ? $_GET['id_toko'] : '';
$filter_id_pelanggan = isset($_GET['id_pelanggan']) ? $_GET['id_pelanggan'] : '';
$filter_status = isset($_GET['status']) ? $_GET['status'] : '';

// Query untuk mendapatkan data toko
$query_toko = "SELECT * FROM toko WHERE status_aktif = 1";
$result_toko = mysqli_query($conn, $query_toko);

// Query untuk mendapatkan data pelanggan
$query_pelanggan = "SELECT * FROM pelanggan";
$result_pelanggan = mysqli_query($conn, $query_pelanggan);

// Query untuk mendapatkan data penjualan dengan filter
$query_penjualan = "SELECT 
                    p.id_penjualan, 
                    p.no_transaksi, 
                    p.tanggal_penjualan, 
                    t.nama_toko, 
                    pl.nama_pelanggan, 
                    u.nama_lengkap as kasir,
                    mp.nama_metode,
                    p.total_penjualan,
                    p.diskon,
                    p.ppn,
                    p.grand_total,
                    p.jumlah_bayar,
                    p.kembalian,
                    p.status_pembayaran,
                    p.sisa_hutang
                FROM penjualan p
                LEFT JOIN toko t ON p.id_toko = t.id_toko
                LEFT JOIN pelanggan pl ON p.id_pelanggan = pl.id_pelanggan
                LEFT JOIN pengguna u ON p.id_pengguna = u.id_pengguna
                LEFT JOIN metode_pembayaran mp ON p.id_metode = mp.id_metode
                WHERE DATE(p.tanggal_penjualan) BETWEEN '$filter_tanggal_mulai' AND '$filter_tanggal_selesai'";

// Tambahkan filter tambahan jika ada
if (!empty($filter_id_toko)) {
    $query_penjualan .= " AND p.id_toko = '$filter_id_toko'";
}

if (!empty($filter_id_pelanggan)) {
    $query_penjualan .= " AND p.id_pelanggan = '$filter_id_pelanggan'";
}

if (!empty($filter_status)) {
    $query_penjualan .= " AND p.status_pembayaran = '$filter_status'";
}

$query_penjualan .= " ORDER BY p.tanggal_penjualan DESC";

$result_penjualan = mysqli_query($conn, $query_penjualan);

// Hitung total penjualan
$query_total = "SELECT 
                COUNT(*) as jumlah_transaksi,
                SUM(total_penjualan) as total_penjualan,
                SUM(diskon) as total_diskon,
                SUM(ppn) as total_ppn,
                SUM(grand_total) as grand_total,
                SUM(jumlah_bayar) as total_bayar,
                SUM(kembalian) as total_kembalian,
                SUM(sisa_hutang) as total_hutang
            FROM penjualan
            WHERE DATE(tanggal_penjualan) BETWEEN '$filter_tanggal_mulai' AND '$filter_tanggal_selesai'";

// Tambahkan filter tambahan jika ada
if (!empty($filter_id_toko)) {
    $query_total .= " AND id_toko = '$filter_id_toko'";
}

if (!empty($filter_id_pelanggan)) {
    $query_total .= " AND id_pelanggan = '$filter_id_pelanggan'";
}

if (!empty($filter_status)) {
    $query_total .= " AND status_pembayaran = '$filter_status'";
}

$result_total = mysqli_query($conn, $query_total);
$total = mysqli_fetch_assoc($result_total);

// Export ke Excel
if (isset($_GET['export']) && $_GET['export'] == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=Laporan_Penjualan_".date('Ymd').".xls");
    
    echo '<table border="1">';
    echo '<tr>';
    echo '<th colspan="12" style="text-align:center;">Laporan Penjualan</th>';
    echo '</tr>';
    echo '<tr>';
    echo '<th colspan="12" style="text-align:left;">Periode: '.date('d/m/Y', strtotime($filter_tanggal_mulai)).' - '.date('d/m/Y', strtotime($filter_tanggal_selesai)).'</th>';
    echo '</tr>';
    echo '<tr>';
    echo '<th>No</th>';
    echo '<th>No. Transaksi</th>';
    echo '<th>Tanggal</th>';
    echo '<th>Toko</th>';
    echo '<th>Pelanggan</th>';
    echo '<th>Kasir</th>';
    echo '<th>Metode Bayar</th>';
    echo '<th>Total</th>';
    echo '<th>Diskon</th>';
    echo '<th>PPN</th>';
    echo '<th>Grand Total</th>';
    echo '<th>Status</th>';
    echo '</tr>';
    
    $no = 1;
    while ($row = mysqli_fetch_assoc($result_penjualan)) {
        echo '<tr>';
        echo '<td>'.$no++.'</td>';
        echo '<td>'.$row['no_transaksi'].'</td>';
        echo '<td>'.date('d/m/Y H:i', strtotime($row['tanggal_penjualan'])).'</td>';
        echo '<td>'.$row['nama_toko'].'</td>';
        echo '<td>'.$row['nama_pelanggan'].'</td>';
        echo '<td>'.$row['kasir'].'</td>';
        echo '<td>'.$row['nama_metode'].'</td>';
        echo '<td>'.number_format($row['total_penjualan'], 0, ',', '.').'</td>';
        echo '<td>'.number_format($row['diskon'], 0, ',', '.').'</td>';
        echo '<td>'.number_format($row['ppn'], 0, ',', '.').'</td>';
        echo '<td>'.number_format($row['grand_total'], 0, ',', '.').'</td>';
        echo '<td>';
        if ($row['status_pembayaran'] == 'lunas') {
            echo 'Lunas';
        } elseif ($row['status_pembayaran'] == 'hutang') {
            echo 'Hutang';
        } else {
            echo 'Sebagian';
        }
        echo '</td>';
        echo '</tr>';
    }
    
    echo '<tr>';
    echo '<td colspan="7" style="text-align:right;font-weight:bold;">TOTAL</td>';
    echo '<td style="font-weight:bold;">'.number_format($total['total_penjualan'], 0, ',', '.').'</td>';
    echo '<td style="font-weight:bold;">'.number_format($total['total_diskon'], 0, ',', '.').'</td>';
    echo '<td style="font-weight:bold;">'.number_format($total['total_ppn'], 0, ',', '.').'</td>';
    echo '<td style="font-weight:bold;">'.number_format($total['grand_total'], 0, ',', '.').'</td>';
    echo '<td></td>';
    echo '</tr>';
    
    echo '</table>';
    exit();
}

// Export ke PDF
if (isset($_GET['export']) && $_GET['export'] == 'pdf') {
    require_once 'vendor/autoload.php'; // Pastikan library TCPDF sudah diinstall
    
    // Buat instance TCPDF
    $pdf = new TCPDF('L', 'mm', 'A4', true, 'UTF-8', false);
    
    // Set dokumen
    $pdf->SetCreator('Toko Kuliner');
    $pdf->SetAuthor('Toko Kuliner');
    $pdf->SetTitle('Laporan Penjualan');
    $pdf->SetSubject('Laporan Penjualan');
    
    // Tambahkan halaman
    $pdf->AddPage();
    
    // Header laporan
    $pdf->SetFont('helvetica', 'B', 16);
    $pdf->Cell(0, 15, 'LAPORAN PENJUALAN', 0, 1, 'C');
    $pdf->SetFont('helvetica', '', 10);
    $pdf->Cell(0, 10, 'Periode: '.date('d/m/Y', strtotime($filter_tanggal_mulai)).' - '.date('d/m/Y', strtotime($filter_tanggal_selesai)), 0, 1, 'C');
    
    // Tabel data
    $pdf->SetFont('helvetica', '', 8);
    
    // Header tabel
    $header = array('No', 'No. Transaksi', 'Tanggal', 'Toko', 'Pelanggan', 'Kasir', 'Metode Bayar', 'Total', 'Diskon', 'PPN', 'Grand Total', 'Status');
    $w = array(8, 25, 25, 25, 25, 25, 25, 20, 15, 15, 20, 15);
    
    for($i = 0; $i < count($header); $i++) {
        $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C');
    }
    $pdf->Ln();
    
    // Data penjualan
    $no = 1;
    $result_penjualan_pdf = mysqli_query($conn, $query_penjualan);
    while($row = mysqli_fetch_assoc($result_penjualan_pdf)) {
        $pdf->Cell($w[0], 6, $no++, 'LR', 0, 'C');
        $pdf->Cell($w[1], 6, $row['no_transaksi'], 'LR', 0, 'L');
        $pdf->Cell($w[2], 6, date('d/m/Y H:i', strtotime($row['tanggal_penjualan'])), 'LR', 0, 'L');
        $pdf->Cell($w[3], 6, $row['nama_toko'], 'LR', 0, 'L');
        $pdf->Cell($w[4], 6, $row['nama_pelanggan'], 'LR', 0, 'L');
        $pdf->Cell($w[5], 6, $row['kasir'], 'LR', 0, 'L');
        $pdf->Cell($w[6], 6, $row['nama_metode'], 'LR', 0, 'L');
        $pdf->Cell($w[7], 6, number_format($row['total_penjualan'], 0, ',', '.'), 'LR', 0, 'R');
        $pdf->Cell($w[8], 6, number_format($row['diskon'], 0, ',', '.'), 'LR', 0, 'R');
        $pdf->Cell($w[9], 6, number_format($row['ppn'], 0, ',', '.'), 'LR', 0, 'R');
        $pdf->Cell($w[10], 6, number_format($row['grand_total'], 0, ',', '.'), 'LR', 0, 'R');
        
        $status = '';
        if ($row['status_pembayaran'] == 'lunas') {
            $status = 'Lunas';
        } elseif ($row['status_pembayaran'] == 'hutang') {
            $status = 'Hutang';
        } else {
            $status = 'Sebagian';
        }
        $pdf->Cell($w[11], 6, $status, 'LR', 0, 'C');
        $pdf->Ln();
    }
    
    // Footer tabel
    $pdf->Cell(array_sum($w), 0, '', 'T');
    $pdf->Ln();
    
    // Total
    $pdf->SetFont('helvetica', 'B', 8);
    $pdf->Cell(159, 6, 'TOTAL', 1, 0, 'R');
    $pdf->Cell(20, 6, number_format($total['total_penjualan'], 0, ',', '.'), 1, 0, 'R');
    $pdf->Cell(15, 6, number_format($total['total_diskon'], 0, ',', '.'), 1, 0, 'R');
    $pdf->Cell(15, 6, number_format($total['total_ppn'], 0, ',', '.'), 1, 0, 'R');
    $pdf->Cell(20, 6, number_format($total['grand_total'], 0, ',', '.'), 1, 0, 'R');
    $pdf->Cell(15, 6, '', 1, 0, 'C');
    
    // Output PDF
    $pdf->Output('Laporan_Penjualan_'.date('Ymd').'.pdf', 'D');
    exit();
}
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Laporan Penjualan</h1>
        <div class="d-none d-sm-inline-block">
            <div class="btn-group" role="group">
                <a href="?export=excel&<?php echo http_build_query($_GET); ?>" class="btn btn-success btn-sm">
                    <i class="fas fa-file-excel fa-sm"></i> Export Excel
                </a>
                <a href="?export=pdf&<?php echo http_build_query($_GET); ?>" class="btn btn-danger btn-sm">
                    <i class="fas fa-file-pdf fa-sm"></i> Export PDF
                </a>
            </div>
        </div>
    </div>
    
    <!-- Filter Form -->
    <div class="card mb-4 animate-fade-in">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary-custom">Filter Laporan</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="tanggal_mulai">Tanggal Mulai</label>
                            <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" 
                                   value="<?php echo $filter_tanggal_mulai; ?>" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="tanggal_selesai">Tanggal Selesai</label>
                            <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" 
                                   value="<?php echo $filter_tanggal_selesai; ?>" required>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="id_toko">Toko</label>
                            <select class="form-control" id="id_toko" name="id_toko">
                                <option value="">Semua Toko</option>
                                <?php while ($toko = mysqli_fetch_assoc($result_toko)): ?>
                                <option value="<?php echo $toko['id_toko']; ?>" <?php echo ($filter_id_toko == $toko['id_toko']) ? 'selected' : ''; ?>>
                                    <?php echo $toko['nama_toko']; ?>
                                </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="id_pelanggan">Pelanggan</label>
                            <select class="form-control" id="id_pelanggan" name="id_pelanggan">
                                <option value="">Semua Pelanggan</option>
                                <?php while ($pelanggan = mysqli_fetch_assoc($result_pelanggan)): ?>
                                <option value="<?php echo $pelanggan['id_pelanggan']; ?>" <?php echo ($filter_id_pelanggan == $pelanggan['id_pelanggan']) ? 'selected' : ''; ?>>
                                    <?php echo $pelanggan['nama_pelanggan']; ?>
                                </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="status">Status Pembayaran</label>
                            <select class="form-control" id="status" name="status">
                                <option value="">Semua Status</option>
                                <option value="lunas" <?php echo ($filter_status == 'lunas') ? 'selected' : ''; ?>>Lunas</option>
                                <option value="hutang" <?php echo ($filter_status == 'hutang') ? 'selected' : ''; ?>>Hutang</option>
                                <option value="sebagian" <?php echo ($filter_status == 'sebagian') ? 'selected' : ''; ?>>Sebagian</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 text-right">
                        <button type="submit" class="btn btn-primary-custom">
                            <i class="fas fa-filter"></i> Filter
                        </button>
                        <a href="laporan_penjualan.php" class="btn btn-secondary">
                            <i class="fas fa-sync-alt"></i> Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Summary Cards -->
    <div class="row mb-4">
        <!-- Total Transaksi -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Transaksi</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total['jumlah_transaksi']; ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-shopping-cart fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Total Penjualan -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Total Penjualan</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo format_rupiah($total['total_penjualan']); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Total Diskon -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Diskon</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo format_rupiah($total['total_diskon']); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-percent fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Grand Total -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Grand Total</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo format_rupiah($total['grand_total']); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calculator fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Data Penjualan -->
    <div class="card animate-fade-in">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary-custom">
                Data Penjualan (<?php echo date('d M Y', strtotime($filter_tanggal_mulai)); ?> - <?php echo date('d M Y', strtotime($filter_tanggal_selesai)); ?>)
            </h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover" id="dataTable" width="100%" cellspacing="0">
                    <thead class="thead-light">
                        <tr>
                            <th>No</th>
                            <th>No. Transaksi</th>
                            <th>Tanggal</th>
                            <th>Toko</th>
                            <th>Pelanggan</th>
                            <th>Kasir</th>
                            <th>Metode Bayar</th>
                            <th>Total</th>
                            <th>Diskon</th>
                            <th>PPN</th>
                            <th>Grand Total</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1;
                        $result_penjualan = mysqli_query($conn, $query_penjualan);
                        while ($penjualan = mysqli_fetch_assoc($result_penjualan)): 
                        ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td><?php echo $penjualan['no_transaksi']; ?></td>
                            <td><?php echo date('d M Y H:i', strtotime($penjualan['tanggal_penjualan'])); ?></td>
                            <td><?php echo $penjualan['nama_toko']; ?></td>
                            <td><?php echo $penjualan['nama_pelanggan']; ?></td>
                            <td><?php echo $penjualan['kasir']; ?></td>
                            <td><?php echo $penjualan['nama_metode']; ?></td>
                            <td class="text-right"><?php echo format_rupiah($penjualan['total_penjualan']); ?></td>
                            <td class="text-right"><?php echo format_rupiah($penjualan['diskon']); ?></td>
                            <td class="text-right"><?php echo format_rupiah($penjualan['ppn']); ?></td>
                            <td class="text-right"><?php echo format_rupiah($penjualan['grand_total']); ?></td>
                            <td>
                                <?php if ($penjualan['status_pembayaran'] == 'lunas'): ?>
                                    <span class="badge badge-success">Lunas</span>
                                <?php elseif ($penjualan['status_pembayaran'] == 'hutang'): ?>
                                    <span class="badge badge-danger">Hutang</span>
                                <?php else: ?>
                                    <span class="badge badge-warning">Sebagian</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="detail_penjualan.php?id=<?php echo $penjualan['id_penjualan']; ?>" class="btn btn-sm btn-info" title="Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="cetak_struk.php?id=<?php echo $penjualan['id_penjualan']; ?>" class="btn btn-sm btn-secondary" title="Cetak Struk" target="_blank">
                                    <i class="fas fa-print"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="7" class="text-right">TOTAL</th>
                            <th class="text-right"><?php echo format_rupiah($total['total_penjualan']); ?></th>
                            <th class="text-right"><?php echo format_rupiah($total['total_diskon']); ?></th>
                            <th class="text-right"><?php echo format_rupiah($total['total_ppn']); ?></th>
                            <th class="text-right"><?php echo format_rupiah($total['grand_total']); ?></th>
                            <th colspan="2"></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Detail Penjualan -->
<div class="modal fade" id="detailPenjualanModal" tabindex="-1" role="dialog" aria-labelledby="detailPenjualanModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="detailPenjualanModalLabel">Detail Penjualan</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="detailPenjualanContent">
                <!-- Konten akan diisi via AJAX -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<!-- Script untuk DataTables -->
<script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            "language": {
                "lengthMenu": "Tampilkan _MENU_ data per halaman",
                "zeroRecords": "Tidak ada data yang ditemukan",
                "info": "Menampilkan halaman _PAGE_ dari _PAGES_",
                "infoEmpty": "Tidak ada data tersedia",
                "infoFiltered": "(difilter dari _MAX_ total data)",
                "search": "Cari:",
                "paginate": {
                    "first": "Pertama",
                    "last": "Terakhir",
                    "next": "Selanjutnya",
                    "previous": "Sebelumnya"
                }
            },
            "order": [[2, "desc"]],
            "dom": '<"top"lf>rt<"bottom"ip><"clear">',
            "buttons": [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
    });
    
    // Fungsi untuk menampilkan detail penjualan
    function showDetail(id) {
        $.ajax({
            url: 'get_detail_penjualan.php',
            type: 'GET',
            data: {id: id},
            success: function(response) {
                $('#detailPenjualanContent').html(response);
                $('#detailPenjualanModal').modal('show');
            },
            error: function(xhr, status, error) {
                alert('Terjadi kesalahan: ' + error);
            }
        });
    }
</script>