<?php
// File: login.php
require_once 'config.php';
session_start();

// Redirect jika sudah login
if (isset($_SESSION['id_pengguna'])) {
    header("Location: dashboard.php");
    exit();
}

$error = '';
$success = '';

// Proses login
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['login'])) {
    $username = clean_input($_POST['username']);
    $password = clean_input($_POST['password']);

    if (empty($username) || empty($password)) {
        $error = "Username dan password harus diisi!";
    } else {
        $stmt = $conn->prepare("SELECT * FROM pengguna WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows == 1) {
            $user = $result->fetch_assoc();

            // Verifikasi password
            if (password_verify($password, $user['password'])) {
                if ($user['is_active']) {
                    // Set session
                    $_SESSION['id_pengguna']   = $user['id_pengguna'];
                    $_SESSION['username']      = $user['username'];
                    $_SESSION['nama_lengkap']  = $user['nama_lengkap'];
                    $_SESSION['id_role']       = $user['id_role'];
                    $_SESSION['id_toko']       = $user['id_toko'];
                    $_SESSION['foto_profil']   = $user['foto_profil'];

                    // Update last login
                    $update_stmt = $conn->prepare("UPDATE pengguna SET last_login = NOW() WHERE id_pengguna = ?");
                    $update_stmt->bind_param("i", $user['id_pengguna']);
                    $update_stmt->execute();

                    // Redirect sesuai role
                    switch ($user['id_role']) {
                        case 1: // Admin
                            header("Location: dashboard.php");
                            break;
                        case 2: // Kasir
                            header("Location: dashboard.php");
                            break;
                        case 3: // Owner
                            header("Location: dashboard.php");
                            break;
                        case 4: // Manajer Toko
                            header("Location: dashboard.php");
                            break;
                        case 5: // Gudang
                            header("Location: pembelian.php");
                            break;
                        case 6: // HRD
                            header("Location: dashboard.php");
                            break;
                        case 7: // Audit
                            header("Location: dashboard.php");
                            break;
                        case 8: // Finance
                            header("Location: dashboard.php");
                            break;
                        case 9: // Supervisor
                            header("Location: dashboard.php");
                            break;
                        case 10: // Teknisi IT
                            header("Location: dashboard.php");
                            break;
                        case 11: // Super Admin
                            header("Location: dashboard.php");
                            break;
                        default:
                            header("Location: dashboard.php");
                    }
                    exit();
                } else {
                    $error = "Akun Anda tidak aktif. Silakan hubungi administrator.";
                }
            } else {
                $error = "Password salah!";
            }
        } else {
            $error = "Username tidak ditemukan!";
        }
    }
}

// Pesan sukses setelah registrasi
if (isset($_GET['register']) && $_GET['register'] == 'success') {
    $success = "Registrasi berhasil! Silakan login dengan akun Anda.";
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sistem Manajemen Toko Kuliner</title>
    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="96x96" href="favicon/favicon-96x96.png">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary: #2e7d32; /* Hijau */
            --primary-dark: #1b5e20; /* Hijau tua */
            --secondary: #d32f2f; /* Merah */
            --light: #f8f9fa;
            --dark: #212121;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            height: 100vh;
            display: flex;
            align-items: center;
            background: linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), 
                        url('assets/bg.jpg') no-repeat center center fixed;
            background-size: cover;
        }
        
        .login-container {
            max-width: 450px;
            width: 100%;
            margin: 0 auto;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }
        
        .login-header {
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            color: white;
            padding: 25px;
            text-align: center;
        }
        
        .login-header h2 {
            margin: 0;
            font-weight: 700;
            font-size: 1.8rem;
        }
        
        .login-body {
            padding: 30px;
        }
        
        .btn-login {
            background: linear-gradient(to right, var(--primary), var(--primary-dark));
            color: white;
            height: 50px;
            border-radius: 8px;
            font-weight: 600;
            border: none;
            width: 100%;
            transition: all 0.3s;
        }
        
        .btn-login:hover {
            background: linear-gradient(to right, var(--primary-dark), var(--primary));
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .alert {
            border-radius: 8px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="login-container">
            <div class="login-header">
                <h2><i class="fas fa-store"></i> SPOG STORE</h2>
                <p>Sistem Manajemen Toko</p>
            </div>
            <div class="login-body">
                <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i> <?= $error ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>               
                <?php if ($success): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i> <?= $success ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>              
                <form method="POST" action="">
                    <div class="mb-4">
                        <label for="username" class="form-label fw-bold">Username</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                            <input type="text" class="form-control" id="username" name="username" placeholder="Masukkan username" required>
                        </div>
                    </div>                 
                    <div class="mb-4">
                        <label for="password" class="form-label fw-bold">Password</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-lock"></i></span>
                            <input type="password" class="form-control" id="password" name="password" placeholder="Masukkan password" required>
                            <button class="btn btn-outline-secondary toggle-password" type="button">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                    </div>                   
                    <div class="mb-4 d-flex justify-content-between align-items-center">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="remember" name="remember">
                            <label class="form-check-label" for="remember">Ingat saya</label>
                        </div>
                        <div>
                            <a href="lupa_password.php" class="text-decoration-none">Lupa Password?</a>
                        </div>
                    </div>                    
                    <button type="submit" name="login" class="btn btn-login mb-4">
                        <i class="fas fa-sign-in-alt me-2"></i> LOGIN
                    </button>                    
                    <div class="text-center pt-3 border-top">
                        <p class="mb-0">Belum punya akun? <a href="register.php" class="fw-bold">Daftar</a></p>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Toggle password visibility
        document.querySelectorAll('.toggle-password').forEach(button => {
            button.addEventListener('click', function() {
                const passwordInput = this.parentElement.querySelector('input');
                const icon = this.querySelector('i');
                
                if (passwordInput.type === 'password') {
                    passwordInput.type = 'text';
                    icon.className = 'fas fa-eye-slash';
                } else {
                    passwordInput.type = 'password';
                    icon.className = 'fas fa-eye';
                }
            });
        });
    </script>
</body>
</html>