<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
require_once 'config.php';

// Check if database connection is established
if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Fungsi untuk format mata uang
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Cek hak akses
$bisa_tambah = false;
$bisa_edit = false;
$bisa_hapus = false;

if (isset($_SESSION['id_role'])) {
    $id_role = $_SESSION['id_role'];
    $query_hak_akses = "SELECT bisa_tambah, bisa_edit, bisa_hapus FROM hak_akses WHERE id_role = $id_role AND modul = 'mutasi'";
    $result_hak_akses = mysqli_query($conn, $query_hak_akses);
    
    if ($result_hak_akses && mysqli_num_rows($result_hak_akses) > 0) {
        $hak_akses = mysqli_fetch_assoc($result_hak_akses);
        $bisa_tambah = $hak_akses['bisa_tambah'];
        $bisa_edit = $hak_akses['bisa_edit'];
        $bisa_hapus = $hak_akses['bisa_hapus'];
    }
}

// Proses filter
$where = "WHERE 1=1";
$filter_tanggal = '';
$filter_barang = '';
$filter_toko_asal = '';
$filter_toko_tujuan = '';

if (isset($_GET['filter'])) {
    // Filter tanggal
    if (!empty($_GET['tanggal_dari']) && !empty($_GET['tanggal_sampai'])) {
        $tanggal_dari = date('Y-m-d', strtotime($_GET['tanggal_dari']));
        $tanggal_sampai = date('Y-m-d', strtotime($_GET['tanggal_sampai']));
        $where .= " AND DATE(m.tanggal_mutasi) BETWEEN '$tanggal_dari' AND '$tanggal_sampai'";
        $filter_tanggal = "Tanggal: " . date('d/m/Y', strtotime($tanggal_dari)) . " - " . date('d/m/Y', strtotime($tanggal_sampai));
    }
    
    // Filter barang
    if (!empty($_GET['id_barang'])) {
        $id_barang = (int) $_GET['id_barang'];
        $where .= " AND md.id_barang = $id_barang";
        
        $query_barang = "SELECT nama_barang FROM barang WHERE id_barang = $id_barang";
        $result_barang = mysqli_query($conn, $query_barang);
        if ($result_barang && mysqli_num_rows($result_barang) > 0) {
            $barang = mysqli_fetch_assoc($result_barang);
            $filter_barang = "Barang: " . $barang['nama_barang'];
        }
    }
    
    // Filter toko asal
    if (!empty($_GET['id_toko_asal'])) {
        $id_toko_asal = (int) $_GET['id_toko_asal'];
        $where .= " AND m.id_toko_asal = $id_toko_asal";
        
        $query_toko = "SELECT nama_toko FROM toko WHERE id_toko = $id_toko_asal";
        $result_toko = mysqli_query($conn, $query_toko);
        if ($result_toko && mysqli_num_rows($result_toko) > 0) {
            $toko = mysqli_fetch_assoc($result_toko);
            $filter_toko_asal = "Toko Asal: " . $toko['nama_toko'];
        }
    }
    
    // Filter toko tujuan
    if (!empty($_GET['id_toko_tujuan'])) {
        $id_toko_tujuan = (int) $_GET['id_toko_tujuan'];
        $where .= " AND m.id_toko_tujuan = $id_toko_tujuan";
        
        $query_toko = "SELECT nama_toko FROM toko WHERE id_toko = $id_toko_tujuan";
        $result_toko = mysqli_query($conn, $query_toko);
        if ($result_toko && mysqli_num_rows($result_toko) > 0) {
            $toko = mysqli_fetch_assoc($result_toko);
            $filter_toko_tujuan = "Toko Tujuan: " . $toko['nama_toko'];
        }
    }
}

// Query untuk mendapatkan data mutasi
$query = "SELECT m.*, 
                 ta.nama_toko as nama_toko_asal, 
                 tt.nama_toko as nama_toko_tujuan,
                 pg.nama_lengkap as nama_pembuat
          FROM mutasi m
          JOIN toko ta ON m.id_toko_asal = ta.id_toko
          JOIN toko tt ON m.id_toko_tujuan = tt.id_toko
          JOIN pengguna pg ON m.id_pengguna = pg.id_pengguna
          $where
          GROUP BY m.id_mutasi
          ORDER BY m.tanggal_mutasi DESC";
$result = mysqli_query($conn, $query);

// Query untuk dropdown barang
$query_barang = "SELECT * FROM barang WHERE is_active = 1 ORDER BY nama_barang";
$result_barang = mysqli_query($conn, $query_barang);

// Query untuk dropdown toko
$query_toko = "SELECT * FROM toko WHERE status_aktif = 1 ORDER BY nama_toko";
$result_toko = mysqli_query($conn, $query_toko);
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Mutasi Stok</h1>
        <div class="d-none d-sm-inline-block">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="#">Stok</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Mutasi</li>
                </ol>
            </nav>
        </div>
    </div>
    
    <!-- Filter dan Tombol Tambah -->
    <div class="card mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-body">
            <form method="GET" action="mutasi.php" class="row g-3">
                <div class="col-md-3">
                    <label for="tanggal_dari" class="form-label">Dari Tanggal</label>
                    <input type="date" class="form-control" id="tanggal_dari" name="tanggal_dari" value="<?php echo isset($_GET['tanggal_dari']) ? $_GET['tanggal_dari'] : ''; ?>">
                </div>
                <div class="col-md-3">
                    <label for="tanggal_sampai" class="form-label">Sampai Tanggal</label>
                    <input type="date" class="form-control" id="tanggal_sampai" name="tanggal_sampai" value="<?php echo isset($_GET['tanggal_sampai']) ? $_GET['tanggal_sampai'] : ''; ?>">
                </div>
                <div class="col-md-2">
                    <label for="id_barang" class="form-label">Barang</label>
                    <select class="form-select" id="id_barang" name="id_barang">
                        <option value="">Semua Barang</option>
                        <?php while ($barang = mysqli_fetch_assoc($result_barang)): ?>
                            <option value="<?php echo $barang['id_barang']; ?>" <?php echo (isset($_GET['id_barang']) && $_GET['id_barang'] == $barang['id_barang']) ? 'selected' : ''; ?>>
                                <?php echo $barang['nama_barang']; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="id_toko_asal" class="form-label">Toko Asal</label>
                    <select class="form-select" id="id_toko_asal" name="id_toko_asal">
                        <option value="">Semua Toko</option>
                        <?php 
                        mysqli_data_seek($result_toko, 0); // Reset pointer result toko
                        while ($toko = mysqli_fetch_assoc($result_toko)): ?>
                            <option value="<?php echo $toko['id_toko']; ?>" <?php echo (isset($_GET['id_toko_asal']) && $_GET['id_toko_asal'] == $toko['id_toko']) ? 'selected' : ''; ?>>
                                <?php echo $toko['nama_toko']; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="id_toko_tujuan" class="form-label">Toko Tujuan</label>
                    <select class="form-select" id="id_toko_tujuan" name="id_toko_tujuan">
                        <option value="">Semua Toko</option>
                        <?php 
                        mysqli_data_seek($result_toko, 0); // Reset pointer result toko
                        while ($toko = mysqli_fetch_assoc($result_toko)): ?>
                            <option value="<?php echo $toko['id_toko']; ?>" <?php echo (isset($_GET['id_toko_tujuan']) && $_GET['id_toko_tujuan'] == $toko['id_toko']) ? 'selected' : ''; ?>>
                                <?php echo $toko['nama_toko']; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="col-12">
                    <button type="submit" name="filter" class="btn btn-primary-custom me-2">
                        <i class="fas fa-filter me-1"></i> Filter
                    </button>
                    <a href="mutasi.php" class="btn btn-secondary">
                        <i class="fas fa-sync-alt me-1"></i> Reset
                    </a>
                    <?php if ($bisa_tambah): ?>
                        <button type="button" class="btn btn-success float-end" data-bs-toggle="modal" data-bs-target="#tambahMutasiModal">
                            <i class="fas fa-plus me-1"></i> Mutasi Baru
                        </button>
                    <?php endif; ?>
                </div>
            </form>
            
            <?php if ($filter_tanggal || $filter_barang || $filter_toko_asal || $filter_toko_tujuan): ?>
                <div class="mt-3">
                    <small class="text-muted">Filter aktif: 
                        <?php echo $filter_tanggal; ?>
                        <?php echo $filter_barang ? ($filter_tanggal ? ', ' : '') . $filter_barang : ''; ?>
                        <?php echo $filter_toko_asal ? (($filter_tanggal || $filter_barang) ? ', ' : '') . $filter_toko_asal : ''; ?>
                        <?php echo $filter_toko_tujuan ? (($filter_tanggal || $filter_barang || $filter_toko_asal) ? ', ' : '') . $filter_toko_tujuan : ''; ?>
                    </small>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Tabel Daftar Mutasi -->
    <div class="card animate-fade-in" style="animation-delay: 0.2s;">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="dataTable">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>No. Mutasi</th>
                            <th>Tanggal</th>
                            <th>Toko Asal</th>
                            <th>Toko Tujuan</th>
                            <th>Total Barang</th>
                            <th>Pembuat</th>
                            <th>Keterangan</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result && mysqli_num_rows($result) > 0): ?>
                            <?php $no = 1; ?>
                            <?php while ($row = mysqli_fetch_assoc($result)): ?>
                                <?php
                                // Hitung total barang dalam mutasi ini
                                $query_total_barang = "SELECT COUNT(*) as total_barang, SUM(total_barang) as total_jumlah 
                                                      FROM mutasi 
                                                      WHERE id_mutasi = " . $row['id_mutasi'];
                                $result_total_barang = mysqli_query($conn, $query_total_barang);
                                $total_barang = mysqli_fetch_assoc($result_total_barang);
                                ?>
                                <tr>
                                    <td><?php echo $no++; ?></td>
                                    <td><?php echo $row['no_mutasi']; ?></td>
                                    <td><?php echo date('d-m-Y H:i', strtotime($row['tanggal_mutasi'])); ?></td>
                                    <td><?php echo $row['nama_toko_asal']; ?></td>
                                    <td><?php echo $row['nama_toko_tujuan']; ?></td>
                                    <td><?php echo $total_barang['total_barang'] . ' jenis (' . $total_barang['total_jumlah'] . ' pcs)'; ?></td>
                                    <td><?php echo $row['nama_pembuat']; ?></td>
                                    <td><?php echo $row['status'] ? substr($row['status'], 0, 30) . (strlen($row['status']) > 30 ? '...' : '') : '-'; ?></td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#detailMutasiModal<?php echo $row['id_mutasi']; ?>">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            
                                            <?php if ($bisa_edit): ?>
                                                <a href="edit_mutasi.php?id=<?php echo $row['id_mutasi']; ?>" class="btn btn-sm btn-warning">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            <?php endif; ?>
                                            
                                            <?php if ($bisa_hapus): ?>
                                                <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#hapusMutasiModal<?php echo $row['id_mutasi']; ?>">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <!-- Modal Detail Mutasi -->
                                        <div class="modal fade" id="detailMutasiModal<?php echo $row['id_mutasi']; ?>" tabindex="-1" aria-labelledby="detailMutasiModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="detailMutasiModalLabel">Detail Mutasi <?php echo $row['no_mutasi']; ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row mb-4">
                                                            <div class="col-md-6">
                                                                <h6>Info Mutasi</h6>
                                                                <table class="table table-sm table-borderless">
                                                                    <tr>
                                                                        <th width="40%">No. Mutasi</th>
                                                                        <td>: <?php echo $row['no_mutasi']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Tanggal</th>
                                                                        <td>: <?php echo date('d-m-Y H:i', strtotime($row['tanggal_mutasi'])); ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Toko Asal</th>
                                                                        <td>: <?php echo $row['nama_toko_asal']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Toko Tujuan</th>
                                                                        <td>: <?php echo $row['nama_toko_tujuan']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Pembuat</th>
                                                                        <td>: <?php echo $row['nama_pembuat']; ?></td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <h6>Info Tambahan</h6>
                                                                <table class="table table-sm table-borderless">
                                                                    <tr>
                                                                        <th width="40%">Total Jenis Barang</th>
                                                                        <td>: <?php echo $total_barang['total_barang']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Total Jumlah Barang</th>
                                                                        <td>: <?php echo $total_barang['total_jumlah']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Status</th>
                                                                        <td>: 
                                                                            <?php if ($row['status'] == 'diproses'): ?>
                                                                                <span class="badge bg-warning text-dark">Diproses</span>
                                                                            <?php elseif ($row['status'] == 'selesai'): ?>
                                                                                <span class="badge bg-success">Selesai</span>
                                                                            <?php elseif ($row['status'] == 'dibatalkan'): ?>
                                                                                <span class="badge bg-danger">Dibatalkan</span>
                                                                            <?php endif; ?>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                        </div>
                                                        
                                                        <h6>Rincian Barang</h6>
                                                        <div class="table-responsive">
                                                            <table class="table table-sm table-bordered">
                                                                <thead>
                                                                    <tr>
                                                                        <th>No</th>
                                                                        <th>Nama Barang</th>
                                                                        <th>Jumlah</th>
                                                                        <th>Satuan</th>
                                                                        <th>Keterangan</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php 
                                                                    $query_detail = "SELECT md.*, b.nama_barang, b.satuan 
                                                                                    FROM mutasi_detail md
                                                                                    JOIN barang b ON md.id_barang = b.id_barang
                                                                                    WHERE md.id_mutasi = " . $row['id_mutasi'];
                                                                    $result_detail = mysqli_query($conn, $query_detail);
                                                                    $no_detail = 1;
                                                                    ?>
                                                                    <?php while ($detail = mysqli_fetch_assoc($result_detail)): ?>
                                                                        <tr>
                                                                            <td><?php echo $no_detail++; ?></td>
                                                                            <td><?php echo $detail['nama_barang']; ?></td>
                                                                            <td><?php echo $detail['jumlah']; ?></td>
                                                                            <td><?php echo $detail['satuan']; ?></td>
                                                                            <td><?php echo $detail['keterangan'] ? $detail['keterangan'] : '-'; ?></td>
                                                                        </tr>
                                                                    <?php endwhile; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                        
                                                        <div class="row mt-3">
                                                            <div class="col-md-12">
                                                                <p class="mb-1"><strong>Keterangan:</strong></p>
                                                                <p><?php echo $row['keterangan'] ? $row['keterangan'] : '-'; ?></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                                        <a href="cetak_mutasi.php?id=<?php echo $row['id_mutasi']; ?>" target="_blank" class="btn btn-primary">
                                                            <i class="fas fa-print me-1"></i> Cetak Mutasi
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Modal Hapus Mutasi -->
                                        <div class="modal fade" id="hapusMutasiModal<?php echo $row['id_mutasi']; ?>" tabindex="-1" aria-labelledby="hapusMutasiModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="hapusMutasiModalLabel">Hapus Mutasi</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>Apakah Anda yakin ingin menghapus mutasi <strong><?php echo $row['no_mutasi']; ?></strong>?</p>
                                                        <p class="text-danger">Data yang dihapus tidak dapat dikembalikan!</p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                        <form action="proses_hapus_mutasi.php" method="POST">
                                                            <input type="hidden" name="id_mutasi" value="<?php echo $row['id_mutasi']; ?>">
                                                            <button type="submit" class="btn btn-danger">Hapus</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center">Tidak ada data mutasi</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Tambah Mutasi -->
<div class="modal fade" id="tambahMutasiModal" tabindex="-1" aria-labelledby="tambahMutasiModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <form id="formMutasi" action="proses_tambah_mutasi.php" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title" id="tambahMutasiModalLabel">Mutasi Stok Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="tanggal_mutasi" class="form-label">Tanggal Mutasi</label>
                                <input type="datetime-local" class="form-control" id="tanggal_mutasi" name="tanggal_mutasi" value="<?php echo date('Y-m-d\TH:i'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="id_toko_asal" class="form-label">Toko Asal</label>
                                <select class="form-select" id="id_toko_asal" name="id_toko_asal" required>
                                    <option value="">Pilih Toko Asal</option>
                                    <?php 
                                    mysqli_data_seek($result_toko, 0); // Reset pointer result toko
                                    while ($toko = mysqli_fetch_assoc($result_toko)): ?>
                                        <option value="<?php echo $toko['id_toko']; ?>"><?php echo $toko['nama_toko']; ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="id_toko_tujuan" class="form-label">Toko Tujuan</label>
                                <select class="form-select" id="id_toko_tujuan" name="id_toko_tujuan" required>
                                    <option value="">Pilih Toko Tujuan</option>
                                    <?php 
                                    mysqli_data_seek($result_toko, 0); // Reset pointer result toko
                                    while ($toko = mysqli_fetch_assoc($result_toko)): ?>
                                        <option value="<?php echo $toko['id_toko']; ?>"><?php echo $toko['nama_toko']; ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="keterangan" class="form-label">Keterangan (Opsional)</label>
                                <textarea class="form-control" id="keterangan" name="keterangan" rows="2"></textarea>
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <h5 class="mb-3">Daftar Barang Dimutasi</h5>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="cari_barang" class="form-label">Cari Barang</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="cari_barang" placeholder="Kode atau nama barang">
                                <button class="btn btn-outline-secondary" type="button" id="btnCariBarang">
                                    <i class="fas fa-search"></i>
                                </button>
                            </div>
                            <div id="hasilPencarianBarang" class="position-absolute w-100 bg-white z-index-1 d-none" style="max-height: 200px; overflow-y: auto;">
                                <!-- Hasil pencarian akan muncul di sini -->
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label for="jumlah" class="form-label">Jumlah</label>
                            <input type="number" class="form-control" id="jumlah" min="1" value="1">
                        </div>
                        <div class="col-md-4">
                            <label for="keterangan_barang" class="form-label">Keterangan Barang (Opsional)</label>
                            <input type="text" class="form-control" id="keterangan_barang" placeholder="Keterangan barang">
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered" id="tabelBarangMutasi">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="35%">Nama Barang</th>
                                    <th width="15%">Jumlah</th>
                                    <th width="15%">Satuan</th>
                                    <th width="25%">Keterangan</th>
                                    <th width="5%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody id="daftarBarangMutasi">
                                <!-- Daftar barang mutasi akan muncul di sini -->
                                <tr id="barangMutasiKosong">
                                    <td colspan="6" class="text-center">Belum ada barang ditambahkan</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan Mutasi</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Script untuk mutasi -->
<script>
$(document).ready(function() {
    // Variabel untuk menyimpan data barang mutasi
    let daftarBarangMutasi = [];
    let counterBarangMutasi = 1;
    
    // Event listener untuk pencarian barang
    $('#btnCariBarang').click(function() {
        const keyword = $('#cari_barang').val().trim();
        const id_toko_asal = $('#id_toko_asal').val();
        
        if (!id_toko_asal) {
            alert('Pilih toko asal terlebih dahulu');
            return;
        }
        
        if (keyword.length < 2) {
            alert('Masukkan minimal 2 karakter untuk pencarian');
            return;
        }
        
        $.ajax({
            url: 'ajax_cari_barang_mutasi.php',
            type: 'GET',
            data: { 
                keyword: keyword,
                id_toko: id_toko_asal
            },
            dataType: 'json',
            success: function(response) {
                const hasilPencarian = $('#hasilPencarianBarang');
                hasilPencarian.empty();
                
                if (response.length > 0) {
                    response.forEach(barang => {
                        // Cek apakah barang sudah ada di daftar
                        const sudahAda = daftarBarangMutasi.some(item => item.id_barang == barang.id_barang);
                        
                        if (!sudahAda) {
                            hasilPencarian.append(`
                                <div class="list-group-item list-group-item-action p-2" 
                                     data-id="${barang.id_barang}" 
                                     data-nama="${barang.nama_barang}" 
                                     data-satuan="${barang.satuan}"
                                     data-stok="${barang.stok}">
                                    ${barang.nama_barang} (${barang.satuan})
                                    <span class="badge bg-info float-end">Stok: ${barang.stok}</span>
                                </div>
                            `);
                        }
                    });
                    
                    if (hasilPencarian.children().length === 0) {
                        hasilPencarian.append('<div class="list-group-item p-2">Semua barang sudah ditambahkan</div>');
                    }
                    
                    hasilPencarian.removeClass('d-none');
                } else {
                    hasilPencarian.append('<div class="list-group-item p-2">Barang tidak ditemukan</div>');
                    hasilPencarian.removeClass('d-none');
                }
            },
            error: function() {
                alert('Terjadi kesalahan saat mencari barang');
            }
        });
    });
    
    // Event listener untuk memilih barang dari hasil pencarian
    $(document).on('click', '#hasilPencarianBarang .list-group-item', function() {
        const idBarang = $(this).data('id');
        const namaBarang = $(this).data('nama');
        const satuan = $(this).data('satuan');
        const stok = parseInt($(this).data('stok'));
        const jumlah = parseInt($('#jumlah').val()) || 1;
        const keterangan = $('#keterangan_barang').val() || '';
        
        // Validasi jumlah tidak melebihi stok
        if (jumlah > stok) {
            alert('Jumlah mutasi tidak boleh melebihi stok yang tersedia');
            return;
        }
        
        // Tambahkan barang ke array daftarBarangMutasi
        const barang = {
            id_barang: idBarang,
            nama_barang: namaBarang,
            jumlah: jumlah,
            satuan: satuan,
            keterangan: keterangan,
            stok: stok
        };
        
        daftarBarangMutasi.push(barang);
        
        // Tambahkan barang ke tabel
        tambahBarangKeTabel(barang);
        
        // Reset form pencarian
        $('#cari_barang').val('');
        $('#jumlah').val('1');
        $('#keterangan_barang').val('');
        $('#hasilPencarianBarang').addClass('d-none').empty();
    });
    
    // Fungsi untuk menambahkan barang ke tabel
    function tambahBarangKeTabel(barang) {
        // Hilangkan pesan barang kosong jika ada
        $('#barangMutasiKosong').remove();
        
        // Tambahkan row baru ke tabel
        const rowId = 'barangMutasi-' + counterBarangMutasi;
        const newRow = `
            <tr id="${rowId}">
                <td>${counterBarangMutasi}</td>
                <td>
                    ${barang.nama_barang}
                    <input type="hidden" name="id_barang[]" value="${barang.id_barang}">
                </td>
                <td>
                    <input type="number" class="form-control form-control-sm jumlah-mutasi" 
                           name="jumlah[]" min="1" max="${barang.stok}" 
                           value="${barang.jumlah}" data-row="${rowId}">
                </td>
                <td>${barang.satuan}</td>
                <td>
                    <input type="text" class="form-control form-control-sm keterangan-mutasi" 
                           name="keterangan_barang[]" value="${barang.keterangan}" data-row="${rowId}">
                </td>
                <td>
                    <button type="button" class="btn btn-sm btn-danger hapus-barang-mutasi" data-row="${rowId}">
                        <i class="fas fa-trash"></i>
                    </button>
                </td>
            </tr>
        `;
        
        $('#daftarBarangMutasi').append(newRow);
        counterBarangMutasi++;
    }
    
    // Event listener untuk menghapus barang dari tabel
    $(document).on('click', '.hapus-barang-mutasi', function() {
        const rowId = $(this).data('row');
        
        // Hapus barang dari array daftarBarangMutasi
        const index = daftarBarangMutasi.findIndex(item => 'barangMutasi-' + daftarBarangMutasi.indexOf(item) + 1 === rowId);
        if (index !== -1) {
            daftarBarangMutasi.splice(index, 1);
        }
        
        // Hapus row dari tabel
        $('#' + rowId).remove();
        
        // Jika tidak ada barang, tampilkan pesan
        if (daftarBarangMutasi.length === 0) {
            $('#daftarBarangMutasi').html('<tr id="barangMutasiKosong"><td colspan="6" class="text-center">Belum ada barang ditambahkan</td></tr>');
        } else {
            // Update nomor urut
            $('#daftarBarangMutasi tr').each(function(index) {
                $(this).find('td:first').text(index + 1);
            });
        }
    });
    
    // Event listener untuk perubahan jumlah atau keterangan barang
    $(document).on('change keyup', '.jumlah-mutasi, .keterangan-mutasi', function() {
        const rowId = $(this).data('row');
        const index = parseInt(rowId.split('-')[2]) - 1;
        
        if (index >= 0 && index < daftarBarangMutasi.length) {
            const jumlah = parseFloat($(this).closest('tr').find('.jumlah-mutasi').val()) || 0;
            const keterangan = $(this).closest('tr').find('.keterangan-mutasi').val() || '';
            
            // Validasi jumlah tidak melebihi stok
            if (jumlah > daftarBarangMutasi[index].stok) {
                alert('Jumlah mutasi tidak boleh melebihi stok yang tersedia');
                $(this).closest('tr').find('.jumlah-mutasi').val(daftarBarangMutasi[index].jumlah);
                return;
            }
            
            // Update data di array
            daftarBarangMutasi[index].jumlah = jumlah;
            daftarBarangMutasi[index].keterangan = keterangan;
        }
    });
    
    // Validasi form sebelum submit
    $('#formMutasi').submit(function(e) {
        // Validasi toko asal dan tujuan tidak boleh sama
        const id_toko_asal = $('#id_toko_asal').val();
        const id_toko_tujuan = $('#id_toko_tujuan').val();
        
        if (id_toko_asal === id_toko_tujuan) {
            e.preventDefault();
            alert('Toko asal dan tujuan tidak boleh sama');
            return false;
        }
        
        // Validasi minimal ada 1 barang
        if (daftarBarangMutasi.length === 0) {
            e.preventDefault();
            alert('Minimal harus ada 1 barang dalam mutasi');
            return false;
        }
        
        return true;
    });
    
    // Tutup hasil pencarian saat klik di luar
    $(document).click(function(e) {
        if (!$(e.target).closest('#hasilPencarianBarang').length && !$(e.target).is('#cari_barang, #btnCariBarang')) {
            $('#hasilPencarianBarang').addClass('d-none');
        }
    });
});
</script>

<?php include 'footer.php'; ?>