<?php 
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
require_once 'config.php';

// Periksa apakah pengguna sudah login
if (!isset($_SESSION['id_pengguna'])) {
    header("Location: login.php");
    exit();
}

$id_pengguna = $_SESSION['id_pengguna'];

// Query untuk mendapatkan notifikasi
$query = "SELECT * FROM notifikasi 
          WHERE id_pengguna = ? 
          ORDER BY is_read ASC, created_at DESC";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_pengguna);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

// Hitung jumlah notifikasi belum dibaca
$query_unread = "SELECT COUNT(*) as total FROM notifikasi 
                 WHERE id_pengguna = ? AND is_read = 0";
$stmt_unread = mysqli_prepare($conn, $query_unread);
mysqli_stmt_bind_param($stmt_unread, "i", $id_pengguna);
mysqli_stmt_execute($stmt_unread);
$result_unread = mysqli_stmt_get_result($stmt_unread);
$unread_count = mysqli_fetch_assoc($result_unread)['total'];

// Tandai notifikasi sebagai sudah dibaca jika ada parameter
if (isset($_GET['mark_as_read']) && $_GET['mark_as_read'] == 'all') {
    $query_mark = "UPDATE notifikasi SET is_read = 1 
                   WHERE id_pengguna = ? AND is_read = 0";
    $stmt_mark = mysqli_prepare($conn, $query_mark);
    mysqli_stmt_bind_param($stmt_mark, "i", $id_pengguna);
    mysqli_stmt_execute($stmt_mark);
    
    // Redirect untuk menghindari resubmit
    header("Location: notifikasi.php");
    exit();
}

// Tandai satu notifikasi sebagai dibaca
if (isset($_GET['read_id'])) {
    $read_id = intval($_GET['read_id']);
    $query_mark_one = "UPDATE notifikasi SET is_read = 1 
                       WHERE id_notifikasi = ? AND id_pengguna = ?";
    $stmt_mark_one = mysqli_prepare($conn, $query_mark_one);
    mysqli_stmt_bind_param($stmt_mark_one, "ii", $read_id, $id_pengguna);
    mysqli_stmt_execute($stmt_mark_one);
    
    // Redirect ke link notifikasi jika ada
    if (isset($_GET['link'])) {
        header("Location: " . urldecode($_GET['link']));
        exit();
    }
    
    // Redirect untuk menghindari resubmit
    header("Location: notifikasi.php");
    exit();
}
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Notifikasi</h1>
        <div class="d-flex">
            <?php if ($unread_count > 0): ?>
                <a href="notifikasi.php?mark_as_read=all" class="btn btn-sm btn-primary-custom me-2">
                    <i class="fas fa-check-circle me-1"></i> Tandai Semua Sudah Dibaca
                </a>
            <?php endif; ?>
            <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#clearAllModal">
                <i class="fas fa-trash-alt me-1"></i> Hapus Semua
            </button>
        </div>
    </div>
    
    <!-- Notifikasi Counter -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-primary-custom text-white animate-fade-in" style="animation-delay: 0.1s;">
                <div class="card-body py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0"><i class="fas fa-bell me-2"></i> Total Notifikasi</h6>
                        </div>
                        <div>
                            <span class="badge bg-white text-primary-custom fs-6">
                                <?php echo mysqli_num_rows($result); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Unread Notifications -->
    <?php if ($unread_count > 0): ?>
        <div class="row mb-4">
            <div class="col-12">
                <div class="card border-left-danger shadow animate-fade-in" style="animation-delay: 0.2s;">
                    <div class="card-header py-3 bg-danger text-white">
                        <h6 class="m-0 font-weight-bold">
                            <i class="fas fa-exclamation-circle me-1"></i> Notifikasi Belum Dibaca
                        </h6>
                    </div>
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush">
                            <?php 
                            mysqli_data_seek($result, 0); // Reset pointer
                            $unread_displayed = 0;
                            while ($row = mysqli_fetch_assoc($result)): 
                                if ($row['is_read'] == 0 && $unread_displayed < 5):
                                    $unread_displayed++;
                            ?>
                                <a href="notifikasi.php?read_id=<?php echo $row['id_notifikasi']; ?>&link=<?php echo urlencode($row['link']); ?>" 
                                   class="list-group-item list-group-item-action">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h6 class="mb-1 fw-bold"><?php echo htmlspecialchars($row['judul']); ?></h6>
                                        <small><?php echo time_ago($row['created_at']); ?></small>
                                    </div>
                                    <p class="mb-1"><?php echo htmlspecialchars($row['pesan']); ?></p>
                                    <small class="text-danger">
                                        <i class="fas fa-circle me-1"></i> Belum dibaca
                                    </small>
                                </a>
                            <?php endif; endwhile; ?>
                            
                            <?php if ($unread_count > 5): ?>
                                <div class="list-group-item text-center">
                                    <a href="#" class="text-primary-custom">Lihat <?php echo $unread_count - 5; ?> notifikasi belum dibaca lainnya</a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    
    <!-- All Notifications -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow animate-fade-in" style="animation-delay: 0.3s;">
                <div class="card-header py-3 bg-success text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-list me-1"></i> Semua Notifikasi
                    </h6>
                </div>
                <div class="card-body p-0">
                    <?php if (mysqli_num_rows($result) > 0): ?>
                        <div class="list-group list-group-flush">
                            <?php 
                            mysqli_data_seek($result, 0); // Reset pointer
                            while ($row = mysqli_fetch_assoc($result)): 
                                $bg_class = $row['is_read'] ? '' : 'bg-light';
                                $text_class = $row['is_read'] ? 'text-muted' : '';
                            ?>
                                <a href="notifikasi.php?read_id=<?php echo $row['id_notifikasi']; ?>&link=<?php echo urlencode($row['link']); ?>" 
                                   class="list-group-item list-group-item-action <?php echo $bg_class; ?>">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h6 class="mb-1 <?php echo $text_class; ?>">
                                            <?php echo htmlspecialchars($row['judul']); ?>
                                            <?php if (!$row['is_read']): ?>
                                                <span class="badge bg-danger ms-2">Baru</span>
                                            <?php endif; ?>
                                        </h6>
                                        <small class="<?php echo $text_class; ?>">
                                            <?php echo time_ago($row['created_at']); ?>
                                        </small>
                                    </div>
                                    <p class="mb-1 <?php echo $text_class; ?>">
                                        <?php echo htmlspecialchars($row['pesan']); ?>
                                    </p>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <small class="<?php echo $text_class; ?>">
                                            <i class="fas fa-<?php echo get_icon_by_type($row['tipe']); ?> me-1"></i>
                                            <?php echo ucfirst($row['tipe']); ?>
                                        </small>
                                        <?php if ($row['link']): ?>
                                            <small>
                                                <i class="fas fa-external-link-alt me-1"></i> Tautan
                                            </small>
                                        <?php endif; ?>
                                    </div>
                                </a>
                            <?php endwhile; ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <img src="assets/img/empty-notification.svg" alt="No notifications" class="img-fluid mb-3" style="max-width: 200px;">
                            <h5 class="text-gray-800">Tidak ada notifikasi</h5>
                            <p class="text-muted">Anda tidak memiliki notifikasi saat ini</p>
                        </div>
                    <?php endif; ?>
                </div>
                <?php if (mysqli_num_rows($result) > 10): ?>
                    <div class="card-footer">
                        <nav aria-label="Notifikasi navigation">
                            <ul class="pagination justify-content-center mb-0">
                                <li class="page-item disabled">
                                    <a class="page-link" href="#" tabindex="-1" aria-disabled="true">Previous</a>
                                </li>
                                <li class="page-item active"><a class="page-link" href="#">1</a></li>
                                <li class="page-item"><a class="page-link" href="#">2</a></li>
                                <li class="page-item"><a class="page-link" href="#">3</a></li>
                                <li class="page-item">
                                    <a class="page-link" href="#">Next</a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</main>

<!-- Clear All Modal -->
<div class="modal fade" id="clearAllModal" tabindex="-1" aria-labelledby="clearAllModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="clearAllModalLabel">Hapus Semua Notifikasi</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus semua notifikasi? Tindakan ini tidak dapat dibatalkan.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <a href="notifikasi.php?action=clear_all" class="btn btn-danger">Ya, Hapus Semua</a>
            </div>
        </div>
    </div>
</div>

<?php 
// Fungsi helper untuk menampilkan waktu lalu
function time_ago($datetime) {
    $time = strtotime($datetime);
    $now = time();
    $diff = $now - $time;
    
    if ($diff < 60) {
        return 'Baru saja';
    } elseif ($diff < 3600) {
        $mins = floor($diff / 60);
        return $mins . ' menit lalu';
    } elseif ($diff < 86400) {
        $hours = floor($diff / 3600);
        return $hours . ' jam lalu';
    } elseif ($diff < 2592000) {
        $days = floor($diff / 86400);
        return $days . ' hari lalu';
    } else {
        return date('d M Y', $time);
    }
}

// Fungsi helper untuk mendapatkan icon berdasarkan tipe notifikasi
function get_icon_by_type($type) {
    switch ($type) {
        case 'info': return 'info-circle';
        case 'warning': return 'exclamation-triangle';
        case 'danger': return 'times-circle';
        case 'success': return 'check-circle';
        default: return 'bell';
    }
}

include 'footer.php'; 
?>