<?php
session_start();
include 'header.php';
require_once 'config.php';

// Fungsi untuk format telepon
function format_telepon($nomor) {
    if (strlen($nomor) == 11) {
        return substr($nomor, 0, 3) . '-' . substr($nomor, 3, 4) . '-' . substr($nomor, 7);
    } elseif (strlen($nomor) == 12) {
        return substr($nomor, 0, 4) . '-' . substr($nomor, 4, 4) . '-' . substr($nomor, 8);
    }
    return $nomor;
}

// Proses CRUD Pelanggan
if (isset($_POST['tambah_pelanggan'])) {
    $kode_pelanggan = mysqli_real_escape_string($conn, $_POST['kode_pelanggan']);
    $nama_pelanggan = mysqli_real_escape_string($conn, $_POST['nama_pelanggan']);
    $alamat = mysqli_real_escape_string($conn, $_POST['alamat']);
    $telepon = mysqli_real_escape_string($conn, $_POST['telepon']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $jenis_pelanggan = mysqli_real_escape_string($conn, $_POST['jenis_pelanggan']);

    $query = "INSERT INTO pelanggan (kode_pelanggan, nama_pelanggan, alamat, telepon, email, jenis_pelanggan) 
              VALUES ('$kode_pelanggan', '$nama_pelanggan', '$alamat', '$telepon', '$email', '$jenis_pelanggan')";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Pelanggan berhasil ditambahkan'];
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menambahkan pelanggan: ' . mysqli_error($conn)];
    }
    header("Location: pelanggan.php");
    exit();
}

if (isset($_POST['edit_pelanggan'])) {
    $id_pelanggan = mysqli_real_escape_string($conn, $_POST['id_pelanggan']);
    $kode_pelanggan = mysqli_real_escape_string($conn, $_POST['kode_pelanggan']);
    $nama_pelanggan = mysqli_real_escape_string($conn, $_POST['nama_pelanggan']);
    $alamat = mysqli_real_escape_string($conn, $_POST['alamat']);
    $telepon = mysqli_real_escape_string($conn, $_POST['telepon']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $jenis_pelanggan = mysqli_real_escape_string($conn, $_POST['jenis_pelanggan']);

    $query = "UPDATE pelanggan SET 
              kode_pelanggan = '$kode_pelanggan',
              nama_pelanggan = '$nama_pelanggan',
              alamat = '$alamat',
              telepon = '$telepon',
              email = '$email',
              jenis_pelanggan = '$jenis_pelanggan'
              WHERE id_pelanggan = $id_pelanggan";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Pelanggan berhasil diupdate'];
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal mengupdate pelanggan: ' . mysqli_error($conn)];
    }
    header("Location: pelanggan.php");
    exit();
}

if (isset($_GET['hapus'])) {
    $id_pelanggan = mysqli_real_escape_string($conn, $_GET['hapus']);
    
    // Cek apakah pelanggan memiliki transaksi
    $cek_penjualan = mysqli_query($conn, "SELECT COUNT(*) as total FROM penjualan WHERE id_pelanggan = $id_pelanggan");
    $jumlah_penjualan = mysqli_fetch_assoc($cek_penjualan)['total'];
    
    if ($jumlah_penjualan > 0) {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menghapus pelanggan karena memiliki ' . $jumlah_penjualan . ' transaksi'];
    } else {
        $query = "DELETE FROM pelanggan WHERE id_pelanggan = $id_pelanggan";
        
        if (mysqli_query($conn, $query)) {
            $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Pelanggan berhasil dihapus'];
        } else {
            $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menghapus pelanggan: ' . mysqli_error($conn)];
        }
    }
    header("Location: pelanggan.php");
    exit();
}

// Filter dan pencarian
$filter_nama = isset($_GET['filter_nama']) ? mysqli_real_escape_string($conn, $_GET['filter_nama']) : '';
$filter_jenis = isset($_GET['filter_jenis']) ? mysqli_real_escape_string($conn, $_GET['filter_jenis']) : '';

// Query data pelanggan
$query = "SELECT * FROM pelanggan WHERE 1=1";

if (!empty($filter_nama)) {
    $query .= " AND nama_pelanggan LIKE '%$filter_nama%'";
}

if (!empty($filter_jenis) && $filter_jenis != 'semua') {
    $query .= " AND jenis_pelanggan = '$filter_jenis'";
}

$query .= " ORDER BY nama_pelanggan ASC";
$result = mysqli_query($conn, $query);
?>

<main class="animate-fade-in">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Manajemen Pelanggan</h1>
        <div>
            <button class="btn btn-primary-custom" data-bs-toggle="modal" data-bs-target="#tambahPelangganModal">
                <i class="fas fa-plus-circle"></i> Tambah Pelanggan
            </button>
        </div>
    </div>

    <?php if (isset($_SESSION['pesan'])): ?>
    <div class="alert alert-<?= $_SESSION['pesan']['tipe'] ?> alert-dismissible fade show">
        <?= $_SESSION['pesan']['isi'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['pesan']); endif; ?>

    <div class="card shadow mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-header py-3 bg-primary-custom text-white">
            <h6 class="m-0 font-weight-bold">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="get" action="">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Nama Pelanggan</label>
                        <input type="text" class="form-control" name="filter_nama" value="<?= htmlspecialchars($filter_nama) ?>">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Jenis Pelanggan</label>
                        <select class="form-select" name="filter_jenis">
                            <option value="semua" <?= $filter_jenis == 'semua' ? 'selected' : '' ?>>Semua Jenis</option>
                            <option value="reguler" <?= $filter_jenis == 'reguler' ? 'selected' : '' ?>>Reguler</option>
                            <option value="member" <?= $filter_jenis == 'member' ? 'selected' : '' ?>>Member</option>
                            <option value="reseller" <?= $filter_jenis == 'reseller' ? 'selected' : '' ?>>Reseller</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary-custom me-2">
                            <i class="fas fa-filter"></i> Filter
                        </button>
                        <a href="pelanggan.php" class="btn btn-secondary">
                            <i class="fas fa-sync-alt"></i> Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow mb-4 animate-fade-in" style="animation-delay: 0.2s;">
        <div class="card-header py-3 bg-primary-custom text-white">
            <h6 class="m-0 font-weight-bold">Daftar Pelanggan</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th width="10%">Kode</th>
                            <th>Nama Pelanggan</th>
                            <th>Alamat</th>
                            <th>Telepon</th>
                            <th>Email</th>
                            <th width="10%">Jenis</th>
                            <th width="15%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (mysqli_num_rows($result) > 0): ?>
                            <?php $no = 1; while ($row = mysqli_fetch_assoc($result)): ?>
                            <tr>
                                <td><?= $no++ ?></td>
                                <td><?= $row['kode_pelanggan'] ?></td>
                                <td><?= $row['nama_pelanggan'] ?></td>
                                <td><?= $row['alamat'] ?></td>
                                <td><?= format_telepon($row['telepon']) ?></td>
                                <td><?= $row['email'] ?></td>
                                <td>
                                    <span class="badge bg-<?= 
                                        $row['jenis_pelanggan'] == 'member' ? 'success' : 
                                        ($row['jenis_pelanggan'] == 'reseller' ? 'info' : 'secondary') 
                                    ?>">
                                        <?= ucfirst($row['jenis_pelanggan']) ?>
                                    </span>
                                </td>
                                <td class="text-center">
                                    <button class="btn btn-sm btn-warning btn-edit" data-bs-toggle="modal" data-bs-target="#editPelangganModal" 
                                            data-id="<?= $row['id_pelanggan'] ?>" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <a href="pelanggan.php?hapus=<?= $row['id_pelanggan'] ?>" class="btn btn-sm btn-danger" 
                                       onclick="return confirm('Yakin ingin menghapus pelanggan ini?')" title="Hapus">
                                        <i class="fas fa-trash-alt"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center">Tidak ada data pelanggan</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Tambah Pelanggan -->
<div class="modal fade" id="tambahPelangganModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title">Tambah Pelanggan Baru</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Kode Pelanggan</label>
                            <input type="text" class="form-control" name="kode_pelanggan" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Nama Pelanggan</label>
                            <input type="text" class="form-control" name="nama_pelanggan" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Alamat</label>
                            <textarea class="form-control" name="alamat" rows="2"></textarea>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Jenis Pelanggan</label>
                            <select class="form-select" name="jenis_pelanggan" required>
                                <option value="reguler">Reguler</option>
                                <option value="member">Member</option>
                                <option value="reseller">Reseller</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Telepon</label>
                            <input type="text" class="form-control" name="telepon" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" name="email">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="tambah_pelanggan" class="btn btn-primary-custom">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Edit Pelanggan -->
<div class="modal fade" id="editPelangganModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title">Edit Pelanggan</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="">
                <input type="hidden" name="id_pelanggan" id="edit_id_pelanggan">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Kode Pelanggan</label>
                            <input type="text" class="form-control" name="kode_pelanggan" id="edit_kode_pelanggan" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Nama Pelanggan</label>
                            <input type="text" class="form-control" name="nama_pelanggan" id="edit_nama_pelanggan" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Alamat</label>
                            <textarea class="form-control" name="alamat" id="edit_alamat" rows="2"></textarea>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Jenis Pelanggan</label>
                            <select class="form-select" name="jenis_pelanggan" id="edit_jenis_pelanggan" required>
                                <option value="reguler">Reguler</option>
                                <option value="member">Member</option>
                                <option value="reseller">Reseller</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Telepon</label>
                            <input type="text" class="form-control" name="telepon" id="edit_telepon" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" name="email" id="edit_email">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="edit_pelanggan" class="btn btn-primary-custom">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// AJAX untuk edit modal
document.querySelectorAll('.btn-edit').forEach(button => {
    button.addEventListener('click', function() {
        const id = this.getAttribute('data-id');
        
        fetch(`get_pelanggan.php?id=${id}`)
            .then(response => response.json())
            .then(data => {
                document.getElementById('edit_id_pelanggan').value = data.id_pelanggan;
                document.getElementById('edit_kode_pelanggan').value = data.kode_pelanggan;
                document.getElementById('edit_nama_pelanggan').value = data.nama_pelanggan;
                document.getElementById('edit_alamat').value = data.alamat;
                document.getElementById('edit_telepon').value = data.telepon;
                document.getElementById('edit_email').value = data.email;
                document.getElementById('edit_jenis_pelanggan').value = data.jenis_pelanggan;
            });
    });
});
</script>

<?php include 'footer.php'; ?>