<?php
// Start session dan validasi login
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Cek apakah user sudah login
if (!isset($_SESSION['id_pengguna'])) {
    header("Location: login.php");
    exit();
}

// Validasi hak akses (hanya Super Admin, Admin dan Owner)
$allowed_roles = ['0', '1', '4']; // Sesuaikan dengan id_role super admin, admin dan owner
if (!isset($_SESSION['id_role']) || !in_array($_SESSION['id_role'], $allowed_roles)) {
    header("Location: unauthorized.php");
    exit();
}

// Proses CRUD Pengguna
if (isset($_POST['tambah_pengguna'])) {
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $nama_lengkap = mysqli_real_escape_string($conn, $_POST['nama_lengkap']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $telepon = mysqli_real_escape_string($conn, $_POST['telepon']);
    $id_role = mysqli_real_escape_string($conn, $_POST['id_role']);
    $id_toko = mysqli_real_escape_string($conn, $_POST['id_toko']);
    $is_active = isset($_POST['is_active']) ? 1 : 0;

    $query = "INSERT INTO pengguna (username, password, nama_lengkap, email, telepon, id_role, id_toko, is_active) 
              VALUES ('$username', '$password', '$nama_lengkap', '$email', '$telepon', $id_role, $id_toko, $is_active)";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Pengguna berhasil ditambahkan'];
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menambahkan pengguna: ' . mysqli_error($conn)];
    }
    header("Location: pengguna.php");
    exit();
}

if (isset($_POST['edit_pengguna'])) {
    $id_pengguna = mysqli_real_escape_string($conn, $_POST['id_pengguna']);
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $nama_lengkap = mysqli_real_escape_string($conn, $_POST['nama_lengkap']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $telepon = mysqli_real_escape_string($conn, $_POST['telepon']);
    $id_role = mysqli_real_escape_string($conn, $_POST['id_role']);
    $id_toko = mysqli_real_escape_string($conn, $_POST['id_toko']);
    $is_active = isset($_POST['is_active']) ? 1 : 0;

    // Update password jika diisi
    $password_update = '';
    if (!empty($_POST['password'])) {
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $password_update = ", password = '$password'";
    }

    $query = "UPDATE pengguna SET 
              username = '$username',
              nama_lengkap = '$nama_lengkap',
              email = '$email',
              telepon = '$telepon',
              id_role = $id_role,
              id_toko = $id_toko,
              is_active = $is_active
              $password_update
              WHERE id_pengguna = $id_pengguna";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Pengguna berhasil diupdate'];
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal mengupdate pengguna: ' . mysqli_error($conn)];
    }
    header("Location: pengguna.php");
    exit();
}

if (isset($_GET['hapus'])) {
    $id_pengguna = mysqli_real_escape_string($conn, $_GET['hapus']);
    
    // Cek apakah pengguna memiliki transaksi
    $cek_penjualan = mysqli_query($conn, "SELECT COUNT(*) as total FROM penjualan WHERE id_pengguna = $id_pengguna");
    $cek_pembelian = mysqli_query($conn, "SELECT COUNT(*) as total FROM pembelian WHERE id_pengguna = $id_pengguna");
    
    $jumlah_penjualan = mysqli_fetch_assoc($cek_penjualan)['total'];
    $jumlah_pembelian = mysqli_fetch_assoc($cek_pembelian)['total'];
    
    if ($jumlah_penjualan > 0 || $jumlah_pembelian > 0) {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menghapus pengguna karena memiliki ' . $jumlah_penjualan . ' penjualan dan ' . $jumlah_pembelian . ' pembelian'];
    } else {
        $query = "DELETE FROM pengguna WHERE id_pengguna = $id_pengguna";
        
        if (mysqli_query($conn, $query)) {
            $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Pengguna berhasil dihapus'];
        } else {
            $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menghapus pengguna: ' . mysqli_error($conn)];
        }
    }
    header("Location: pengguna.php");
    exit();
}

// Query data pengguna dengan join ke role dan toko
$query = "SELECT p.*, r.nama_role, t.nama_toko 
          FROM pengguna p
          LEFT JOIN role r ON p.id_role = r.id_role
          LEFT JOIN toko t ON p.id_toko = t.id_toko
          ORDER BY p.nama_lengkap";

$result = mysqli_query($conn, $query);

// Query untuk dropdown role
$query_role = "SELECT * FROM role ORDER BY nama_role";
$result_role = mysqli_query($conn, $query_role);

// Query untuk dropdown toko
$query_toko = "SELECT * FROM toko WHERE status_aktif = 1 ORDER BY nama_toko";
$result_toko = mysqli_query($conn, $query_toko);
?>

<main class="animate-fade-in">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Manajemen Pengguna</h1>
        <div>
            <button class="btn btn-primary-custom" data-bs-toggle="modal" data-bs-target="#tambahPenggunaModal">
                <i class="fas fa-plus-circle"></i> Tambah Pengguna
            </button>
        </div>
    </div>

    <?php if (isset($_SESSION['pesan'])): ?>
    <div class="alert alert-<?= $_SESSION['pesan']['tipe'] ?> alert-dismissible fade show">
        <?= $_SESSION['pesan']['isi'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['pesan']); endif; ?>

    <div class="card shadow mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-header py-3 bg-primary-custom text-white">
            <h6 class="m-0 font-weight-bold">Daftar Pengguna</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th>Username</th>
                            <th>Nama Lengkap</th>
                            <th>Role</th>
                            <th>Toko</th>
                            <th>Email</th>
                            <th>Telepon</th>
                            <th width="10%">Status</th>
                            <th width="15%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (mysqli_num_rows($result) > 0): ?>
                            <?php $no = 1; while ($row = mysqli_fetch_assoc($result)): ?>
                            <tr>
                                <td><?= $no++ ?></td>
                                <td><?= $row['username'] ?></td>
                                <td><?= $row['nama_lengkap'] ?></td>
                                <td><?= $row['nama_role'] ?></td>
                                <td><?= $row['nama_toko'] ?? '-' ?></td>
                                <td><?= $row['email'] ?></td>
                                <td><?= $row['telepon'] ?></td>
                                <td class="text-center">
                                    <span class="badge bg-<?= $row['is_active'] ? 'success' : 'danger' ?>">
                                        <?= $row['is_active'] ? 'Aktif' : 'Nonaktif' ?>
                                    </span>
                                </td>
                                <td class="text-center">
                                    <button class="btn btn-sm btn-warning btn-edit" data-bs-toggle="modal" data-bs-target="#editPenggunaModal" 
                                            data-id="<?= $row['id_pengguna'] ?>" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <a href="pengguna.php?hapus=<?= $row['id_pengguna'] ?>" class="btn btn-sm btn-danger" 
                                       onclick="return confirm('Yakin ingin menghapus pengguna ini?')" title="Hapus">
                                        <i class="fas fa-trash-alt"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center">Tidak ada data pengguna</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Tambah Pengguna -->
<div class="modal fade" id="tambahPenggunaModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title">Tambah Pengguna Baru</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Username</label>
                            <input type="text" class="form-control" name="username" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Password</label>
                            <input type="password" class="form-control" name="password" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Nama Lengkap</label>
                            <input type="text" class="form-control" name="nama_lengkap" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" name="email">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Telepon</label>
                            <input type="text" class="form-control" name="telepon" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Role</label>
                            <select class="form-select" name="id_role" required>
                                <?php while ($role = mysqli_fetch_assoc($result_role)): ?>
                                    <option value="<?= $role['id_role'] ?>"><?= $role['nama_role'] ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Toko</label>
                            <select class="form-select" name="id_toko">
                                <option value="">- Pilih Toko -</option>
                                <?php while ($toko = mysqli_fetch_assoc($result_toko)): ?>
                                    <option value="<?= $toko['id_toko'] ?>"><?= $toko['nama_toko'] ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" checked>
                        <label class="form-check-label" for="is_active">
                            Aktif
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="tambah_pengguna" class="btn btn-primary-custom">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Edit Pengguna -->
<div class="modal fade" id="editPenggunaModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title">Edit Pengguna</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="">
                <input type="hidden" name="id_pengguna" id="edit_id_pengguna">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Username</label>
                            <input type="text" class="form-control" name="username" id="edit_username" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Password</label>
                            <input type="password" class="form-control" name="password" placeholder="Kosongkan jika tidak ingin mengubah">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Nama Lengkap</label>
                            <input type="text" class="form-control" name="nama_lengkap" id="edit_nama_lengkap" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" name="email" id="edit_email">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Telepon</label>
                            <input type="text" class="form-control" name="telepon" id="edit_telepon" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Role</label>
                            <select class="form-select" name="id_role" id="edit_id_role" required>
                                <?php mysqli_data_seek($result_role, 0); ?>
                                <?php while ($role = mysqli_fetch_assoc($result_role)): ?>
                                    <option value="<?= $role['id_role'] ?>"><?= $role['nama_role'] ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Toko</label>
                            <select class="form-select" name="id_toko" id="edit_id_toko">
                                <option value="">- Pilih Toko -</option>
                                <?php mysqli_data_seek($result_toko, 0); ?>
                                <?php while ($toko = mysqli_fetch_assoc($result_toko)): ?>
                                    <option value="<?= $toko['id_toko'] ?>"><?= $toko['nama_toko'] ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="is_active" id="edit_is_active">
                        <label class="form-check-label" for="edit_is_active">
                            Aktif
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="edit_pengguna" class="btn btn-primary-custom">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// AJAX untuk edit modal
document.querySelectorAll('.btn-edit').forEach(button => {
    button.addEventListener('click', function() {
        const id = this.getAttribute('data-id');
        
        fetch(`get_pengguna.php?id=${id}`)
            .then(response => response.json())
            .then(data => {
                document.getElementById('edit_id_pengguna').value = data.id_pengguna;
                document.getElementById('edit_username').value = data.username;
                document.getElementById('edit_nama_lengkap').value = data.nama_lengkap;
                document.getElementById('edit_email').value = data.email;
                document.getElementById('edit_telepon').value = data.telepon;
                document.getElementById('edit_id_role').value = data.id_role;
                document.getElementById('edit_id_toko').value = data.id_toko || '';
                document.getElementById('edit_is_active').checked = data.is_active == 1;
            });
    });
});
</script>

<?php include 'footer.php'; ?>