<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
require_once 'config.php';

// Check if database connection is established
if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Fungsi untuk format mata uang
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Fungsi untuk generate nomor transaksi
function generate_no_transaksi() {
    global $conn;
    $prefix = 'TRX-' . date('Ymd') . '-';
    $query = "SELECT MAX(no_transaksi) as last_number FROM penjualan WHERE no_transaksi LIKE '$prefix%'";
    $result = mysqli_query($conn, $query);
    $data = mysqli_fetch_assoc($result);
    
    if ($data['last_number']) {
        $last_number = (int) substr($data['last_number'], strlen($prefix) + 1);
        $next_number = $last_number + 1;
    } else {
        $next_number = 1;
    }
    
    return $prefix . str_pad($next_number, 4, '0', STR_PAD_LEFT);
}

// Cek hak akses
$bisa_tambah = false;
$bisa_edit = false;
$bisa_hapus = false;

if (isset($_SESSION['id_role'])) {
    $id_role = $_SESSION['id_role'];
    $query_hak_akses = "SELECT bisa_tambah, bisa_edit, bisa_hapus FROM hak_akses WHERE id_role = $id_role AND modul = 'penjualan'";
    $result_hak_akses = mysqli_query($conn, $query_hak_akses);
    
    if ($result_hak_akses && mysqli_num_rows($result_hak_akses) > 0) {
        $hak_akses = mysqli_fetch_assoc($result_hak_akses);
        $bisa_tambah = $hak_akses['bisa_tambah'];
        $bisa_edit = $hak_akses['bisa_edit'];
        $bisa_hapus = $hak_akses['bisa_hapus'];
    }
}

// Proses filter
$where = "WHERE 1=1";
$filter_tanggal = '';
$filter_pelanggan = '';
$filter_status = '';

if (isset($_GET['filter'])) {
    // Filter tanggal
    if (!empty($_GET['tanggal_dari']) && !empty($_GET['tanggal_sampai'])) {
        $tanggal_dari = date('Y-m-d', strtotime($_GET['tanggal_dari']));
        $tanggal_sampai = date('Y-m-d', strtotime($_GET['tanggal_sampai']));
        $where .= " AND DATE(p.tanggal_penjualan) BETWEEN '$tanggal_dari' AND '$tanggal_sampai'";
        $filter_tanggal = "Tanggal: " . date('d/m/Y', strtotime($tanggal_dari)) . " - " . date('d/m/Y', strtotime($tanggal_sampai));
    }
    
    // Filter pelanggan
    if (!empty($_GET['id_pelanggan'])) {
        $id_pelanggan = (int) $_GET['id_pelanggan'];
        $where .= " AND p.id_pelanggan = $id_pelanggan";
        
        $query_pelanggan = "SELECT nama_pelanggan FROM pelanggan WHERE id_pelanggan = $id_pelanggan";
        $result_pelanggan = mysqli_query($conn, $query_pelanggan);
        if ($result_pelanggan && mysqli_num_rows($result_pelanggan) > 0) {
            $pelanggan = mysqli_fetch_assoc($result_pelanggan);
            $filter_pelanggan = "Pelanggan: " . $pelanggan['nama_pelanggan'];
        }
    }
    
    // Filter status
    if (!empty($_GET['status_pembayaran']) && in_array($_GET['status_pembayaran'], ['lunas', 'hutang', 'sebagian'])) {
        $status = $_GET['status_pembayaran'];
        $where .= " AND p.status_pembayaran = '$status'";
        $filter_status = "Status: " . ucfirst($status);
    }
}

// Query untuk mendapatkan data penjualan
$query = "SELECT p.*, pl.nama_pelanggan, mp.nama_metode, pg.nama_lengkap as nama_kasir
          FROM penjualan p
          LEFT JOIN pelanggan pl ON p.id_pelanggan = pl.id_pelanggan
          JOIN metode_pembayaran mp ON p.id_metode = mp.id_metode
          JOIN pengguna pg ON p.id_pengguna = pg.id_pengguna
          $where
          ORDER BY p.tanggal_penjualan DESC";
$result = mysqli_query($conn, $query);

// Query untuk dropdown pelanggan
$query_pelanggan = "SELECT * FROM pelanggan ORDER BY nama_pelanggan";
$result_pelanggan = mysqli_query($conn, $query_pelanggan);

// Query untuk dropdown toko
$query_toko = "SELECT * FROM toko WHERE status_aktif = 1";
$result_toko = mysqli_query($conn, $query_toko);

// Query untuk dropdown metode pembayaran
$query_metode = "SELECT * FROM metode_pembayaran WHERE is_active = 1";
$result_metode = mysqli_query($conn, $query_metode);
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Transaksi Penjualan</h1>
        <div class="d-none d-sm-inline-block">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="#">Transaksi</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Penjualan</li>
                </ol>
            </nav>
        </div>
    </div>
    
    <!-- Filter dan Tombol Tambah -->
    <div class="card mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-body">
            <form method="GET" action="penjualan.php" class="row g-3">
                <div class="col-md-3">
                    <label for="tanggal_dari" class="form-label">Dari Tanggal</label>
                    <input type="date" class="form-control" id="tanggal_dari" name="tanggal_dari" value="<?php echo isset($_GET['tanggal_dari']) ? $_GET['tanggal_dari'] : ''; ?>">
                </div>
                <div class="col-md-3">
                    <label for="tanggal_sampai" class="form-label">Sampai Tanggal</label>
                    <input type="date" class="form-control" id="tanggal_sampai" name="tanggal_sampai" value="<?php echo isset($_GET['tanggal_sampai']) ? $_GET['tanggal_sampai'] : ''; ?>">
                </div>
                <div class="col-md-3">
                    <label for="id_pelanggan" class="form-label">Pelanggan</label>
                    <select class="form-select" id="id_pelanggan" name="id_pelanggan">
                        <option value="">Semua Pelanggan</option>
                        <?php while ($pelanggan = mysqli_fetch_assoc($result_pelanggan)): ?>
                            <option value="<?php echo $pelanggan['id_pelanggan']; ?>" <?php echo (isset($_GET['id_pelanggan']) && $_GET['id_pelanggan'] == $pelanggan['id_pelanggan']) ? 'selected' : ''; ?>>
                                <?php echo $pelanggan['nama_pelanggan']; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="status_pembayaran" class="form-label">Status Pembayaran</label>
                    <select class="form-select" id="status_pembayaran" name="status_pembayaran">
                        <option value="">Semua Status</option>
                        <option value="lunas" <?php echo (isset($_GET['status_pembayaran']) && $_GET['status_pembayaran'] == 'lunas') ? 'selected' : ''; ?>>Lunas</option>
                        <option value="hutang" <?php echo (isset($_GET['status_pembayaran']) && $_GET['status_pembayaran'] == 'hutang') ? 'selected' : ''; ?>>Hutang</option>
                        <option value="sebagian" <?php echo (isset($_GET['status_pembayaran']) && $_GET['status_pembayaran'] == 'sebagian') ? 'selected' : ''; ?>>Sebagian</option>
                    </select>
                </div>
                <div class="col-12">
                    <button type="submit" name="filter" class="btn btn-primary-custom me-2">
                        <i class="fas fa-filter me-1"></i> Filter
                    </button>
                    <a href="penjualan.php" class="btn btn-secondary">
                        <i class="fas fa-sync-alt me-1"></i> Reset
                    </a>
                    <?php if ($bisa_tambah): ?>
                        <button type="button" class="btn btn-success float-end" data-bs-toggle="modal" data-bs-target="#tambahPenjualanModal">
                            <i class="fas fa-plus me-1"></i> Transaksi Baru
                        </button>
                    <?php endif; ?>
                </div>
            </form>
            
            <?php if ($filter_tanggal || $filter_pelanggan || $filter_status): ?>
                <div class="mt-3">
                    <small class="text-muted">Filter aktif: 
                        <?php echo $filter_tanggal; ?>
                        <?php echo $filter_pelanggan ? ($filter_tanggal ? ', ' : '') . $filter_pelanggan : ''; ?>
                        <?php echo $filter_status ? (($filter_tanggal || $filter_pelanggan) ? ', ' : '') . $filter_status : ''; ?>
                    </small>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Tabel Daftar Transaksi -->
    <div class="card animate-fade-in" style="animation-delay: 0.2s;">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="dataTable">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>No Transaksi</th>
                            <th>Tanggal</th>
                            <th>Pelanggan</th>
                            <th>Metode Bayar</th>
                            <th>Total</th>
                            <th>Grand Total</th>
                            <th>Dibayar</th>
                            <th>Kembalian</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result && mysqli_num_rows($result) > 0): ?>
                            <?php $no = 1; ?>
                            <?php while ($row = mysqli_fetch_assoc($result)): ?>
                                <tr>
                                    <td><?php echo $no++; ?></td>
                                    <td><?php echo $row['no_transaksi']; ?></td>
                                    <td><?php echo date('d-m-Y H:i', strtotime($row['tanggal_penjualan'])); ?></td>
                                    <td><?php echo $row['nama_pelanggan'] ?? '-'; ?></td>
                                    <td><?php echo $row['nama_metode']; ?></td>
                                    <td><?php echo format_rupiah($row['total_penjualan']); ?></td>
                                    <td><?php echo format_rupiah($row['grand_total']); ?></td>
                                    <td><?php echo format_rupiah($row['jumlah_bayar']); ?></td>
                                    <td><?php echo format_rupiah($row['kembalian']); ?></td>
                                    <td>
                                        <?php 
                                        $badge_class = '';
                                        if ($row['status_pembayaran'] == 'lunas') {
                                            $badge_class = 'bg-success';
                                        } elseif ($row['status_pembayaran'] == 'hutang') {
                                            $badge_class = 'bg-warning text-dark';
                                        } else {
                                            $badge_class = 'bg-info text-dark';
                                        }
                                        ?>
                                        <span class="badge <?php echo $badge_class; ?>">
                                            <?php echo ucfirst($row['status_pembayaran']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#detailPenjualanModal<?php echo $row['id_penjualan']; ?>">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            
                                            <?php if ($bisa_edit && $row['status_pembayaran'] != 'lunas'): ?>
                                                <a href="edit_penjualan.php?id=<?php echo $row['id_penjualan']; ?>" class="btn btn-sm btn-warning">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            <?php endif; ?>
                                            
                                            <a href="cetak_struk.php?id=<?php echo $row['id_penjualan']; ?>" target="_blank" class="btn btn-sm btn-info">
                                                <i class="fas fa-print"></i>
                                            </a>
                                            
                                            <?php if ($bisa_hapus): ?>
                                                <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#hapusPenjualanModal<?php echo $row['id_penjualan']; ?>">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <!-- Modal Detail Penjualan -->
                                        <div class="modal fade" id="detailPenjualanModal<?php echo $row['id_penjualan']; ?>" tabindex="-1" aria-labelledby="detailPenjualanModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="detailPenjualanModalLabel">Detail Transaksi <?php echo $row['no_transaksi']; ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row mb-4">
                                                            <div class="col-md-6">
                                                                <h6>Info Transaksi</h6>
                                                                <table class="table table-sm table-borderless">
                                                                    <tr>
                                                                        <th width="40%">No. Transaksi</th>
                                                                        <td>: <?php echo $row['no_transaksi']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Tanggal</th>
                                                                        <td>: <?php echo date('d-m-Y H:i', strtotime($row['tanggal_penjualan'])); ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Kasir</th>
                                                                        <td>: <?php echo $row['nama_kasir']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Metode Bayar</th>
                                                                        <td>: <?php echo $row['nama_metode']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Status</th>
                                                                        <td>: 
                                                                            <span class="badge <?php echo $badge_class; ?>">
                                                                                <?php echo ucfirst($row['status_pembayaran']); ?>
                                                                            </span>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <h6>Info Pelanggan</h6>
                                                                <table class="table table-sm table-borderless">
                                                                    <tr>
                                                                        <th width="40%">Nama</th>
                                                                        <td>: <?php echo $row['nama_pelanggan'] ?? '-'; ?></td>
                                                                    </tr>
                                                                    <?php if (!empty($row['nama_pelanggan'])): ?>
                                                                        <?php 
                                                                        $query_pelanggan_detail = "SELECT * FROM pelanggan WHERE id_pelanggan = " . $row['id_pelanggan'];
                                                                        $result_pelanggan_detail = mysqli_query($conn, $query_pelanggan_detail);
                                                                        if ($result_pelanggan_detail && mysqli_num_rows($result_pelanggan_detail) > 0) {
                                                                            $pelanggan_detail = mysqli_fetch_assoc($result_pelanggan_detail);
                                                                        ?>
                                                                            <tr>
                                                                                <th>Telepon</th>
                                                                                <td>: <?php echo $pelanggan_detail['telepon'] ?? '-'; ?></td>
                                                                            </tr>
                                                                            <tr>
                                                                                <th>Alamat</th>
                                                                                <td>: <?php echo $pelanggan_detail['alamat'] ?? '-'; ?></td>
                                                                            </tr>
                                                                        <?php } ?>
                                                                    <?php endif; ?>
                                                                </table>
                                                            </div>
                                                        </div>
                                                        
                                                        <h6>Rincian Barang</h6>
                                                        <div class="table-responsive">
                                                            <table class="table table-sm table-bordered">
                                                                <thead>
                                                                    <tr>
                                                                        <th>No</th>
                                                                        <th>Nama Barang</th>
                                                                        <th>Harga</th>
                                                                        <th>Jumlah</th>
                                                                        <th>Diskon</th>
                                                                        <th>Subtotal</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php 
                                                                    $query_detail = "SELECT dp.*, b.nama_barang 
                                                                                    FROM detail_penjualan dp
                                                                                    JOIN barang b ON dp.id_barang = b.id_barang
                                                                                    WHERE dp.id_penjualan = " . $row['id_penjualan'];
                                                                    $result_detail = mysqli_query($conn, $query_detail);
                                                                    $no_detail = 1;
                                                                    ?>
                                                                    <?php while ($detail = mysqli_fetch_assoc($result_detail)): ?>
                                                                        <tr>
                                                                            <td><?php echo $no_detail++; ?></td>
                                                                            <td><?php echo $detail['nama_barang']; ?></td>
                                                                            <td><?php echo format_rupiah($detail['harga_jual']); ?></td>
                                                                            <td><?php echo $detail['jumlah']; ?></td>
                                                                            <td><?php echo format_rupiah($detail['diskon_item']); ?></td>
                                                                            <td><?php echo format_rupiah($detail['subtotal']); ?></td>
                                                                        </tr>
                                                                    <?php endwhile; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                        
                                                        <div class="row mt-3">
                                                            <div class="col-md-6">
                                                                <p class="mb-1"><strong>Catatan:</strong></p>
                                                                <p><?php echo $row['catatan'] ? $row['catatan'] : '-'; ?></p>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <table class="table table-sm table-borderless float-end">
                                                                    <tr>
                                                                        <th>Total Penjualan</th>
                                                                        <td>: <?php echo format_rupiah($row['total_penjualan']); ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Diskon</th>
                                                                        <td>: <?php echo format_rupiah($row['diskon']); ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>PPN</th>
                                                                        <td>: <?php echo format_rupiah($row['ppn']); ?></td>
                                                                    </tr>
                                                                    <tr class="table-active">
                                                                        <th>Grand Total</th>
                                                                        <td>: <?php echo format_rupiah($row['grand_total']); ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Dibayar</th>
                                                                        <td>: <?php echo format_rupiah($row['jumlah_bayar']); ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Kembalian</th>
                                                                        <td>: <?php echo format_rupiah($row['kembalian']); ?></td>
                                                                    </tr>
                                                                    <?php if ($row['status_pembayaran'] != 'lunas'): ?>
                                                                        <tr>
                                                                            <th>Sisa Hutang</th>
                                                                            <td>: <?php echo format_rupiah($row['sisa_hutang']); ?></td>
                                                                        </tr>
                                                                    <?php endif; ?>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                                        <a href="cetak_struk.php?id=<?php echo $row['id_penjualan']; ?>" target="_blank" class="btn btn-primary">
                                                            <i class="fas fa-print me-1"></i> Cetak Struk
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Modal Hapus Penjualan -->
                                        <div class="modal fade" id="hapusPenjualanModal<?php echo $row['id_penjualan']; ?>" tabindex="-1" aria-labelledby="hapusPenjualanModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="hapusPenjualanModalLabel">Hapus Transaksi</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>Apakah Anda yakin ingin menghapus transaksi <strong><?php echo $row['no_transaksi']; ?></strong>?</p>
                                                        <p class="text-danger">Data yang dihapus tidak dapat dikembalikan!</p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                        <form action="proses_hapus_penjualan.php" method="POST">
                                                            <input type="hidden" name="id_penjualan" value="<?php echo $row['id_penjualan']; ?>">
                                                            <button type="submit" class="btn btn-danger">Hapus</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="11" class="text-center">Tidak ada data transaksi penjualan</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Tambah Penjualan -->
<div class="modal fade" id="tambahPenjualanModal" tabindex="-1" aria-labelledby="tambahPenjualanModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <form id="formPenjualan" action="proses_tambah_penjualan.php" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title" id="tambahPenjualanModalLabel">Transaksi Penjualan Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="no_transaksi" class="form-label">No. Transaksi</label>
                                <input type="text" class="form-control" id="no_transaksi" name="no_transaksi" value="<?php echo generate_no_transaksi(); ?>" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tanggal_penjualan" class="form-label">Tanggal Penjualan</label>
                                <input type="datetime-local" class="form-control" id="tanggal_penjualan" name="tanggal_penjualan" value="<?php echo date('Y-m-d\TH:i'); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="id_toko" class="form-label">Toko</label>
                                <select class="form-select" id="id_toko" name="id_toko" required>
                                    <option value="">Pilih Toko</option>
                                    <?php 
                                    mysqli_data_seek($result_toko, 0); // Reset pointer result toko
                                    while ($toko = mysqli_fetch_assoc($result_toko)): ?>
                                        <option value="<?php echo $toko['id_toko']; ?>"><?php echo $toko['nama_toko']; ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="id_pelanggan" class="form-label">Pelanggan (Opsional)</label>
                                <select class="form-select" id="id_pelanggan" name="id_pelanggan">
                                    <option value="">Pilih Pelanggan</option>
                                    <?php 
                                    mysqli_data_seek($result_pelanggan, 0); // Reset pointer result pelanggan
                                    while ($pelanggan = mysqli_fetch_assoc($result_pelanggan)): ?>
                                        <option value="<?php echo $pelanggan['id_pelanggan']; ?>"><?php echo $pelanggan['nama_pelanggan']; ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="id_metode" class="form-label">Metode Pembayaran</label>
                                <select class="form-select" id="id_metode" name="id_metode" required>
                                    <option value="">Pilih Metode</option>
                                    <?php 
                                    mysqli_data_seek($result_metode, 0); // Reset pointer result metode
                                    while ($metode = mysqli_fetch_assoc($result_metode)): ?>
                                        <option value="<?php echo $metode['id_metode']; ?>"><?php echo $metode['nama_metode']; ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="catatan" class="form-label">Catatan (Opsional)</label>
                                <textarea class="form-control" id="catatan" name="catatan" rows="1"></textarea>
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <h5 class="mb-3">Daftar Barang</h5>
                    
                    <div class="row mb-3">
                        <div class="col-md-8">
                            <label for="cari_barang" class="form-label">Cari Barang</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="cari_barang" placeholder="Kode atau nama barang">
                                <button class="btn btn-outline-secondary" type="button" id="btnCariBarang">
                                    <i class="fas fa-search"></i>
                                </button>
                            </div>
                            <div id="hasilPencarianBarang" class="position-absolute w-100 bg-white z-index-1 d-none" style="max-height: 200px; overflow-y: auto;">
                                <!-- Hasil pencarian akan muncul di sini -->
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label for="jumlah" class="form-label">Jumlah</label>
                            <input type="number" class="form-control" id="jumlah" min="1" value="1">
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered" id="tabelBarang">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="35%">Nama Barang</th>
                                    <th width="15%">Harga Jual</th>
                                    <th width="10%">Jumlah</th>
                                    <th width="15%">Diskon</th>
                                    <th width="20%">Subtotal</th>
                                    <th width="5%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody id="daftarBarang">
                                <!-- Daftar barang akan muncul di sini -->
                                <tr id="barangKosong">
                                    <td colspan="7" class="text-center">Belum ada barang ditambahkan</td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="5" class="text-end"><strong>Total</strong></td>
                                    <td id="totalPenjualan">Rp 0</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-end"><strong>Diskon</strong></td>
                                    <td>
                                        <input type="number" class="form-control form-control-sm" id="diskon" name="diskon" min="0" value="0">
                                    </td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-end"><strong>PPN</strong></td>
                                    <td>
                                        <input type="number" class="form-control form-control-sm" id="ppn" name="ppn" min="0" value="0">
                                    </td>
                                    <td></td>
                                </tr>
                                <tr class="table-active">
                                    <td colspan="5" class="text-end"><strong>Grand Total</strong></td>
                                    <td id="grandTotal">Rp 0</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-end"><strong>Jumlah Bayar</strong></td>
                                    <td>
                                        <input type="number" class="form-control form-control-sm" id="jumlahBayar" name="jumlah_bayar" min="0" value="0" required>
                                    </td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-end"><strong>Kembalian</strong></td>
                                    <td id="kembalian">Rp 0</td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    
                    <input type="hidden" id="statusPembayaran" name="status_pembayaran" value="lunas">
                    <input type="hidden" id="sisaHutang" name="sisa_hutang" value="0">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan Transaksi</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Script untuk penjualan -->
<script>
$(document).ready(function() {
    // Variabel untuk menyimpan data barang
    let daftarBarang = [];
    let counterBarang = 1;
    
    // Fungsi untuk menghitung total, grand total, kembalian, dll
    function hitungTotal() {
        let total = 0;
        
        // Hitung total dari daftar barang
        daftarBarang.forEach(barang => {
            total += barang.subtotal;
        });
        
        // Update total penjualan
        $('#totalPenjualan').text(formatRupiah(total));
        
        // Hitung diskon dan ppn
        const diskon = parseFloat($('#diskon').val()) || 0;
        const ppn = parseFloat($('#ppn').val()) || 0;
        
        // Hitung grand total
        const grandTotal = total - diskon + ppn;
        $('#grandTotal').text(formatRupiah(grandTotal));
        
        // Hitung kembalian
        const jumlahBayar = parseFloat($('#jumlahBayar').val()) || 0;
        const kembalian = jumlahBayar - grandTotal;
        
        if (kembalian >= 0) {
            $('#kembalian').text(formatRupiah(kembalian));
            $('#statusPembayaran').val('lunas');
            $('#sisaHutang').val('0');
        } else {
            $('#kembalian').text(formatRupiah(0));
            $('#statusPembayaran').val('hutang');
            $('#sisaHutang').val(Math.abs(kembalian).toFixed(2));
        }
    }
    
    // Fungsi untuk format rupiah
    function formatRupiah(angka) {
        return 'Rp ' + angka.toLocaleString('id-ID');
    }
    
    // Fungsi untuk menambahkan barang ke tabel
    function tambahBarangKeTabel(barang) {
        // Hilangkan pesan barang kosong jika ada
        $('#barangKosong').remove();
        
        // Tambahkan row baru ke tabel
        const rowId = 'barang-' + counterBarang;
        const newRow = `
            <tr id="${rowId}">
                <td>${counterBarang}</td>
                <td>
                    ${barang.nama_barang}
                    <input type="hidden" name="id_barang[]" value="${barang.id_barang}">
                    <input type="hidden" name="harga_jual[]" value="${barang.harga_jual}">
                </td>
                <td>${formatRupiah(barang.harga_jual)}</td>
                <td>
                    <input type="number" class="form-control form-control-sm jumlah" name="jumlah[]" min="1" value="${barang.jumlah}" data-row="${rowId}">
                </td>
                <td>
                    <input type="number" class="form-control form-control-sm diskon" name="diskon_item[]" min="0" value="${barang.diskon_item}" data-row="${rowId}">
                </td>
                <td class="subtotal">${formatRupiah(barang.subtotal)}</td>
                <td>
                    <button type="button" class="btn btn-sm btn-danger hapus-barang" data-row="${rowId}">
                        <i class="fas fa-trash"></i>
                    </button>
                </td>
            </tr>
        `;
        
        $('#daftarBarang').append(newRow);
        counterBarang++;
    }
    
    // Event listener untuk pencarian barang
    $('#btnCariBarang').click(function() {
        const keyword = $('#cari_barang').val().trim();
        
        if (keyword.length < 2) {
            alert('Masukkan minimal 2 karakter untuk pencarian');
            return;
        }
        
        $.ajax({
            url: 'ajax_cari_barang.php',
            type: 'GET',
            data: { keyword: keyword },
            dataType: 'json',
            success: function(response) {
                const hasilPencarian = $('#hasilPencarianBarang');
                hasilPencarian.empty();
                
                if (response.length > 0) {
                    response.forEach(barang => {
                        // Cek apakah barang sudah ada di daftar
                        const sudahAda = daftarBarang.some(item => item.id_barang == barang.id_barang);
                        
                        if (!sudahAda) {
                            hasilPencarian.append(`
                                <div class="list-group-item list-group-item-action p-2" 
                                     data-id="${barang.id_barang}" 
                                     data-nama="${barang.nama_barang}" 
                                     data-harga="${barang.harga_jual}">
                                    ${barang.nama_barang} - ${formatRupiah(barang.harga_jual)}
                                    ${barang.stok ? '<span class="badge bg-info float-end">Stok: ' + barang.stok + '</span>' : ''}
                                </div>
                            `);
                        }
                    });
                    
                    if (hasilPencarian.children().length === 0) {
                        hasilPencarian.append('<div class="list-group-item p-2">Semua barang sudah ditambahkan</div>');
                    }
                    
                    hasilPencarian.removeClass('d-none');
                } else {
                    hasilPencarian.append('<div class="list-group-item p-2">Barang tidak ditemukan</div>');
                    hasilPencarian.removeClass('d-none');
                }
            },
            error: function() {
                alert('Terjadi kesalahan saat mencari barang');
            }
        });
    });
    
    // Event listener untuk memilih barang dari hasil pencarian
    $(document).on('click', '#hasilPencarianBarang .list-group-item', function() {
        const idBarang = $(this).data('id');
        const namaBarang = $(this).data('nama');
        const hargaJual = parseFloat($(this).data('harga'));
        const jumlah = parseInt($('#jumlah').val()) || 1;
        
        // Tambahkan barang ke array daftarBarang
        const barang = {
            id_barang: idBarang,
            nama_barang: namaBarang,
            harga_jual: hargaJual,
            jumlah: jumlah,
            diskon_item: 0,
            subtotal: hargaJual * jumlah
        };
        
        daftarBarang.push(barang);
        
        // Tambahkan barang ke tabel
        tambahBarangKeTabel(barang);
        
        // Hitung ulang total
        hitungTotal();
        
        // Reset form pencarian
        $('#cari_barang').val('');
        $('#jumlah').val('1');
        $('#hasilPencarianBarang').addClass('d-none').empty();
    });
    
    // Event listener untuk menghapus barang dari tabel
    $(document).on('click', '.hapus-barang', function() {
        const rowId = $(this).data('row');
        
        // Hapus barang dari array daftarBarang
        const index = daftarBarang.findIndex(item => 'barang-' + daftarBarang.indexOf(item) + 1 === rowId);
        if (index !== -1) {
            daftarBarang.splice(index, 1);
        }
        
        // Hapus row dari tabel
        $('#' + rowId).remove();
        
        // Jika tidak ada barang, tampilkan pesan
        if (daftarBarang.length === 0) {
            $('#daftarBarang').html('<tr id="barangKosong"><td colspan="7" class="text-center">Belum ada barang ditambahkan</td></tr>');
        } else {
            // Update nomor urut
            $('#daftarBarang tr').each(function(index) {
                $(this).find('td:first').text(index + 1);
            });
        }
        
        // Hitung ulang total
        hitungTotal();
    });
    
    // Event listener untuk perubahan jumlah atau diskon barang
    $(document).on('change', '.jumlah, .diskon', function() {
        const rowId = $(this).data('row');
        const index = parseInt(rowId.split('-')[1]) - 1;
        
        if (index >= 0 && index < daftarBarang.length) {
            const jumlah = parseFloat($(this).closest('tr').find('.jumlah').val()) || 0;
            const diskon = parseFloat($(this).closest('tr').find('.diskon').val()) || 0;
            const hargaJual = daftarBarang[index].harga_jual;
            
            // Update data di array
            daftarBarang[index].jumlah = jumlah;
            daftarBarang[index].diskon_item = diskon;
            daftarBarang[index].subtotal = (hargaJual * jumlah) - diskon;
            
            // Update subtotal di tabel
            $(this).closest('tr').find('.subtotal').text(formatRupiah(daftarBarang[index].subtotal));
            
            // Hitung ulang total
            hitungTotal();
        }
    });
    
    // Event listener untuk perubahan diskon, ppn, atau jumlah bayar
    $('#diskon, #ppn, #jumlahBayar').on('change keyup', function() {
        hitungTotal();
    });
    
    // Validasi form sebelum submit
    $('#formPenjualan').submit(function(e) {
        if (daftarBarang.length === 0) {
            e.preventDefault();
            alert('Minimal harus ada 1 barang dalam transaksi');
            return false;
        }
        
        const jumlahBayar = parseFloat($('#jumlahBayar').val()) || 0;
        const grandTotal = parseFloat($('#grandTotal').text().replace(/[^0-9]/g, '')) || 0;
        
        if (jumlahBayar <= 0) {
            e.preventDefault();
            alert('Jumlah bayar harus lebih dari 0');
            return false;
        }
        
        // Jika metode pembayaran adalah hutang, pastikan pelanggan dipilih
        if ($('#statusPembayaran').val() === 'hutang' && !$('#id_pelanggan').val()) {
            e.preventDefault();
            alert('Untuk transaksi hutang, pelanggan harus dipilih');
            return false;
        }
        
        return true;
    });
    
    // Tutup hasil pencarian saat klik di luar
    $(document).click(function(e) {
        if (!$(e.target).closest('#hasilPencarianBarang').length && !$(e.target).is('#cari_barang, #btnCariBarang')) {
            $('#hasilPencarianBarang').addClass('d-none');
        }
    });
});
</script>

<?php include 'footer.php'; ?>