<?php 
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
require_once 'config.php';

// Periksa apakah pengguna sudah login
if (!isset($_SESSION['id_pengguna'])) {
    header("Location: login.php");
    exit();
}

// Ambil data pengguna yang sedang login
$id_pengguna = $_SESSION['id_pengguna'];
$query = "SELECT p.*, r.nama_role, t.nama_toko 
          FROM pengguna p
          JOIN role r ON p.id_role = r.id_role
          LEFT JOIN toko t ON p.id_toko = t.id_toko
          WHERE p.id_pengguna = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_pengguna);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$user_data = mysqli_fetch_assoc($result);

// Format tanggal bergabung
$tanggal_bergabung = date('d F Y', strtotime($user_data['created_at']));
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Profil Pengguna</h1>
        <a href="pengaturan.php" class="d-none d-sm-inline-block btn btn-sm btn-primary-custom">
            <i class="fas fa-cog fa-sm"></i> Pengaturan Akun
        </a>
    </div>
    
    <div class="row">
        <!-- Kolom Foto Profil -->
        <div class="col-lg-4 mb-4">
            <div class="card shadow animate-fade-in" style="animation-delay: 0.1s;">
                <div class="card-header py-3 bg-success text-white">
                    <h6 class="m-0 font-weight-bold">Foto Profil</h6>
                </div>
                <div class="card-body text-center">
                    <img src="<?php echo $user_data['foto_profil'] ? 'uploads/profil/'.$user_data['foto_profil'] : 'assets/img/undraw_profile.svg'; ?>" 
                         class="img-fluid rounded-circle mb-3" 
                         style="width: 200px; height: 200px; object-fit: cover; border: 5px solid #e9ecef;"
                         alt="Foto Profil">
                    
                    <h4 class="text-gray-800"><?php echo htmlspecialchars($user_data['nama_lengkap']); ?></h4>
                    <span class="badge bg-success"><?php echo htmlspecialchars($user_data['nama_role']); ?></span>
                    
                    <?php if ($user_data['id_toko']): ?>
                        <p class="mt-2 mb-1">
                            <i class="fas fa-store text-primary-custom"></i> 
                            <?php echo htmlspecialchars($user_data['nama_toko']); ?>
                        </p>
                    <?php endif; ?>
                    
                    <p class="text-muted small mt-3">
                        <i class="fas fa-calendar-alt text-primary-custom"></i> 
                        Bergabung sejak <?php echo $tanggal_bergabung; ?>
                    </p>
                </div>
            </div>
            
            <div class="card shadow mt-4 animate-fade-in" style="animation-delay: 0.2s;">
                <div class="card-header py-3 bg-success text-white">
                    <h6 class="m-0 font-weight-bold">Statistik Aktivitas</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <h6 class="small font-weight-bold text-gray-800 mb-1">Login Terakhir</h6>
                        <p>
                            <?php echo $user_data['last_login'] ? date('d F Y H:i', strtotime($user_data['last_login'])) : 'Belum pernah login'; ?>
                        </p>
                    </div>
                    
                    <?php 
                    // Query untuk statistik aktivitas
                    $query_penjualan = "SELECT COUNT(*) as total FROM penjualan WHERE id_pengguna = ?";
                    $stmt = mysqli_prepare($conn, $query_penjualan);
                    mysqli_stmt_bind_param($stmt, "i", $id_pengguna);
                    mysqli_stmt_execute($stmt);
                    $result = mysqli_stmt_get_result($stmt);
                    $total_penjualan = mysqli_fetch_assoc($result)['total'];
                    ?>
                    
                    <div class="mb-3">
                        <h6 class="small font-weight-bold text-gray-800 mb-1">Total Transaksi</h6>
                        <p><?php echo $total_penjualan; ?> transaksi</p>
                    </div>
                    
                    <?php 
                    // Query untuk total nilai penjualan
                    $query_total_penjualan = "SELECT COALESCE(SUM(grand_total), 0) as total FROM penjualan 
                                             WHERE id_pengguna = ? AND status_pembayaran != 'dibatalkan'";
                    $stmt = mysqli_prepare($conn, $query_total_penjualan);
                    mysqli_stmt_bind_param($stmt, "i", $id_pengguna);
                    mysqli_stmt_execute($stmt);
                    $result = mysqli_stmt_get_result($stmt);
                    $total_nilai_penjualan = mysqli_fetch_assoc($result)['total'];
                    ?>
                    
                    <div class="mb-3">
                        <h6 class="small font-weight-bold text-gray-800 mb-1">Total Nilai Penjualan</h6>
                        <p>Rp <?php echo number_format($total_nilai_penjualan, 0, ',', '.'); ?></p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Kolom Informasi Pengguna -->
        <div class="col-lg-8 mb-4">
            <div class="card shadow animate-fade-in" style="animation-delay: 0.3s;">
                <div class="card-header py-3 bg-success text-white">
                    <h6 class="m-0 font-weight-bold">Informasi Pengguna</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <h6 class="small font-weight-bold text-gray-800 mb-1">Nama Lengkap</h6>
                            <p><?php echo htmlspecialchars($user_data['nama_lengkap']); ?></p>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <h6 class="small font-weight-bold text-gray-800 mb-1">Username</h6>
                            <p><?php echo htmlspecialchars($user_data['username']); ?></p>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <h6 class="small font-weight-bold text-gray-800 mb-1">Email</h6>
                            <p><?php echo $user_data['email'] ? htmlspecialchars($user_data['email']) : '-'; ?></p>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <h6 class="small font-weight-bold text-gray-800 mb-1">Nomor Telepon</h6>
                            <p><?php echo $user_data['telepon'] ? htmlspecialchars($user_data['telepon']) : '-'; ?></p>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <h6 class="small font-weight-bold text-gray-800 mb-1">Status Akun</h6>
                            <p>
                                <span class="badge bg-<?php echo $user_data['is_active'] ? 'success' : 'danger'; ?>">
                                    <?php echo $user_data['is_active'] ? 'Aktif' : 'Nonaktif'; ?>
                                </span>
                            </p>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <h6 class="small font-weight-bold text-gray-800 mb-1">Hak Akses</h6>
                            <p><?php echo htmlspecialchars($user_data['nama_role']); ?></p>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <h5 class="font-weight-bold text-gray-800 mb-3">Informasi Toko</h5>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <h6 class="small font-weight-bold text-gray-800 mb-1">Nama Toko</h6>
                            <p><?php echo $user_data['nama_toko'] ? htmlspecialchars($user_data['nama_toko']) : '-'; ?></p>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <h6 class="small font-weight-bold text-gray-800 mb-1">ID Toko</h6>
                            <p><?php echo $user_data['id_toko'] ? $user_data['id_toko'] : '-'; ?></p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Riwayat Login Terakhir -->
            <div class="card shadow mt-4 animate-fade-in" style="animation-delay: 0.4s;">
                <div class="card-header py-3 bg-success text-white">
                    <h6 class="m-0 font-weight-bold">Riwayat Login Terakhir</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Tanggal</th>
                                    <th>Waktu</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
            // Query hanya dari kolom last_login di tabel pengguna
            $query_login = "SELECT last_login FROM pengguna WHERE id_pengguna = ?";
            $stmt = mysqli_prepare($conn, $query_login);
            mysqli_stmt_bind_param($stmt, "i", $id_pengguna);
            mysqli_stmt_execute($stmt);
            $result = mysqli_stmt_get_result($stmt);
            ?>

            <tbody>
            <?php
            if ($row = mysqli_fetch_assoc($result)) {
                if ($row['last_login']) {
                    echo '<tr>';
                    echo '<td>' . date('d M Y', strtotime($row['last_login'])) . '</td>';
                    echo '<td>' . date('H:i:s', strtotime($row['last_login'])) . '</td>';
                    echo '<td><span class="badge bg-success">Success</span></td>';
                    echo '</tr>';
                } else {
                    echo '<tr><td colspan="3" class="text-center">Belum pernah login</td></tr>';
                }
            } else {
                echo '<tr><td colspan="3" class="text-center">Gagal mengambil data login</td></tr>';
            }
            ?>
            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include 'footer.php'; ?>