<?php
session_start();
require_once 'config.php';

// Cek koneksi database
if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Cek apakah request POST
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    die("Invalid request method");
}

// Cek apakah user sudah login
if (!isset($_SESSION['id_pengguna'])) {
    die("Anda harus login terlebih dahulu");
}

// Cek hak akses
if (!isset($_SESSION['id_role']) || !checkAccess($_SESSION['id_role'], 'penjualan', 'bisa_edit')) {
    die("Anda tidak memiliki hak akses untuk mengedit transaksi");
}

// Ambil data dari form
$id_penjualan = (int)$_POST['id_penjualan'];
$tanggal_penjualan = mysqli_real_escape_string($conn, $_POST['tanggal_penjualan']);
$id_toko = (int)$_POST['id_toko'];
$id_pelanggan = !empty($_POST['id_pelanggan']) ? (int)$_POST['id_pelanggan'] : NULL;
$id_metode = (int)$_POST['id_metode'];
$total_penjualan = (float)str_replace(['Rp', '.', ','], '', $_POST['total_penjualan']);
$diskon = (float)$_POST['diskon'];
$ppn = (float)$_POST['ppn'];
$grand_total = (float)str_replace(['Rp', '.', ','], '', $_POST['grand_total']);
$jumlah_bayar = (float)$_POST['jumlah_bayar'];
$kembalian = (float)str_replace(['Rp', '.', ','], '', $_POST['kembalian']);
$status_pembayaran = mysqli_real_escape_string($conn, $_POST['status_pembayaran']);
$sisa_hutang = (float)$_POST['sisa_hutang'];
$catatan = mysqli_real_escape_string($conn, $_POST['catatan']);

// Mulai transaksi
mysqli_begin_transaction($conn);

try {
    // 1. Update data penjualan
    $query_update = "UPDATE penjualan SET
                    tanggal_penjualan = ?,
                    id_toko = ?,
                    id_pelanggan = ?,
                    id_metode = ?,
                    total_penjualan = ?,
                    diskon = ?,
                    ppn = ?,
                    grand_total = ?,
                    jumlah_bayar = ?,
                    kembalian = ?,
                    status_pembayaran = ?,
                    sisa_hutang = ?,
                    catatan = ?
                    WHERE id_penjualan = ?";
    
    $stmt_update = mysqli_prepare($conn, $query_update);
    mysqli_stmt_bind_param($stmt_update, "siisddddddssi", 
        $tanggal_penjualan, $id_toko, $id_pelanggan, $id_metode,
        $total_penjualan, $diskon, $ppn, $grand_total,
        $jumlah_bayar, $kembalian, $status_pembayaran, $sisa_hutang, $catatan,
        $id_penjualan
    );
    
    if (!mysqli_stmt_execute($stmt_update)) {
        throw new Exception("Gagal update data penjualan: " . mysqli_error($conn));
    }
    
    // 2. Hapus detail penjualan lama dan update stok
    $query_detail_lama = "SELECT id_barang, jumlah FROM detail_penjualan WHERE id_penjualan = ?";
    $stmt_detail_lama = mysqli_prepare($conn, $query_detail_lama);
    mysqli_stmt_bind_param($stmt_detail_lama, "i", $id_penjualan);
    mysqli_stmt_execute($stmt_detail_lama);
    $result_detail_lama = mysqli_stmt_get_result($stmt_detail_lama);
    
    while ($detail_lama = mysqli_fetch_assoc($result_detail_lama)) {
        $query_update_stok = "UPDATE stok_toko 
                             SET stok_keluar = stok_keluar - ?,
                                 stok_akhir = stok_awal + stok_masuk - (stok_keluar - ?)
                             WHERE id_barang = ? AND id_toko = ?";
        
        $stmt_update_stok = mysqli_prepare($conn, $query_update_stok);
        mysqli_stmt_bind_param($stmt_update_stok, "iiii", 
            $detail_lama['jumlah'], $detail_lama['jumlah'], $detail_lama['id_barang'], $id_toko
        );
        
        if (!mysqli_stmt_execute($stmt_update_stok)) {
            throw new Exception("Gagal update stok barang: " . mysqli_error($conn));
        }
    }
    
    // Hapus detail penjualan lama
    $query_hapus_detail = "DELETE FROM detail_penjualan WHERE id_penjualan = ?";
    $stmt_hapus_detail = mysqli_prepare($conn, $query_hapus_detail);
    mysqli_stmt_bind_param($stmt_hapus_detail, "i", $id_penjualan);
    mysqli_stmt_execute($stmt_hapus_detail);
    
    // 3. Simpan detail penjualan baru dan update stok
    if (!isset($_POST['id_barang']) || !is_array($_POST['id_barang'])) {
        throw new Exception("Tidak ada barang dalam transaksi");
    }
    
    $id_barang_array = $_POST['id_barang'];
    $jumlah_array = $_POST['jumlah'];
    $harga_jual_array = $_POST['harga_jual'];
    $diskon_item_array = $_POST['diskon_item'];
    
    for ($i = 0; $i < count($id_barang_array); $i++) {
        $id_barang = (int)$id_barang_array[$i];
        $jumlah = (int)$jumlah_array[$i];
        $harga_jual = (float)$harga_jual_array[$i];
        $diskon_item = (float)$diskon_item_array[$i];
        $subtotal = ($harga_jual * $jumlah) - $diskon_item;
        
        // Simpan detail penjualan
        $query_detail = "INSERT INTO detail_penjualan (
            id_penjualan, id_barang, jumlah, harga_jual, diskon_item, subtotal
        ) VALUES (?, ?, ?, ?, ?, ?)";
        
        $stmt_detail = mysqli_prepare($conn, $query_detail);
        mysqli_stmt_bind_param($stmt_detail, "iiiddd", $id_penjualan, $id_barang, $jumlah, $harga_jual, $diskon_item, $subtotal);
        
        if (!mysqli_stmt_execute($stmt_detail)) {
            throw new Exception("Gagal menyimpan detail penjualan: " . mysqli_error($conn));
        }
        
        // Update stok barang
        $query_stok = "UPDATE stok_toko 
                      SET stok_keluar = stok_keluar + ?, 
                          stok_akhir = stok_awal + stok_masuk - (stok_keluar + ?)
                      WHERE id_barang = ? AND id_toko = ?";
        
        $stmt_stok = mysqli_prepare($conn, $query_stok);
        mysqli_stmt_bind_param($stmt_stok, "iiii", $jumlah, $jumlah, $id_barang, $id_toko);
        
        if (!mysqli_stmt_execute($stmt_stok)) {
            throw new Exception("Gagal update stok barang: " . mysqli_error($conn));
        }
        
        // Cek apakah stok cukup
        $query_cek_stok = "SELECT stok_akhir FROM stok_toko WHERE id_barang = ? AND id_toko = ?";
        $stmt_cek_stok = mysqli_prepare($conn, $query_cek_stok);
        mysqli_stmt_bind_param($stmt_cek_stok, "ii", $id_barang, $id_toko);
        mysqli_stmt_execute($stmt_cek_stok);
        $result_cek_stok = mysqli_stmt_get_result($stmt_cek_stok);
        $stok = mysqli_fetch_assoc($result_cek_stok);
        
        if ($stok['stok_akhir'] < 0) {
            throw new Exception("Stok barang tidak mencukupi");
        }
    }
    
    // 4. Update atau buat hutang pelanggan jika status hutang
    if ($status_pembayaran == 'hutang' && $id_pelanggan) {
        // Cek apakah sudah ada hutang untuk transaksi ini
        $query_cek_hutang = "SELECT id_hutang FROM hutang_pelanggan WHERE id_penjualan = ?";
        $stmt_cek_hutang = mysqli_prepare($conn, $query_cek_hutang);
        mysqli_stmt_bind_param($stmt_cek_hutang, "i", $id_penjualan);
        mysqli_stmt_execute($stmt_cek_hutang);
        $result_cek_hutang = mysqli_stmt_get_result($stmt_cek_hutang);
        
        if (mysqli_num_rows($result_cek_hutang) > 0) {
            // Update hutang yang sudah ada
            $query_update_hutang = "UPDATE hutang_pelanggan SET
                                  id_pelanggan = ?,
                                  jumlah_hutang = ?,
                                  jumlah_bayar = ?,
                                  sisa_hutang = ?,
                                  status = 'belum_lunas'
                                  WHERE id_penjualan = ?";
            
            $stmt_update_hutang = mysqli_prepare($conn, $query_update_hutang);
            mysqli_stmt_bind_param($stmt_update_hutang, "idddi", 
                $id_pelanggan, $grand_total, $jumlah_bayar, $sisa_hutang, $id_penjualan
            );
            
            if (!mysqli_stmt_execute($stmt_update_hutang)) {
                throw new Exception("Gagal update data hutang: " . mysqli_error($conn));
            }
        } else {
            // Buat hutang baru
            $query_hutang = "INSERT INTO hutang_pelanggan (
                id_penjualan, id_pelanggan, tanggal_hutang, tanggal_jatuh_tempo,
                jumlah_hutang, jumlah_bayar, sisa_hutang, status
            ) VALUES (?, ?, ?, DATE_ADD(?, INTERVAL 30 DAY), ?, ?, ?, 'belum_lunas')";
            
            $stmt_hutang = mysqli_prepare($conn, $query_hutang);
            mysqli_stmt_bind_param($stmt_hutang, "iissddd", 
                $id_penjualan, $id_pelanggan, $tanggal_penjualan, $tanggal_penjualan,
                $grand_total, $jumlah_bayar, $sisa_hutang
            );
            
            if (!mysqli_stmt_execute($stmt_hutang)) {
                throw new Exception("Gagal menyimpan data hutang: " . mysqli_error($conn));
            }
        }
    } else {
        // Hapus hutang jika status bukan hutang
        $query_hapus_hutang = "DELETE FROM hutang_pelanggan WHERE id_penjualan = ?";
        $stmt_hapus_hutang = mysqli_prepare($conn, $query_hapus_hutang);
        mysqli_stmt_bind_param($stmt_hapus_hutang, "i", $id_penjualan);
        mysqli_stmt_execute($stmt_hapus_hutang);
    }
    
    // Commit transaksi jika semua berhasil
    mysqli_commit($conn);
    
    // Redirect ke halaman detail penjualan
    header("Location: detail_penjualan.php?id=$id_penjualan");
    exit();
    
} catch (Exception $e) {
    // Rollback transaksi jika ada error
    mysqli_rollback($conn);
    
    // Tampilkan error
    die("Error: " . $e->getMessage());
}

// Fungsi untuk cek hak akses
function checkAccess($id_role, $modul, $akses) {
    global $conn;
    
    $query = "SELECT $akses FROM hak_akses WHERE id_role = ? AND modul = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "is", $id_role, $modul);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        return (bool)$row[$akses];
    }
    
    return false;
}
?>