<?php
session_start();
require_once 'config.php';

// Cek koneksi database
if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Cek apakah request POST
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    die("Invalid request method");
}

// Cek apakah user sudah login
if (!isset($_SESSION['id_pengguna'])) {
    die("Anda harus login terlebih dahulu");
}

// Cek hak akses
if (!isset($_SESSION['id_role']) || !checkAccess($_SESSION['id_role'], 'penjualan', 'bisa_hapus')) {
    die("Anda tidak memiliki hak akses untuk menghapus transaksi");
}

// Ambil ID penjualan
$id_penjualan = (int)$_POST['id_penjualan'];

if ($id_penjualan <= 0) {
    die("ID penjualan tidak valid");
}

// Mulai transaksi
mysqli_begin_transaction($conn);

try {
    // 1. Dapatkan detail penjualan untuk update stok
    $query_detail = "SELECT id_barang, jumlah, id_toko 
                    FROM detail_penjualan dp
                    JOIN penjualan p ON dp.id_penjualan = p.id_penjualan
                    WHERE dp.id_penjualan = ?";
    
    $stmt_detail = mysqli_prepare($conn, $query_detail);
    mysqli_stmt_bind_param($stmt_detail, "i", $id_penjualan);
    mysqli_stmt_execute($stmt_detail);
    $result_detail = mysqli_stmt_get_result($stmt_detail);
    
    $details = [];
    while ($row = mysqli_fetch_assoc($result_detail)) {
        $details[] = $row;
    }
    
    // 2. Update stok untuk setiap barang
    foreach ($details as $detail) {
        $query_update_stok = "UPDATE stok_toko 
                             SET stok_keluar = stok_keluar - ?,
                                 stok_akhir = stok_awal + stok_masuk - (stok_keluar - ?)
                             WHERE id_barang = ? AND id_toko = ?";
        
        $stmt_update_stok = mysqli_prepare($conn, $query_update_stok);
        mysqli_stmt_bind_param($stmt_update_stok, "iiii", 
            $detail['jumlah'], $detail['jumlah'], $detail['id_barang'], $detail['id_toko']
        );
        
        if (!mysqli_stmt_execute($stmt_update_stok)) {
            throw new Exception("Gagal update stok barang: " . mysqli_error($conn));
        }
    }
    
    // 3. Hapus hutang pelanggan jika ada
    $query_hapus_hutang = "DELETE FROM hutang_pelanggan WHERE id_penjualan = ?";
    $stmt_hapus_hutang = mysqli_prepare($conn, $query_hapus_hutang);
    mysqli_stmt_bind_param($stmt_hapus_hutang, "i", $id_penjualan);
    mysqli_stmt_execute($stmt_hapus_hutang);
    
    // 4. Hapus detail penjualan
    $query_hapus_detail = "DELETE FROM detail_penjualan WHERE id_penjualan = ?";
    $stmt_hapus_detail = mysqli_prepare($conn, $query_hapus_detail);
    mysqli_stmt_bind_param($stmt_hapus_detail, "i", $id_penjualan);
    mysqli_stmt_execute($stmt_hapus_detail);
    
    // 5. Hapus penjualan
    $query_hapus_penjualan = "DELETE FROM penjualan WHERE id_penjualan = ?";
    $stmt_hapus_penjualan = mysqli_prepare($conn, $query_hapus_penjualan);
    mysqli_stmt_bind_param($stmt_hapus_penjualan, "i", $id_penjualan);
    mysqli_stmt_execute($stmt_hapus_penjualan);
    
    // Commit transaksi jika semua berhasil
    mysqli_commit($conn);
    
    // Redirect ke halaman penjualan dengan pesan sukses
    $_SESSION['success_message'] = "Transaksi berhasil dihapus";
    header("Location: penjualan.php");
    exit();
    
} catch (Exception $e) {
    // Rollback transaksi jika ada error
    mysqli_rollback($conn);
    
    // Redirect ke halaman penjualan dengan pesan error
    $_SESSION['error_message'] = "Gagal menghapus transaksi: " . $e->getMessage();
    header("Location: penjualan.php");
    exit();
}

// Fungsi untuk cek hak akses
function checkAccess($id_role, $modul, $akses) {
    global $conn;
    
    $query = "SELECT $akses FROM hak_akses WHERE id_role = ? AND modul = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "is", $id_role, $modul);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        return (bool)$row[$akses];
    }
    
    return false;
}
?>