<?php
session_start();
require_once 'config.php';

// Cek koneksi database
if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Cek apakah request POST
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    die("Invalid request method");
}

// Cek apakah user sudah login
if (!isset($_SESSION['id_pengguna'])) {
    die("Anda harus login terlebih dahulu");
}

// Ambil data dari form
$no_transaksi = mysqli_real_escape_string($conn, $_POST['no_transaksi']);
$tanggal_penjualan = mysqli_real_escape_string($conn, $_POST['tanggal_penjualan']);
$id_toko = (int)$_POST['id_toko'];
$id_pelanggan = !empty($_POST['id_pelanggan']) ? (int)$_POST['id_pelanggan'] : NULL;
$id_metode = (int)$_POST['id_metode'];
$total_penjualan = (float)str_replace(['Rp', '.', ','], '', $_POST['total_penjualan']);
$diskon = (float)$_POST['diskon'];
$ppn = (float)$_POST['ppn'];
$grand_total = (float)str_replace(['Rp', '.', ','], '', $_POST['grand_total']);
$jumlah_bayar = (float)$_POST['jumlah_bayar'];
$kembalian = (float)str_replace(['Rp', '.', ','], '', $_POST['kembalian']);
$status_pembayaran = mysqli_real_escape_string($conn, $_POST['status_pembayaran']);
$sisa_hutang = (float)$_POST['sisa_hutang'];
$catatan = mysqli_real_escape_string($conn, $_POST['catatan']);
$id_pengguna = (int)$_SESSION['id_pengguna'];

// Mulai transaksi
mysqli_begin_transaction($conn);

try {
    // 1. Simpan data penjualan
    $query_penjualan = "INSERT INTO penjualan (
        no_transaksi, id_toko, id_pelanggan, id_pengguna, id_metode, 
        tanggal_penjualan, total_penjualan, diskon, ppn, grand_total, 
        jumlah_bayar, kembalian, status_pembayaran, sisa_hutang, catatan
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt_penjualan = mysqli_prepare($conn, $query_penjualan);
    mysqli_stmt_bind_param($stmt_penjualan, "siiiiisddddddss", 
        $no_transaksi, $id_toko, $id_pelanggan, $id_pengguna, $id_metode,
        $tanggal_penjualan, $total_penjualan, $diskon, $ppn, $grand_total,
        $jumlah_bayar, $kembalian, $status_pembayaran, $sisa_hutang, $catatan
    );
    
    if (!mysqli_stmt_execute($stmt_penjualan)) {
        throw new Exception("Gagal menyimpan data penjualan: " . mysqli_error($conn));
    }
    
    $id_penjualan = mysqli_insert_id($conn);
    
    // 2. Simpan detail penjualan dan update stok
    if (!isset($_POST['id_barang']) || !is_array($_POST['id_barang'])) {
        throw new Exception("Tidak ada barang dalam transaksi");
    }
    
    $id_barang_array = $_POST['id_barang'];
    $jumlah_array = $_POST['jumlah'];
    $harga_jual_array = $_POST['harga_jual'];
    $diskon_item_array = $_POST['diskon_item'];
    
    for ($i = 0; $i < count($id_barang_array); $i++) {
        $id_barang = (int)$id_barang_array[$i];
        $jumlah = (int)$jumlah_array[$i];
        $harga_jual = (float)$harga_jual_array[$i];
        $diskon_item = (float)$diskon_item_array[$i];
        $subtotal = ($harga_jual * $jumlah) - $diskon_item;
        
        // Simpan detail penjualan
        $query_detail = "INSERT INTO detail_penjualan (
            id_penjualan, id_barang, jumlah, harga_jual, diskon_item, subtotal
        ) VALUES (?, ?, ?, ?, ?, ?)";
        
        $stmt_detail = mysqli_prepare($conn, $query_detail);
        mysqli_stmt_bind_param($stmt_detail, "iiiddd", $id_penjualan, $id_barang, $jumlah, $harga_jual, $diskon_item, $subtotal);
        
        if (!mysqli_stmt_execute($stmt_detail)) {
            throw new Exception("Gagal menyimpan detail penjualan: " . mysqli_error($conn));
        }
        
        // Update stok barang
        $query_stok = "UPDATE stok_toko 
                      SET stok_keluar = stok_keluar + ?, 
                          stok_akhir = stok_awal + stok_masuk - (stok_keluar + ?)
                      WHERE id_barang = ? AND id_toko = ?";
        
        $stmt_stok = mysqli_prepare($conn, $query_stok);
        mysqli_stmt_bind_param($stmt_stok, "iiii", $jumlah, $jumlah, $id_barang, $id_toko);
        
        if (!mysqli_stmt_execute($stmt_stok)) {
            throw new Exception("Gagal update stok barang: " . mysqli_error($conn));
        }
        
        // Cek apakah stok cukup
        $query_cek_stok = "SELECT stok_akhir FROM stok_toko WHERE id_barang = ? AND id_toko = ?";
        $stmt_cek_stok = mysqli_prepare($conn, $query_cek_stok);
        mysqli_stmt_bind_param($stmt_cek_stok, "ii", $id_barang, $id_toko);
        mysqli_stmt_execute($stmt_cek_stok);
        $result_cek_stok = mysqli_stmt_get_result($stmt_cek_stok);
        $stok = mysqli_fetch_assoc($result_cek_stok);
        
        if ($stok['stok_akhir'] < 0) {
            throw new Exception("Stok barang tidak mencukupi");
        }
    }
    
    // 3. Jika status hutang, simpan ke tabel hutang_pelanggan
    if ($status_pembayaran == 'hutang' && $id_pelanggan) {
        $query_hutang = "INSERT INTO hutang_pelanggan (
            id_penjualan, id_pelanggan, tanggal_hutang, tanggal_jatuh_tempo,
            jumlah_hutang, jumlah_bayar, sisa_hutang, status
        ) VALUES (?, ?, ?, DATE_ADD(?, INTERVAL 30 DAY), ?, ?, ?, 'belum_lunas')";
        
        $stmt_hutang = mysqli_prepare($conn, $query_hutang);
        mysqli_stmt_bind_param($stmt_hutang, "iissddd", 
            $id_penjualan, $id_pelanggan, $tanggal_penjualan, $tanggal_penjualan,
            $grand_total, $jumlah_bayar, $sisa_hutang
        );
        
        if (!mysqli_stmt_execute($stmt_hutang)) {
            throw new Exception("Gagal menyimpan data hutang: " . mysqli_error($conn));
        }
    }
    
    // Commit transaksi jika semua berhasil
    mysqli_commit($conn);
    
    // Redirect ke halaman detail penjualan
    header("Location: detail_penjualan.php?id=$id_penjualan");
    exit();
    
} catch (Exception $e) {
    // Rollback transaksi jika ada error
    mysqli_rollback($conn);
    
    // Tampilkan error
    die("Error: " . $e->getMessage());
}
?>