<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
require_once 'config.php';

// Check if database connection is established
if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Fungsi untuk format mata uang
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Fungsi untuk generate nomor retur
function generate_no_retur() {
    global $conn;
    $prefix = 'RTB-' . date('Ymd') . '-';
    $query = "SELECT MAX(no_retur) as last_number FROM retur_pembelian WHERE no_retur LIKE '$prefix%'";
    $result = mysqli_query($conn, $query);
    $data = mysqli_fetch_assoc($result);
    
    if ($data['last_number']) {
        $last_number = (int) substr($data['last_number'], strlen($prefix) + 1);
        $next_number = $last_number + 1;
    } else {
        $next_number = 1;
    }
    
    return $prefix . str_pad($next_number, 4, '0', STR_PAD_LEFT);
}

// Cek hak akses
$bisa_tambah = false;
$bisa_edit = false;
$bisa_hapus = false;

if (isset($_SESSION['id_role'])) {
    $id_role = $_SESSION['id_role'];
    $query_hak_akses = "SELECT bisa_tambah, bisa_edit, bisa_hapus FROM hak_akses WHERE id_role = $id_role AND modul = 'retur_pembelian'";
    $result_hak_akses = mysqli_query($conn, $query_hak_akses);
    
    if ($result_hak_akses && mysqli_num_rows($result_hak_akses) > 0) {
        $hak_akses = mysqli_fetch_assoc($result_hak_akses);
        $bisa_tambah = $hak_akses['bisa_tambah'];
        $bisa_edit = $hak_akses['bisa_edit'];
        $bisa_hapus = $hak_akses['bisa_hapus'];
    }
}

// Proses filter
$where = "WHERE 1=1";
$filter_tanggal = '';
$filter_supplier = '';

if (isset($_GET['filter'])) {
    // Filter tanggal
    if (!empty($_GET['tanggal_dari']) && !empty($_GET['tanggal_sampai'])) {
        $tanggal_dari = date('Y-m-d', strtotime($_GET['tanggal_dari']));
        $tanggal_sampai = date('Y-m-d', strtotime($_GET['tanggal_sampai']));
        $where .= " AND DATE(r.tanggal_retur) BETWEEN '$tanggal_dari' AND '$tanggal_sampai'";
        $filter_tanggal = "Tanggal: " . date('d/m/Y', strtotime($tanggal_dari)) . " - " . date('d/m/Y', strtotime($tanggal_sampai));
    }
    
    // Filter supplier
    if (!empty($_GET['id_supplier'])) {
        $id_supplier = (int) $_GET['id_supplier'];
        $where .= " AND p.id_supplier = $id_supplier";
        
        $query_supplier = "SELECT nama_supplier FROM supplier WHERE id_supplier = $id_supplier";
        $result_supplier = mysqli_query($conn, $query_supplier);
        if ($result_supplier && mysqli_num_rows($result_supplier) > 0) {
            $supplier = mysqli_fetch_assoc($result_supplier);
            $filter_supplier = "Supplier: " . $supplier['nama_supplier'];
        }
    }
}

// Query untuk mendapatkan data retur pembelian
$query = "SELECT r.*, p.id_pembelian, s.nama_supplier, pg.nama_lengkap as nama_pembuat
          FROM retur_pembelian r
          JOIN pembelian p ON r.id_pembelian = p.id_pembelian
          LEFT JOIN supplier s ON p.id_supplier = s.id_supplier
          JOIN pengguna pg ON r.id_pengguna = pg.id_pengguna
          $where
          ORDER BY r.tanggal_retur DESC";
$result = mysqli_query($conn, $query);

// Query untuk dropdown supplier
$query_supplier = "SELECT * FROM supplier ORDER BY nama_supplier";
$result_supplier = mysqli_query($conn, $query_supplier);
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Retur Pembelian</h1>
        <div class="d-none d-sm-inline-block">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="#">Transaksi</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Retur Pembelian</li>
                </ol>
            </nav>
        </div>
    </div>
    
    <!-- Filter dan Tombol Tambah -->
    <div class="card mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-body">
            <form method="GET" action="retur_pembelian.php" class="row g-3">
                <div class="col-md-4">
                    <label for="tanggal_dari" class="form-label">Dari Tanggal</label>
                    <input type="date" class="form-control" id="tanggal_dari" name="tanggal_dari" value="<?php echo isset($_GET['tanggal_dari']) ? $_GET['tanggal_dari'] : ''; ?>">
                </div>
                <div class="col-md-4">
                    <label for="tanggal_sampai" class="form-label">Sampai Tanggal</label>
                    <input type="date" class="form-control" id="tanggal_sampai" name="tanggal_sampai" value="<?php echo isset($_GET['tanggal_sampai']) ? $_GET['tanggal_sampai'] : ''; ?>">
                </div>
                <div class="col-md-4">
                    <label for="id_supplier" class="form-label">Supplier</label>
                    <select class="form-select" id="id_supplier" name="id_supplier">
                        <option value="">Semua Supplier</option>
                        <?php while ($supplier = mysqli_fetch_assoc($result_supplier)): ?>
                            <option value="<?php echo $supplier['id_supplier']; ?>" <?php echo (isset($_GET['id_supplier']) && $_GET['id_supplier'] == $supplier['id_supplier']) ? 'selected' : ''; ?>>
                                <?php echo $supplier['nama_supplier']; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="col-12">
                    <button type="submit" name="filter" class="btn btn-primary-custom me-2">
                        <i class="fas fa-filter me-1"></i> Filter
                    </button>
                    <a href="retur_pembelian.php" class="btn btn-secondary">
                        <i class="fas fa-sync-alt me-1"></i> Reset
                    </a>
                    <?php if ($bisa_tambah): ?>
                        <button type="button" class="btn btn-success float-end" data-bs-toggle="modal" data-bs-target="#tambahReturModal">
                            <i class="fas fa-plus me-1"></i> Retur Baru
                        </button>
                    <?php endif; ?>
                </div>
            </form>
            
            <?php if ($filter_tanggal || $filter_supplier): ?>
                <div class="mt-3">
                    <small class="text-muted">Filter aktif: 
                        <?php echo $filter_tanggal; ?>
                        <?php echo $filter_supplier ? ($filter_tanggal ? ', ' : '') . $filter_supplier : ''; ?>
                    </small>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Tabel Daftar Retur -->
    <div class="card animate-fade-in" style="animation-delay: 0.2s;">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="dataTable">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>No Retur</th>
                            <th>Tanggal</th>
                            <th>No Pembelian</th>
                            <th>Supplier</th>
                            <th>Total Retur</th>
                            <th>Keterangan</th>
                            <th>Pembuat</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result && mysqli_num_rows($result) > 0): ?>
                            <?php $no = 1; ?>
                            <?php while ($row = mysqli_fetch_assoc($result)): ?>
                                <tr>
                                    <td><?php echo $no++; ?></td>
                                    <td><?php echo $row['no_retur']; ?></td>
                                    <td><?php echo date('d-m-Y H:i', strtotime($row['tanggal_retur'])); ?></td>
                                    <td><?php echo $row['id_pembelian']; ?></td>
                                    <td><?php echo $row['nama_supplier'] ?? '-'; ?></td>
                                    <td><?php echo format_rupiah($row['total_retur']); ?></td>
                                    <td><?php echo $row['keterangan'] ? substr($row['keterangan'], 0, 30) . (strlen($row['keterangan']) > 30 ? '...' : '') : '-'; ?></td>
                                    <td><?php echo $row['nama_pembuat']; ?></td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#detailReturModal<?php echo $row['id_retur_pembelian']; ?>">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            
                                            <?php if ($bisa_edit): ?>
                                                <a href="edit_retur_pembelian.php?id=<?php echo $row['id_retur_pembelian']; ?>" class="btn btn-sm btn-warning">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            <?php endif; ?>
                                            
                                            <?php if ($bisa_hapus): ?>
                                                <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#hapusReturModal<?php echo $row['id_retur_pembelian']; ?>">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <!-- Modal Detail Retur -->
                                        <div class="modal fade" id="detailReturModal<?php echo $row['id_retur_pembelian']; ?>" tabindex="-1" aria-labelledby="detailReturModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="detailReturModalLabel">Detail Retur <?php echo $row['no_retur']; ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row mb-4">
                                                            <div class="col-md-6">
                                                                <h6>Info Retur</h6>
                                                                <table class="table table-sm table-borderless">
                                                                    <tr>
                                                                        <th width="40%">No. Retur</th>
                                                                        <td>: <?php echo $row['no_retur']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Tanggal</th>
                                                                        <td>: <?php echo date('d-m-Y H:i', strtotime($row['tanggal_retur'])); ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>No. Pembelian</th>
                                                                        <td>: <?php echo $row['id_pembelian']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Pembuat</th>
                                                                        <td>: <?php echo $row['nama_pembuat']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Total Retur</th>
                                                                        <td>: <?php echo format_rupiah($row['total_retur']); ?></td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <h6>Info Supplier</h6>
                                                                <table class="table table-sm table-borderless">
                                                                    <tr>
                                                                        <th width="40%">Nama</th>
                                                                        <td>: <?php echo $row['nama_supplier'] ?? '-'; ?></td>
                                                                    </tr>
                                                                    <?php if (!empty($row['nama_supplier'])): ?>
                                                                        <?php 
                                                                        $query_supplier_detail = "SELECT * FROM supplier WHERE id_supplier = " . $row['id_supplier'];
                                                                        $result_supplier_detail = mysqli_query($conn, $query_supplier_detail);
                                                                        if ($result_supplier_detail && mysqli_num_rows($result_supplier_detail) > 0) {
                                                                            $supplier_detail = mysqli_fetch_assoc($result_supplier_detail);
                                                                        ?>
                                                                            <tr>
                                                                                <th>Telepon</th>
                                                                                <td>: <?php echo $supplier_detail['telepon'] ?? '-'; ?></td>
                                                                            </tr>
                                                                            <tr>
                                                                                <th>Alamat</th>
                                                                                <td>: <?php echo $supplier_detail['alamat'] ?? '-'; ?></td>
                                                                            </tr>
                                                                        <?php } ?>
                                                                    <?php endif; ?>
                                                                </table>
                                                            </div>
                                                        </div>
                                                        
                                                        <h6>Rincian Barang</h6>
                                                        <div class="table-responsive">
                                                            <table class="table table-sm table-bordered">
                                                                <thead>
                                                                    <tr>
                                                                        <th>No</th>
                                                                        <th>Nama Barang</th>
                                                                        <th>Jumlah</th>
                                                                        <th>Harga</th>
                                                                        <th>Subtotal</th>
                                                                        <th>Alasan</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php 
                                                                    $query_detail = "SELECT rd.*, b.nama_barang 
                                                                                    FROM retur_pembelian_detail rd
                                                                                    JOIN barang b ON rd.id_barang = b.id_barang
                                                                                    WHERE rd.id_retur_pembelian = " . $row['id_retur_pembelian'];
                                                                    $result_detail = mysqli_query($conn, $query_detail);
                                                                    $no_detail = 1;
                                                                    ?>
                                                                    <?php while ($detail = mysqli_fetch_assoc($result_detail)): ?>
                                                                        <tr>
                                                                            <td><?php echo $no_detail++; ?></td>
                                                                            <td><?php echo $detail['nama_barang']; ?></td>
                                                                            <td><?php echo $detail['jumlah']; ?></td>
                                                                            <td><?php echo format_rupiah($detail['harga']); ?></td>
                                                                            <td><?php echo format_rupiah($detail['subtotal']); ?></td>
                                                                            <td><?php echo $detail['alasan']; ?></td>
                                                                        </tr>
                                                                    <?php endwhile; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                        
                                                        <div class="row mt-3">
                                                            <div class="col-md-12">
                                                                <p class="mb-1"><strong>Keterangan:</strong></p>
                                                                <p><?php echo $row['keterangan'] ? $row['keterangan'] : '-'; ?></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                                        <a href="cetak_retur_pembelian.php?id=<?php echo $row['id_retur_pembelian']; ?>" target="_blank" class="btn btn-primary">
                                                            <i class="fas fa-print me-1"></i> Cetak Retur
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Modal Hapus Retur -->
                                        <div class="modal fade" id="hapusReturModal<?php echo $row['id_retur_pembelian']; ?>" tabindex="-1" aria-labelledby="hapusReturModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="hapusReturModalLabel">Hapus Retur</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>Apakah Anda yakin ingin menghapus retur <strong><?php echo $row['no_retur']; ?></strong>?</p>
                                                        <p class="text-danger">Data yang dihapus tidak dapat dikembalikan!</p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                        <form action="proses_hapus_retur_pembelian.php" method="POST">
                                                            <input type="hidden" name="id_retur_pembelian" value="<?php echo $row['id_retur_pembelian']; ?>">
                                                            <button type="submit" class="btn btn-danger">Hapus</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center">Tidak ada data retur pembelian</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Tambah Retur -->
<div class="modal fade" id="tambahReturModal" tabindex="-1" aria-labelledby="tambahReturModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <form id="formRetur" action="proses_tambah_retur_pembelian.php" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title" id="tambahReturModalLabel">Retur Pembelian Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="no_retur" class="form-label">No. Retur</label>
                                <input type="text" class="form-control" id="no_retur" name="no_retur" value="<?php echo generate_no_retur(); ?>" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tanggal_retur" class="form-label">Tanggal Retur</label>
                                <input type="datetime-local" class="form-control" id="tanggal_retur" name="tanggal_retur" value="<?php echo date('Y-m-d\TH:i'); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="id_pembelian" class="form-label">Transaksi Pembelian</label>
                                <select class="form-select" id="id_pembelian" name="id_pembelian" required>
                                    <option value="">Pilih Transaksi Pembelian</option>
                                    <?php 
                                    $query_pembelian = "SELECT p.id_pembelian, p.id_pembelian, p.tanggal_pembelian, s.nama_supplier 
                                                       FROM pembelian p
                                                       LEFT JOIN supplier s ON p.id_supplier = s.id_supplier
                                                       ORDER BY p.tanggal_pembelian DESC";
                                    $result_pembelian = mysqli_query($conn, $query_pembelian);
                                    while ($pembelian = mysqli_fetch_assoc($result_pembelian)): ?>
                                        <option value="<?php echo $pembelian['id_pembelian']; ?>">
                                            <?php echo $pembelian['id_pembelian'] . ' - ' . date('d/m/Y', strtotime($pembelian['tanggal_pembelian'])) . 
                                                 ($pembelian['nama_supplier'] ? ' (' . $pembelian['nama_supplier'] . ')' : ''); ?>
                                        </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="keterangan" class="form-label">Keterangan (Opsional)</label>
                                <textarea class="form-control" id="keterangan" name="keterangan" rows="1"></textarea>
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <h5 class="mb-3">Daftar Barang Diretur</h5>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered" id="tabelBarangRetur">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="35%">Nama Barang</th>
                                    <th width="10%">Jumlah</th>
                                    <th width="15%">Harga</th>
                                    <th width="20%">Subtotal</th>
                                    <th width="15%">Alasan</th>
                                    <th width="5%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody id="daftarBarangRetur">
                                <!-- Daftar barang retur akan muncul di sini -->
                                <tr id="barangReturKosong">
                                    <td colspan="7" class="text-center">Pilih transaksi pembelian terlebih dahulu</td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr class="table-active">
                                    <td colspan="4" class="text-end"><strong>Total Retur</strong></td>
                                    <td id="totalRetur">Rp 0</td>
                                    <td colspan="2"></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    
                    <input type="hidden" id="total_retur" name="total_retur" value="0">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan Retur</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Script untuk retur pembelian -->
<script>
$(document).ready(function() {
    // Variabel untuk menyimpan data barang retur
    let daftarBarangRetur = [];
    let counterBarangRetur = 1;
    
    // Fungsi untuk menghitung total retur
    function hitungTotalRetur() {
        let total = 0;
        
        // Hitung total dari daftar barang retur
        daftarBarangRetur.forEach(barang => {
            total += barang.subtotal;
        });
        
        // Update total retur
        $('#totalRetur').text(formatRupiah(total));
        $('#total_retur').val(total);
    }
    
    // Fungsi untuk format rupiah
    function formatRupiah(angka) {
        return 'Rp ' + angka.toLocaleString('id-ID');
    }
    
    // Event listener untuk perubahan transaksi pembelian
    $('#id_pembelian').change(function() {
        const id_pembelian = $(this).val();
        
        if (id_pembelian) {
            // Ambil detail barang dari transaksi pembelian
            $.ajax({
                url: 'ajax_get_detail_pembelian.php',
                type: 'GET',
                data: { id_pembelian: id_pembelian },
                dataType: 'json',
                success: function(response) {
                    // Reset daftar barang retur
                    daftarBarangRetur = [];
                    counterBarangRetur = 1;
                    $('#daftarBarangRetur').empty();
                    
                    if (response.length > 0) {
                        response.forEach(barang => {
                            // Tambahkan barang ke array daftarBarangRetur
                            const barangRetur = {
                                id_barang: barang.id_barang,
                                nama_barang: barang.nama_barang,
                                jumlah: 0,
                                harga: barang.harga_beli,
                                subtotal: 0,
                                alasan: ''
                            };
                            
                            daftarBarangRetur.push(barangRetur);
                            
                            // Tambahkan row ke tabel
                            const rowId = 'barangRetur-' + counterBarangRetur;
                            const newRow = `
                                <tr id="${rowId}">
                                    <td>${counterBarangRetur}</td>
                                    <td>
                                        ${barang.nama_barang}
                                        <input type="hidden" name="id_barang[]" value="${barang.id_barang}">
                                        <input type="hidden" name="harga[]" value="${barang.harga_beli}">
                                    </td>
                                    <td>
                                        <input type="number" class="form-control form-control-sm jumlah-retur" 
                                               name="jumlah[]" min="0" max="${barang.jumlah}" 
                                               value="0" data-row="${rowId}">
                                    </td>
                                    <td>${formatRupiah(barang.harga_beli)}</td>
                                    <td class="subtotal-retur">Rp 0</td>
                                    <td>
                                        <input type="text" class="form-control form-control-sm alasan-retur" 
                                               name="alasan[]" data-row="${rowId}">
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-danger hapus-barang-retur" data-row="${rowId}">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            `;
                            
                            $('#daftarBarangRetur').append(newRow);
                            counterBarangRetur++;
                        });
                    } else {
                        $('#daftarBarangRetur').html('<tr id="barangReturKosong"><td colspan="7" class="text-center">Tidak ada barang dalam transaksi ini</td></tr>');
                    }
                },
                error: function() {
                    alert('Terjadi kesalahan saat mengambil data pembelian');
                }
            });
        } else {
            // Reset tabel jika tidak ada transaksi dipilih
            daftarBarangRetur = [];
            counterBarangRetur = 1;
            $('#daftarBarangRetur').html('<tr id="barangReturKosong"><td colspan="7" class="text-center">Pilih transaksi pembelian terlebih dahulu</td></tr>');
            $('#totalRetur').text('Rp 0');
            $('#total_retur').val('0');
        }
    });
    
    // Event listener untuk perubahan jumlah atau alasan retur
    $(document).on('change keyup', '.jumlah-retur, .alasan-retur', function() {
        const rowId = $(this).data('row');
        const index = parseInt(rowId.split('-')[2]) - 1;
        
        if (index >= 0 && index < daftarBarangRetur.length) {
            const jumlah = parseFloat($(this).closest('tr').find('.jumlah-retur').val()) || 0;
            const alasan = $(this).closest('tr').find('.alasan-retur').val() || '';
            const harga = daftarBarangRetur[index].harga;
            
            // Update data di array
            daftarBarangRetur[index].jumlah = jumlah;
            daftarBarangRetur[index].alasan = alasan;
            daftarBarangRetur[index].subtotal = harga * jumlah;
            
            // Update subtotal di tabel
            $(this).closest('tr').find('.subtotal-retur').text(formatRupiah(daftarBarangRetur[index].subtotal));
            
            // Hitung ulang total
            hitungTotalRetur();
        }
    });
    
    // Event listener untuk menghapus barang retur dari tabel
    $(document).on('click', '.hapus-barang-retur', function() {
        const rowId = $(this).data('row');
        
        // Hapus barang dari array daftarBarangRetur
        const index = parseInt(rowId.split('-')[2]) - 1;
        if (index !== -1) {
            daftarBarangRetur.splice(index, 1);
        }
        
        // Hapus row dari tabel
        $('#' + rowId).remove();
        
        // Update nomor urut
        $('#daftarBarangRetur tr').each(function(index) {
            $(this).find('td:first').text(index + 1);
        });
        
        // Jika tidak ada barang, tampilkan pesan
        if (daftarBarangRetur.length === 0) {
            $('#daftarBarangRetur').html('<tr id="barangReturKosong"><td colspan="7" class="text-center">Tidak ada barang diretur</td></tr>');
        }
        
        // Hitung ulang total
        hitungTotalRetur();
    });
    
    // Validasi form sebelum submit
    $('#formRetur').submit(function(e) {
        let adaBarangDiretur = false;
        
        // Cek apakah ada barang yang jumlah returnya > 0
        daftarBarangRetur.forEach(barang => {
            if (barang.jumlah > 0) {
                adaBarangDiretur = true;
            }
        });
        
        if (!adaBarangDiretur) {
            e.preventDefault();
            alert('Minimal harus ada 1 barang dengan jumlah retur lebih dari 0');
            return false;
        }
        
        return true;
    });
});
</script>

<?php include 'footer.php'; ?>