<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
require_once 'config.php';

// Check if database connection is established
if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Fungsi untuk format mata uang
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Fungsi untuk generate nomor retur
function generate_no_retur() {
    global $conn;
    $prefix = 'RTR-' . date('Ymd') . '-';
    $query = "SELECT MAX(no_retur) as last_number FROM retur_penjualan WHERE no_retur LIKE '$prefix%'";
    $result = mysqli_query($conn, $query);
    $data = mysqli_fetch_assoc($result);
    
    if ($data['last_number']) {
        $last_number = (int) substr($data['last_number'], strlen($prefix) + 1);
        $next_number = $last_number + 1;
    } else {
        $next_number = 1;
    }
    
    return $prefix . str_pad($next_number, 4, '0', STR_PAD_LEFT);
}

// Cek hak akses
$bisa_tambah = false;
$bisa_edit = false;
$bisa_hapus = false;

if (isset($_SESSION['id_role'])) {
    $id_role = $_SESSION['id_role'];
    $query_hak_akses = "SELECT bisa_tambah, bisa_edit, bisa_hapus FROM hak_akses WHERE id_role = $id_role AND modul = 'retur_penjualan'";
    $result_hak_akses = mysqli_query($conn, $query_hak_akses);
    
    if ($result_hak_akses && mysqli_num_rows($result_hak_akses) > 0) {
        $hak_akses = mysqli_fetch_assoc($result_hak_akses);
        $bisa_tambah = $hak_akses['bisa_tambah'];
        $bisa_edit = $hak_akses['bisa_edit'];
        $bisa_hapus = $hak_akses['bisa_hapus'];
    }
}

// Proses filter
$where = "WHERE 1=1";
$filter_tanggal = '';
$filter_pelanggan = '';

if (isset($_GET['filter'])) {
    // Filter tanggal
    if (!empty($_GET['tanggal_dari']) && !empty($_GET['tanggal_sampai'])) {
        $tanggal_dari = date('Y-m-d', strtotime($_GET['tanggal_dari']));
        $tanggal_sampai = date('Y-m-d', strtotime($_GET['tanggal_sampai']));
        $where .= " AND DATE(r.tanggal_retur) BETWEEN '$tanggal_dari' AND '$tanggal_sampai'";
        $filter_tanggal = "Tanggal: " . date('d/m/Y', strtotime($tanggal_dari)) . " - " . date('d/m/Y', strtotime($tanggal_sampai));
    }
    
    // Filter pelanggan
    if (!empty($_GET['id_pelanggan'])) {
        $id_pelanggan = (int) $_GET['id_pelanggan'];
        $where .= " AND p.id_pelanggan = $id_pelanggan";
        
        $query_pelanggan = "SELECT nama_pelanggan FROM pelanggan WHERE id_pelanggan = $id_pelanggan";
        $result_pelanggan = mysqli_query($conn, $query_pelanggan);
        if ($result_pelanggan && mysqli_num_rows($result_pelanggan) > 0) {
            $pelanggan = mysqli_fetch_assoc($result_pelanggan);
            $filter_pelanggan = "Pelanggan: " . $pelanggan['nama_pelanggan'];
        }
    }
}

// Query untuk mendapatkan data retur penjualan
$query = "SELECT r.*, p.no_transaksi, pl.nama_pelanggan, pg.nama_lengkap as nama_kasir
          FROM retur_penjualan r
          JOIN penjualan p ON r.id_penjualan = p.id_penjualan
          LEFT JOIN pelanggan pl ON p.id_pelanggan = pl.id_pelanggan
          JOIN pengguna pg ON r.id_pengguna = pg.id_pengguna
          $where
          ORDER BY r.tanggal_retur DESC";
$result = mysqli_query($conn, $query);

// Query untuk dropdown pelanggan
$query_pelanggan = "SELECT * FROM pelanggan ORDER BY nama_pelanggan";
$result_pelanggan = mysqli_query($conn, $query_pelanggan);
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Retur Penjualan</h1>
        <div class="d-none d-sm-inline-block">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="#">Transaksi</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Retur Penjualan</li>
                </ol>
            </nav>
        </div>
    </div>
    
    <!-- Filter dan Tombol Tambah -->
    <div class="card mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-body">
            <form method="GET" action="retur_penjualan.php" class="row g-3">
                <div class="col-md-4">
                    <label for="tanggal_dari" class="form-label">Dari Tanggal</label>
                    <input type="date" class="form-control" id="tanggal_dari" name="tanggal_dari" value="<?php echo isset($_GET['tanggal_dari']) ? $_GET['tanggal_dari'] : ''; ?>">
                </div>
                <div class="col-md-4">
                    <label for="tanggal_sampai" class="form-label">Sampai Tanggal</label>
                    <input type="date" class="form-control" id="tanggal_sampai" name="tanggal_sampai" value="<?php echo isset($_GET['tanggal_sampai']) ? $_GET['tanggal_sampai'] : ''; ?>">
                </div>
                <div class="col-md-4">
                    <label for="id_pelanggan" class="form-label">Pelanggan</label>
                    <select class="form-select" id="id_pelanggan" name="id_pelanggan">
                        <option value="">Semua Pelanggan</option>
                        <?php while ($pelanggan = mysqli_fetch_assoc($result_pelanggan)): ?>
                            <option value="<?php echo $pelanggan['id_pelanggan']; ?>" <?php echo (isset($_GET['id_pelanggan']) && $_GET['id_pelanggan'] == $pelanggan['id_pelanggan']) ? 'selected' : ''; ?>>
                                <?php echo $pelanggan['nama_pelanggan']; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="col-12">
                    <button type="submit" name="filter" class="btn btn-primary-custom me-2">
                        <i class="fas fa-filter me-1"></i> Filter
                    </button>
                    <a href="retur_penjualan.php" class="btn btn-secondary">
                        <i class="fas fa-sync-alt me-1"></i> Reset
                    </a>
                    <?php if ($bisa_tambah): ?>
                        <button type="button" class="btn btn-success float-end" data-bs-toggle="modal" data-bs-target="#tambahReturModal">
                            <i class="fas fa-plus me-1"></i> Retur Baru
                        </button>
                    <?php endif; ?>
                </div>
            </form>
            
            <?php if ($filter_tanggal || $filter_pelanggan): ?>
                <div class="mt-3">
                    <small class="text-muted">Filter aktif: 
                        <?php echo $filter_tanggal; ?>
                        <?php echo $filter_pelanggan ? ($filter_tanggal ? ', ' : '') . $filter_pelanggan : ''; ?>
                    </small>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Tabel Daftar Retur -->
    <div class="card animate-fade-in" style="animation-delay: 0.2s;">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="dataTable">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>No Retur</th>
                            <th>Tanggal</th>
                            <th>No Transaksi</th>
                            <th>Pelanggan</th>
                            <th>Total Retur</th>
                            <th>Keterangan</th>
                            <th>Kasir</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result && mysqli_num_rows($result) > 0): ?>
                            <?php $no = 1; ?>
                            <?php while ($row = mysqli_fetch_assoc($result)): ?>
                                <tr>
                                    <td><?php echo $no++; ?></td>
                                    <td><?php echo $row['no_retur']; ?></td>
                                    <td><?php echo date('d-m-Y H:i', strtotime($row['tanggal_retur'])); ?></td>
                                    <td><?php echo $row['no_transaksi']; ?></td>
                                    <td><?php echo $row['nama_pelanggan'] ?? '-'; ?></td>
                                    <td><?php echo format_rupiah($row['total_retur']); ?></td>
                                    <td><?php echo $row['keterangan'] ? substr($row['keterangan'], 0, 30) . (strlen($row['keterangan']) > 30 ? '...' : '') : '-'; ?></td>
                                    <td><?php echo $row['nama_kasir']; ?></td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#detailReturModal<?php echo $row['id_retur_penjualan']; ?>">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            
                                            <?php if ($bisa_edit): ?>
                                                <a href="edit_retur_penjualan.php?id=<?php echo $row['id_retur_penjualan']; ?>" class="btn btn-sm btn-warning">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            <?php endif; ?>
                                            
                                            <?php if ($bisa_hapus): ?>
                                                <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#hapusReturModal<?php echo $row['id_retur_penjualan']; ?>">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <!-- Modal Detail Retur -->
                                        <div class="modal fade" id="detailReturModal<?php echo $row['id_retur_penjualan']; ?>" tabindex="-1" aria-labelledby="detailReturModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="detailReturModalLabel">Detail Retur <?php echo $row['no_retur']; ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row mb-4">
                                                            <div class="col-md-6">
                                                                <h6>Info Retur</h6>
                                                                <table class="table table-sm table-borderless">
                                                                    <tr>
                                                                        <th width="40%">No. Retur</th>
                                                                        <td>: <?php echo $row['no_retur']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Tanggal</th>
                                                                        <td>: <?php echo date('d-m-Y H:i', strtotime($row['tanggal_retur'])); ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>No. Transaksi</th>
                                                                        <td>: <?php echo $row['no_transaksi']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Kasir</th>
                                                                        <td>: <?php echo $row['nama_kasir']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Total Retur</th>
                                                                        <td>: <?php echo format_rupiah($row['total_retur']); ?></td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <h6>Info Pelanggan</h6>
                                                                <table class="table table-sm table-borderless">
                                                                    <tr>
                                                                        <th width="40%">Nama</th>
                                                                        <td>: <?php echo $row['nama_pelanggan'] ?? '-'; ?></td>
                                                                    </tr>
                                                                    <?php if (!empty($row['nama_pelanggan'])): ?>
                                                                        <?php 
                                                                        $query_pelanggan_detail = "SELECT * FROM pelanggan WHERE id_pelanggan = " . $row['id_pelanggan'];
                                                                        $result_pelanggan_detail = mysqli_query($conn, $query_pelanggan_detail);
                                                                        if ($result_pelanggan_detail && mysqli_num_rows($result_pelanggan_detail) > 0) {
                                                                            $pelanggan_detail = mysqli_fetch_assoc($result_pelanggan_detail);
                                                                        ?>
                                                                            <tr>
                                                                                <th>Telepon</th>
                                                                                <td>: <?php echo $pelanggan_detail['telepon'] ?? '-'; ?></td>
                                                                            </tr>
                                                                            <tr>
                                                                                <th>Alamat</th>
                                                                                <td>: <?php echo $pelanggan_detail['alamat'] ?? '-'; ?></td>
                                                                            </tr>
                                                                        <?php } ?>
                                                                    <?php endif; ?>
                                                                </table>
                                                            </div>
                                                        </div>
                                                        
                                                        <h6>Rincian Barang</h6>
                                                        <div class="table-responsive">
                                                            <table class="table table-sm table-bordered">
                                                                <thead>
                                                                    <tr>
                                                                        <th>No</th>
                                                                        <th>Nama Barang</th>
                                                                        <th>Jumlah</th>
                                                                        <th>Harga</th>
                                                                        <th>Subtotal</th>
                                                                        <th>Alasan</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php 
                                                                    $query_detail = "SELECT rd.*, b.nama_barang 
                                                                                    FROM retur_penjualan_detail rd
                                                                                    JOIN barang b ON rd.id_barang = b.id_barang
                                                                                    WHERE rd.id_retur_penjualan = " . $row['id_retur_penjualan'];
                                                                    $result_detail = mysqli_query($conn, $query_detail);
                                                                    $no_detail = 1;
                                                                    ?>
                                                                    <?php while ($detail = mysqli_fetch_assoc($result_detail)): ?>
                                                                        <tr>
                                                                            <td><?php echo $no_detail++; ?></td>
                                                                            <td><?php echo $detail['nama_barang']; ?></td>
                                                                            <td><?php echo $detail['jumlah']; ?></td>
                                                                            <td><?php echo format_rupiah($detail['harga']); ?></td>
                                                                            <td><?php echo format_rupiah($detail['subtotal']); ?></td>
                                                                            <td><?php echo $detail['alasan']; ?></td>
                                                                        </tr>
                                                                    <?php endwhile; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                        
                                                        <div class="row mt-3">
                                                            <div class="col-md-12">
                                                                <p class="mb-1"><strong>Keterangan:</strong></p>
                                                                <p><?php echo $row['keterangan'] ? $row['keterangan'] : '-'; ?></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                                        <a href="cetak_retur_penjualan.php?id=<?php echo $row['id_retur_penjualan']; ?>" target="_blank" class="btn btn-primary">
                                                            <i class="fas fa-print me-1"></i> Cetak Retur
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Modal Hapus Retur -->
                                        <div class="modal fade" id="hapusReturModal<?php echo $row['id_retur_penjualan']; ?>" tabindex="-1" aria-labelledby="hapusReturModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="hapusReturModalLabel">Hapus Retur</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>Apakah Anda yakin ingin menghapus retur <strong><?php echo $row['no_retur']; ?></strong>?</p>
                                                        <p class="text-danger">Data yang dihapus tidak dapat dikembalikan!</p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                        <form action="proses_hapus_retur_penjualan.php" method="POST">
                                                            <input type="hidden" name="id_retur_penjualan" value="<?php echo $row['id_retur_penjualan']; ?>">
                                                            <button type="submit" class="btn btn-danger">Hapus</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center">Tidak ada data retur penjualan</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Tambah Retur -->
<div class="modal fade" id="tambahReturModal" tabindex="-1" aria-labelledby="tambahReturModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <form id="formRetur" action="proses_tambah_retur_penjualan.php" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title" id="tambahReturModalLabel">Retur Penjualan Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="no_retur" class="form-label">No. Retur</label>
                                <input type="text" class="form-control" id="no_retur" name="no_retur" value="<?php echo generate_no_retur(); ?>" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tanggal_retur" class="form-label">Tanggal Retur</label>
                                <input type="datetime-local" class="form-control" id="tanggal_retur" name="tanggal_retur" value="<?php echo date('Y-m-d\TH:i'); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="id_penjualan" class="form-label">Transaksi Penjualan</label>
                                <select class="form-select" id="id_penjualan" name="id_penjualan" required>
                                    <option value="">Pilih Transaksi Penjualan</option>
                                    <?php 
                                    $query_penjualan = "SELECT p.id_penjualan, p.no_transaksi, p.tanggal_penjualan, pl.nama_pelanggan 
                                                        FROM penjualan p
                                                        LEFT JOIN pelanggan pl ON p.id_pelanggan = pl.id_pelanggan
                                                        ORDER BY p.tanggal_penjualan DESC";
                                    $result_penjualan = mysqli_query($conn, $query_penjualan);
                                    while ($penjualan = mysqli_fetch_assoc($result_penjualan)): ?>
                                        <option value="<?php echo $penjualan['id_penjualan']; ?>">
                                            <?php echo $penjualan['no_transaksi'] . ' - ' . date('d/m/Y', strtotime($penjualan['tanggal_penjualan'])) . 
                                                 ($penjualan['nama_pelanggan'] ? ' (' . $penjualan['nama_pelanggan'] . ')' : ''); ?>
                                        </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="keterangan" class="form-label">Keterangan (Opsional)</label>
                                <textarea class="form-control" id="keterangan" name="keterangan" rows="1"></textarea>
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <h5 class="mb-3">Daftar Barang Diretur</h5>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered" id="tabelBarangRetur">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="35%">Nama Barang</th>
                                    <th width="10%">Jumlah</th>
                                    <th width="15%">Harga</th>
                                    <th width="20%">Subtotal</th>
                                    <th width="15%">Alasan</th>
                                    <th width="5%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody id="daftarBarangRetur">
                                <!-- Daftar barang retur akan muncul di sini -->
                                <tr id="barangReturKosong">
                                    <td colspan="7" class="text-center">Pilih transaksi penjualan terlebih dahulu</td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr class="table-active">
                                    <td colspan="4" class="text-end"><strong>Total Retur</strong></td>
                                    <td id="totalRetur">Rp 0</td>
                                    <td colspan="2"></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    
                    <input type="hidden" id="total_retur" name="total_retur" value="0">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan Retur</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Script untuk retur penjualan -->
<script>
$(document).ready(function() {
    // Variabel untuk menyimpan data barang retur
    let daftarBarangRetur = [];
    let counterBarangRetur = 1;
    
    // Fungsi untuk menghitung total retur
    function hitungTotalRetur() {
        let total = 0;
        
        // Hitung total dari daftar barang retur
        daftarBarangRetur.forEach(barang => {
            total += barang.subtotal;
        });
        
        // Update total retur
        $('#totalRetur').text(formatRupiah(total));
        $('#total_retur').val(total);
    }
    
    // Fungsi untuk format rupiah
    function formatRupiah(angka) {
        return 'Rp ' + angka.toLocaleString('id-ID');
    }
    
    // Event listener untuk perubahan transaksi penjualan
    $('#id_penjualan').change(function() {
        const id_penjualan = $(this).val();
        
        if (id_penjualan) {
            // Ambil detail barang dari transaksi penjualan
            $.ajax({
                url: 'ajax_get_detail_penjualan.php',
                type: 'GET',
                data: { id_penjualan: id_penjualan },
                dataType: 'json',
                success: function(response) {
                    // Reset daftar barang retur
                    daftarBarangRetur = [];
                    counterBarangRetur = 1;
                    $('#daftarBarangRetur').empty();
                    
                    if (response.length > 0) {
                        response.forEach(barang => {
                            // Tambahkan barang ke array daftarBarangRetur
                            const barangRetur = {
                                id_barang: barang.id_barang,
                                nama_barang: barang.nama_barang,
                                jumlah: 0,
                                harga: barang.harga_jual,
                                subtotal: 0,
                                alasan: ''
                            };
                            
                            daftarBarangRetur.push(barangRetur);
                            
                            // Tambahkan row ke tabel
                            const rowId = 'barangRetur-' + counterBarangRetur;
                            const newRow = `
                                <tr id="${rowId}">
                                    <td>${counterBarangRetur}</td>
                                    <td>
                                        ${barang.nama_barang}
                                        <input type="hidden" name="id_barang[]" value="${barang.id_barang}">
                                        <input type="hidden" name="harga[]" value="${barang.harga_jual}">
                                    </td>
                                    <td>
                                        <input type="number" class="form-control form-control-sm jumlah-retur" 
                                               name="jumlah[]" min="0" max="${barang.jumlah}" 
                                               value="0" data-row="${rowId}">
                                    </td>
                                    <td>${formatRupiah(barang.harga_jual)}</td>
                                    <td class="subtotal-retur">Rp 0</td>
                                    <td>
                                        <input type="text" class="form-control form-control-sm alasan-retur" 
                                               name="alasan[]" data-row="${rowId}">
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-danger hapus-barang-retur" data-row="${rowId}">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            `;
                            
                            $('#daftarBarangRetur').append(newRow);
                            counterBarangRetur++;
                        });
                    } else {
                        $('#daftarBarangRetur').html('<tr id="barangReturKosong"><td colspan="7" class="text-center">Tidak ada barang dalam transaksi ini</td></tr>');
                    }
                },
                error: function() {
                    alert('Terjadi kesalahan saat mengambil data penjualan');
                }
            });
        } else {
            // Reset tabel jika tidak ada transaksi dipilih
            daftarBarangRetur = [];
            counterBarangRetur = 1;
            $('#daftarBarangRetur').html('<tr id="barangReturKosong"><td colspan="7" class="text-center">Pilih transaksi penjualan terlebih dahulu</td></tr>');
            $('#totalRetur').text('Rp 0');
            $('#total_retur').val('0');
        }
    });
    
    // Event listener untuk perubahan jumlah atau alasan retur
    $(document).on('change keyup', '.jumlah-retur, .alasan-retur', function() {
        const rowId = $(this).data('row');
        const index = parseInt(rowId.split('-')[2]) - 1;
        
        if (index >= 0 && index < daftarBarangRetur.length) {
            const jumlah = parseFloat($(this).closest('tr').find('.jumlah-retur').val()) || 0;
            const alasan = $(this).closest('tr').find('.alasan-retur').val() || '';
            const harga = daftarBarangRetur[index].harga;
            
            // Update data di array
            daftarBarangRetur[index].jumlah = jumlah;
            daftarBarangRetur[index].alasan = alasan;
            daftarBarangRetur[index].subtotal = harga * jumlah;
            
            // Update subtotal di tabel
            $(this).closest('tr').find('.subtotal-retur').text(formatRupiah(daftarBarangRetur[index].subtotal));
            
            // Hitung ulang total
            hitungTotalRetur();
        }
    });
    
    // Event listener untuk menghapus barang retur dari tabel
    $(document).on('click', '.hapus-barang-retur', function() {
        const rowId = $(this).data('row');
        
        // Hapus barang dari array daftarBarangRetur
        const index = parseInt(rowId.split('-')[2]) - 1;
        if (index !== -1) {
            daftarBarangRetur.splice(index, 1);
        }
        
        // Hapus row dari tabel
        $('#' + rowId).remove();
        
        // Update nomor urut
        $('#daftarBarangRetur tr').each(function(index) {
            $(this).find('td:first').text(index + 1);
        });
        
        // Jika tidak ada barang, tampilkan pesan
        if (daftarBarangRetur.length === 0) {
            $('#daftarBarangRetur').html('<tr id="barangReturKosong"><td colspan="7" class="text-center">Tidak ada barang diretur</td></tr>');
        }
        
        // Hitung ulang total
        hitungTotalRetur();
    });
    
    // Validasi form sebelum submit
    $('#formRetur').submit(function(e) {
        let adaBarangDiretur = false;
        
        // Cek apakah ada barang yang jumlah returnya > 0
        daftarBarangRetur.forEach(barang => {
            if (barang.jumlah > 0) {
                adaBarangDiretur = true;
            }
        });
        
        if (!adaBarangDiretur) {
            e.preventDefault();
            alert('Minimal harus ada 1 barang dengan jumlah retur lebih dari 0');
            return false;
        }
        
        return true;
    });
});
</script>

<?php include 'footer.php'; ?>