<?php
session_start();
include 'header.php';
require_once 'config.php';

// Fungsi untuk format rupiah
function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}

// Query data stok
$query = "SELECT b.id_barang, b.kode_barang, b.nama_barang, k.nama_kategori, 
          s.stok_awal, s.stok_masuk, s.stok_keluar, s.stok_akhir, s.expired_date,
          b.stok_minimal, b.harga_beli, b.harga_jual
          FROM barang b
          JOIN stok_toko s ON b.id_barang = s.id_barang
          JOIN kategori k ON b.id_kategori = k.id_kategori
          WHERE s.id_toko = 1
          ORDER BY b.nama_barang";

$result = mysqli_query($conn, $query);
?>

<main class="animate-fade-in">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Manajemen Stok Barang</h1>
        <div>
            <a href="stok_opname.php" class="btn btn-warning me-2">
                <i class="fas fa-clipboard-check"></i> Stok Opname
            </a>
            <a href="barang_habis.php" class="btn btn-danger me-2">
                <i class="fas fa-exclamation-triangle"></i> Barang Hampir Habis
            </a>
            <a href="barang_kedaluwarsa.php" class="btn btn-secondary">
                <i class="fas fa-calendar-times"></i> Barang Kedaluwarsa
            </a>
        </div>
    </div>

    <div class="card shadow mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-header py-3 bg-primary-custom text-white">
            <h6 class="m-0 font-weight-bold">Daftar Stok Barang</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Kode</th>
                            <th>Nama Barang</th>
                            <th>Kategori</th>
                            <th>Stok Awal</th>
                            <th>Stok Masuk</th>
                            <th>Stok Keluar</th>
                            <th>Stok Akhir</th>
                            <th>Minimal</th>
                            <th>Harga Beli</th>
                            <th>Harga Jual</th>
                            <th>Expired</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; while($row = mysqli_fetch_assoc($result)): ?>
                        <tr class="<?= ($row['stok_akhir'] <= $row['stok_minimal']) ? 'table-warning' : '' ?>">
                            <td><?= $no++ ?></td>
                            <td><?= $row['kode_barang'] ?></td>
                            <td><?= $row['nama_barang'] ?></td>
                            <td><?= $row['nama_kategori'] ?></td>
                            <td class="text-center"><?= $row['stok_awal'] ?></td>
                            <td class="text-center"><?= $row['stok_masuk'] ?></td>
                            <td class="text-center"><?= $row['stok_keluar'] ?></td>
                            <td class="text-center <?= ($row['stok_akhir'] <= $row['stok_minimal']) ? 'text-danger fw-bold' : '' ?>">
                                <?= $row['stok_akhir'] ?>
                            </td>
                            <td class="text-center"><?= $row['stok_minimal'] ?></td>
                            <td class="text-end"><?= format_rupiah($row['harga_beli']) ?></td>
                            <td class="text-end"><?= format_rupiah($row['harga_jual']) ?></td>
                            <td><?= $row['expired_date'] ? date('d/m/Y', strtotime($row['expired_date'])) : '-' ?></td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<?php include 'footer.php'; ?>