<?php
session_start();
include 'header.php';
require_once 'config.php';

// Proses simpan stok opname
if(isset($_POST['simpan_opname'])) {
    $id_barang = $_POST['id_barang'];
    $stok_fisik = $_POST['stok_fisik'];
    $keterangan = $_POST['keterangan'];
    $id_pengguna = $_SESSION['id_pengguna'];
    
    // Insert ke tabel penyesuaian_stok
    $query = "INSERT INTO penyesuaian_stok (id_toko, id_pengguna, tanggal_penyesuaian, total_barang, catatan)
              VALUES (1, $id_pengguna, NOW(), 1, 'Stok opname manual')";
    
    if(mysqli_query($conn, $query)) {
        $id_penyesuaian = mysqli_insert_id($conn);
        
        // Insert detail penyesuaian
        foreach($id_barang as $key => $id) {
            $stok_sistem = $_POST['stok_sistem'][$key];
            $selisih = $stok_fisik[$key] - $stok_sistem;
            
            $query_detail = "INSERT INTO detail_penyesuaian 
                            (id_penyesuaian, id_barang, stok_sistem, stok_fisik, selisih, keterangan)
                            VALUES ($id_penyesuaian, $id, $stok_sistem, $stok_fisik[$key], $selisih, '$keterangan[$key]')";
            mysqli_query($conn, $query_detail);
            
            // Update stok di stok_toko
            $query_update = "UPDATE stok_toko SET stok_akhir = $stok_fisik[$key] 
                            WHERE id_barang = $id AND id_toko = 1";
            mysqli_query($conn, $query_update);
        }
        
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Stok opname berhasil disimpan'];
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menyimpan stok opname: ' . mysqli_error($conn)];
    }
    
    header("Location: stok_opname.php");
    exit();
}

// Query data barang untuk stok opname
$query = "SELECT b.id_barang, b.kode_barang, b.nama_barang, s.stok_akhir
          FROM barang b
          JOIN stok_toko s ON b.id_barang = s.id_barang
          WHERE s.id_toko = 1
          ORDER BY b.nama_barang";
$result = mysqli_query($conn, $query);
?>

<main class="animate-fade-in">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Stok Opname</h1>
        <div>
            <button class="btn btn-primary-custom" data-bs-toggle="modal" data-bs-target="#tambahOpnameModal">
                <i class="fas fa-plus-circle"></i> Tambah Stok Opname
            </button>
        </div>
    </div>

    <?php if(isset($_SESSION['pesan'])): ?>
    <div class="alert alert-<?= $_SESSION['pesan']['tipe'] ?> alert-dismissible fade show">
        <?= $_SESSION['pesan']['isi'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['pesan']); endif; ?>

    <div class="card shadow mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-header py-3 bg-primary-custom text-white">
            <h6 class="m-0 font-weight-bold">Riwayat Stok Opname</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Tanggal</th>
                            <th>Petugas</th>
                            <th>Jumlah Barang</th>
                            <th>Catatan</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $query_history = "SELECT ps.*, p.nama_lengkap 
                                        FROM penyesuaian_stok ps
                                        JOIN pengguna p ON ps.id_pengguna = p.id_pengguna
                                        ORDER BY ps.tanggal_penyesuaian DESC";
                        $result_history = mysqli_query($conn, $query_history);
                        $no = 1;
                        while($row = mysqli_fetch_assoc($result_history)): ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= date('d/m/Y H:i', strtotime($row['tanggal_penyesuaian'])) ?></td>
                            <td><?= $row['nama_lengkap'] ?></td>
                            <td class="text-center"><?= $row['total_barang'] ?></td>
                            <td><?= $row['catatan'] ?></td>
                            <td>
                                <a href="detail_opname.php?id=<?= $row['id_penyesuaian'] ?>" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i> Detail
                                </a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Tambah Stok Opname -->
<div class="modal fade" id="tambahOpnameModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title">Tambah Stok Opname</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="">
                <div class="modal-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Kode</th>
                                    <th>Nama Barang</th>
                                    <th width="10%">Stok Sistem</th>
                                    <th width="10%">Stok Fisik</th>
                                    <th width="10%">Selisih</th>
                                    <th width="20%">Keterangan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1; while($row = mysqli_fetch_assoc($result)): ?>
                                <tr>
                                    <td><?= $no ?></td>
                                    <td><?= $row['kode_barang'] ?></td>
                                    <td><?= $row['nama_barang'] ?></td>
                                    <td>
                                        <input type="hidden" name="id_barang[]" value="<?= $row['id_barang'] ?>">
                                        <input type="number" class="form-control" name="stok_sistem[]" 
                                               value="<?= $row['stok_akhir'] ?>" readonly>
                                    </td>
                                    <td>
                                        <input type="number" class="form-control stok-fisik" name="stok_fisik[]" 
                                               data-index="<?= $no-1 ?>" min="0" required>
                                    </td>
                                    <td>
                                        <input type="number" class="form-control selisih" name="selisih[]" readonly>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" name="keterangan[]">
                                    </td>
                                </tr>
                                <?php $no++; endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="simpan_opname" class="btn btn-primary-custom">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Hitung selisih stok
document.querySelectorAll('.stok-fisik').forEach(input => {
    input.addEventListener('change', function() {
        const index = this.getAttribute('data-index');
        const stokSistem = document.querySelectorAll('input[name="stok_sistem[]"]')[index].value;
        const selisihInput = document.querySelectorAll('.selisih')[index];
        
        selisihInput.value = this.value - stokSistem;
    });
});
</script>

<?php include 'footer.php'; ?>