<?php
session_start();
include 'header.php';
require_once 'config.php';

// Fungsi untuk format telepon
function format_telepon($nomor) {
    if (strlen($nomor) == 11) {
        return substr($nomor, 0, 3) . '-' . substr($nomor, 3, 4) . '-' . substr($nomor, 7);
    } elseif (strlen($nomor) == 12) {
        return substr($nomor, 0, 4) . '-' . substr($nomor, 4, 4) . '-' . substr($nomor, 8);
    }
    return $nomor;
}

// Proses CRUD Supplier
if (isset($_POST['tambah_supplier'])) {
    $kode_supplier = mysqli_real_escape_string($conn, $_POST['kode_supplier']);
    $nama_supplier = mysqli_real_escape_string($conn, $_POST['nama_supplier']);
    $alamat = mysqli_real_escape_string($conn, $_POST['alamat']);
    $telepon = mysqli_real_escape_string($conn, $_POST['telepon']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $kontak_person = mysqli_real_escape_string($conn, $_POST['kontak_person']);
    $rekening_bank = mysqli_real_escape_string($conn, $_POST['rekening_bank']);
    $status_aktif = isset($_POST['status_aktif']) ? 1 : 0;

    $query = "INSERT INTO supplier (kode_supplier, nama_supplier, alamat, telepon, email, kontak_person, rekening_bank, status_aktif) 
              VALUES ('$kode_supplier', '$nama_supplier', '$alamat', '$telepon', '$email', '$kontak_person', '$rekening_bank', $status_aktif)";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Supplier berhasil ditambahkan'];
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menambahkan supplier: ' . mysqli_error($conn)];
    }
    header("Location: supplier.php");
    exit();
}

if (isset($_POST['edit_supplier'])) {
    $id_supplier = mysqli_real_escape_string($conn, $_POST['id_supplier']);
    $kode_supplier = mysqli_real_escape_string($conn, $_POST['kode_supplier']);
    $nama_supplier = mysqli_real_escape_string($conn, $_POST['nama_supplier']);
    $alamat = mysqli_real_escape_string($conn, $_POST['alamat']);
    $telepon = mysqli_real_escape_string($conn, $_POST['telepon']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $kontak_person = mysqli_real_escape_string($conn, $_POST['kontak_person']);
    $rekening_bank = mysqli_real_escape_string($conn, $_POST['rekening_bank']);
    $status_aktif = isset($_POST['status_aktif']) ? 1 : 0;

    $query = "UPDATE supplier SET 
              kode_supplier = '$kode_supplier',
              nama_supplier = '$nama_supplier',
              alamat = '$alamat',
              telepon = '$telepon',
              email = '$email',
              kontak_person = '$kontak_person',
              rekening_bank = '$rekening_bank',
              status_aktif = $status_aktif
              WHERE id_supplier = $id_supplier";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Supplier berhasil diupdate'];
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal mengupdate supplier: ' . mysqli_error($conn)];
    }
    header("Location: supplier.php");
    exit();
}

if (isset($_GET['hapus'])) {
    $id_supplier = mysqli_real_escape_string($conn, $_GET['hapus']);
    
    // Cek apakah supplier memiliki pembelian
    $cek_pembelian = mysqli_query($conn, "SELECT COUNT(*) as total FROM pembelian WHERE id_supplier = $id_supplier");
    $jumlah_pembelian = mysqli_fetch_assoc($cek_pembelian)['total'];
    
    if ($jumlah_pembelian > 0) {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menghapus supplier karena memiliki ' . $jumlah_pembelian . ' transaksi pembelian'];
    } else {
        $query = "DELETE FROM supplier WHERE id_supplier = $id_supplier";
        
        if (mysqli_query($conn, $query)) {
            $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Supplier berhasil dihapus'];
        } else {
            $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menghapus supplier: ' . mysqli_error($conn)];
        }
    }
    header("Location: supplier.php");
    exit();
}

// Filter dan pencarian
$filter_nama = isset($_GET['filter_nama']) ? mysqli_real_escape_string($conn, $_GET['filter_nama']) : '';
$filter_status = isset($_GET['filter_status']) ? mysqli_real_escape_string($conn, $_GET['filter_status']) : '';

// Query data supplier
$query = "SELECT * FROM supplier WHERE 1=1";

if (!empty($filter_nama)) {
    $query .= " AND nama_supplier LIKE '%$filter_nama%'";
}

if (!empty($filter_status) && $filter_status != 'semua') {
    $query .= " AND status_aktif = " . ($filter_status == 'aktif' ? 1 : 0);
}

$query .= " ORDER BY nama_supplier ASC";
$result = mysqli_query($conn, $query);
?>

<main class="animate-fade-in">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Manajemen Supplier</h1>
        <div>
            <button class="btn btn-primary-custom" data-bs-toggle="modal" data-bs-target="#tambahSupplierModal">
                <i class="fas fa-plus-circle"></i> Tambah Supplier
            </button>
        </div>
    </div>

    <?php if (isset($_SESSION['pesan'])): ?>
    <div class="alert alert-<?= $_SESSION['pesan']['tipe'] ?> alert-dismissible fade show">
        <?= $_SESSION['pesan']['isi'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['pesan']); endif; ?>

    <div class="card shadow mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-header py-3 bg-primary-custom text-white">
            <h6 class="m-0 font-weight-bold">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="get" action="">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Nama Supplier</label>
                        <input type="text" class="form-control" name="filter_nama" value="<?= htmlspecialchars($filter_nama) ?>">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" name="filter_status">
                            <option value="semua" <?= $filter_status == 'semua' ? 'selected' : '' ?>>Semua Status</option>
                            <option value="aktif" <?= $filter_status == 'aktif' ? 'selected' : '' ?>>Aktif</option>
                            <option value="nonaktif" <?= $filter_status == 'nonaktif' ? 'selected' : '' ?>>Nonaktif</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary-custom me-2">
                            <i class="fas fa-filter"></i> Filter
                        </button>
                        <a href="supplier.php" class="btn btn-secondary">
                            <i class="fas fa-sync-alt"></i> Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow mb-4 animate-fade-in" style="animation-delay: 0.2s;">
        <div class="card-header py-3 bg-primary-custom text-white">
            <h6 class="m-0 font-weight-bold">Daftar Supplier</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th width="10%">Kode</th>
                            <th>Nama Supplier</th>
                            <th>Kontak</th>
                            <th>Telepon</th>
                            <th>Email</th>
                            <th width="10%">Status</th>
                            <th width="15%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (mysqli_num_rows($result) > 0): ?>
                            <?php $no = 1; while ($row = mysqli_fetch_assoc($result)): ?>
                            <tr>
                                <td><?= $no++ ?></td>
                                <td><?= $row['kode_supplier'] ?></td>
                                <td><?= $row['nama_supplier'] ?></td>
                                <td><?= $row['kontak_person'] ?></td>
                                <td><?= format_telepon($row['telepon']) ?></td>
                                <td><?= $row['email'] ?></td>
                                <td class="text-center">
                                    <span class="badge bg-<?= $row['status_aktif'] ? 'success' : 'danger' ?>">
                                        <?= $row['status_aktif'] ? 'Aktif' : 'Nonaktif' ?>
                                    </span>
                                </td>
                                <td class="text-center">
                                    <button class="btn btn-sm btn-warning btn-edit" data-bs-toggle="modal" data-bs-target="#editSupplierModal" 
                                            data-id="<?= $row['id_supplier'] ?>" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <a href="supplier.php?hapus=<?= $row['id_supplier'] ?>" class="btn btn-sm btn-danger" 
                                       onclick="return confirm('Yakin ingin menghapus supplier ini?')" title="Hapus">
                                        <i class="fas fa-trash-alt"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center">Tidak ada data supplier</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Tambah Supplier -->
<div class="modal fade" id="tambahSupplierModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title">Tambah Supplier Baru</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Kode Supplier</label>
                            <input type="text" class="form-control" name="kode_supplier" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Nama Supplier</label>
                            <input type="text" class="form-control" name="nama_supplier" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Alamat</label>
                            <textarea class="form-control" name="alamat" rows="2"></textarea>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Kontak Person</label>
                            <input type="text" class="form-control" name="kontak_person">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Telepon</label>
                            <input type="text" class="form-control" name="telepon" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" name="email">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Rekening Bank</label>
                            <input type="text" class="form-control" name="rekening_bank">
                        </div>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="status_aktif" id="status_aktif" checked>
                        <label class="form-check-label" for="status_aktif">
                            Aktif
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="tambah_supplier" class="btn btn-primary-custom">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Edit Supplier -->
<div class="modal fade" id="editSupplierModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title">Edit Supplier</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="">
                <input type="hidden" name="id_supplier" id="edit_id_supplier">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Kode Supplier</label>
                            <input type="text" class="form-control" name="kode_supplier" id="edit_kode_supplier" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Nama Supplier</label>
                            <input type="text" class="form-control" name="nama_supplier" id="edit_nama_supplier" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Alamat</label>
                            <textarea class="form-control" name="alamat" id="edit_alamat" rows="2"></textarea>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Kontak Person</label>
                            <input type="text" class="form-control" name="kontak_person" id="edit_kontak_person">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Telepon</label>
                            <input type="text" class="form-control" name="telepon" id="edit_telepon" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" name="email" id="edit_email">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Rekening Bank</label>
                            <input type="text" class="form-control" name="rekening_bank" id="edit_rekening_bank">
                        </div>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="status_aktif" id="edit_status_aktif">
                        <label class="form-check-label" for="edit_status_aktif">
                            Aktif
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="edit_supplier" class="btn btn-primary-custom">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// AJAX untuk edit modal
document.querySelectorAll('.btn-edit').forEach(button => {
    button.addEventListener('click', function() {
        const id = this.getAttribute('data-id');
        
        fetch(`get_supplier.php?id=${id}`)
            .then(response => response.json())
            .then(data => {
                document.getElementById('edit_id_supplier').value = data.id_supplier;
                document.getElementById('edit_kode_supplier').value = data.kode_supplier;
                document.getElementById('edit_nama_supplier').value = data.nama_supplier;
                document.getElementById('edit_alamat').value = data.alamat;
                document.getElementById('edit_telepon').value = data.telepon;
                document.getElementById('edit_email').value = data.email;
                document.getElementById('edit_kontak_person').value = data.kontak_person;
                document.getElementById('edit_rekening_bank').value = data.rekening_bank;
                document.getElementById('edit_status_aktif').checked = data.status_aktif == 1;
            });
    });
});
</script>

<?php include 'footer.php'; ?>