<?php
ob_start(); // <- Tambahkan ini paling atas
// Start session dan validasi login
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Cek apakah user sudah login dan memiliki akses (admin/marketing)
if (!isset($_SESSION['id_pengguna']) || ($_SESSION['id_role'] != 1 && $_SESSION['id_role'] != 2)) {
    header("Location: unauthorized.php");
    exit();
}

include 'header.php';
require_once 'config.php';

// Inisialisasi variabel
$errors = [];
$success = false;
$promo_data = [
    'kode_promo' => '',
    'nama_promo' => '',
    'jenis_promo' => 'diskon',
    'nilai_promo' => '',
    'tipe_nilai' => 'nominal',
    'tanggal_mulai' => date('Y-m-d'),
    'tanggal_selesai' => date('Y-m-d', strtotime('+1 week')),
    'id_toko' => '',
    'min_pembelian' => '',
    'max_diskon' => '',
    'kuota' => '',
    'deskripsi' => '',
    'is_active' => 1
];

// Proses form submit
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Validasi input
    $promo_data['kode_promo'] = trim($_POST['kode_promo']);
    $promo_data['nama_promo'] = trim($_POST['nama_promo']);
    $promo_data['jenis_promo'] = $_POST['jenis_promo'];
    $promo_data['nilai_promo'] = (float)$_POST['nilai_promo'];
    $promo_data['tipe_nilai'] = $_POST['tipe_nilai'];
    $promo_data['tanggal_mulai'] = $_POST['tanggal_mulai'];
    $promo_data['tanggal_selesai'] = $_POST['tanggal_selesai'];
    $promo_data['id_toko'] = !empty($_POST['id_toko']) ? (int)$_POST['id_toko'] : NULL;
    $promo_data['min_pembelian'] = !empty($_POST['min_pembelian']) ? (float)$_POST['min_pembelian'] : 0;
    $promo_data['max_diskon'] = !empty($_POST['max_diskon']) ? (float)$_POST['max_diskon'] : NULL;
    $promo_data['kuota'] = !empty($_POST['kuota']) ? (int)$_POST['kuota'] : NULL;
    $promo_data['deskripsi'] = trim($_POST['deskripsi']);
    $promo_data['is_active'] = isset($_POST['is_active']) ? 1 : 0;
    $barang_promo = isset($_POST['barang']) ? $_POST['barang'] : [];

    // Validasi
    if (empty($promo_data['kode_promo'])) {
        $errors['kode_promo'] = 'Kode promo harus diisi';
    }
    if (empty($promo_data['nama_promo'])) {
        $errors['nama_promo'] = 'Nama promo harus diisi';
    }
    if ($promo_data['nilai_promo'] <= 0) {
        $errors['nilai_promo'] = 'Nilai promo harus lebih dari 0';
    }
    if (strtotime($promo_data['tanggal_mulai']) > strtotime($promo_data['tanggal_selesai'])) {
        $errors['tanggal'] = 'Tanggal selesai harus setelah tanggal mulai';
    }

    // Jika tidak ada error, simpan ke database
    if (empty($errors)) {
        mysqli_begin_transaction($conn);
        
        try {
            // Insert ke tabel promo
            $query = "INSERT INTO promo (
                kode_promo, nama_promo, jenis_promo, nilai_promo, tipe_nilai,
                tanggal_mulai, tanggal_selesai, id_toko, min_pembelian,
                max_diskon, kuota, deskripsi, is_active
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            
            $stmt = mysqli_prepare($conn, $query);
            mysqli_stmt_bind_param(
                $stmt, 
                "sssdsssdiddsi",
                $promo_data['kode_promo'],
                $promo_data['nama_promo'],
                $promo_data['jenis_promo'],
                $promo_data['nilai_promo'],
                $promo_data['tipe_nilai'],
                $promo_data['tanggal_mulai'],
                $promo_data['tanggal_selesai'],
                $promo_data['id_toko'],
                $promo_data['min_pembelian'],
                $promo_data['max_diskon'],
                $promo_data['kuota'],
                $promo_data['deskripsi'],
                $promo_data['is_active']
            );
            
            mysqli_stmt_execute($stmt);
            $id_promo = mysqli_insert_id($conn);
            
            // Insert ke tabel promo_barang
            if (!empty($barang_promo)) {
                $query_barang = "INSERT INTO promo_barang (id_promo, id_barang) VALUES (?, ?)";
                $stmt_barang = mysqli_prepare($conn, $query_barang);
                
                foreach ($barang_promo as $id_barang) {
                    mysqli_stmt_bind_param($stmt_barang, "ii", $id_promo, $id_barang);
                    mysqli_stmt_execute($stmt_barang);
                }
            }
            
            mysqli_commit($conn);
            $success = true;
            $_SESSION['success'] = "Promo berhasil ditambahkan";
            header("Location: promo.php");
            exit();
            
        } catch (Exception $e) {
            mysqli_rollback($conn);
            $errors['database'] = "Gagal menyimpan promo: " . $e->getMessage();
        }
    }
}

// Ambil data toko untuk dropdown
$query_toko = "SELECT id_toko, nama_toko FROM toko ORDER BY nama_toko";
$result_toko = mysqli_query($conn, $query_toko);

// Ambil data barang untuk pilihan
$query_barang = "SELECT id_barang, kode_barang, nama_barang FROM barang WHERE is_active = 1 ORDER BY nama_barang";
$result_barang = mysqli_query($conn, $query_barang);
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card shadow mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-primary-custom">
                        <h6 class="m-0 font-weight-bold text-white">Tambah Promo Baru</h6>
                        <a href="promo.php" class="btn btn-sm btn-light">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                    <div class="card-body">
                        <?php if (!empty($errors)): ?>
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    <?php foreach ($errors as $error): ?>
                                        <li><?php echo $error; ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        
                        <form method="POST" action="">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="kode_promo">Kode Promo *</label>
                                        <input type="text" class="form-control <?php echo isset($errors['kode_promo']) ? 'is-invalid' : ''; ?>" 
                                               id="kode_promo" name="kode_promo" required
                                               value="<?php echo htmlspecialchars($promo_data['kode_promo']); ?>">
                                        <?php if (isset($errors['kode_promo'])): ?>
                                            <div class="invalid-feedback"><?php echo $errors['kode_promo']; ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="nama_promo">Nama Promo *</label>
                                        <input type="text" class="form-control <?php echo isset($errors['nama_promo']) ? 'is-invalid' : ''; ?>" 
                                               id="nama_promo" name="nama_promo" required
                                               value="<?php echo htmlspecialchars($promo_data['nama_promo']); ?>">
                                        <?php if (isset($errors['nama_promo'])): ?>
                                            <div class="invalid-feedback"><?php echo $errors['nama_promo']; ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="jenis_promo">Jenis Promo *</label>
                                        <select class="form-control" id="jenis_promo" name="jenis_promo" required>
                                            <option value="diskon" <?php echo $promo_data['jenis_promo'] == 'diskon' ? 'selected' : ''; ?>>Diskon</option>
                                            <option value="gratis" <?php echo $promo_data['jenis_promo'] == 'gratis' ? 'selected' : ''; ?>>Gratis</option>
                                            <option value="bundling" <?php echo $promo_data['jenis_promo'] == 'bundling' ? 'selected' : ''; ?>>Bundling</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="nilai_promo">Nilai Promo *</label>
                                        <input type="number" step="0.01" class="form-control <?php echo isset($errors['nilai_promo']) ? 'is-invalid' : ''; ?>" 
                                               id="nilai_promo" name="nilai_promo" required
                                               value="<?php echo htmlspecialchars($promo_data['nilai_promo']); ?>">
                                        <?php if (isset($errors['nilai_promo'])): ?>
                                            <div class="invalid-feedback"><?php echo $errors['nilai_promo']; ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="tipe_nilai">Tipe Nilai *</label>
                                        <select class="form-control" id="tipe_nilai" name="tipe_nilai" required>
                                            <option value="nominal" <?php echo $promo_data['tipe_nilai'] == 'nominal' ? 'selected' : ''; ?>>Nominal (Rp)</option>
                                            <option value="persen" <?php echo $promo_data['tipe_nilai'] == 'persen' ? 'selected' : ''; ?>>Persentase (%)</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="tanggal_mulai">Tanggal Mulai *</label>
                                        <input type="date" class="form-control <?php echo isset($errors['tanggal']) ? 'is-invalid' : ''; ?>" 
                                               id="tanggal_mulai" name="tanggal_mulai" required
                                               value="<?php echo htmlspecialchars($promo_data['tanggal_mulai']); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="tanggal_selesai">Tanggal Selesai *</label>
                                        <input type="date" class="form-control <?php echo isset($errors['tanggal']) ? 'is-invalid' : ''; ?>" 
                                               id="tanggal_selesai" name="tanggal_selesai" required
                                               value="<?php echo htmlspecialchars($promo_data['tanggal_selesai']); ?>">
                                        <?php if (isset($errors['tanggal'])): ?>
                                            <div class="invalid-feedback"><?php echo $errors['tanggal']; ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="id_toko">Toko (Kosongkan untuk semua toko)</label>
                                        <select class="form-control" id="id_toko" name="id_toko">
                                            <option value="">Semua Toko</option>
                                            <?php while ($toko = mysqli_fetch_assoc($result_toko)): ?>
                                                <option value="<?php echo $toko['id_toko']; ?>" 
                                                    <?php echo $promo_data['id_toko'] == $toko['id_toko'] ? 'selected' : ''; ?>>
                                                    <?php echo htmlspecialchars($toko['nama_toko']); ?>
                                                </option>
                                            <?php endwhile; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="min_pembelian">Minimal Pembelian (Rp)</label>
                                        <input type="number" step="0.01" class="form-control" 
                                               id="min_pembelian" name="min_pembelian"
                                               value="<?php echo htmlspecialchars($promo_data['min_pembelian']); ?>">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="max_diskon">Maksimal Diskon (Rp)</label>
                                        <input type="number" step="0.01" class="form-control" 
                                               id="max_diskon" name="max_diskon"
                                               value="<?php echo htmlspecialchars($promo_data['max_diskon']); ?>">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="kuota">Kuota (Kosongkan untuk tidak terbatas)</label>
                                        <input type="number" class="form-control" 
                                               id="kuota" name="kuota"
                                               value="<?php echo htmlspecialchars($promo_data['kuota']); ?>">
                                    </div>
                                </div>
                                <div class="col-md-8">
                                    <div class="form-group">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" 
                                                   id="is_active" name="is_active" value="1"
                                                   <?php echo $promo_data['is_active'] ? 'checked' : ''; ?>>
                                            <label class="custom-control-label" for="is_active">Aktif</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="deskripsi">Deskripsi</label>
                                <textarea class="form-control" id="deskripsi" name="deskripsi" rows="3"><?php echo htmlspecialchars($promo_data['deskripsi']); ?></textarea>
                            </div>
                            
                            <div class="form-group">
                                <label>Pilih Barang yang Ikut Promo</label>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th width="5%">Pilih</th>
                                                <th>Kode Barang</th>
                                                <th>Nama Barang</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php while ($barang = mysqli_fetch_assoc($result_barang)): ?>
                                                <tr>
                                                    <td class="text-center">
                                                        <input type="checkbox" name="barang[]" 
                                                               value="<?php echo $barang['id_barang']; ?>">
                                                    </td>
                                                    <td><?php echo htmlspecialchars($barang['kode_barang']); ?></td>
                                                    <td><?php echo htmlspecialchars($barang['nama_barang']); ?></td>
                                                </tr>
                                            <?php endwhile; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            
                            <div class="form-group text-right">
                                <button type="submit" class="btn btn-primary-custom">
                                    <i class="fas fa-save"></i> Simpan Promo
                                </button>
                                <a href="promo.php" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> Batal
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php 
include 'footer.php'; 
ob_end_flush(); 
?>