<?php
session_start();
include 'header.php';
require_once 'config.php';

// Proses CRUD Toko
if (isset($_POST['tambah_toko'])) {
    $kode_toko = mysqli_real_escape_string($conn, $_POST['kode_toko']);
    $nama_toko = mysqli_real_escape_string($conn, $_POST['nama_toko']);
    $alamat = mysqli_real_escape_string($conn, $_POST['alamat']);
    $telepon = mysqli_real_escape_string($conn, $_POST['telepon']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $tanggal_buka = mysqli_real_escape_string($conn, $_POST['tanggal_buka']);
    $status_aktif = isset($_POST['status_aktif']) ? 1 : 0;

    $query = "INSERT INTO toko (kode_toko, nama_toko, alamat, telepon, email, tanggal_buka, status_aktif) 
              VALUES ('$kode_toko', '$nama_toko', '$alamat', '$telepon', '$email', '$tanggal_buka', $status_aktif)";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Toko berhasil ditambahkan'];
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menambahkan toko: ' . mysqli_error($conn)];
    }
    header("Location: toko.php");
    exit();
}

if (isset($_POST['edit_toko'])) {
    $id_toko = mysqli_real_escape_string($conn, $_POST['id_toko']);
    $kode_toko = mysqli_real_escape_string($conn, $_POST['kode_toko']);
    $nama_toko = mysqli_real_escape_string($conn, $_POST['nama_toko']);
    $alamat = mysqli_real_escape_string($conn, $_POST['alamat']);
    $telepon = mysqli_real_escape_string($conn, $_POST['telepon']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $tanggal_buka = mysqli_real_escape_string($conn, $_POST['tanggal_buka']);
    $status_aktif = isset($_POST['status_aktif']) ? 1 : 0;

    $query = "UPDATE toko SET 
              kode_toko = '$kode_toko',
              nama_toko = '$nama_toko',
              alamat = '$alamat',
              telepon = '$telepon',
              email = '$email',
              tanggal_buka = '$tanggal_buka',
              status_aktif = $status_aktif
              WHERE id_toko = $id_toko";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Toko berhasil diupdate'];
    } else {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal mengupdate toko: ' . mysqli_error($conn)];
    }
    header("Location: toko.php");
    exit();
}

if (isset($_GET['hapus'])) {
    $id_toko = mysqli_real_escape_string($conn, $_GET['hapus']);
    
    // Cek apakah toko memiliki stok atau pengguna
    $cek_stok = mysqli_query($conn, "SELECT COUNT(*) as total FROM stok_toko WHERE id_toko = $id_toko");
    $cek_pengguna = mysqli_query($conn, "SELECT COUNT(*) as total FROM pengguna WHERE id_toko = $id_toko");
    
    $jumlah_stok = mysqli_fetch_assoc($cek_stok)['total'];
    $jumlah_pengguna = mysqli_fetch_assoc($cek_pengguna)['total'];
    
    if ($jumlah_stok > 0 || $jumlah_pengguna > 0) {
        $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menghapus toko karena memiliki ' . $jumlah_stok . ' stok barang dan ' . $jumlah_pengguna . ' pengguna'];
    } else {
        $query = "DELETE FROM toko WHERE id_toko = $id_toko";
        
        if (mysqli_query($conn, $query)) {
            $_SESSION['pesan'] = ['tipe' => 'success', 'isi' => 'Toko berhasil dihapus'];
        } else {
            $_SESSION['pesan'] = ['tipe' => 'danger', 'isi' => 'Gagal menghapus toko: ' . mysqli_error($conn)];
        }
    }
    header("Location: toko.php");
    exit();
}

// Filter dan pencarian
$filter_nama = isset($_GET['filter_nama']) ? mysqli_real_escape_string($conn, $_GET['filter_nama']) : '';
$filter_status = isset($_GET['filter_status']) ? mysqli_real_escape_string($conn, $_GET['filter_status']) : '';

// Query data toko
$query = "SELECT * FROM toko WHERE 1=1";

if (!empty($filter_nama)) {
    $query .= " AND nama_toko LIKE '%$filter_nama%'";
}

if (!empty($filter_status) && $filter_status != 'semua') {
    $query .= " AND status_aktif = " . ($filter_status == 'aktif' ? 1 : 0);
}

$query .= " ORDER BY nama_toko ASC";
$result = mysqli_query($conn, $query);
?>

<main class="animate-fade-in">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Manajemen Toko</h1>
        <div>
            <button class="btn btn-primary-custom" data-bs-toggle="modal" data-bs-target="#tambahTokoModal">
                <i class="fas fa-plus-circle"></i> Tambah Toko
            </button>
        </div>
    </div>

    <?php if (isset($_SESSION['pesan'])): ?>
    <div class="alert alert-<?= $_SESSION['pesan']['tipe'] ?> alert-dismissible fade show">
        <?= $_SESSION['pesan']['isi'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['pesan']); endif; ?>

    <div class="card shadow mb-4 animate-fade-in" style="animation-delay: 0.1s;">
        <div class="card-header py-3 bg-primary-custom text-white">
            <h6 class="m-0 font-weight-bold">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="get" action="">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Nama Toko</label>
                        <input type="text" class="form-control" name="filter_nama" value="<?= htmlspecialchars($filter_nama) ?>">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" name="filter_status">
                            <option value="semua" <?= $filter_status == 'semua' ? 'selected' : '' ?>>Semua Status</option>
                            <option value="aktif" <?= $filter_status == 'aktif' ? 'selected' : '' ?>>Aktif</option>
                            <option value="nonaktif" <?= $filter_status == 'nonaktif' ? 'selected' : '' ?>>Nonaktif</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary-custom me-2">
                            <i class="fas fa-filter"></i> Filter
                        </button>
                        <a href="toko.php" class="btn btn-secondary">
                            <i class="fas fa-sync-alt"></i> Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow mb-4 animate-fade-in" style="animation-delay: 0.2s;">
        <div class="card-header py-3 bg-primary-custom text-white">
            <h6 class="m-0 font-weight-bold">Daftar Toko</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th width="10%">Kode</th>
                            <th>Nama Toko</th>
                            <th>Alamat</th>
                            <th>Telepon</th>
                            <th>Email</th>
                            <th width="10%">Tgl Buka</th>
                            <th width="10%">Status</th>
                            <th width="15%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (mysqli_num_rows($result) > 0): ?>
                            <?php $no = 1; while ($row = mysqli_fetch_assoc($result)): ?>
                            <tr>
                                <td><?= $no++ ?></td>
                                <td><?= $row['kode_toko'] ?></td>
                                <td><?= $row['nama_toko'] ?></td>
                                <td><?= $row['alamat'] ?></td>
                                <td><?= $row['telepon'] ?></td>
                                <td><?= $row['email'] ?></td>
                                <td><?= date('d/m/Y', strtotime($row['tanggal_buka'])) ?></td>
                                <td class="text-center">
                                    <span class="badge bg-<?= $row['status_aktif'] ? 'success' : 'danger' ?>">
                                        <?= $row['status_aktif'] ? 'Aktif' : 'Nonaktif' ?>
                                    </span>
                                </td>
                                <td class="text-center">
                                    <button class="btn btn-sm btn-warning btn-edit" data-bs-toggle="modal" data-bs-target="#editTokoModal" 
                                            data-id="<?= $row['id_toko'] ?>" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <a href="toko.php?hapus=<?= $row['id_toko'] ?>" class="btn btn-sm btn-danger" 
                                       onclick="return confirm('Yakin ingin menghapus toko ini?')" title="Hapus">
                                        <i class="fas fa-trash-alt"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center">Tidak ada data toko</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Tambah Toko -->
<div class="modal fade" id="tambahTokoModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title">Tambah Toko Baru</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Kode Toko</label>
                            <input type="text" class="form-control" name="kode_toko" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Nama Toko</label>
                            <input type="text" class="form-control" name="nama_toko" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Alamat</label>
                            <textarea class="form-control" name="alamat" rows="2" required></textarea>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Tanggal Buka</label>
                            <input type="date" class="form-control" name="tanggal_buka" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Telepon</label>
                            <input type="text" class="form-control" name="telepon" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" name="email">
                        </div>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="status_aktif" id="status_aktif" checked>
                        <label class="form-check-label" for="status_aktif">
                            Aktif
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="tambah_toko" class="btn btn-primary-custom">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Edit Toko -->
<div class="modal fade" id="editTokoModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary-custom text-white">
                <h5 class="modal-title">Edit Toko</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="">
                <input type="hidden" name="id_toko" id="edit_id_toko">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Kode Toko</label>
                            <input type="text" class="form-control" name="kode_toko" id="edit_kode_toko" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Nama Toko</label>
                            <input type="text" class="form-control" name="nama_toko" id="edit_nama_toko" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Alamat</label>
                            <textarea class="form-control" name="alamat" id="edit_alamat" rows="2" required></textarea>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Tanggal Buka</label>
                            <input type="date" class="form-control" name="tanggal_buka" id="edit_tanggal_buka" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Telepon</label>
                            <input type="text" class="form-control" name="telepon" id="edit_telepon" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" name="email" id="edit_email">
                        </div>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="status_aktif" id="edit_status_aktif">
                        <label class="form-check-label" for="edit_status_aktif">
                            Aktif
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="edit_toko" class="btn btn-primary-custom">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// AJAX untuk edit modal
document.querySelectorAll('.btn-edit').forEach(button => {
    button.addEventListener('click', function() {
        const id = this.getAttribute('data-id');
        
        fetch(`get_toko.php?id=${id}`)
            .then(response => response.json())
            .then(data => {
                document.getElementById('edit_id_toko').value = data.id_toko;
                document.getElementById('edit_kode_toko').value = data.kode_toko;
                document.getElementById('edit_nama_toko').value = data.nama_toko;
                document.getElementById('edit_alamat').value = data.alamat;
                document.getElementById('edit_telepon').value = data.telepon;
                document.getElementById('edit_email').value = data.email;
                document.getElementById('edit_tanggal_buka').value = data.tanggal_buka;
                document.getElementById('edit_status_aktif').checked = data.status_aktif == 1;
            });
    });
});
</script>

<?php include 'footer.php'; ?>