<?php
// Start session jika belum dimulai
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'header.php';
?>

<!-- Main Content -->
<main class="animate-fade-in">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10">
                <div class="card shadow-lg my-5">
                    <div class="card-header bg-danger text-white">
                        <h4 class="m-0 font-weight-bold text-center">Akses Ditolak</h4>
                    </div>
                    <div class="card-body text-center py-5">
                        <div class="mb-4">
                            <i class="fas fa-ban fa-5x text-danger"></i>
                        </div>
                        <h3 class="text-gray-900 mb-4">Anda Tidak Memiliki Akses!</h3>
                        <p class="text-gray-700 mb-4">
                            Maaf, Anda tidak memiliki izin untuk mengakses halaman ini.
                            <br>Silakan hubungi administrator sistem jika Anda membutuhkan akses.
                        </p>
                        <div class="mt-5">
                            <a href="dashboard.php" class="btn btn-primary-custom">
                                <i class="fas fa-home mr-2"></i> Kembali ke Dashboard
                            </a>
                            <?php if (isset($_SESSION['id_pengguna'])): ?>
                                <a href="logout.php" class="btn btn-danger ml-2">
                                    <i class="fas fa-sign-out-alt mr-2"></i> Logout
                                </a>
                            <?php else: ?>
                                <a href="login.php" class="btn btn-success ml-2">
                                    <i class="fas fa-sign-in-alt mr-2"></i> Login
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include 'footer.php'; ?>